/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.cache;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.file.MD5Helper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.cache.CacheProxy;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.biz.module.page.entity.AppCenterCache;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.entity.PageIdMapCode;
import com.kingdee.portal.biz.module.page.entity.PageLayoutTmpl;
import com.kingdee.portal.biz.module.page.service.AppCenterService;
import com.kingdee.portal.biz.module.page.service.PageIdMapCodeService;
import com.kingdee.portal.biz.module.page.service.PageLayoutTmplService;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.perm.entity.PermRefRes;
import com.kingdee.portal.biz.module.perm.service.PermService;
import com.kingdee.portal.biz.module.personal.dto.PersonalFavoriteDTO;
import com.kingdee.portal.biz.module.personal.service.PersonalFavoriteService;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.entity.PortletTheme;
import com.kingdee.portal.biz.module.portlet.entity.PortletTmpl;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.biz.module.portlet.service.PortletThemeService;
import com.kingdee.portal.biz.module.portlet.service.PortletTmplService;
import com.kingdee.portal.biz.module.setting.service.SettingService;
import com.kingdee.portal.common.util.Base64Util;
import com.kingdee.portal.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalCache {
    private static Logger logger = LoggerFactory.getLogger(PortalCache.class);
    private String BOS_BASE_SERVICE_SP_INFO = "\u5904\u7406OA\u83dc\u5355\u5f71\u54cd\u767b\u5f55\u6027\u80fd\u7684\u95ee\u9898";

    public static List<Page> getEnabledSysPageList() {
        List<Page> sysPageList = null;
        try {
            sysPageList = (List<Page>)CacheProxy.getCache().get("portal_all_system_page");
            if (sysPageList == null) {
                sysPageList = PortalCache.freshEnabledSysPageList();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            sysPageList = PortalCache.freshEnabledSysPageList();
        }
        return sysPageList;
    }

    public static List<Page> freshEnabledSysPageList() {
        List<Page> sysPageList = null;
        try {
            PageService pageService = (PageService)PortalServiceLocator.getBean("pageService");
            sysPageList = pageService.findAllEnabledSysPageList();
            CacheProxy.getCache().put("portal_all_system_page", sysPageList);
        }
        catch (Exception ex) {
            logger.error("Error for set system page to cache:{}", (Object)ex.getMessage());
        }
        return sysPageList;
    }

    public static void clearEnabledSysPageList() {
        CacheProxy.getCache().clear("portal_all_system_page");
    }

    public static boolean isExisted4SysPageList() {
        return CacheProxy.getCache().contains("portal_all_system_page");
    }

    public static List<PageLayoutTmpl> getEnabledPageLayoutTmplList() {
        List<PageLayoutTmpl> pageLayoutTmplList = null;
        try {
            pageLayoutTmplList = (List<PageLayoutTmpl>)CacheProxy.getCache().get("portal_all_page_Layout_Tmpl");
            if (pageLayoutTmplList == null) {
                pageLayoutTmplList = PortalCache.freshEnabledPageLayoutTmplList();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            pageLayoutTmplList = PortalCache.freshEnabledPageLayoutTmplList();
        }
        return pageLayoutTmplList;
    }

    public static List<PageLayoutTmpl> freshEnabledPageLayoutTmplList() {
        List<PageLayoutTmpl> pageLayoutTmplList = null;
        try {
            PageLayoutTmplService pageLayoutTmplService = (PageLayoutTmplService)PortalServiceLocator.getBean("pageLayoutTmplService");
            pageLayoutTmplList = pageLayoutTmplService.findEnabledLayoutTmplList();
            CacheProxy.getCache().put("portal_all_page_Layout_Tmpl", pageLayoutTmplList);
        }
        catch (Exception ex) {
            logger.error("Error for set system pageLayoutTmpl to cache:{}", (Object)ex.getMessage());
        }
        return pageLayoutTmplList;
    }

    public static void clearEnabledPageLayoutTmplList() {
        CacheProxy.getCache().clear("portal_all_page_Layout_Tmpl");
    }

    public static boolean isExisted4PageLayoutTmplList() {
        return CacheProxy.getCache().contains("portal_all_page_Layout_Tmpl");
    }

    public static List<PortletTmpl> getEnabledPortletTmplList() {
        List<PortletTmpl> portletTmplList = null;
        try {
            portletTmplList = (List<PortletTmpl>)CacheProxy.getCache().get("portlet_all_tmpl");
            if (portletTmplList == null) {
                portletTmplList = PortalCache.freshEnabledPortletTmplList();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            portletTmplList = PortalCache.freshEnabledPortletTmplList();
        }
        return portletTmplList;
    }

    public static List<PortletTmpl> freshEnabledPortletTmplList() {
        List<PortletTmpl> portletTmplList = null;
        try {
            PortletTmplService portletTmplService = (PortletTmplService)PortalServiceLocator.getBean("portletTmplService");
            portletTmplList = portletTmplService.findPortletTmplList4Enable();
            CacheProxy.getCache().put("portlet_all_tmpl", portletTmplList);
        }
        catch (Exception ex) {
            logger.error("Error for set system portletTmpl to cache:{}", (Object)ex.getMessage());
            ex.printStackTrace();
        }
        return portletTmplList;
    }

    public static void clearEnabledPortletTmplList() {
        CacheProxy.getCache().clear("portlet_all_tmpl");
    }

    public static boolean isExisted4PortletTmplList() {
        return CacheProxy.getCache().contains("portlet_all_tmpl");
    }

    public static List<PortletTheme> getEnabledPortletThemeList() {
        List<PortletTheme> portletThemeList = null;
        try {
            portletThemeList = (List<PortletTheme>)CacheProxy.getCache().get("portlet_all_theme");
            if (portletThemeList == null) {
                portletThemeList = PortalCache.freshEnabledPortletThemeList();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            portletThemeList = PortalCache.freshEnabledPortletThemeList();
        }
        return portletThemeList;
    }

    public static List<PortletTheme> freshEnabledPortletThemeList() {
        List<PortletTheme> portletThemeList = null;
        try {
            PortletThemeService portletThemeService = (PortletThemeService)PortalServiceLocator.getBean("portletThemeService");
            portletThemeList = portletThemeService.findPortletThemeList4Enable();
            CacheProxy.getCache().put("portlet_all_theme", portletThemeList);
        }
        catch (Exception ex) {
            logger.error("Error for set system portletTmpl to cache:{}", (Object)ex.getMessage());
            ex.printStackTrace();
        }
        return portletThemeList;
    }

    public static void clearEnabledPortletThemeList() {
        CacheProxy.getCache().clear("portlet_all_theme");
    }

    public static boolean isExisted4PortletThemeList() {
        return CacheProxy.getCache().contains("portlet_all_theme");
    }

    public static Map<String, String> getPortalProfileMap() {
        Map<String, String> portalProfileMap = null;
        try {
            portalProfileMap = (Map<String, String>)CacheProxy.getCache().get("portal_profile_map");
            if (portalProfileMap == null) {
                portalProfileMap = PortalCache.freshPortalProfileMap();
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            portalProfileMap = PortalCache.freshPortalProfileMap();
        }
        return portalProfileMap;
    }

    public static Map<String, String> freshPortalProfileMap() {
        Map<String, String> portalProfileMap = null;
        try {
            SettingService settingService = (SettingService)PortalServiceLocator.getBean("settingService");
            portalProfileMap = settingService.findPortalProfileMap();
            CacheProxy.getCache().put("portal_profile_map", portalProfileMap);
        }
        catch (Exception ex) {
            logger.error("Error for set system portalProfile to cache:{}", (Object)ex.getMessage());
            ex.printStackTrace();
        }
        return portalProfileMap;
    }

    public static void clearPortalProfileMap() {
        CacheProxy.getCache().clear("portal_profile_map");
    }

    public static boolean isExisted4PortalProfileMap() {
        return CacheProxy.getCache().contains("portal_profile_map");
    }

    public static List<PortletDefinition> getEnablePortletList(PortalContext context, String userId) {
        List<PortletDefinition> portletList = null;
        try {
            portletList = (List<PortletDefinition>)CacheProxy.getCache().get("portal_all_enable_portlet");
            if (portletList == null) {
                portletList = PortalCache.freshEnablePortletList(context, userId);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            portletList = PortalCache.freshEnablePortletList(context, userId);
        }
        return portletList;
    }

    public static List<PortletDefinition> freshEnablePortletList(PortalContext context, String userId) {
        List<PortletDefinition> portletList = null;
        try {
            PortletDefinitionService portletDefinitionService = (PortletDefinitionService)PortalServiceLocator.getBean("portletDefinitionService");
            portletList = portletDefinitionService.findEnablePltList(context, userId);
            CacheProxy.getCache().put("portal_all_enable_portlet", portletList);
        }
        catch (Exception ex) {
            logger.error("Error for set enable portlet to cache:{}", (Object)ex.getMessage());
        }
        return portletList;
    }

    public static void clearEnablePortletList() {
        CacheProxy.getCache().clear("portal_all_enable_portlet");
    }

    public static boolean isExisted4EnablePortletList() {
        return CacheProxy.getCache().contains("portal_all_enable_portlet");
    }

    public static void clearPermissionMap() {
        CacheProxy.getCache().clear("CACHE_PORTAL_PERMISSION_KEY");
    }

    public static String getPageIdMapCodeList() {
        String ic = null;
        if (CacheProxy.getCache().get("portal_all_page_idmapcode") != null) {
            ic = (String)CacheProxy.getCache().get("portal_all_page_idmapcode");
        }
        if (ic == null) {
            ic = PortalCache.freshPageIdMapCodeList();
        }
        return ic;
    }

    public static String freshPageIdMapCodeList() {
        String ic = "";
        try {
            PageIdMapCodeService pageIdMapCodeService = (PageIdMapCodeService)PortalServiceLocator.getBean("pageIdMapCodeService");
            List<PageIdMapCode> icList = pageIdMapCodeService.findePageIdMapCodeList();
            if (icList != null && icList.size() > 0) {
                JSONObject obj = new JSONObject();
                for (PageIdMapCode imc : icList) {
                    obj.put((Object)imc.getPageNumber(), (Object)imc.getPageId());
                }
                ic = obj.toString();
            }
            CacheProxy.getCache().put("portal_all_page_idmapcode", ic);
        }
        catch (Exception ex) {
            logger.error("Error for set freshPageIdMapCodeList to cache:{}", (Object)ex.getMessage());
        }
        return ic;
    }

    public static boolean getLicenseFlag(Context ctx) {
        boolean licenseFlag = false;
        try {
            if (CacheProxy.getCache().get("portal_license_flag") != null) {
                licenseFlag = (Boolean)CacheProxy.getCache().get("portal_license_flag");
            } else {
                EASService easService = (EASService)PortalServiceLocator.getBean("easService");
                int result = easService.checkPortalLicense(ctx);
                if (result == 1) {
                    licenseFlag = true;
                } else if (result == 3) {
                    licenseFlag = false;
                }
                PortalCache.setLicenseFlag(licenseFlag);
            }
        }
        catch (Exception e) {
            logger.info("getLicenseFlag from cache===", (Throwable)e);
        }
        return licenseFlag;
    }

    public static void setLicenseFlag(boolean licenseFlag) {
        CacheProxy.getCache().put("portal_license_flag", licenseFlag);
    }

    public static List<PermRefRes> getPortalPagePerm(PortalContext ctx) {
        List permList = null;
        String userId = ctx.getLoginUser().getId();
        PermService permService = (PermService)PortalServiceLocator.getBean("permService");
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        boolean licenseFlag = PortalCache.getLicenseFlag(context);
        try {
            if (CacheProxy.getCache().get("page_perm_key_" + userId) != null) {
                permList = (List)CacheProxy.getCache().get("page_perm_key_" + userId);
            }
            if (permList == null) {
                permList = permService.getPermLlist(ctx, licenseFlag);
                String clearAppCenterSql = "delete from T_JP_AppCenterCache where FUserId ='" + userId + "'";
                DbUtil.execute((Context)context, (String)clearAppCenterSql);
            }
        }
        catch (Exception e) {
            logger.error("getPortalPagePerm error===", (Throwable)e);
            try {
                permList = permService.getPermLlist(ctx, licenseFlag);
            }
            catch (PortalBizException e1) {
                logger.error("getPortalPagePerm getPermLlist error===", (Throwable)e1);
            }
        }
        return permList;
    }

    public static void setPortalPagePerm(PortalContext ctx, List<PermRefRes> permList) {
        try {
            String userId = ctx.getLoginUser().getId();
            CacheProxy.getCache().put("page_perm_key_" + userId, permList);
        }
        catch (Exception e) {
            logger.error("setPortalPagePerm error===", (Throwable)e);
        }
    }

    public static Map<String, String> getGUIListPerm(PortalContext ctx) {
        Map<String, String> map = null;
        String userId = ctx.getLoginUser().getId();
        String hashKey = PortalCache.getUserWithHashRef(userId, "gui");
        PermService permService = (PermService)PortalServiceLocator.getBean("permService");
        try {
            if (StringUtil.isEmpty((String)hashKey)) {
                map = permService.getPermGUILinkList(ctx);
            } else {
                if (CacheProxy.getCache().get(hashKey) != null) {
                    map = (Map<String, String>)CacheProxy.getCache().get(hashKey);
                }
                if (map == null) {
                    map = permService.getPermGUILinkList(ctx);
                }
            }
        }
        catch (Exception e) {
            logger.error("getGUIListPerm error === ", (Throwable)e);
            map = permService.getPermGUILinkList(ctx);
        }
        return map;
    }

    public static void setGUIListPerm(PortalContext ctx, Map<String, String> guiList) {
        try {
            String userId = ctx.getLoginUser().getId();
            String guiListHash = MD5Helper.getStringMD5((String)guiList.get("idString"));
            if (StringUtil.isEmpty((String)guiListHash)) {
                guiListHash = userId;
            }
            String hashKey = "gui_" + guiListHash;
            if (CacheProxy.getCache().get(hashKey) == null) {
                guiList.remove("idString");
                CacheProxy.getCache().put(hashKey, guiList);
            }
            PortalCache.setUserWithHashRef(userId, hashKey);
        }
        catch (Exception e) {
            logger.error("setGUIListPerm error===", (Throwable)e);
        }
    }

    public static Map<String, String> getEasWebListPerm(PortalContext ctx) {
        Map<String, String> map = null;
        String userId = ctx.getLoginUser().getId();
        System.out.println("getEasWebListPerm userid:" + userId);
        String hashKey = PortalCache.getUserWithHashRef(userId, "web");
        System.out.println("getEasWebListPerm hashKey:" + hashKey);
        PermService permService = (PermService)PortalServiceLocator.getBean("permService");
        try {
            if (StringUtil.isEmpty((String)hashKey)) {
                map = permService.getPermEasWebList(ctx);
            } else {
                map = (Map<String, String>)CacheProxy.getCache().get(hashKey);
                if (map == null) {
                    map = permService.getPermEasWebList(ctx);
                }
            }
        }
        catch (Exception e) {
            logger.error("getEasWebListPerm error === ", (Throwable)e);
            map = permService.getPermEasWebList(ctx);
        }
        return map;
    }

    public static void setEasWebListPerm(PortalContext ctx, Map<String, String> easWebList) {
        try {
            String userId = ctx.getLoginUser().getId();
            System.out.println("setEasWebListPerm userId:" + userId);
            String listHash = MD5Helper.getStringMD5((String)easWebList.get("idString"));
            System.out.println("setEasWebListPerm listHash:" + listHash);
            if (StringUtil.isEmpty((String)listHash)) {
                listHash = userId;
            }
            String hashKey = "web_" + listHash;
            if (CacheProxy.getCache().get(hashKey) == null) {
                System.out.println("setEasWebListPerm putCache");
                easWebList.remove("idString");
                CacheProxy.getCache().put(hashKey, easWebList);
            }
            PortalCache.setUserWithHashRef(userId, hashKey);
        }
        catch (Exception e) {
            logger.error("setEasWebListPerm error===", (Throwable)e);
        }
    }

    public static Map<String, String> getOADynamicListPerm(PortalContext ctx) {
        String BOS_BASE_SERVICE_SP_CHANGE = "\u73b0\u573a\u6839\u672c\u6ca1\u6709\u8fd9\u79cd\u7c7b\u578b\u7684\u6570\u636e\uff0c\u53cd\u800c\u4f1a\u5f71\u54cd\u6027\u80fd";
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    public static void setOADynamicListPerm(PortalContext ctx, Map<String, String> oaList) {
        try {
            String userId = ctx.getLoginUser().getId();
            String listHash = MD5Helper.getStringMD5((String)oaList.get("idString"));
            if (StringUtil.isEmpty((String)listHash)) {
                listHash = userId;
            }
            String hashKey = "oad_" + listHash;
            if (CacheProxy.getCache().get(hashKey) == null) {
                oaList.remove("idString");
                CacheProxy.getCache().put(hashKey, oaList);
            }
            PortalCache.setUserWithHashRef(userId, hashKey);
        }
        catch (Exception e) {
            logger.error("setOADynamicListPerm error===", (Throwable)e);
        }
    }

    public static Map<String, String> getSHRWebListPerm(PortalContext ctx) {
        Map<String, String> map = null;
        String userId = ctx.getLoginUser().getId();
        String hashKey = PortalCache.getUserWithHashRef(userId, "shrd");
        PermService permService = (PermService)PortalServiceLocator.getBean("permService");
        try {
            if (StringUtil.isEmpty((String)hashKey)) {
                map = permService.getPermSHRWebList(ctx);
            } else {
                if (CacheProxy.getCache().get(hashKey) != null) {
                    map = (Map<String, String>)CacheProxy.getCache().get(hashKey);
                }
                if (map == null) {
                    map = permService.getPermSHRWebList(ctx);
                }
            }
        }
        catch (Exception e) {
            logger.error("getSHRWebListPerm error === ", (Throwable)e);
            map = permService.getPermSHRWebList(ctx);
        }
        return map;
    }

    public static void setSHRWebListPerm(PortalContext ctx, Map<String, String> shrList) {
        try {
            String userId = ctx.getLoginUser().getId();
            String listHash = MD5Helper.getStringMD5((String)shrList.get("idString"));
            if (StringUtil.isEmpty((String)listHash)) {
                listHash = userId;
            }
            String hashKey = "shrd_" + listHash;
            if (CacheProxy.getCache().get(hashKey) == null) {
                shrList.remove("idString");
                CacheProxy.getCache().put(hashKey, shrList);
            }
            PortalCache.setUserWithHashRef(userId, hashKey);
        }
        catch (Exception e) {
            logger.error("setSHRWebListPerm error===", (Throwable)e);
        }
    }

    private static void setUserWithHashRef(String userId, String hashValue) {
        try {
            if (CacheProxy.getCache().get("perm_" + userId) == null) {
                CacheProxy.getCache().put("perm_" + userId, hashValue);
            } else {
                String oldRef = (String)CacheProxy.getCache().get("perm_" + userId);
                if (oldRef.indexOf(hashValue) > -1) {
                    System.out.println("setUserWithHashRef hashValue:" + hashValue);
                    return;
                }
                String[] refs = oldRef.split(",");
                boolean isFind = false;
                for (int i = 0; i < refs.length; ++i) {
                    if (refs[i].indexOf(hashValue.substring(0, 4)) <= -1) continue;
                    refs[i] = hashValue;
                    isFind = true;
                    break;
                }
                String newRef = "";
                if (isFind) {
                    for (int i = 0; i < refs.length; ++i) {
                        newRef = newRef + refs[i] + ",";
                    }
                    newRef = newRef.substring(0, newRef.length() - 1);
                } else {
                    newRef = oldRef + "," + hashValue;
                }
                CacheProxy.getCache().put("perm_" + userId, newRef);
                System.out.println("setUserWithHashRef newRef:" + newRef);
            }
        }
        catch (Exception e) {
            logger.error("setUserWithHashRef error ====", (Throwable)e);
        }
    }

    private static String getUserWithHashRef(String userId, String menuType) {
        String hashKey;
        block3: {
            hashKey = null;
            try {
                String ref = null;
                if (CacheProxy.getCache().get("perm_" + userId) == null) break block3;
                ref = (String)CacheProxy.getCache().get("perm_" + userId);
                String[] refs = ref.split(",");
                for (int i = 0; i < refs.length; ++i) {
                    if (refs[i].indexOf(menuType + "_") <= -1) continue;
                    hashKey = refs[i];
                    break;
                }
            }
            catch (Exception e) {
                logger.error("getUserWithHashRef error ====", (Throwable)e);
            }
        }
        return hashKey;
    }

    public static void refreshMenu(PortalContext ctx) {
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            boolean licenseFlag = PortalCache.getLicenseFlag(context);
            PermService permService = (PermService)PortalServiceLocator.getBean("permService");
            permService.refreshMenu(ctx, licenseFlag);
            String lang = context.getLocale().toString();
            AppCenterService appCenterService = (AppCenterService)PortalServiceLocator.getBean("appCenterService");
            AppCenterCache appCache = appCenterService.getAppCenterDataByUserId(ctx);
            if (appCache == null) {
                appCenterService.updateAppCenterCacheByLanguage(ctx, lang, null);
            } else {
                if (appCache.getTreeContentL1() != null) {
                    appCenterService.updateAppCenterCacheByLanguage(ctx, "l1", appCache);
                }
                if (appCache.getTreeContentL2() != null) {
                    appCenterService.updateAppCenterCacheByLanguage(ctx, "l2", appCache);
                }
                if (appCache.getTreeContentL3() != null) {
                    appCenterService.updateAppCenterCacheByLanguage(ctx, "l3", appCache);
                }
            }
            PortalCache.setFavoriteList(ctx, null);
        }
        catch (Exception e) {
            logger.error("refreshMenu error === ", (Throwable)e);
        }
    }

    public static List<Page> getFavePageList(PortalContext ctx) {
        String userId = ctx.getLoginUser().getId();
        List<Page> pageList = null;
        PageService pageService = (PageService)PortalServiceLocator.getBean("pageService");
        try {
            String ids = null;
            pageList = CacheProxy.getCache().get("FavPage_" + userId) != null ? ((ids = (String)CacheProxy.getCache().get("FavPage_" + userId)).length() > 0 ? pageService.findPageListByIds(ctx, ids.split(",")) : new ArrayList()) : pageService.findFavPageList(ctx);
        }
        catch (Exception e) {
            logger.error("getFavePageList error === ", (Throwable)e);
            pageList = new ArrayList<Page>();
        }
        return pageList;
    }

    public static void setFavePageList(PortalContext ctx, String ids) {
        try {
            String userId = ctx.getLoginUser().getId();
            CacheProxy.getCache().put("FavPage_" + userId, ids);
        }
        catch (Exception e) {
            logger.error("setFavePageList error===", (Throwable)e);
        }
    }

    public static void removeFavePageListNull(PortalContext ctx) {
        try {
            String userId = ctx.getLoginUser().getId();
            CacheProxy.getCache().clear("FavPage_" + userId);
        }
        catch (Exception e) {
            logger.error("setFavePageList error===", (Throwable)e);
        }
    }

    public static List<PersonalFavoriteDTO> getFavoriteList(PortalContext ctx) {
        List<PersonalFavoriteDTO> favList = null;
        PersonalFavoriteService personalFavoriteService = (PersonalFavoriteService)PortalServiceLocator.getBean("personalFavoriteService");
        try {
            String cacheKey = "fav_" + ctx.getLoginUser().getId();
            if (CacheProxy.getCache().get(cacheKey) != null) {
                favList = (List<PersonalFavoriteDTO>)CacheProxy.getCache().get(cacheKey);
            }
            if (favList == null || favList.size() < 1) {
                favList = personalFavoriteService.findFavoriteListFromDB(ctx);
            }
        }
        catch (Exception e) {
            logger.error("getFavoriteList error===", (Throwable)e);
            try {
                favList = personalFavoriteService.findFavoriteListFromDB(ctx);
            }
            catch (PortalBizException e1) {
                logger.error("getFavoriteList getFavoriteList error===", (Throwable)e1);
            }
        }
        return favList;
    }

    public static void setFavoriteList(PortalContext ctx, List<PersonalFavoriteDTO> favList) {
        try {
            String userId = ctx.getLoginUser().getId();
            CacheProxy.getCache().put("fav_" + userId, favList);
        }
        catch (Exception e) {
            logger.error("setFavoriteList error===", (Throwable)e);
        }
    }

    public static Map<String, String> getNewContainerLicense(Context ctx) {
        Map<String, String> map = null;
        try {
            map = (Map<String, String>)CacheProxy.getCache().get("newContainerLicense");
            if (map == null) {
                map = PortalCache.freshNewContainerLicense(ctx);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return map;
    }

    public static Map<String, String> freshNewContainerLicense(Context ctx) {
        HashMap<String, String> licenseMap = new HashMap<String, String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FPageId,FClassName from T_JP_NEWPAGELICENSE");
            while (rs.next()) {
                String pageId = rs.getString("FPageId");
                String className = rs.getString("FClassName");
                licenseMap.put(pageId, Base64Util.decode((String)className));
            }
            CacheProxy.getCache().put("newContainerLicense", licenseMap);
        }
        catch (Exception ex) {
            logger.error("Error for set NewContainerLicense to cache:{}", (Object)ex.getMessage());
        }
        return licenseMap;
    }
}

