/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.action;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.enums.ResponseContentTypeEnum;
import com.kingdee.portal.biz.common.exception.handle.ErrHandle;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.perm.service.PermService;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.common.util.StringUtil;
import com.opensymphony.xwork2.ActionSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAction
extends ActionSupport {
    private PermService permService = (PermService)PortalServiceLocator.getBean("permService");
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected PagingParam pagingParam;

    protected HttpServletRequest getRequest() {
        return ServletActionContext.getRequest();
    }

    protected HttpServletResponse getResponse() {
        return ServletActionContext.getResponse();
    }

    protected ServletContext getServletContext() {
        return ServletActionContext.getServletContext();
    }

    protected PortalContext getPortalContext() {
        return PortalContextUtil.getPortalContext(this.getRequest());
    }

    protected LocalErr handleErr(Exception ex) {
        LocalErr err = ErrHandle.getLocalErr(ex, this.getPortalContext());
        this.logger.error(err.toString());
        return err;
    }

    protected void writeAjaxData(boolean success, LocalErr errinfo, Object result) {
        Object tempResult = result == null ? "" : result;
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("success", success);
        ajaxData.put("errinfo", errinfo);
        ajaxData.put("result", tempResult);
        this.writeObjectData(JSONUtil.getJson4Object(ajaxData), ResponseContentTypeEnum.JSON);
    }

    protected void writePagingResult(PagingResult<?> pagingResult) {
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("page", pagingResult.getPagingParam().getPageNo());
        ajaxData.put("total", pagingResult.getTotalCount());
        ajaxData.put("rows", pagingResult.getRecords());
        this.writeObjectData(JSONUtil.getJson4Object(ajaxData), ResponseContentTypeEnum.JSON);
    }

    protected void writeObjectData(Object result, ResponseContentTypeEnum contentType) {
        try {
            String _contentType = null;
            byte[] _result = null;
            if (ResponseContentTypeEnum.JSON.equals((Object)contentType)) {
                _contentType = "text/json;charset=utf-8";
                _result = result instanceof String ? result.toString().getBytes("utf-8") : (result instanceof byte[] ? (byte[])result : (result instanceof Collection ? JSONUtil.getJson4List((Collection)((Collection)result)).toString().getBytes("utf-8") : JSONUtil.getJson4Object((Object)result).toString().getBytes("utf-8")));
            } else if (ResponseContentTypeEnum.HTML.equals((Object)contentType)) {
                _contentType = "text/html;charset=utf-8";
                _result = result instanceof String ? result.toString().getBytes("utf-8") : (result instanceof byte[] ? (byte[])result : result.toString().getBytes("utf-8"));
            }
            this.writeResponse(this.getResponse(), _contentType, _result);
        }
        catch (Exception ex) {
            this.logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
    }

    protected void writeObjectData(Object result) {
        try {
            this.writeResponse(this.getResponse(), null, result.toString().getBytes("utf-8"));
        }
        catch (Exception ex) {
            this.logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
    }

    protected void writeResponse(HttpServletResponse response, String contentType, byte[] result) {
        try {
            response.setHeader("cache-control", "no-cache");
            response.setHeader("charset", "utf-8");
            if (!StringUtil.isEmpty((String)contentType)) {
                response.setContentType(contentType);
            }
            response.getOutputStream().write(result);
        }
        catch (Exception ex) {
            this.logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
    }

    protected Map<String, Object> getPermMap() {
        return null;
    }

    public PagingParam getPagingParam() {
        return this.pagingParam;
    }

    public void setPagingParam(PagingParam pagingParam) {
        this.pagingParam = pagingParam;
    }
}

