/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.portal.common.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.struts2.interceptor.ServletRequestAware;

public class BaseFileUploadAction
extends BaseAction
implements ServletRequestAware {
    private HttpServletRequest request;
    private File upload;
    private String uploadFileName;
    private String uploadContentType;

    protected void copyFile2UploadFolder() throws IOException {
        String uploadContentType = this.getUploadContentType();
        if (!FilterSpecialCharactersTool.checkImgValid(uploadContentType) || !FilterSpecialCharactersTool.checkImgNameValid(this.uploadFileName)) {
            throw new IOException("Illegal file format");
        }
        String targetDirectory = this.getTargetDirectory();
        String targetFileName = this.generateFileName(this.uploadFileName);
        File target = new File(targetDirectory, targetFileName);
        FileUtils.copyFile((File)this.upload, (File)target);
        this.upload = target;
    }

    protected File getFileByTempName(String fileTempName) {
        String targetDirectory = this.getTargetDirectory();
        String targetFileName = targetDirectory + "/" + fileTempName;
        File uploadFile = new File(targetFileName);
        return uploadFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getFileContent(File file) {
        byte[] data = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file.getAbsolutePath());
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
        }
        catch (IOException e) {
            this.logger.error("getFileContent===", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return data;
    }

    protected void writeResponse4Down(String displayName, String contentType, byte[] result) {
        try {
            this.getResponse().reset();
            this.getResponse().setHeader("cache-control", "no-cache");
            this.getResponse().setHeader("charset", "utf-8");
            if (StringUtil.isEmpty((String)contentType)) {
                String _displayName = URLEncoder.encode(StringUtil.convNull((String)displayName), "UTF-8");
                if (this.getRequest().getHeader("User-Agent").toLowerCase().indexOf("firefox") > 0) {
                    _displayName = new String(StringUtil.convNull((String)displayName).getBytes("UTF-8"), "ISO8859-1");
                }
                this.getResponse().addHeader("Content-Disposition", "attachment;filename=" + _displayName);
                this.getResponse().setContentType("application/x-download");
            } else {
                this.getResponse().setContentType(contentType);
            }
            this.getResponse().getOutputStream().write(result);
            this.getResponse().getOutputStream().flush();
        }
        catch (Exception ex) {
            this.logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
    }

    protected String getTargetDirectory() {
        String targetDirectory = Constant.TEMP_UPLOAD_PATH;
        this.logger.debug("upload dir:" + targetDirectory);
        return targetDirectory;
    }

    protected String generateFileName(String fileName) {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
        String formatDate = format.format(new Date());
        int random = new Random().nextInt(10000);
        int position = fileName.lastIndexOf(".");
        String extension = fileName.substring(position);
        return formatDate + random + extension;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public File getUpload() {
        return this.upload;
    }

    public void setUpload(File upload) {
        this.upload = upload;
    }

    public String getUploadFileName() {
        return this.uploadFileName;
    }

    public void setUploadFileName(String uploadFileName) {
        this.uploadFileName = uploadFileName;
    }

    public String getUploadContentType() {
        return this.uploadContentType;
    }

    public void setUploadContentType(String uploadContentType) {
        this.uploadContentType = uploadContentType;
    }
}

