/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.cache.impl;

import com.kingdee.portal.biz.common.cache.Cache;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionCache
implements Cache,
Serializable {
    private static final long serialVersionUID = -8798733103843402875L;
    private static final String HTTP_SESSION_CACHE_MAP_KEY = "http_session_cache_map_";
    private Logger logger = LoggerFactory.getLogger(HttpSessionCache.class);
    private Map<String, Object> cacheMap;

    public HttpSessionCache() {
        HttpSession session = ServletActionContext.getRequest().getSession();
        if (session.getAttribute(HTTP_SESSION_CACHE_MAP_KEY) == null) {
            session.setAttribute(HTTP_SESSION_CACHE_MAP_KEY, new HashMap());
        }
        this.cacheMap = (Map)session.getAttribute(HTTP_SESSION_CACHE_MAP_KEY);
    }

    public HttpSessionCache(HttpSession session) {
        if (session.getAttribute(HTTP_SESSION_CACHE_MAP_KEY) == null) {
            session.setAttribute(HTTP_SESSION_CACHE_MAP_KEY, new HashMap());
        }
        this.cacheMap = (Map)session.getAttribute(HTTP_SESSION_CACHE_MAP_KEY);
    }

    public HttpSessionCache(PortletSession session) {
        if (session.getAttribute(HTTP_SESSION_CACHE_MAP_KEY) == null) {
            session.setAttribute(HTTP_SESSION_CACHE_MAP_KEY, new HashMap());
        }
        this.cacheMap = (Map)session.getAttribute(HTTP_SESSION_CACHE_MAP_KEY);
    }

    @Override
    public void put(String cacheKey, Object value) {
        this.cacheMap.put(cacheKey, value);
        this.logger.info("HttpSessionCache put cache:" + cacheKey);
    }

    @Override
    public Object get(String cacheKey) {
        this.logger.info("HttpSessionCache get cache:" + cacheKey);
        return this.cacheMap.get(cacheKey);
    }

    @Override
    public void clear(String cacheKey) {
        this.cacheMap.remove(cacheKey);
        this.logger.info("HttpSessionCache clear cache:" + cacheKey);
    }

    @Override
    public boolean contains(String cacheKey) {
        return this.cacheMap.containsKey(cacheKey);
    }

    @Override
    public void clearAll() {
    }
}

