/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.cache.impl;

import com.kingdee.portal.biz.common.cache.Cache;
import com.kingdee.portal.biz.core.datacenter.DSObserver;
import com.kingdee.portal.common.util.StringUtil;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextCache
implements Cache {
    private static Logger logger = LoggerFactory.getLogger(ServletContextCache.class);
    private static ServletContext sysContext = null;

    @Override
    public void put(String cacheKey, Object value) {
        String _cacheKey = ServletContextCache.buildCacheKey(cacheKey);
        sysContext.setAttribute(_cacheKey, value);
        logger.info("ServletContextCache put cache:" + _cacheKey);
    }

    @Override
    public Object get(String cacheKey) {
        String _cacheKey = ServletContextCache.buildCacheKey(cacheKey);
        logger.info("ServletContextCache get cache:" + _cacheKey);
        return sysContext.getAttribute(_cacheKey);
    }

    @Override
    public void clear(String cacheKey) {
        String _cacheKey = ServletContextCache.buildCacheKey(cacheKey);
        sysContext.removeAttribute(_cacheKey);
        logger.info("ServletContextCache clear cache:" + _cacheKey);
    }

    @Override
    public boolean contains(String cacheKey) {
        String _cacheKey = ServletContextCache.buildCacheKey(cacheKey);
        return sysContext.getAttribute(_cacheKey) != null;
    }

    @Override
    public void clearAll() {
    }

    private static String buildCacheKey(String cacheKey) {
        return StringUtil.convNull((String)(cacheKey + "_" + DSObserver.getSp()));
    }

    public static void setServletContext(ServletContext servletContext) {
        sysContext = servletContext;
    }
}

