/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.dao.impl;

import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.IBaseDAO;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.QueryObject;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.entity.CoreBaseEntity;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.common.util.StringUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDAOImpl<T extends CoreBaseEntity>
implements IBaseDAO<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<T> entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private String entityClassName = this.entityClass.getSimpleName();
    @PersistenceContext
    protected EntityManager em;
    private static final String JPQL_DELETE_BY_ID = "DELETE {entityClassName} WHERE id = '{id}' ";
    private static final String JPQL_DELETE_BY_IDS = "DELETE {entityClassName} WHERE id IN ({ids}) ";
    private static final String JPQL_FINDLIST_BY_IDS = "SELECT t FROM {entityClassName} t WHERE t.id IN ({ids}) ";

    @Override
    public T create(T entity) throws DataAccessException {
        try {
            this.em.persist(entity);
            return entity;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public List<T> create(List<T> entityList) throws DataAccessException {
        try {
            if (entityList != null) {
                for (CoreBaseEntity entity : entityList) {
                    this.create((T)entity);
                }
            }
            return entityList;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public T update(T entity) throws DataAccessException {
        try {
            return (T)((CoreBaseEntity)this.em.merge(entity));
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public List<T> update(List<T> entityList) throws DataAccessException {
        try {
            if (entityList != null) {
                for (CoreBaseEntity entity : entityList) {
                    this.update((T)entity);
                }
            }
            return entityList;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public void delete(T entity) throws DataAccessException {
        try {
            this.em.remove(entity);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public int deleteById(String id) throws DataAccessException {
        try {
            String jpql = StringUtil.merge((String)JPQL_DELETE_BY_ID, (String[])new String[]{this.getEntityClassName(), id});
            int updated = this.executeUpdate(jpql, new Object[0]);
            return updated;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public int deleteByIds(String[] ids) throws DataAccessException {
        if (ids == null || ids.length <= 0) {
            return 0;
        }
        try {
            StringBuilder builder = new StringBuilder(100);
            builder.append("''");
            if (ids != null) {
                for (String id : ids) {
                    if (StringUtil.isEmpty((String)id)) continue;
                    builder.append(",'").append(id).append("'");
                }
            }
            String jpql = StringUtil.merge((String)JPQL_DELETE_BY_IDS, (String[])new String[]{this.getEntityClassName(), builder.toString()});
            int updated = this.executeUpdate(jpql, new Object[0]);
            return updated;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public T findById(String id) throws DataAccessException {
        try {
            return (T)((CoreBaseEntity)this.em.find(this.entityClass, (Object)id));
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public T findObject(T entity, Filter ... filters) throws DataAccessException {
        try {
            List<T> list = this.findList(entity, filters);
            if (list != null && !list.isEmpty()) {
                return (T)((CoreBaseEntity)list.get(0));
            }
            return null;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public T findObject(Filter ... filters) throws DataAccessException {
        try {
            List<CoreBaseEntity> list = this.findList((T)null, filters);
            if (list != null && !list.isEmpty()) {
                return (T)list.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public List<T> findList(Filter ... filters) throws DataAccessException {
        try {
            QueryObject queryObject = this.buildQueryObject((CoreBaseEntity)null, filters);
            return this.findList(queryObject);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public List<T> findList(T entity, Filter ... filters) throws DataAccessException {
        try {
            QueryObject queryObject = this.buildQueryObject(entity, filters);
            return this.findList(queryObject);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public List<T> findListByIds(String[] ids) throws DataAccessException {
        try {
            ArrayList<T> resultList = new ArrayList<T>();
            if (ids != null) {
                int pageSize = 900;
                int totalCount = ids.length;
                int totalPage = (totalCount - 1) / pageSize + 1;
                for (int i = 0; i < totalPage; ++i) {
                    int firstCount = i * pageSize;
                    int maxCount = (i + 1) * pageSize;
                    if (maxCount > totalCount) {
                        maxCount = totalCount;
                    }
                    StringBuilder builder = new StringBuilder(100);
                    builder.append("''");
                    for (int j = firstCount; j < maxCount; ++j) {
                        if (StringUtil.isEmpty((String)ids[j])) continue;
                        builder.append(",'").append(ids[j]).append("'");
                    }
                    String jpql = StringUtil.merge((String)JPQL_FINDLIST_BY_IDS, (String[])new String[]{this.getEntityClassName(), builder.toString()});
                    resultList.addAll(this.findList(jpql, new Object[0]));
                }
            }
            return resultList;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public PagingResult<T> findList(T entity, PagingParam pagingParam, Filter ... filters) throws DataAccessException {
        QueryObject queryObject = this.buildQueryObject(entity, pagingParam, filters);
        List<T> list = this.findList(queryObject);
        queryObject.setSelectClause(this.getSelectCountSQL());
        queryObject.setOrderClause(null);
        int totalCount = this.totalCount(queryObject);
        PagingResult<T> pagingResult = new PagingResult<T>(pagingParam, totalCount, list);
        return pagingResult;
    }

    protected PagingResult<Object[]> findList(String pagingJpql, Map<String, Object> paramMap, PagingParam pagingParam, String countJpql) throws DataAccessException {
        QueryObject queryObject = this.buildQueryObject(pagingJpql, paramMap, pagingParam);
        List pagingList = this.findCustomList(queryObject);
        queryObject.setSelectClause(countJpql);
        int totalCount = this.totalCount(queryObject);
        PagingResult<Object[]> pagingResult = new PagingResult<Object[]>(pagingParam, totalCount, pagingList);
        return pagingResult;
    }

    protected PagingResult<?> findList4CustomJPQL(String pagingJpql, Map<String, Object> paramMap, PagingParam pagingParam, String countJpql) throws DataAccessException {
        QueryObject queryObject = this.buildQueryObject(pagingJpql, paramMap, pagingParam);
        List pagingList = this.findCustomList(queryObject);
        queryObject.setSelectClause(countJpql);
        int totalCount = this.totalCount(queryObject);
        PagingResult pagingResult = new PagingResult(pagingParam, totalCount, pagingList);
        return pagingResult;
    }

    @Override
    public int totalCount(T entity, Filter ... filters) throws DataAccessException {
        QueryObject queryObject = this.buildQueryObject(entity, filters);
        queryObject.setSelectClause(this.getSelectCountSQL());
        return this.totalCount(queryObject);
    }

    protected String getSelectObjectSQL() {
        StringBuilder select = new StringBuilder(100);
        select.append("SELECT t FROM ").append(this.entityClassName).append(" t ");
        return select.toString();
    }

    protected String getSelectCountSQL() {
        StringBuilder select = new StringBuilder(100);
        select.append("SELECT count(t) FROM ").append(this.entityClassName).append(" t ");
        return select.toString();
    }

    protected Class<T> getEntityClass() {
        return this.entityClass;
    }

    protected String getEntityClassName() {
        return this.entityClassName;
    }

    protected int totalCount(QueryObject queryObject) throws DataAccessException {
        Query query = this.buildQuery(queryObject);
        return ((Long)query.getSingleResult()).intValue();
    }

    protected T findSingleResult(QueryObject queryObject) throws DataAccessException {
        Query query = this.buildQuery(queryObject);
        return (T)((CoreBaseEntity)query.getSingleResult());
    }

    protected List<T> findList(QueryObject queryObject) throws DataAccessException {
        Query query = this.buildQuery(queryObject);
        return query.getResultList();
    }

    @Override
    public List<T> findList(String jpql, Object ... params) throws DataAccessException {
        QueryObject queryObject = this.buildQueryObject(jpql, params);
        Query query = this.buildQuery(queryObject);
        return query.getResultList();
    }

    protected List findCustomList(QueryObject queryObject) throws DataAccessException {
        Query query = this.buildQuery(queryObject);
        return query.getResultList();
    }

    protected List<T> findList(String jpql, Map<String, Object> paramMap) throws DataAccessException {
        QueryObject queryObject = this.buildQueryObject(jpql, paramMap);
        Query query = this.buildQuery(queryObject);
        return query.getResultList();
    }

    protected int executeUpdate(String jpql, Object ... params) throws DataAccessException {
        QueryObject queryObject = this.buildQueryObject(jpql, params);
        Query query = this.buildQuery(queryObject);
        return query.executeUpdate();
    }

    protected int executeUpdate(String jpql, Map<String, Object> paramMap) throws DataAccessException {
        QueryObject queryObject = this.buildQueryObject(jpql, paramMap);
        Query query = this.buildQuery(queryObject);
        return query.executeUpdate();
    }

    private QueryObject _buildWhereClause4Entity(Object entity, String jpqlPrefix, String paramPrefix) throws DataAccessException {
        QueryObject queryObject = new QueryObject();
        try {
            StringBuilder whereClause = new StringBuilder(100);
            List<Field> fieldArray = this.getColumnFieldArray(entity);
            int index = 0;
            for (Field field : fieldArray) {
                String fieldName = field.getName();
                Object fieldValue = field.get(entity);
                if (fieldValue == null) continue;
                String fieldSuffix = "_e" + index++;
                whereClause.append("AND ").append(jpqlPrefix).append(fieldName).append(" = :").append(paramPrefix).append(fieldName).append(fieldSuffix).append(" ");
                queryObject.getParamMap().put(paramPrefix + fieldName + fieldSuffix, fieldValue);
            }
            queryObject.setWhereClause(whereClause.toString());
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            throw new DataAccessException(ex.getCause());
        }
        return queryObject;
    }

    private QueryObject buildQueryObject(T entity, Filter ... filters) throws DataAccessException {
        QueryObject queryObject = new QueryObject();
        try {
            List<FieldFilter> fieldFilterList;
            queryObject.setSelectClause(this.getSelectObjectSQL());
            StringBuilder whereClause = new StringBuilder(100);
            if (entity != null) {
                QueryObject _whereClauseQueryObject = this._buildWhereClause4Entity(entity, "t.", "t_");
                whereClause.append(_whereClauseQueryObject.getWhereClause());
                queryObject.getParamMap().putAll(_whereClauseQueryObject.getParamMap());
                List<Field> entityFieldArray = this.getEntityFieldArray(entity);
                for (Field field : entityFieldArray) {
                    String fieldName = field.getName();
                    Object fieldValue = field.get(entity);
                    if (fieldValue == null) continue;
                    _whereClauseQueryObject = this._buildWhereClause4Entity(fieldValue, "t." + fieldName + ".", "t_" + fieldName + "_");
                    whereClause.append(_whereClauseQueryObject.getWhereClause());
                    queryObject.getParamMap().putAll(_whereClauseQueryObject.getParamMap());
                }
            }
            if ((fieldFilterList = this.getFieldFilter(filters)) != null) {
                for (int i = 0; i < fieldFilterList.size(); ++i) {
                    FieldFilter fieldFilter = fieldFilterList.get(i);
                    String fieldSuffix = "_f" + i;
                    String tempFieldValueKey = fieldFilter.getFieldName() + fieldSuffix;
                    whereClause.append("AND t.").append(fieldFilter.getFieldName()).append(" ").append(fieldFilter.getCompare()).append(" :").append(tempFieldValueKey).append(" ");
                    queryObject.getParamMap().put(tempFieldValueKey, fieldFilter.getFieldValue());
                }
            }
            queryObject.setWhereClause(whereClause.toString());
            StringBuilder orderClause = new StringBuilder(100);
            List<OrderFilter> orderFilterList = this.getOrderFilter(filters);
            if (orderFilterList != null && !orderFilterList.isEmpty()) {
                for (int i = 0; i < orderFilterList.size(); ++i) {
                    OrderFilter orderFilter = orderFilterList.get(i);
                    orderClause.append("t.").append(orderFilter.getFieldName()).append(" ").append(orderFilter.getOrderEnum().toString());
                    if (i >= orderFilterList.size() - 1) continue;
                    orderClause.append(", ");
                }
            }
            queryObject.setOrderClause(orderClause.toString());
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            throw new DataAccessException(ex.getCause());
        }
        return queryObject;
    }

    private QueryObject buildQueryObject(T entity, PagingParam pagingParam, Filter ... filters) throws DataAccessException {
        Filter[] _filters = this.insertPagingOrderFilter(pagingParam, filters);
        QueryObject queryObject = this.buildQueryObject(entity, _filters);
        queryObject.setStartResultIndex(pagingParam.getStartIndex());
        queryObject.setMaxResultSize(pagingParam.getPageSize());
        return queryObject;
    }

    private QueryObject buildQueryObject(String jpql, Map<String, Object> paramMap) {
        QueryObject queryObject = new QueryObject();
        queryObject.setSelectClause(jpql);
        if (paramMap != null && !paramMap.isEmpty()) {
            queryObject.setParamMap(paramMap);
        }
        return queryObject;
    }

    private QueryObject buildQueryObject(String jpql, Map<String, Object> paramMap, PagingParam pagingParam) {
        QueryObject queryObject = new QueryObject();
        queryObject.setSelectClause(jpql);
        if (paramMap != null && !paramMap.isEmpty()) {
            queryObject.setParamMap(paramMap);
        }
        queryObject.setStartResultIndex(pagingParam.getStartIndex());
        queryObject.setMaxResultSize(pagingParam.getPageSize());
        return queryObject;
    }

    private QueryObject buildQueryObject(String jpql, Object[] params) {
        QueryObject queryObject = new QueryObject();
        jpql = jpql + " ";
        queryObject.setSelectClause(jpql);
        if (params != null && params.length > 0) {
            List<String> jpqlFieldList = this.getJpqlFieldList(jpql);
            for (int i = 0; i < jpqlFieldList.size(); ++i) {
                queryObject.getParamMap().put(jpqlFieldList.get(i), params[i]);
            }
        }
        return queryObject;
    }

    private Query buildQuery(QueryObject queryObject) {
        Query query = this.em.createQuery(queryObject.getQueryString());
        if (queryObject.getParamMap() != null && !queryObject.getParamMap().isEmpty()) {
            for (String attrName : queryObject.getParamMap().keySet()) {
                Object param = queryObject.getParamMap().get(attrName);
                if (param instanceof Timestamp) {
                    query.setParameter(attrName, (Date)((Timestamp)param), TemporalType.TIMESTAMP);
                    continue;
                }
                if (param instanceof Date) {
                    query.setParameter(attrName, (Date)param, TemporalType.DATE);
                    continue;
                }
                query.setParameter(attrName, param);
            }
        }
        return query;
    }

    private List<String> getJpqlFieldList(String jpql) {
        ArrayList<String> fieldList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(":(.+?)\\s");
        Matcher matcher = pattern.matcher(jpql);
        int i = 0;
        while (matcher.find(i)) {
            String key = matcher.group(1);
            fieldList.add(key);
            i = jpql.indexOf(":" + key, i) + key.length();
        }
        return fieldList;
    }

    private List<FieldFilter> getFieldFilter(Filter[] filter) {
        ArrayList<FieldFilter> fieldFilterList = new ArrayList<FieldFilter>();
        if (filter != null) {
            for (int i = 0; i < filter.length; ++i) {
                if (!(filter[i] instanceof FieldFilter)) continue;
                fieldFilterList.add((FieldFilter)filter[i]);
            }
        }
        return fieldFilterList;
    }

    private List<OrderFilter> getOrderFilter(Filter[] filter) {
        ArrayList<OrderFilter> orderFilterList = new ArrayList<OrderFilter>();
        if (filter != null) {
            for (int i = 0; i < filter.length; ++i) {
                if (!(filter[i] instanceof OrderFilter)) continue;
                orderFilterList.add((OrderFilter)filter[i]);
            }
        }
        return orderFilterList;
    }

    private List<Field> getColumnFieldArray(Object entity) {
        ArrayList<AccessibleObject> allFieldList = new ArrayList<AccessibleObject>();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Class<?> clazz = entity.getClass();
        while (clazz.getName().indexOf("com.kingdee.portal") > -1) {
            AccessibleObject[] fieldArray = clazz.getDeclaredFields();
            Field.setAccessible(fieldArray, true);
            allFieldList.addAll(Arrays.asList(fieldArray));
            clazz = clazz.getSuperclass();
        }
        for (Field field : allFieldList) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            fieldList.add(field);
        }
        return fieldList;
    }

    private List<Field> getEntityFieldArray(T entity) {
        ArrayList<AccessibleObject> allFieldList = new ArrayList<AccessibleObject>();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Class<?> clazz = entity.getClass();
        while (clazz.getName().indexOf("com.kingdee.portal") > -1) {
            AccessibleObject[] fieldArray = clazz.getDeclaredFields();
            Field.setAccessible(fieldArray, true);
            allFieldList.addAll(Arrays.asList(fieldArray));
            clazz = clazz.getSuperclass();
        }
        for (Field field : allFieldList) {
            if (!field.isAnnotationPresent(OneToOne.class) && !field.isAnnotationPresent(ManyToOne.class)) continue;
            fieldList.add(field);
        }
        return fieldList;
    }

    private Filter[] insertPagingOrderFilter(PagingParam pagingParam, Filter ... filters) {
        OrderFilter pagingOrderFilter = null;
        if (!StringUtil.isEmpty((String)pagingParam.getSortField())) {
            pagingOrderFilter = pagingParam.getOrder() != null ? new OrderFilter(pagingParam.getSortField(), pagingParam.getOrder()) : new OrderFilter(pagingParam.getSortField(), OrderEnum.ASC);
        } else if (this.getOrderFilter(filters).isEmpty()) {
            pagingOrderFilter = new OrderFilter("id", OrderEnum.ASC);
        }
        if (pagingOrderFilter == null) {
            return filters;
        }
        Filter[] _filters = null;
        if (filters == null) {
            _filters = new Filter[]{pagingOrderFilter};
        } else {
            _filters = new Filter[filters.length + 1];
            _filters[0] = pagingOrderFilter;
            for (int i = 1; i < _filters.length; ++i) {
                _filters[i] = filters[i - 1];
            }
        }
        return _filters;
    }
}

