/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.entity;

import com.kingdee.portal.biz.common.entity.ObjectBaseEntity;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import javax.persistence.Column;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;

@Inheritance(strategy=InheritanceType.JOINED)
@MappedSuperclass
public class TreeBaseEntity
extends ObjectBaseEntity {
    @Column(name="FParentNodeId", length=44)
    private String parentNodeId;
    @Column(name="FNodePath", length=1200)
    private String nodePath;
    @Column(name="FNodeLevel")
    private Integer nodeLevel;
    @Column(name="FNodeOrder")
    private Integer nodeOrder;
    @Column(name="FHidden")
    private Boolean hidden;
    @Transient
    private TreeBaseEntity parentNode;

    @PrePersist
    private void prePersist4TreeBaseEntity() throws DataAccessException {
        if (this.parentNode != null) {
            this.nodeLevel = this.parentNode.getNodeLevel() + 1;
            this.nodePath = this.parentNode.getNodePath() + "/" + this.getId();
            this.parentNodeId = this.parentNode.getId();
        }
        if (this.nodePath == null || this.nodeLevel == null) {
            throw new DataAccessException("parentNode not be set!");
        }
        if (this.nodeOrder == null) {
            this.nodeOrder = 0;
        }
        if (this.hidden == null) {
            this.hidden = false;
        }
    }

    @PreUpdate
    private void preUpdate4TreeBaseEntity() {
        if (this.parentNode != null) {
            this.nodeLevel = this.parentNode.getNodeLevel() + 1;
            this.nodePath = this.parentNode.getNodePath() + "/" + this.getId();
            this.parentNodeId = this.parentNode.getId();
        }
    }

    public String getParentNodeId() {
        return this.parentNodeId;
    }

    public void setParentNodeId(String parentNodeId) {
        this.parentNodeId = parentNodeId;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    public Integer getNodeLevel() {
        return this.nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }

    public Integer getNodeOrder() {
        return this.nodeOrder;
    }

    public void setNodeOrder(Integer nodeOrder) {
        this.nodeOrder = nodeOrder;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void setParentNode(TreeBaseEntity parentNode) {
        this.parentNode = parentNode;
    }

    public boolean hasChildNode(TreeBaseEntity childNode) {
        return !this.getId().equals(childNode.getId()) && childNode.getNodePath().startsWith(this.getNodePath());
    }
}

