/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.exception.conf;

import com.kingdee.portal.biz.common.exception.model.Err;
import com.kingdee.portal.biz.common.exception.model.ErrDesc;
import com.kingdee.portal.biz.common.exception.model.ErrLevelEnum;
import com.kingdee.portal.biz.common.exception.model.ErrMsg;
import com.kingdee.portal.biz.common.exception.model.ErrSuggest;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrConfig {
    protected static final Logger logger = LoggerFactory.getLogger(ErrConfig.class);
    private static Map<String, Err> errorMap = new HashMap<String, Err>();
    public static final String UNKNOWN_ERROR = "001";
    public static final String DATABASE_ERROR = "002";
    public static final String LOSE_PARAMS_ERROR = "003";

    public static boolean isExisted(String errCode) {
        return errorMap.containsKey(errCode);
    }

    public static void putError(String errCode, Err error) {
        if (errorMap.containsKey(errCode)) {
            logger.error("Already exists errCode:" + errCode);
            return;
        }
        errorMap.put(errCode, error);
    }

    public static Err getError(String errCode) {
        return errorMap.get(errCode).clone();
    }

    static {
        ErrConfig.putError(UNKNOWN_ERROR, new Err(UNKNOWN_ERROR, new ErrMsg("Unkown Exception", "\u672a\u77e5\u5f02\u5e38", "\u672a\u77e5\u7570\u5e38"), new ErrDesc("Encounter one undefined exception", "\u7cfb\u7edf\u9047\u5230\u4e00\u4e2a\u5c1a\u672a\u88ab\u660e\u786e\u5b9a\u4e49\u7684\u5f02\u5e38\u7c7b\u578b", ""), ErrLevelEnum.BIZ, new ErrSuggest[]{new ErrSuggest("Please contact system manager", "\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406", "\u806f\u7e6b\u7ba1\u7406\u54e1\u9032\u884c\u8655\u7406")}));
        ErrConfig.putError(DATABASE_ERROR, new Err(DATABASE_ERROR, new ErrMsg("Database error", "\u6570\u636e\u5e93\u9519\u8bef", "\u6578\u64da\u5eab\u932f\u8aa4"), new ErrDesc("During transaction,encounter one error can not be recovered", "\u5904\u7406\u4e1a\u52a1\u65f6\uff0c\u9047\u5230\u4e00\u4e2a\u65e0\u6cd5\u6062\u590d\u7684\u6570\u636e\u5e93\u9519\u8bef", ""), ErrLevelEnum.BIZ, new ErrSuggest[]{new ErrSuggest("Please contact system manager", "\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406", "\u806f\u7e6b\u7ba1\u7406\u54e1\u9032\u884c\u8655\u7406")}));
        ErrConfig.putError(LOSE_PARAMS_ERROR, new Err(LOSE_PARAMS_ERROR, new ErrMsg("Be lack of essential parameters", "\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570", "\u7f3a\u5c11\u5fc5\u8981\u7684\u53c3\u6578"), new ErrDesc("Be lack of essentail parameters to execute fucntion", "\u65b9\u6cd5\u6267\u884c\u65f6\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570", "\u65b9\u6cd5\u57f7\u884c\u6642\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c3\u6578"), ErrLevelEnum.BIZ, new ErrSuggest[]{new ErrSuggest("Please contact system manager", "\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406", "\u806f\u7e6b\u7ba1\u7406\u54e1\u9032\u884c\u8655\u7406")}));
    }
}

