/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.exception.handle;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.conf.ErrConfig;
import com.kingdee.portal.biz.common.exception.model.Err;
import com.kingdee.portal.biz.common.exception.model.ErrMsg;
import com.kingdee.portal.biz.common.exception.model.ErrSuggest;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class ErrHandle {
    public static Err getErr(Exception ex) {
        Err err = null;
        if (ex instanceof BizException) {
            BizException bex = (BizException)ex;
            String errCode = bex.getErrCode();
            if (ErrConfig.isExisted(errCode)) {
                err = ErrConfig.getError(errCode);
                err.setContextParams(bex.getErrContext());
                if (bex != null && bex.getCause() != null) {
                    err.setThrowable(bex.getCause());
                } else {
                    err.setThrowable(bex);
                }
            }
        } else {
            err = ErrConfig.getError("001");
            ErrMsg msg = new ErrMsg(ex.getMessage(), ex.getMessage(), ex.getMessage());
            err.setMsg(msg);
            err.setThrowable(ex);
        }
        if (err == null) {
            err = ErrConfig.getError("001");
            err.setThrowable(ex);
        }
        return err;
    }

    public static LocalErr getLocalErr(Exception ex, PortalContext portalContext) {
        Err err = ErrHandle.getErr(ex);
        LocalErr localErr = new LocalErr();
        String locale = "zh_CN";
        if (portalContext != null) {
            locale = portalContext.getLocale().toString();
        }
        localErr.setCode(err.getCode());
        localErr.setMsg(err.getMsg().setLocale(locale).getLocaleText());
        localErr.setDesc(err.getDesc().setLocale(locale).getLocaleText());
        localErr.setErrorLevel(err.getErrorLevel());
        String[] errSuggests = null;
        if (err.getSuggests() != null && err.getSuggests().length > 0) {
            errSuggests = new String[err.getSuggests().length];
            int i = 0;
            for (ErrSuggest suggest : err.getSuggests()) {
                errSuggests[i++] = suggest.setLocale(locale).getLocaleText();
            }
            localErr.setSuggests(errSuggests);
        }
        if (err.getThrowable() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            err.getThrowable().printStackTrace(ps);
            String stackInfo = baos.toString();
            stackInfo = stackInfo.replaceAll("\tat ", "<br/> at ");
            localErr.setStackInfo(stackInfo);
        }
        return localErr;
    }
}

