/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.i18n.service.impl;

import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nServiceImpl
implements II18nService {
    private static final Logger logger = LoggerFactory.getLogger(I18nServiceImpl.class);

    @Override
    public String getText(PortalContext pcontext, String sourceFileName, String keyName) throws PortalBizException {
        String result = "";
        try {
            Locale local = pcontext.getLocale();
            if (StringUtil.isEmpty((String)local.getCountry())) {
                Locale.setDefault(new Locale("en", "EN"));
            }
            ResourceBundle bundle = ResourceBundle.getBundle(sourceFileName, local);
            result = bundle.getString(keyName);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return result;
        }
        return result;
    }

    @Override
    public String getText(PortalContext pcontext, String sourceFileName, String keyName, Locale locale) throws PortalBizException {
        String result = "";
        try {
            if (locale == null) {
                Locale.setDefault(new Locale("en", "EN"));
            }
            ResourceBundle bundle = ResourceBundle.getBundle(sourceFileName, locale);
            result = bundle.getString(keyName);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return result;
        }
        return result;
    }
}

