/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.tag;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.io.IOException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18NTextTag
extends TagSupport {
    private String text = null;
    private static Logger logger = LoggerFactory.getLogger(I18NTextTag.class);

    public int doStartTag() throws JspTagException {
        return 1;
    }

    public int doEndTag() throws JspTagException {
        try {
            JspWriter out = this.pageContext.getOut();
            String currentLangText = "";
            if (!StringUtil.isEmpty((String)this.text)) {
                PortalContext portalContext = PortalContextUtil.getPortalContext(this.pageContext.getSession());
                try {
                    DisplayName displayName = new DisplayName(this.text, portalContext.getLocale().toString());
                    currentLangText = displayName.getLocaleText();
                }
                catch (Exception ex) {
                    logger.error("json format error:" + this.text, (Throwable)ex);
                    currentLangText = "";
                }
            }
            out.print(currentLangText);
        }
        catch (IOException e) {
            logger.error("i18N conversion error:" + this.text, (Throwable)e);
        }
        return 0;
    }

    public void release() {
        super.release();
        this.text = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

