/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.VersionManager;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.util.EASWebLicenceHelper;
import com.kingdee.util.Base64Encoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class AboutInfoUtil {
    public static final String UNKNOWN = "Unknown";
    private static final String HOME_URL = "http://www.kingdee.com";
    private static final String SERVICE_URL = "http://service.kingdee.com";
    private static final String Genuine_URL = "http://www.kingdee.com/genuine";

    public static String getBosVersion(PortalContext portalContext) {
        Context context = (Context)portalContext.getMetaInfo().get("eas_context");
        String bosversion = UIFrameUtils.getEASOrBOSVersionFromServerAtProperties((String)"BOS", (Locale)context.getLocale());
        return bosversion == null ? UNKNOWN : bosversion;
    }

    public static String getEASversion(PortalContext portalContext) {
        Context context = (Context)portalContext.getMetaInfo().get("eas_context");
        String version = UIFrameUtils.getEASOrBOSVersionFromServerAtProperties((String)"EAS", (Locale)context.getLocale());
        if (null == version) {
            VersionManager vmeas = new VersionManager();
            try {
                version = vmeas.getMetadataVersion();
            }
            catch (Exception e1) {
                version = UNKNOWN;
            }
        }
        return version;
    }

    public static String getSerialNum() {
        try {
            return LicenseSrvAgentFactory.getRemoteInstance().getLicenseBaseInfo().getSerialNum();
        }
        catch (LicenseException e) {
            e.printStackTrace();
            return UNKNOWN;
        }
    }

    public static String getLicenseTo() {
        try {
            return new String(Base64Encoder.base64ToByteArray((String)LicenseSrvAgentFactory.getRemoteInstance().getLicenseBaseInfo().getLicenseTo()), "GBK");
        }
        catch (Exception e) {
            e.printStackTrace();
            return UNKNOWN;
        }
    }

    public static String getKDCopyRight() {
        return AboutInfoUtil.getString("AboutDlg.KD");
    }

    public static String getEIS() {
        return AboutInfoUtil.getString("AboutDlg.EIS");
    }

    public static String getHomeURL() {
        return HOME_URL;
    }

    public static String getServiceURL() {
        return SERVICE_URL;
    }

    public static String getGenuineURL() {
        return Genuine_URL;
    }

    public static String getServicValideDate() {
        try {
            ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getRemoteInstance();
            Date servicValideDate = iLicenseSrvAgent.getLicenseBaseInfo().getServiceDate();
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
            String formatServicValideDate = ft.format(servicValideDate);
            return formatServicValideDate;
        }
        catch (LicenseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getlicenseValidDate() {
        try {
            Date now = new Date();
            long time = now.getTime();
            ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getRemoteInstance();
            long licenseValidDays = EASWebLicenceHelper.getValidDays(iLicenseSrvAgent.getLicenseValidateInfo()) * 86400000L;
            Date licenseValideDate = new Date(time += licenseValidDays);
            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
            String formatLicenseValideDate = ft.format(licenseValideDate);
            return formatLicenseValideDate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String getString(String strKey) {
        return UIFrameResource.getString((String)strKey);
    }
}

