/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AttackFilter
implements Filter {
    private static final Pattern SCRIPT_PATTERN = Pattern.compile("<\\s*script\\s*>.*<\\s*/\\s*script\\s*>");
    private static final Pattern JAVASCRIPT_PATTERN = Pattern.compile("<\\s*javascript\\s*>.*<\\s*/\\s*javascript\\s*>");
    private static final Pattern ALERT_PATTERN = Pattern.compile("\\s*alert\\s*\\((.*)\\)\\s*");
    private static final Pattern EVAL_PATTERN = Pattern.compile("\\s*eval\\s*\\((.*)\\)\\s*");
    private boolean enabled = false;
    private boolean enableCSRFCheck;
    private Map<String, Pattern[]> allowMap = new HashMap<String, Pattern[]>();
    private Map<String, Pattern[]> denyMap = new HashMap<String, Pattern[]>();
    private List<Pattern> FILTERS_PATTERN = new ArrayList<Pattern>();
    private static String[] SERVERNAME_WHITELIST;
    private static final String[] HTMLASC_X;
    private static final String[] HTMLASC;
    private static final String[] HTMLCHARS;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.checkAccess((HttpServletRequest)request)) {
            ((HttpServletResponse)response).sendError(403);
            return;
        }
        if (this.enableCSRFCheck && !this.checkCSRF(request)) {
            ((HttpServletResponse)response).sendError(403);
            return;
        }
        if (this.enabled && !this.checkAttack(request)) {
            ((HttpServletResponse)response).sendError(403);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean checkAccess(HttpServletRequest request) {
        String contextroot;
        boolean result = true;
        String clientHostId = request.getRemoteAddr();
        if (!this.isAllowHost(clientHostId, contextroot = request.getContextPath()) || this.isDenyHost(clientHostId, contextroot)) {
            return false;
        }
        return result;
    }

    private boolean checkAttack(ServletRequest request) {
        return this.checkAttack(((HttpServletRequest)request).getRequestURI(), request.getParameterMap());
    }

    private boolean checkCSRF(ServletRequest request) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String referer = httpServletRequest.getHeader("Referer");
        String serverName = request.getServerName();
        return this.checkCSRF(referer, serverName);
    }

    protected boolean checkCSRF(String referer, String serverName) {
        if (referer == null || referer.length() <= 0 || referer.contains(serverName)) {
            return true;
        }
        if (SERVERNAME_WHITELIST != null && SERVERNAME_WHITELIST.length > 0) {
            for (int i = 0; i < SERVERNAME_WHITELIST.length; ++i) {
                if (referer.indexOf(SERVERNAME_WHITELIST[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkAttack(String requestUri, Map<String, String[]> paramMap) {
        if (SCRIPT_PATTERN.matcher((requestUri = AttackFilter.htmlNotationtoChar(requestUri)).toLowerCase()).find() || JAVASCRIPT_PATTERN.matcher(requestUri.toLowerCase()).find() || ALERT_PATTERN.matcher(requestUri.toLowerCase()).find()) {
            return false;
        }
        String[] params = null;
        String lowStr = null;
        Iterator<String> it = paramMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            params = paramMap.get(key);
            key = AttackFilter.htmlNotationtoChar(key.toLowerCase());
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    lowStr = AttackFilter.htmlNotationtoChar(params[i].toLowerCase());
                    for (Pattern tmp : this.FILTERS_PATTERN) {
                        if (!tmp.matcher(lowStr).find() && !tmp.matcher(key).find()) continue;
                        return false;
                    }
                }
            }
            params = null;
        }
        return true;
    }

    public void init(FilterConfig fConfig) throws ServletException {
        int i;
        String[] tmps;
        String root;
        this.enabled = AttackFilter.parseBoolean(fConfig.getInitParameter("enableAttackFilter"), false);
        this.enableCSRFCheck = AttackFilter.parseBoolean(fConfig.getInitParameter("enableCSRFCheck"), false);
        String allowHosts = fConfig.getInitParameter("allowHosts");
        String denyHosts = fConfig.getInitParameter("denyHosts");
        String filterKWstr1 = fConfig.getInitParameter("filterKW1");
        String filterKWstr2 = fConfig.getInitParameter("filterKW2");
        String serverNameWhiteList = fConfig.getInitParameter("serverNameWhiteList");
        List<String> filterKWList1 = Arrays.asList(filterKWstr1 == null ? "alert,javascript,script,expression".split(",") : filterKWstr1.split(","));
        List<String> filterKWList2 = Arrays.asList(filterKWstr2 == null ? "alter".split(",") : filterKWstr2.split(","));
        this.FILTERS_PATTERN.add(SCRIPT_PATTERN);
        this.FILTERS_PATTERN.add(JAVASCRIPT_PATTERN);
        this.FILTERS_PATTERN.add(ALERT_PATTERN);
        this.FILTERS_PATTERN.add(EVAL_PATTERN);
        for (String tmp : filterKWList1) {
            this.FILTERS_PATTERN.add(Pattern.compile("\\s*" + tmp + "\\s*\\((.*)\\)\\s*"));
        }
        for (String tmp : filterKWList2) {
            this.FILTERS_PATTERN.add(Pattern.compile("\\s+" + tmp + "\\s+"));
            this.FILTERS_PATTERN.add(Pattern.compile("^" + tmp + "\\s+"));
        }
        if (serverNameWhiteList != null) {
            SERVERNAME_WHITELIST = serverNameWhiteList.split(",");
        }
        if (allowHosts != null && allowHosts.length() > 0) {
            int flag = allowHosts.indexOf(":");
            root = null;
            if (flag > 0) {
                root = allowHosts.substring(0, flag);
                allowHosts = allowHosts.substring(flag + 1);
            }
            tmps = allowHosts.split(",");
            Pattern[] allowHostsPattern = new Pattern[tmps.length];
            i = 0;
            for (String tmp : tmps) {
                tmp = tmp.replaceAll("\\.", "\\\\.");
                tmp = tmp.replaceAll("\\*", ".\\*");
                allowHostsPattern[i++] = Pattern.compile(tmp);
            }
            root = root == null || root.equals("") ? "allRoot" : root;
            this.allowMap.put(root, allowHostsPattern);
        }
        if (denyHosts != null && denyHosts.length() > 0) {
            int flag = denyHosts.indexOf(":");
            root = null;
            if (flag > 0) {
                root = denyHosts.substring(0, flag);
                denyHosts = denyHosts.substring(flag + 1);
            }
            tmps = denyHosts.split(",");
            Pattern[] denyHostsPattern = new Pattern[tmps.length];
            i = 0;
            for (String tmp : tmps) {
                tmp = tmp.replaceAll("\\.", "\\\\.");
                tmp = tmp.replaceAll("\\*", ".\\*");
                denyHostsPattern[i++] = Pattern.compile(tmp);
            }
            root = root == null || root.equals("") ? "allRoot" : root;
            this.denyMap.put(root, denyHostsPattern);
        }
    }

    public boolean isAllowHost(String hostID, String root) {
        Pattern[] allowHostsPattern;
        if (root == null || root.length() == 0 || root.equals("/")) {
            root = "allRoot";
        }
        if ((allowHostsPattern = this.allowMap.get(root)) == null) {
            return true;
        }
        for (Pattern p : allowHostsPattern) {
            Matcher m = p.matcher(hostID);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isDenyHost(String hostID, String root) {
        Pattern[] denyHostsPattern;
        if (root == null || root.length() == 0 || root.equals("/")) {
            root = "allRoot";
        }
        if ((denyHostsPattern = this.denyMap.get(root)) == null) {
            return false;
        }
        for (Pattern p : denyHostsPattern) {
            Matcher m = p.matcher(hostID);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public static String htmlNotationtoChar(String input) {
        int i;
        int flag = input.indexOf("&#");
        if (flag > -1) {
            for (i = 0; i < HTMLASC_X.length; ++i) {
                input = input.replace(HTMLASC_X[i], HTMLCHARS[i]);
            }
        }
        if ((flag = input.indexOf("&#")) > -1) {
            for (i = 0; i < HTMLASC.length; ++i) {
                input = input.replace(HTMLASC[i], HTMLCHARS[i]);
            }
        }
        return input;
    }

    public void destroy() {
        this.denyMap.clear();
        this.allowMap.clear();
    }

    private static boolean parseBoolean(String paramVal, boolean defVal) {
        if (paramVal != null && !(paramVal = paramVal.trim()).isEmpty()) {
            if ("true".equalsIgnoreCase(paramVal)) {
                return true;
            }
            if ("false".equalsIgnoreCase(paramVal)) {
                return false;
            }
            return defVal;
        }
        return defVal;
    }

    static {
        HTMLASC_X = new String[]{"&#x28;", "&#x29;", "&#x6a;", "&#x61;", "&#x76;", "&#x61;", "&#x73;", "&#x63;", "&#x72;", "&#x69;", "&#x70;", "&#x74;", "&#x3a;"};
        HTMLASC = new String[]{"&#40;", "&#41;", "&#106;", "&#97;", "&#118;", "&#97;", "&#115;", "&#99;", "&#114;", "&#105;", "&#112;", "&#116;", "&#58;"};
        HTMLCHARS = new String[]{"(", ")", "j", "a", "v", "a", "s", "c", "r", "i", "p", "t", ":"};
    }
}

