/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CnToSpell {
    private static Logger logger = LoggerFactory.getLogger(CnToSpell.class);
    private static Map spellMap = null;
    private static Map uncommonWordsMap = null;

    private CnToSpell() {
    }

    private static void putSpellMap(String key, int value) {
        spellMap.put(key, new Integer(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initUncommonWordsMap() {
        InputStream is = null;
        try {
            is = CnToSpell.class.getClassLoader().getResourceAsStream("com/kingdee/eas/hr/base/util/complexPingYinForName.properties");
            Properties p = new Properties();
            p.load(is);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                if (key == null || key.toCharArray().length <= 0) continue;
                uncommonWordsMap.put(new Character(key.toCharArray()[0]), entry.getValue());
            }
        }
        catch (Exception e) {
            logger.error("complexPingYinForNameError", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void initialize() {
        CnToSpell.putSpellMap("\u2019a", -20319);
        CnToSpell.putSpellMap("\u2019ai", -20317);
        CnToSpell.putSpellMap("\u2019an", -20304);
        CnToSpell.putSpellMap("\u2019ang", -20295);
        CnToSpell.putSpellMap("\u2019ao", -20292);
        CnToSpell.putSpellMap("ba", -20283);
        CnToSpell.putSpellMap("bai", -20265);
        CnToSpell.putSpellMap("ban", -20257);
        CnToSpell.putSpellMap("bang", -20242);
        CnToSpell.putSpellMap("bao", -20230);
        CnToSpell.putSpellMap("bei", -20051);
        CnToSpell.putSpellMap("ben", -20036);
        CnToSpell.putSpellMap("beng", -20032);
        CnToSpell.putSpellMap("bi", -20026);
        CnToSpell.putSpellMap("bian", -20002);
        CnToSpell.putSpellMap("biao", -19990);
        CnToSpell.putSpellMap("bie", -19986);
        CnToSpell.putSpellMap("bin", -19982);
        CnToSpell.putSpellMap("bing", -19976);
        CnToSpell.putSpellMap("bo", -19805);
        CnToSpell.putSpellMap("bu", -19784);
        CnToSpell.putSpellMap("ca", -19775);
        CnToSpell.putSpellMap("cai", -19774);
        CnToSpell.putSpellMap("can", -19763);
        CnToSpell.putSpellMap("cang", -19756);
        CnToSpell.putSpellMap("cao", -19751);
        CnToSpell.putSpellMap("ce", -19746);
        CnToSpell.putSpellMap("ceng", -19741);
        CnToSpell.putSpellMap("cha", -19739);
        CnToSpell.putSpellMap("chai", -19728);
        CnToSpell.putSpellMap("chan", -19725);
        CnToSpell.putSpellMap("chang", -19715);
        CnToSpell.putSpellMap("chao", -19540);
        CnToSpell.putSpellMap("che", -19531);
        CnToSpell.putSpellMap("chen", -19525);
        CnToSpell.putSpellMap("cheng", -19515);
        CnToSpell.putSpellMap("chi", -19500);
        CnToSpell.putSpellMap("chong", -19484);
        CnToSpell.putSpellMap("chou", -19479);
        CnToSpell.putSpellMap("chu", -19467);
        CnToSpell.putSpellMap("chuai", -19289);
        CnToSpell.putSpellMap("chuan", -19288);
        CnToSpell.putSpellMap("chuang", -19281);
        CnToSpell.putSpellMap("chui", -19275);
        CnToSpell.putSpellMap("chun", -19270);
        CnToSpell.putSpellMap("chuo", -19263);
        CnToSpell.putSpellMap("ci", -19261);
        CnToSpell.putSpellMap("cong", -19249);
        CnToSpell.putSpellMap("cou", -19243);
        CnToSpell.putSpellMap("cu", -19242);
        CnToSpell.putSpellMap("cuan", -19238);
        CnToSpell.putSpellMap("cui", -19235);
        CnToSpell.putSpellMap("cun", -19227);
        CnToSpell.putSpellMap("cuo", -19224);
        CnToSpell.putSpellMap("da", -19218);
        CnToSpell.putSpellMap("dai", -19212);
        CnToSpell.putSpellMap("dan", -19038);
        CnToSpell.putSpellMap("dang", -19023);
        CnToSpell.putSpellMap("dao", -19018);
        CnToSpell.putSpellMap("de", -19006);
        CnToSpell.putSpellMap("deng", -19003);
        CnToSpell.putSpellMap("di", -18996);
        CnToSpell.putSpellMap("dian", -18977);
        CnToSpell.putSpellMap("diao", -18961);
        CnToSpell.putSpellMap("die", -18952);
        CnToSpell.putSpellMap("ding", -18783);
        CnToSpell.putSpellMap("diu", -18774);
        CnToSpell.putSpellMap("dong", -18773);
        CnToSpell.putSpellMap("dou", -18763);
        CnToSpell.putSpellMap("du", -18756);
        CnToSpell.putSpellMap("duan", -18741);
        CnToSpell.putSpellMap("dui", -18735);
        CnToSpell.putSpellMap("dun", -18731);
        CnToSpell.putSpellMap("duo", -18722);
        CnToSpell.putSpellMap("\u2019e", -18710);
        CnToSpell.putSpellMap("\u2019en", -18697);
        CnToSpell.putSpellMap("\u2019er", -18696);
        CnToSpell.putSpellMap("fa", -18526);
        CnToSpell.putSpellMap("fan", -18518);
        CnToSpell.putSpellMap("fang", -18501);
        CnToSpell.putSpellMap("fei", -18490);
        CnToSpell.putSpellMap("fen", -18478);
        CnToSpell.putSpellMap("feng", -18463);
        CnToSpell.putSpellMap("fo", -18448);
        CnToSpell.putSpellMap("fou", -18447);
        CnToSpell.putSpellMap("fu", -18446);
        CnToSpell.putSpellMap("ga", -18239);
        CnToSpell.putSpellMap("gai", -18237);
        CnToSpell.putSpellMap("gan", -18231);
        CnToSpell.putSpellMap("gang", -18220);
        CnToSpell.putSpellMap("gao", -18211);
        CnToSpell.putSpellMap("ge", -18201);
        CnToSpell.putSpellMap("gei", -18184);
        CnToSpell.putSpellMap("gen", -18183);
        CnToSpell.putSpellMap("geng", -18181);
        CnToSpell.putSpellMap("gong", -18012);
        CnToSpell.putSpellMap("gou", -17997);
        CnToSpell.putSpellMap("gu", -17988);
        CnToSpell.putSpellMap("gua", -17970);
        CnToSpell.putSpellMap("guai", -17964);
        CnToSpell.putSpellMap("guan", -17961);
        CnToSpell.putSpellMap("guang", -17950);
        CnToSpell.putSpellMap("gui", -17947);
        CnToSpell.putSpellMap("gun", -17931);
        CnToSpell.putSpellMap("guo", -17928);
        CnToSpell.putSpellMap("ha", -17922);
        CnToSpell.putSpellMap("hai", -17759);
        CnToSpell.putSpellMap("han", -17752);
        CnToSpell.putSpellMap("hang", -17733);
        CnToSpell.putSpellMap("hao", -17730);
        CnToSpell.putSpellMap("he", -17721);
        CnToSpell.putSpellMap("hei", -17703);
        CnToSpell.putSpellMap("hen", -17701);
        CnToSpell.putSpellMap("heng", -17697);
        CnToSpell.putSpellMap("hong", -17692);
        CnToSpell.putSpellMap("hou", -17683);
        CnToSpell.putSpellMap("hu", -17676);
        CnToSpell.putSpellMap("hua", -17496);
        CnToSpell.putSpellMap("huai", -17487);
        CnToSpell.putSpellMap("huan", -17482);
        CnToSpell.putSpellMap("huang", -17468);
        CnToSpell.putSpellMap("hui", -17454);
        CnToSpell.putSpellMap("hun", -17433);
        CnToSpell.putSpellMap("huo", -17427);
        CnToSpell.putSpellMap("ji", -17417);
        CnToSpell.putSpellMap("jia", -17202);
        CnToSpell.putSpellMap("jian", -17185);
        CnToSpell.putSpellMap("jiang", -16983);
        CnToSpell.putSpellMap("jiao", -16970);
        CnToSpell.putSpellMap("jie", -16942);
        CnToSpell.putSpellMap("jin", -16915);
        CnToSpell.putSpellMap("jing", -16733);
        CnToSpell.putSpellMap("jiong", -16708);
        CnToSpell.putSpellMap("jiu", -16706);
        CnToSpell.putSpellMap("ju", -16689);
        CnToSpell.putSpellMap("juan", -16664);
        CnToSpell.putSpellMap("jue", -16657);
        CnToSpell.putSpellMap("jun", -16647);
        CnToSpell.putSpellMap("ka", -16474);
        CnToSpell.putSpellMap("kai", -16470);
        CnToSpell.putSpellMap("kan", -16465);
        CnToSpell.putSpellMap("kang", -16459);
        CnToSpell.putSpellMap("kao", -16452);
        CnToSpell.putSpellMap("ke", -16448);
        CnToSpell.putSpellMap("ken", -16433);
        CnToSpell.putSpellMap("keng", -16429);
        CnToSpell.putSpellMap("kong", -16427);
        CnToSpell.putSpellMap("kou", -16423);
        CnToSpell.putSpellMap("ku", -16419);
        CnToSpell.putSpellMap("kua", -16412);
        CnToSpell.putSpellMap("kuai", -16407);
        CnToSpell.putSpellMap("kuan", -16403);
        CnToSpell.putSpellMap("kuang", -16401);
        CnToSpell.putSpellMap("kui", -16393);
        CnToSpell.putSpellMap("kun", -16220);
        CnToSpell.putSpellMap("kuo", -16216);
        CnToSpell.putSpellMap("la", -16212);
        CnToSpell.putSpellMap("lai", -16205);
        CnToSpell.putSpellMap("lan", -16202);
        CnToSpell.putSpellMap("lang", -16187);
        CnToSpell.putSpellMap("lao", -16180);
        CnToSpell.putSpellMap("le", -16171);
        CnToSpell.putSpellMap("lei", -16169);
        CnToSpell.putSpellMap("leng", -16158);
        CnToSpell.putSpellMap("li", -16155);
        CnToSpell.putSpellMap("lia", -15959);
        CnToSpell.putSpellMap("lian", -15958);
        CnToSpell.putSpellMap("liang", -15944);
        CnToSpell.putSpellMap("liao", -15933);
        CnToSpell.putSpellMap("lie", -15920);
        CnToSpell.putSpellMap("lin", -15915);
        CnToSpell.putSpellMap("ling", -15903);
        CnToSpell.putSpellMap("liu", -15889);
        CnToSpell.putSpellMap("long", -15878);
        CnToSpell.putSpellMap("lou", -15707);
        CnToSpell.putSpellMap("lu", -15701);
        CnToSpell.putSpellMap("lv", -15681);
        CnToSpell.putSpellMap("luan", -15667);
        CnToSpell.putSpellMap("lue", -15661);
        CnToSpell.putSpellMap("lun", -15659);
        CnToSpell.putSpellMap("luo", -15652);
        CnToSpell.putSpellMap("ma", -15640);
        CnToSpell.putSpellMap("mai", -15631);
        CnToSpell.putSpellMap("man", -15625);
        CnToSpell.putSpellMap("mang", -15454);
        CnToSpell.putSpellMap("mao", -15448);
        CnToSpell.putSpellMap("me", -15436);
        CnToSpell.putSpellMap("mei", -15435);
        CnToSpell.putSpellMap("men", -15419);
        CnToSpell.putSpellMap("meng", -15416);
        CnToSpell.putSpellMap("mi", -15408);
        CnToSpell.putSpellMap("mian", -15394);
        CnToSpell.putSpellMap("miao", -15385);
        CnToSpell.putSpellMap("mie", -15377);
        CnToSpell.putSpellMap("min", -15375);
        CnToSpell.putSpellMap("ming", -15369);
        CnToSpell.putSpellMap("miu", -15363);
        CnToSpell.putSpellMap("mo", -15362);
        CnToSpell.putSpellMap("mou", -15183);
        CnToSpell.putSpellMap("mu", -15180);
        CnToSpell.putSpellMap("na", -15165);
        CnToSpell.putSpellMap("nai", -15158);
        CnToSpell.putSpellMap("nan", -15153);
        CnToSpell.putSpellMap("nang", -15150);
        CnToSpell.putSpellMap("nao", -15149);
        CnToSpell.putSpellMap("ne", -15144);
        CnToSpell.putSpellMap("nei", -15143);
        CnToSpell.putSpellMap("nen", -15141);
        CnToSpell.putSpellMap("neng", -15140);
        CnToSpell.putSpellMap("ni", -15139);
        CnToSpell.putSpellMap("nian", -15128);
        CnToSpell.putSpellMap("niang", -15121);
        CnToSpell.putSpellMap("niao", -15119);
        CnToSpell.putSpellMap("nie", -15117);
        CnToSpell.putSpellMap("nin", -15110);
        CnToSpell.putSpellMap("ning", -15109);
        CnToSpell.putSpellMap("niu", -14941);
        CnToSpell.putSpellMap("nong", -14937);
        CnToSpell.putSpellMap("nu", -14933);
        CnToSpell.putSpellMap("nv", -14930);
        CnToSpell.putSpellMap("nuan", -14929);
        CnToSpell.putSpellMap("nue", -14928);
        CnToSpell.putSpellMap("nuo", -14926);
        CnToSpell.putSpellMap("\u2019o", -14922);
        CnToSpell.putSpellMap("\u2019ou", -14921);
        CnToSpell.putSpellMap("pa", -14914);
        CnToSpell.putSpellMap("pai", -14908);
        CnToSpell.putSpellMap("pan", -14902);
        CnToSpell.putSpellMap("pang", -14894);
        CnToSpell.putSpellMap("pao", -14889);
        CnToSpell.putSpellMap("pei", -14882);
        CnToSpell.putSpellMap("pen", -14873);
        CnToSpell.putSpellMap("peng", -14871);
        CnToSpell.putSpellMap("pi", -14857);
        CnToSpell.putSpellMap("pian", -14678);
        CnToSpell.putSpellMap("piao", -14674);
        CnToSpell.putSpellMap("pie", -14670);
        CnToSpell.putSpellMap("pin", -14668);
        CnToSpell.putSpellMap("ping", -14663);
        CnToSpell.putSpellMap("po", -14654);
        CnToSpell.putSpellMap("pu", -14645);
        CnToSpell.putSpellMap("qi", -14630);
        CnToSpell.putSpellMap("qia", -14594);
        CnToSpell.putSpellMap("qian", -14429);
        CnToSpell.putSpellMap("qiang", -14407);
        CnToSpell.putSpellMap("qiao", -14399);
        CnToSpell.putSpellMap("qie", -14384);
        CnToSpell.putSpellMap("qin", -14379);
        CnToSpell.putSpellMap("qing", -14368);
        CnToSpell.putSpellMap("qiong", -14355);
        CnToSpell.putSpellMap("qiu", -14353);
        CnToSpell.putSpellMap("qu", -14345);
        CnToSpell.putSpellMap("quan", -14170);
        CnToSpell.putSpellMap("que", -14159);
        CnToSpell.putSpellMap("qun", -14151);
        CnToSpell.putSpellMap("ran", -14149);
        CnToSpell.putSpellMap("rang", -14145);
        CnToSpell.putSpellMap("rao", -14140);
        CnToSpell.putSpellMap("re", -14137);
        CnToSpell.putSpellMap("ren", -14135);
        CnToSpell.putSpellMap("reng", -14125);
        CnToSpell.putSpellMap("ri", -14123);
        CnToSpell.putSpellMap("rong", -14122);
        CnToSpell.putSpellMap("rou", -14112);
        CnToSpell.putSpellMap("ru", -14109);
        CnToSpell.putSpellMap("ruan", -14099);
        CnToSpell.putSpellMap("rui", -14097);
        CnToSpell.putSpellMap("run", -14094);
        CnToSpell.putSpellMap("ruo", -14092);
        CnToSpell.putSpellMap("sa", -14090);
        CnToSpell.putSpellMap("sai", -14087);
        CnToSpell.putSpellMap("san", -14083);
        CnToSpell.putSpellMap("sang", -13917);
        CnToSpell.putSpellMap("sao", -13914);
        CnToSpell.putSpellMap("se", -13910);
        CnToSpell.putSpellMap("sen", -13907);
        CnToSpell.putSpellMap("seng", -13906);
        CnToSpell.putSpellMap("sha", -13905);
        CnToSpell.putSpellMap("shai", -13896);
        CnToSpell.putSpellMap("shan", -13894);
        CnToSpell.putSpellMap("shang", -13878);
        CnToSpell.putSpellMap("shao", -13870);
        CnToSpell.putSpellMap("she", -13859);
        CnToSpell.putSpellMap("shen", -13847);
        CnToSpell.putSpellMap("sheng", -13831);
        CnToSpell.putSpellMap("shi", -13658);
        CnToSpell.putSpellMap("shou", -13611);
        CnToSpell.putSpellMap("shu", -13601);
        CnToSpell.putSpellMap("shua", -13406);
        CnToSpell.putSpellMap("shuai", -13404);
        CnToSpell.putSpellMap("shuan", -13400);
        CnToSpell.putSpellMap("shuang", -13398);
        CnToSpell.putSpellMap("shui", -13395);
        CnToSpell.putSpellMap("shun", -13391);
        CnToSpell.putSpellMap("shuo", -13387);
        CnToSpell.putSpellMap("si", -13383);
        CnToSpell.putSpellMap("song", -13367);
        CnToSpell.putSpellMap("sou", -13359);
        CnToSpell.putSpellMap("su", -13356);
        CnToSpell.putSpellMap("suan", -13343);
        CnToSpell.putSpellMap("sui", -13340);
        CnToSpell.putSpellMap("sun", -13329);
        CnToSpell.putSpellMap("suo", -13326);
        CnToSpell.putSpellMap("ta", -13318);
        CnToSpell.putSpellMap("tai", -13147);
        CnToSpell.putSpellMap("tan", -13138);
        CnToSpell.putSpellMap("tang", -13120);
        CnToSpell.putSpellMap("tao", -13107);
        CnToSpell.putSpellMap("te", -13096);
        CnToSpell.putSpellMap("teng", -13095);
        CnToSpell.putSpellMap("ti", -13091);
        CnToSpell.putSpellMap("tian", -13076);
        CnToSpell.putSpellMap("tiao", -13068);
        CnToSpell.putSpellMap("tie", -13063);
        CnToSpell.putSpellMap("ting", -13060);
        CnToSpell.putSpellMap("tong", -12888);
        CnToSpell.putSpellMap("tou", -12875);
        CnToSpell.putSpellMap("tu", -12871);
        CnToSpell.putSpellMap("tuan", -12860);
        CnToSpell.putSpellMap("tui", -12858);
        CnToSpell.putSpellMap("tun", -12852);
        CnToSpell.putSpellMap("tuo", -12849);
        CnToSpell.putSpellMap("wa", -12838);
        CnToSpell.putSpellMap("wai", -12831);
        CnToSpell.putSpellMap("wan", -12829);
        CnToSpell.putSpellMap("wang", -12812);
        CnToSpell.putSpellMap("wei", -12802);
        CnToSpell.putSpellMap("wen", -12607);
        CnToSpell.putSpellMap("weng", -12597);
        CnToSpell.putSpellMap("wo", -12594);
        CnToSpell.putSpellMap("wu", -12585);
        CnToSpell.putSpellMap("xi", -12556);
        CnToSpell.putSpellMap("xia", -12359);
        CnToSpell.putSpellMap("xian", -12346);
        CnToSpell.putSpellMap("xiang", -12320);
        CnToSpell.putSpellMap("xiao", -12300);
        CnToSpell.putSpellMap("xie", -12120);
        CnToSpell.putSpellMap("xin", -12099);
        CnToSpell.putSpellMap("xing", -12089);
        CnToSpell.putSpellMap("xiong", -12074);
        CnToSpell.putSpellMap("xiu", -12067);
        CnToSpell.putSpellMap("xu", -12058);
        CnToSpell.putSpellMap("xuan", -12039);
        CnToSpell.putSpellMap("xue", -11867);
        CnToSpell.putSpellMap("xun", -11861);
        CnToSpell.putSpellMap("ya", -11847);
        CnToSpell.putSpellMap("yan", -11831);
        CnToSpell.putSpellMap("yang", -11798);
        CnToSpell.putSpellMap("yao", -11781);
        CnToSpell.putSpellMap("ye", -11604);
        CnToSpell.putSpellMap("yi", -11589);
        CnToSpell.putSpellMap("yin", -11536);
        CnToSpell.putSpellMap("ying", -11358);
        CnToSpell.putSpellMap("yo", -11340);
        CnToSpell.putSpellMap("yong", -11339);
        CnToSpell.putSpellMap("you", -11324);
        CnToSpell.putSpellMap("yu", -11303);
        CnToSpell.putSpellMap("yuan", -11097);
        CnToSpell.putSpellMap("yue", -11077);
        CnToSpell.putSpellMap("yun", -11067);
        CnToSpell.putSpellMap("za", -11055);
        CnToSpell.putSpellMap("zai", -11052);
        CnToSpell.putSpellMap("zan", -11045);
        CnToSpell.putSpellMap("zang", -11041);
        CnToSpell.putSpellMap("zao", -11038);
        CnToSpell.putSpellMap("ze", -11024);
        CnToSpell.putSpellMap("zei", -11020);
        CnToSpell.putSpellMap("zen", -11019);
        CnToSpell.putSpellMap("zeng", -11018);
        CnToSpell.putSpellMap("zha", -11014);
        CnToSpell.putSpellMap("zhai", -10838);
        CnToSpell.putSpellMap("zhan", -10832);
        CnToSpell.putSpellMap("zhang", -10815);
        CnToSpell.putSpellMap("zhao", -10800);
        CnToSpell.putSpellMap("zhe", -10790);
        CnToSpell.putSpellMap("zhen", -10780);
        CnToSpell.putSpellMap("zheng", -10764);
        CnToSpell.putSpellMap("zhi", -10587);
        CnToSpell.putSpellMap("zhong", -10544);
        CnToSpell.putSpellMap("zhou", -10533);
        CnToSpell.putSpellMap("zhu", -10519);
        CnToSpell.putSpellMap("zhua", -10331);
        CnToSpell.putSpellMap("zhuai", -10329);
        CnToSpell.putSpellMap("zhuan", -10328);
        CnToSpell.putSpellMap("zhuang", -10322);
        CnToSpell.putSpellMap("zhui", -10315);
        CnToSpell.putSpellMap("zhun", -10309);
        CnToSpell.putSpellMap("zhuo", -10307);
        CnToSpell.putSpellMap("zi", -10296);
        CnToSpell.putSpellMap("zong", -10281);
        CnToSpell.putSpellMap("zou", -10274);
        CnToSpell.putSpellMap("zu", -10270);
        CnToSpell.putSpellMap("zuan", -10262);
        CnToSpell.putSpellMap("zui", -10260);
        CnToSpell.putSpellMap("zun", -10256);
        CnToSpell.putSpellMap("zuo", -10254);
    }

    public static void putUncommonWord(char cnWord, String spell) {
        uncommonWordsMap.put(new Character(cnWord), spell);
    }

    public static int getCnAscii(char cn) {
        byte[] bytes = null;
        try {
            bytes = String.valueOf(cn).getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            return 0;
        }
        if (bytes == null || bytes.length == 0 || bytes.length > 2) {
            return 0;
        }
        if (bytes.length == 1) {
            return bytes[0];
        }
        if (bytes.length == 2) {
            int hightByte = 256 + bytes[0];
            int lowByte = 256 + bytes[1];
            return 256 * hightByte + lowByte - 65536;
        }
        return 0;
    }

    public static String getSpellByAscii(int ascii) {
        if (ascii > 0 && ascii < 160) {
            return String.valueOf((char)ascii);
        }
        if (ascii < -20319 || ascii > -10247) {
            return "";
        }
        String spell2 = null;
        String spellPrevious = null;
        int asciiRangPrevious = -20319;
        for (String spell2 : spellMap.keySet()) {
            Integer asciiRang = (Integer)spellMap.get(spell2);
            if (asciiRang == null) continue;
            if (ascii >= asciiRangPrevious && ascii < asciiRang) {
                return spellPrevious == null ? spell2 : spellPrevious;
            }
            spellPrevious = spell2;
            asciiRangPrevious = asciiRang;
        }
        return "";
    }

    public static String getSpell(String cnStr, boolean onlyFirstSpell) {
        if (cnStr == null) {
            return null;
        }
        char[] chars = cnStr.trim().toCharArray();
        StringBuffer sb = new StringBuffer();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            int ascii = CnToSpell.getCnAscii(chars[i]);
            if (ascii == 0) {
                sb.append(chars[i]);
                continue;
            }
            String spell = CnToSpell.getSpellByAscii(ascii);
            if (spell == null || spell.length() == 0) {
                spell = (String)uncommonWordsMap.get(new Character(chars[i]));
            }
            if (spell == null || spell.length() == 0) {
                sb.append(chars[i]);
                continue;
            }
            if (onlyFirstSpell) {
                sb.append(spell.startsWith("\u2019") ? spell.substring(1, 2) : spell.substring(0, 1));
                continue;
            }
            sb.append(spell);
        }
        return sb.toString();
    }

    static {
        if (spellMap == null) {
            spellMap = Collections.synchronizedMap(new LinkedHashMap(396));
            uncommonWordsMap = Collections.synchronizedMap(new LinkedHashMap(200));
        }
        CnToSpell.initialize();
        CnToSpell.initUncommonWordsMap();
    }
}

