/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommonHelperUtil {
    public static final String DOC_PKG = "com.kingdee.eas.cp.base.web.DmIndexBean";

    public static String checkLicense(HttpServletRequest request, HttpServletResponse response, String licenseUrl) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int result = 0;
        String returnResult = null;
        try {
            String isCheckLicnese = (String)request.getSession().getAttribute("doc_" + licenseUrl);
            if (StringUtil.isEmpty((String)isCheckLicnese)) {
                LicenseUserInfo licenseUserInfo = CommonHelperUtil.createLicenseUserInfo(request, ctx);
                result = LicenseSrvFactory.getInstance().requestLicenseOnInvalid(licenseUserInfo, DOC_PKG);
                if (result == 1) {
                    returnResult = "success";
                } else if (result == 2) {
                    request.setAttribute("message", (Object)CommonHelperUtil.constructLicenseMessage(DOC_PKG, 2, request));
                    returnResult = "checkLicence";
                } else {
                    request.setAttribute("message", (Object)CommonHelperUtil.constructLicenseMessage(DOC_PKG, 3, request));
                    returnResult = "checkLicence";
                }
            } else {
                returnResult = "success";
            }
        }
        catch (Exception e) {
            returnResult = "checkLicence";
            request.setAttribute("message", (Object)e.getMessage());
            e.printStackTrace();
        }
        return returnResult;
    }

    public static LicenseUserInfo createLicenseUserInfo(HttpServletRequest request, Context ctx) {
        return CommonHelperUtil.createLicenseUserInfo(ctx.getClientHostIP(), ctx);
    }

    public static LicenseUserInfo createLicenseUserInfo(String clientIP, Context ctx) {
        UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        LicenseUserInfo user = null;
        try {
            Date loginTime = new Date(System.currentTimeMillis());
            user = new LicenseUserInfo();
            if (ctx != null) {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                if (userInfo != null && userInfo.getId() != null) {
                    user.setUserID(userInfo.getId().toString());
                }
                if (userinfo.getId() != null) {
                    user.setUserID(userinfo.getId().toString());
                }
                user.setUserName(ctx.getUserName());
                user.setSessionID(ctx.getContextID());
                if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    user.setUserCompany(ContextUtil.getCurrentCtrlUnit((Context)ctx).getName());
                }
                user.setUserLoginAis(ctx.getAIS());
            }
            user.setUserIP(clientIP);
            user.setUserLoginTime(loginTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            user = null;
        }
        return user;
    }

    public static String constructLicenseMessage(String packageName, int result, HttpServletRequest request) throws LicenseException {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        Locale local = null;
        if (ctx != null) {
            local = ctx.getLocale();
        }
        if (packageName == null) {
            return "";
        }
        String strResource = "com.kingdee.eas.framework.FrameWorkResource.";
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append(ResourceBase.getString((String)(strResource + "Msg_ModuleName"), (Locale)local));
        String moduleName = LicenseSrvAgentFactory.getRemoteInstance().getModuleByPackage(packageName);
        buffer.append(moduleName);
        String licenseStr = ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS", (Locale)local);
        if (result == 3) {
            licenseStr = ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid", (Locale)local);
        }
        return licenseStr + buffer.toString();
    }

    public static void releaseLicnese(HttpServletRequest request, String sendUrl) {
        try {
            Context contex = (Context)PortalContextUtil.getPortalContext(request).getMetaInfo().get("eas_context");
            String sessionId = contex.getContextID();
            LicenseSrvAgentFactory.getRemoteInstance().releaseLicense(sessionId, DOC_PKG);
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        request.getSession().removeAttribute("doc_" + sendUrl);
    }

    public static void releaseBizLicnese(HttpServletRequest request, String sendUrl, String licensePK) {
        try {
            Context contex = (Context)PortalContextUtil.getPortalContext(request).getMetaInfo().get("eas_context");
            String sessionId = contex.getContextID();
            LicenseSrvAgentFactory.getRemoteInstance().releaseLicense(sessionId, licensePK);
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        request.getSession().removeAttribute(sendUrl);
    }

    public static boolean checkIsPerson(HttpServletRequest request) {
        boolean isPerson = false;
        PortalContext portalContext = PortalContextUtil.getPortalContext(request);
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        try {
            PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            if (person != null) {
                isPerson = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isPerson;
    }

    public static boolean updateQingCardID(Map<String, String> cardIDMap) {
        return false;
    }
}

