/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.util;

import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class FilterSpecialCharactersTool {
    public static boolean isContainSQLSpecialCharacters(HttpServletRequest request) {
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paraName = (String)enu.nextElement();
            String param = request.getParameter(paraName);
            if (StringUtil.isEmpty((String)param)) continue;
            String[] inj_strA = new String[]{"'", " and ", "insert", "select", "delete", "update", "*", "truncate", " or ", "<", "("};
            for (int i = 0; i < inj_strA.length; ++i) {
                if (param.indexOf(inj_strA[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isContainXmlSpecialCharacters(HttpServletRequest request) {
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paraName = (String)enu.nextElement();
            String param = request.getParameter(paraName);
            if (StringUtil.isEmpty((String)param)) continue;
            String[] inj_strA = new String[]{"./", "../", "\\", ":", "*", "\"", "<", ">", "|"};
            for (int i = 0; i < inj_strA.length; ++i) {
                if (param.indexOf(inj_strA[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isUUID(String id) {
        String uid = StringUtil.convNull((String)id);
        return uid.length() == 36 && uid.split("-").length == 5;
    }

    public static boolean checkParamsValid(String param) {
        if (StringUtil.isEmpty((String)param)) {
            return true;
        }
        String[] invalidParams = new String[]{"./", "../", "\\", ":", "*", "\"", "<", ">", "|"};
        for (int i = 0; i < invalidParams.length; ++i) {
            if (param.indexOf(invalidParams[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean checkImgValid(String param) {
        if (StringUtil.isEmpty((String)param)) {
            return false;
        }
        String[] imgeArray = new String[]{"image/png", "image/x-png", "image/gif", "image/jpg", "image/jpeg", "image/pjpeg"};
        for (int i = 0; i < imgeArray.length; ++i) {
            if (param.indexOf(imgeArray[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean checkImgNameValid(String param) {
        if (StringUtil.isEmpty((String)param)) {
            return false;
        }
        param = param.substring(param.lastIndexOf(".") + 1, param.length());
        String[] imgeNameArray = new String[]{"jpg", "gif", "png", "jpeg"};
        for (int i = 0; i < imgeNameArray.length; ++i) {
            if (!imgeNameArray[i].equalsIgnoreCase(param)) continue;
            return true;
        }
        return false;
    }

    public static String checkValidParamsForJSON(String displayName) {
        DisplayName display;
        if (StringUtils.isEmpty((String)displayName)) {
            return "";
        }
        display.setEn(FilterSpecialCharactersTool.checkParamsValid((display = new DisplayName(displayName)).getEn()) ? display.getEn() : "");
        display.setZh_CN(FilterSpecialCharactersTool.checkParamsValid(display.getZh_CN()) ? display.getZh_CN() : "");
        display.setZh_TW(FilterSpecialCharactersTool.checkParamsValid(display.getZh_TW()) ? display.getZh_TW() : "");
        return display.toString();
    }

    public static String cleanXSS(String param) {
        String[] dangerCharacters;
        if (StringUtils.isEmpty((String)param)) {
            return "";
        }
        for (String s : dangerCharacters = new String[]{"<", ">", "\\|", "\\./", "\\.\\./", "javascript", "document", "eval", "onblur", "onclick"}) {
            param = param.replaceAll(s, "");
        }
        return param;
    }

    public static boolean checkHTMLValid(String param) {
        if (StringUtil.isEmpty((String)param)) {
            return true;
        }
        String[] invalidParams = new String[]{"javascript", "document", "eval", "onblur", "onclick"};
        for (int i = 0; i < invalidParams.length; ++i) {
            if (param.indexOf(invalidParams[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public static String cleanPathString(String aString) {
        if (aString == null) {
            return null;
        }
        String cleanString = "";
        for (int i = 0; i < aString.length(); ++i) {
            cleanString = cleanString + FilterSpecialCharactersTool.cleanChar(aString.charAt(i));
        }
        return cleanString;
    }

    private static char cleanChar(char aChar) {
        int i;
        for (i = 48; i < 58; ++i) {
            if (aChar != i) continue;
            return (char)i;
        }
        for (i = 65; i < 91; ++i) {
            if (aChar != i) continue;
            return (char)i;
        }
        for (i = 97; i < 123; ++i) {
            if (aChar != i) continue;
            return (char)i;
        }
        switch (aChar) {
            case 47: {
                return '/';
            }
            case 46: {
                return '.';
            }
            case 45: {
                return '-';
            }
            case 95: {
                return '_';
            }
            case 32: {
                return ' ';
            }
            case 92: {
                return '\\';
            }
            case 58: {
                return ':';
            }
        }
        return '%';
    }
}

