/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.common.util;

import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.setting.entity.LogoSetting;
import com.kingdee.portal.biz.module.setting.service.LogoSettingService;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.util.StringUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class LogoImgUtil {
    private static LogoSettingService logoSettingService = (LogoSettingService)PortalServiceLocator.getBean("logoSettingService");

    public static int getTopLogoImaWidth(String language, String dataCenter) {
        if (StringUtils.isEmpty((String)language) || StringUtils.isEmpty((String)dataCenter)) {
            return 0;
        }
        String type = "top";
        String url = null;
        LogoSetting logoSetting = null;
        try {
            logoSetting = logoSettingService.getLogoSettingByLogoName(type, dataCenter, language);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (logoSetting == null) {
            url = LogoImgUtil.getFilePrePath() + LogoImgUtil.getDefaultPicFileName(type, language);
        } else {
            url = LogoImgUtil.getFilePrePath() + type + "_logo_" + dataCenter + "_" + language + ".png";
            File logoFile = new File(url);
            if (logoFile.exists()) {
                long fileLastModified = logoFile.lastModified();
                if (logoSetting.getLastUpdateTime().getTime() > fileLastModified) {
                    LogoImgUtil.writeFile(url, logoSetting.getLogoContent());
                }
            } else {
                LogoImgUtil.writeFile(url, logoSetting.getLogoContent());
            }
        }
        return LogoImgUtil.getImgWidth(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getImgWidth(String fileUrl) {
        int width = 0;
        if (StringUtils.isEmpty((String)fileUrl)) {
            return width;
        }
        File topLogoFile = new File(fileUrl);
        if (topLogoFile.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(topLogoFile);
                BufferedImage bi = ImageIO.read(fileInputStream);
                width = bi.getWidth();
                if (width >= 500) {
                    width = 500;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return width;
    }

    private static String getFilePrePath() {
        return Constant.SYSTEM_ROOT_PATH + "res" + Constant.SYSTEM_PATH_SEPARATOR + "img" + Constant.SYSTEM_PATH_SEPARATOR + "global" + Constant.SYSTEM_PATH_SEPARATOR + "common" + Constant.SYSTEM_PATH_SEPARATOR;
    }

    private static String getDefaultPicFileName(String type, String language) {
        return type + "_logo_default_" + language + ".png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String file, byte[] content) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

