/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.core;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.handle.ErrHandle;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.enums.PageModeEnum;
import com.kingdee.portal.biz.module.page.dto.PageModel;
import com.kingdee.portal.biz.module.page.service.OnlineEditPageService;
import com.kingdee.portal.biz.module.portlet.common.util.PortletHelper;
import com.kingdee.portal.biz.module.portlet.entity.PortletRuntimePreferences;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.common.util.StringUtil;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletSession;
import org.apache.pluto.container.PortletPreference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletRuntimeDataLoader {
    private static final Logger logger = LoggerFactory.getLogger(PortletRuntimeDataLoader.class);
    private static OnlineEditPageService onlineEditPageService = (OnlineEditPageService)PortalServiceLocator.getBean("onlineEditPageService");

    public static Map<String, List<String>> findStoredPreferences(PortletSession portletSession, String metaInfoStr) {
        Map<String, String> metaInfo = PortletRuntimeDataLoader.buildMetaInfo(metaInfoStr);
        Map<String, List<String>> preferencesMap = null;
        if (!StringUtil.isEmpty((String)metaInfo.get("insId")) && !metaInfo.get("insId").startsWith("fragment")) {
            if (PageModeEnum.VIEW.toString().equalsIgnoreCase(metaInfo.get("pageMode"))) {
                preferencesMap = PortletRuntimeDataLoader.findRuntimePreferencesMap4Database(portletSession, metaInfo.get("insId"));
                return preferencesMap;
            }
            if (PageModeEnum.EDIT.toString().equalsIgnoreCase(metaInfo.get("pageMode")) || PageModeEnum.EDIT_VIEW.toString().equalsIgnoreCase(metaInfo.get("pageMode"))) {
                preferencesMap = PortletRuntimeDataLoader.findRuntimePreferencesMap4Session(portletSession, metaInfo);
                return preferencesMap;
            }
        }
        return Collections.emptyMap();
    }

    public static void storePortletPreferences(PortletSession portletSession, String metaInfoStr, Map<String, PortletPreference> preferenceMap) {
        Map<String, String> metaInfo = PortletRuntimeDataLoader.buildMetaInfo(metaInfoStr);
        Preferences preferences = PortletRuntimeDataLoader.convPreferences4Map(preferenceMap);
        if (preferences != null) {
            if (PageModeEnum.VIEW.toString().equalsIgnoreCase(metaInfo.get("pageMode"))) {
                PortletRuntimeDataLoader.storePortletPreferences4Database(portletSession, metaInfo, preferences);
            } else if (PageModeEnum.EDIT.toString().equalsIgnoreCase(metaInfo.get("pageMode")) || PageModeEnum.EDIT_VIEW.toString().equalsIgnoreCase(metaInfo.get("pageMode"))) {
                PortletRuntimeDataLoader.storePortletPreferences4Session(portletSession, metaInfo, preferences);
            }
        }
    }

    private static String getFixedUserId(String userId) {
        return URLDecoder.decode(userId);
    }

    private static Map<String, String> buildMetaInfo(String metaInfoStr) {
        HashMap<String, String> metaInfo = new HashMap<String, String>();
        String[] params = metaInfoStr.split("\\|");
        if (params != null && params.length >= 1) {
            metaInfo.put("insId", params[0]);
        }
        if (params != null && params.length >= 3) {
            metaInfo.put("pageMode", params[2]);
        }
        if (params != null && params.length >= 4) {
            metaInfo.put("pageId", params[3]);
        }
        if (params != null && params.length >= 5) {
            String userId = PortletRuntimeDataLoader.getFixedUserId(params[4]);
            metaInfo.put("userId", userId);
        }
        return metaInfo;
    }

    private static PageModel getPageModel4Cache(PortletSession portletSession, String pageId, String userId) {
        Map pageModelMap = (Map)portletSession.getAttribute("temp_page_edit_model", 1);
        String pageMdoelKey = pageId + "_" + userId;
        return (PageModel)pageModelMap.get(pageMdoelKey);
    }

    private static void storePortletPreferences4Session(PortletSession portletSession, Map<String, String> metaInfo, Preferences preferences) {
        PageModel pageModel = PortletRuntimeDataLoader.getPageModel4Cache(portletSession, metaInfo.get("pageId"), metaInfo.get("userId"));
        List<PortletRuntimePreferences> insPrefList = pageModel.getPltRuntimePreferencesList();
        if (insPrefList != null && !insPrefList.isEmpty()) {
            for (PortletRuntimePreferences pref : insPrefList) {
                if (!pref.getInsId().equals(metaInfo.get("insId"))) continue;
                pref.setPreferences(preferences.toString());
                break;
            }
        }
        if (PageModeEnum.EDIT_VIEW.toString().equalsIgnoreCase(metaInfo.get("pageMode"))) {
            PortalContext portalContext = PortalContextUtil.getPortalContext(portletSession);
            try {
                onlineEditPageService.saveOnlineEditPage(portalContext, pageModel, null);
            }
            catch (Exception ex) {
                LocalErr localErr = ErrHandle.getLocalErr(ex, portalContext);
                logger.error(localErr.toString());
            }
        }
        if (NodeTypeEnum.PLAN.equals((Object)pageModel.getPage().getNodeType()) || NodeTypeEnum.NEW_PAGE.equals((Object)pageModel.getPage().getNodeType())) {
            PortletRuntimeDataLoader.storePortletPreferences4Database(portletSession, metaInfo, preferences);
        }
    }

    private static void storePortletPreferences4Database(PortletSession portletSession, Map<String, String> metaInfo, Preferences preferences) {
        try {
            PortletService portletService = (PortletService)PortalServiceLocator.getBean("portletService");
            PortalContext portalContext = (PortalContext)portletSession.getAttribute("portal_context", 1);
            portletService.updatePortletPreferences(portalContext, metaInfo.get("insId"), preferences);
        }
        catch (PortalBizException ex) {
            logger.error(ex.getMessage());
        }
    }

    private static Preferences convPreferences4Map(Map<String, PortletPreference> preferenceMap) {
        Preferences preferences = null;
        if (preferenceMap != null && !preferenceMap.isEmpty()) {
            preferences = new Preferences();
            for (String key : preferenceMap.keySet()) {
                PortletPreference portletPreference = preferenceMap.get(key);
                Preference preference = new Preference();
                preference.setName(portletPreference.getName());
                for (String value : portletPreference.getValues()) {
                    preference.addValue(value);
                }
                preferences.addPreference(preference);
            }
        }
        return preferences;
    }

    private static Map<String, List<String>> findRuntimePreferencesMap4Session(PortletSession portletSession, Map<String, String> metaInfo) {
        Preferences preferences;
        block5: {
            preferences = null;
            try {
                List<PortletRuntimePreferences> insPrefList;
                PageModel pageModel = PortletRuntimeDataLoader.getPageModel4Cache(portletSession, metaInfo.get("pageId"), metaInfo.get("userId"));
                if (pageModel == null || pageModel.getPltRuntimePreferencesList() == null) {
                    logger.error("findRuntimePreferencesMap4Session pageModel is null");
                    logger.error("portletSession id=" + portletSession.getId());
                    String pageId = metaInfo.get("pageId");
                    String userId = metaInfo.get("userId");
                    PortalContext portalContext = (PortalContext)portletSession.getAttribute("portal_context", 1);
                    pageModel = onlineEditPageService.buildPageModel(portalContext, pageId, userId);
                    HashMap<String, PageModel> pageModelMap = (HashMap<String, PageModel>)portletSession.getAttribute("temp_page_edit_model", 1);
                    if (pageModelMap == null) {
                        pageModelMap = new HashMap<String, PageModel>();
                        portletSession.setAttribute("temp_page_edit_model", pageModelMap);
                    }
                    String pageMdoelKey = pageId + "_" + userId;
                    logger.error("set pageModelMap key=" + pageMdoelKey);
                    pageModelMap.put(pageMdoelKey, pageModel);
                }
                if ((insPrefList = pageModel.getPltRuntimePreferencesList()) == null || insPrefList.isEmpty()) break block5;
                for (PortletRuntimePreferences pref : insPrefList) {
                    if (!pref.getInsId().equals(metaInfo.get("insId"))) continue;
                    preferences = PortletHelper.convPreferences(pref.getPreferences());
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return PortletHelper.convPreferences2Map(preferences);
    }

    private static Map<String, List<String>> findRuntimePreferencesMap4Database(PortletSession portletSession, String portletInsId) {
        PortletService portletService = (PortletService)PortalServiceLocator.getBean("portletService");
        PortalContext portalContext = (PortalContext)portletSession.getAttribute("portal_context", 1);
        Preferences preferences = null;
        try {
            preferences = portletService.findPortletInsPreferences(portalContext, portletInsId);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return PortletHelper.convPreferences2Map(preferences);
    }
}

