/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.core.datacenter;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.biz.core.datacenter.DSObserver;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCenterFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DataCenterFilter.class);
    private boolean enableCSRFCheck;
    private boolean enableCSRFCheck_Post;
    private boolean enableCSRFCheck_URL;
    private static String[] SERVERNAME_WHITELIST;
    private List<String> URL_AllowsList = null;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String currentDataCenterCode;
        HttpServletRequest _request = (HttpServletRequest)request;
        PortalContext portalContext = PortalContextUtil.getPortalContext(_request);
        if (this.needSetDataCenter(portalContext, _request.getRequestURI()) && (currentDataCenterCode = (String)portalContext.getMetaInfo().get("current_data_center")) != null) {
            DSObserver.putDSName(currentDataCenterCode);
        }
        if (this.enableCSRFCheck && !this.checkCSRF((ServletRequest)_request)) {
            ((HttpServletResponse)response).sendError(403);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean checkCSRF(ServletRequest request) {
        String url;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String referer = httpServletRequest.getHeader("Referer");
        String remoteAddress = httpServletRequest.getRemoteAddr();
        if (SERVERNAME_WHITELIST != null && SERVERNAME_WHITELIST.length > 0) {
            String domain = referer;
            if (domain != null) {
                int flag1 = domain.indexOf("://");
                int flag2 = domain.indexOf("/", flag1 + 3);
                flag1 = flag1 < 0 ? 0 : flag1 + 3;
                int n = flag2 = flag2 < 0 ? domain.length() : flag2;
                if (flag2 > flag1) {
                    domain = domain.substring(flag1, flag2);
                }
            }
            for (int i = 0; i < SERVERNAME_WHITELIST.length; ++i) {
                if ((domain == null || !domain.equals(SERVERNAME_WHITELIST[i]) && !domain.startsWith(SERVERNAME_WHITELIST[i])) && !remoteAddress.startsWith(SERVERNAME_WHITELIST[i])) continue;
                return true;
            }
        }
        if (this.enableCSRFCheck_URL && this.isAllowURL(this.URL_AllowsList, url = httpServletRequest.getRequestURI())) {
            return true;
        }
        if (this.enableCSRFCheck_Post) {
            String method = httpServletRequest.getMethod();
            if ((referer == null || referer.length() <= 0) && method.equals("POST")) {
                return false;
            }
        }
        String serverName = request.getServerName();
        return referer == null || referer.length() <= 0 || referer.contains(serverName);
    }

    private boolean needSetDataCenter(PortalContext portalContext, String requestURI) {
        if (portalContext == null) {
            return false;
        }
        return requestURI.indexOf("/res/") <= 0;
    }

    public void init(FilterConfig fConfig) throws ServletException {
        try {
            FilterRegistration attackFilter = fConfig.getServletContext().getFilterRegistration("AttackFilter");
            if (attackFilter == null) {
                return;
            }
            this.enableCSRFCheck = DataCenterFilter.parseBoolean(attackFilter.getInitParameter("enableCSRFCheck"), false);
            this.enableCSRFCheck_Post = DataCenterFilter.parseBoolean(attackFilter.getInitParameter("enableCSRFCheck_POST"), false);
            this.enableCSRFCheck_URL = DataCenterFilter.parseBoolean(attackFilter.getInitParameter("enableCSRFCheck_URL"), false);
            String serverNameWhiteList = attackFilter.getInitParameter("serverNameWhiteList");
            if (serverNameWhiteList != null && !serverNameWhiteList.trim().equals("")) {
                serverNameWhiteList = serverNameWhiteList.trim();
                SERVERNAME_WHITELIST = serverNameWhiteList.split(",");
            }
            String allow_URLS = attackFilter.getInitParameter("allow_URLS");
            List emptyLi = Collections.emptyList();
            this.URL_AllowsList = allow_URLS == null ? emptyLi : Arrays.asList(allow_URLS.split(","));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean parseBoolean(String paramVal, boolean defVal) {
        if (paramVal != null) {
            if ("true".equalsIgnoreCase(paramVal = paramVal.trim())) {
                return true;
            }
            return "false".equalsIgnoreCase(paramVal) ? false : defVal;
        }
        return defVal;
    }

    private boolean isAllowURL(List<String> URL_AllowsList, String url) {
        if (URL_AllowsList.isEmpty()) {
            return false;
        }
        for (String tmp : URL_AllowsList) {
            if (tmp.startsWith("/")) {
                if (!url.startsWith(tmp)) continue;
                return true;
            }
            if (tmp.startsWith("*")) {
                tmp = tmp.substring(1);
            }
            if (!url.endsWith(tmp)) continue;
            return true;
        }
        return false;
    }
}

