/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.core.datacenter;

import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.core.datacenter.PortalLoadBeanOnRuntime;
import com.kingdee.portal.common.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class DataCenterUtil {
    private static final Logger logger = LoggerFactory.getLogger(DataCenterUtil.class);
    private static String DEFAULT_DATABASEPLATFORM = "org.hibernate.dialect.SQLServerDialect";
    private static Map<String, String> databaseDialectMapping = new HashMap<String, String>();

    public static String getDataSourceDialect(String dataSourceName) {
        String databaseDialect = databaseDialectMapping.get(dataSourceName);
        if (!StringUtil.isEmpty((String)databaseDialect)) {
            return databaseDialect;
        }
        DataSource dataSource = DataCenterUtil.getDataSource(dataSourceName);
        return DataCenterUtil.getDataSourceDialect(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataSourceDialect(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String databaseType = conn.getMetaData().getDatabaseProductName();
            String dialectString = DataCenterUtil.convHiberanteDialect(databaseType);
            Properties tempP = new Properties();
            tempP.put("hibernate.dialect", dialectString);
            Dialect dialect = null;
            try {
                dialect = (Dialect)ReflectHelper.classForName((String)dialectString).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new HibernateException("Dialect class not found: " + dialectString, (Throwable)e);
            }
            catch (Exception e) {
                throw new HibernateException("Could not instantiate dialect class", (Throwable)e);
            }
            if (dialect != null) {
                String string = dialect.getClass().getName();
                return string;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return DEFAULT_DATABASEPLATFORM;
    }

    public static DataSource getDataSource(String dataSourceName) {
        DataSource dataSource = null;
        try {
            dataSource = (DataSource)PortalServiceLocator.getBean(dataSourceName);
        }
        catch (NoSuchBeanDefinitionException ex) {
            try {
                PortalLoadBeanOnRuntime loadBean = (PortalLoadBeanOnRuntime)PortalServiceLocator.getBean("loadBeanOnRuntime");
                loadBean.loadBean("/WEB-INF/config/spring/applicationContext-datasource.xml");
                dataSource = (DataSource)PortalServiceLocator.getBean(dataSourceName);
            }
            catch (Exception e) {
                logger.error("There is not the dataSource", e.getCause());
            }
        }
        return dataSource;
    }

    public static String convHiberanteDialect(String databaseType) {
        String _databaseType = StringUtil.convNull((String)databaseType).toLowerCase();
        if (_databaseType.indexOf("microsoft sql server") > -1) {
            return "org.hibernate.dialect.SQLServerDialect";
        }
        if (_databaseType.indexOf("db2") > -1) {
            return "org.hibernate.dialect.DB2Dialect";
        }
        if (_databaseType.indexOf("oracle") > -1 || _databaseType.indexOf("dm") > -1) {
            return "org.hibernate.dialect.Oracle10gDialect";
        }
        if (_databaseType.indexOf("mysql") > -1) {
            return "org.hibernate.dialect.MySQLDialect";
        }
        if (_databaseType.indexOf("sybase") > -1) {
            return "org.hibernate.dialect.SybaseDialect";
        }
        if (_databaseType.indexOf("postgresql") > -1) {
            return "org.hibernate.dialect.PostgreSQLDialect";
        }
        return "org.hibernate.dialect.PostgreSQLDialect";
    }
}

