/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.core.datacenter;

import com.kingdee.portal.biz.core.datacenter.DSObserver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDialectCfg {
    private static final Logger logger = LoggerFactory.getLogger(DataDialectCfg.class);
    private static Map<String, Object> databaseDialectMapping = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void confirmDSDialect(String dataSourceName, DataSource ds) {
        if (dataSourceName == null || dataSourceName.equals("")) {
            return;
        }
        Object dialect = databaseDialectMapping.get(dataSourceName);
        if (dialect == null) {
            Connection conn = null;
            try {
                conn = ds.getConnection();
                new StandardDialectResolver().resolveDialect((DialectResolutionInfo)new DatabaseMetaDataDialectResolutionInfoAdapter(conn.getMetaData()));
                databaseDialectMapping.put(dataSourceName, dialect);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static Dialect getDsDialect(String dataSourceName) {
        return (Dialect)databaseDialectMapping.get(dataSourceName);
    }

    public static Dialect getDsDialect() {
        return DataDialectCfg.getDsDialect(DSObserver.getSp());
    }
}

