/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.core.datacenter;

import com.kingdee.portal.biz.core.datacenter.DSObserver;
import com.kingdee.portal.biz.core.datacenter.DataCenterUtil;
import com.kingdee.portal.biz.core.datacenter.PortalLoadBeanOnRuntime;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class KDPortalDataSource
extends DriverManagerDataSource
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(KDPortalDataSource.class);
    private static Map<String, Object> databaseDialectMapping = new HashMap<String, Object>();
    private DataSource dataSource = null;
    private ApplicationContext applicationContext = null;

    public KDPortalDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public KDPortalDataSource() {
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            logger.error("JDBC resource is not available" + e);
            String sp = DSObserver.getSp();
            DataSource ds = null;
            try {
                PortalLoadBeanOnRuntime loadBean = (PortalLoadBeanOnRuntime)this.applicationContext.getBean("loadBeanOnRuntime");
                loadBean.loadBean("/WEB-INF/config/spring/applicationContext-datasource.xml");
                if (sp == null) {
                    throw e;
                }
                ds = (DataSource)this.applicationContext.getBean(sp);
            }
            catch (BeansException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return ds.getConnection();
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource(String dataSourceName) {
        logger.debug("dataSourceName:" + dataSourceName);
        try {
            if (dataSourceName == null || dataSourceName.equals("")) {
                logger.debug("dataSourceName is null or length is zero");
                return this.dataSource;
            }
            logger.debug("getDataSource from applicationContext");
            DataSource ds = (DataSource)this.applicationContext.getBean(dataSourceName);
            KDPortalDataSource.confirmDSDialect(dataSourceName, ds);
            return ds;
        }
        catch (NoSuchBeanDefinitionException ex) {
            try {
                PortalLoadBeanOnRuntime loadBean = (PortalLoadBeanOnRuntime)this.applicationContext.getBean("loadBeanOnRuntime");
                loadBean.loadBean("/WEB-INF/config/spring/applicationContext-datasource.xml");
                DataSource ds = (DataSource)this.applicationContext.getBean(dataSourceName);
                KDPortalDataSource.confirmDSDialect(dataSourceName, ds);
                return ds;
            }
            catch (Exception e) {
                logger.error("Load bean runtime error", (Throwable)e);
                throw new RuntimeException("There is not the dataSource", e.getCause());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void confirmDSDialect(String dataSourceName, DataSource ds) {
        if (dataSourceName == null || dataSourceName.equals("")) {
            return;
        }
        Object dialect = databaseDialectMapping.get(dataSourceName);
        if (dialect == null) {
            Connection conn = null;
            try {
                conn = ds.getConnection();
                String databaseType = conn.getMetaData().getDatabaseProductName();
                String dialectString = DataCenterUtil.convHiberanteDialect(databaseType);
                Properties tempP = new Properties();
                tempP.put("hibernate.dialect", dialectString);
                try {
                    dialect = (Dialect)ReflectHelper.classForName((String)dialectString).newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new HibernateException("Dialect class not found: " + dialectString, (Throwable)e);
                }
                catch (Exception e) {
                    throw new HibernateException("Could not instantiate dialect class", (Throwable)e);
                }
                databaseDialectMapping.put(dataSourceName, dialect);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static Dialect getDsDialect(String dataSourceName) {
        return (Dialect)databaseDialectMapping.get(dataSourceName);
    }

    public static Dialect getDsDialect() {
        return KDPortalDataSource.getDsDialect(DSObserver.getSp());
    }

    public DataSource getDataSource() {
        String sp = DSObserver.getSp();
        return this.getDataSource(sp);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

