/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.core.datacenter;

import com.kingdee.portal.biz.core.datacenter.DSObserver;
import com.kingdee.portal.biz.core.datacenter.DataCenterUtil;
import com.kingdee.portal.biz.core.datacenter.KDPortalDataSource;
import com.kingdee.portal.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

public class KDPortalJpaVendorAdapter
extends HibernateJpaVendorAdapter
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(KDPortalJpaVendorAdapter.class);
    private ApplicationContext applicationContext = null;
    private boolean generateDdl = false;
    private boolean showSql = false;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected String getDatabasePlatform() {
        String dataSource = DSObserver.getSp();
        if (!StringUtil.isEmpty((String)dataSource)) {
            return DataCenterUtil.getDataSourceDialect(dataSource);
        }
        KDPortalDataSource portalDataSource = (KDPortalDataSource)((Object)this.applicationContext.getBean("dataSource"));
        return DataCenterUtil.getDataSourceDialect(portalDataSource.getDataSource());
    }

    public void setGenerateDdl(boolean generateDdl) {
        this.generateDdl = generateDdl;
    }

    public boolean isGenerateDdl() {
        return this.generateDdl;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public boolean isShowSql() {
        return this.showSql;
    }
}

