/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.facade.eas.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.ILoginAndLogout;
import com.kingdee.eas.base.log.LoginAndLogoutFactory;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.utils.KingdeeServiceUtil;
import com.kingdee.eas.base.uiframe.utils.SecurityValidator;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.NotAllowRepeatLoginUserFactory;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgF7Facade;
import com.kingdee.eas.basedata.org.NewOrgF7FacadeFactory;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.portal.EasServiceImplFacadeFactory;
import com.kingdee.eas.portal.IEasServiceImplFacade;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.util.EASWebLicenceHelper;
import com.kingdee.portal.biz.common.util.PrivacyProtectUtil;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.biz.facade.eas.util.DataSHRTools;
import com.kingdee.portal.biz.facade.eas.util.DataTools;
import com.kingdee.portal.biz.facade.eas.util.DataToolsEx;
import com.kingdee.portal.biz.facade.eas.util.PersonUtil;
import com.kingdee.portal.biz.facade.portal.PortalServiceFacade;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.dto.MenuItemInfo;
import com.kingdee.portal.biz.module.page.dto.PersonPhotoDTO;
import com.kingdee.portal.biz.module.page.dto.SHRMenuDTO;
import com.kingdee.portal.biz.module.perm.dto.GroupDTO;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import org.jfree.util.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EASServiceImpl
implements EASService {
    private static final Logger logger = LoggerFactory.getLogger(EASServiceImpl.class);
    private boolean isOAExist = true;

    @Override
    public List<PersonPhotoDTO> generatePhotoURL(PortalContext ctx, HttpServletRequest request, String[] personIds) throws Exception {
        return PersonUtil.generatePhotoURL(ctx, request, personIds);
    }

    @Override
    public String getPersonLogoUrl(PortalContext ctx, HttpServletRequest request, String personId) throws PortalBizException {
        PersonPhotoDTO dto = null;
        try {
            dto = PersonUtil.generatePhotoURL(ctx, request, personId);
        }
        catch (Exception e) {
            logger.error(" \u83b7\u53d6\u804c\u5458" + personId + "\u5934\u8c61\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
            throw new PortalBizException("\u83b7\u53d6\u804c\u5458\u5934\u8c61\u4fe1\u606f\u5931\u8d25\uff01", e);
        }
        return dto.getImgPath();
    }

    @Override
    public Map getPersonBaseInfo(HttpServletRequest request, PortalContext portalContext, String personId) throws PortalBizException {
        HashMap<String, String> personMap = new HashMap<String, String>();
        Locale local = portalContext.getLocale();
        PersonInfo info = null;
        try {
            info = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            AdminOrgUnitInfo adminInfo = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
            PositionInfo posInfo = PersonFactory.getRemoteInstance().getPrimaryPosition(BOSUuid.read((String)personId));
            String position = null;
            String hrOrgName = "";
            String imgUrl = "";
            try {
                if (null != posInfo) {
                    position = posInfo.getDisplayName(local);
                }
                if (null != adminInfo) {
                    hrOrgName = adminInfo.getName(local);
                }
                imgUrl = this.getPersonLogoUrl(portalContext, request, personId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            personMap.put("id", personId);
            personMap.put("name", info.getName(local));
            personMap.put("hrOrgName", hrOrgName);
            personMap.put("position", position);
            personMap.put("email", info.getEmail());
            personMap.put("backupEMail", info.getBackupEMail());
            personMap.put("officePhone", info.getOfficePhone());
            if (info.isIsHideSensitive()) {
                personMap.put("homePhone", null);
                personMap.put("cell", null);
                personMap.put("backupcell", null);
            } else {
                personMap.put("homePhone", info.getHomePhone());
                personMap.put("cell", info.getCell());
                personMap.put("backupcell", info.getBackupCell());
            }
            String rootPath = request.getContextPath();
            if (null == imgUrl || "".equals(imgUrl)) {
                imgUrl = rootPath + "/res/img/global/icons/default-user-logo.png";
            }
            personMap.put("imgUrl", imgUrl);
        }
        catch (Exception e) {
            Log.error((Object)" \u83b7\u53d6\u804c\u5458\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff01", (Exception)e);
            throw new PortalBizException("\u83b7\u53d6\u804c\u5458\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff01", e);
        }
        return personMap;
    }

    @Override
    public List<MenuItemInfo> getExternalLinkList(PortalContext ctx, NodeTypeEnum type, String longnumber, int parentLevel, boolean isSys) throws PortalBizException {
        List<MenuItemInfo> list = null;
        try {
            if (NodeTypeEnum.EXTERNAL_LINK_OA == type) {
                Context bosCtx = (Context)ctx.getMetaInfo().get("eas_context");
                if (StringUtils.isEmpty((String)longnumber)) {
                    IRowSet rs = DataTools.getAllTemplateType(bosCtx, null);
                    list = this.buildMenuItemListFromOATemplateType(rs);
                } else {
                    IRowSet rs = DataTools.getAllTemplate(bosCtx, " and FTemplateTypeID='" + longnumber + "' ");
                    list = this.buildMenuItemListFromOATemplate(rs, longnumber);
                }
            } else if (NodeTypeEnum.EXTERNAL_LINK_SHR == type) {
                Context bosCtx = (Context)ctx.getMetaInfo().get("eas_context");
                String locale = bosCtx.getLocale().toString();
                if (StringUtils.isEmpty((String)longnumber)) {
                    JSONArray jsonArray = DataSHRTools.findSHRMenuList(bosCtx);
                    list = this.buildMenuItemListFromSHR(jsonArray, null, false, locale);
                } else {
                    JSONArray jsonArray = DataSHRTools.findSHRMenuList(bosCtx);
                    list = this.buildMenuItemListFromSHR(jsonArray, longnumber, false, locale);
                }
            } else {
                IRowSet rs = this.getMenuItem4Import(ctx, type, longnumber, parentLevel, isSys);
                list = this.buildMenuItemList(rs);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5916\u90e8\u83dc\u5355\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            throw new PortalBizException("\u83b7\u53d6EAS\u83dc\u5355\u5931\u8d25\uff01");
        }
        return list;
    }

    private IRowSet getMenuItem4Import(PortalContext ctx, NodeTypeEnum type, String longnumber, int parentLevel, boolean isSys) throws BOSException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        Locale locale = context.getLocale();
        StringBuilder sql = new StringBuilder();
        this.appendSelectPart(sql, locale.toString(), isSys);
        this.appendWhereTruePart(sql, type);
        this.appendLevelFilterPart(sql, longnumber, parentLevel);
        this.appendOrderPart(sql, parentLevel);
        return DbUtil.executeQuery((Context)context, (String)sql.toString());
    }

    private void appendSelectPart(StringBuilder sql, String locale, boolean isSys) {
        sql.append("select fid, fname_").append(locale).append(" fname, flongnumber, fparent, flevel, fisleaf, fuiclassname,fimagepath,fuiclassparam,fuioprt,fopenmethod from ");
        if (isSys) {
            sql.append(" T_BAS_SysMenuItem");
        } else {
            sql.append(" T_PM_MainMenuItem");
        }
    }

    private void appendWhereTruePart(StringBuilder sql, NodeTypeEnum type) {
        sql.append(" where 1=1 ");
        if (NodeTypeEnum.EXTERNAL_LINK == type) {
            sql.append(" and fmenutype=5");
        } else if (NodeTypeEnum.EXTERNAL_LINK_G == type) {
            sql.append(" and (fmenutype is null or fmenutype=10)");
        }
    }

    private void appendLevelFilterPart(StringBuilder sql, String longnumber, int parentLevel) {
        if (parentLevel > 0) {
            sql.append(" and flevel = ").append(parentLevel + 1);
        }
        if (StringUtils.isEmpty((String)longnumber)) {
            sql.append(" and fparent is null ");
        } else {
            sql.append(" and flongnumber like '").append(longnumber).append("!%'");
        }
    }

    private void appendOrderPart(StringBuilder sql, int parentLevel) {
        if (parentLevel > 0) {
            sql.append(" order by flongnumber asc ");
        } else {
            sql.append(" order by forder asc ");
        }
    }

    @Override
    public List<MenuItemInfo> getExternalLinkList(PortalContext ctx, NodeTypeEnum type, String[] menuItemLongNumberColl, String[] menuItemIdColl, boolean isSys) throws PortalBizException {
        List<MenuItemInfo> list = null;
        try {
            if (NodeTypeEnum.EXTERNAL_LINK_OA == type) {
                StringBuffer selectCondition1 = new StringBuffer();
                StringBuffer selectCondition2 = new StringBuffer();
                selectCondition1.append(" fid in (");
                selectCondition2.append(" or FTemplateTypeID in (");
                boolean byTempType = false;
                ArrayList<String> longNumberCol = new ArrayList<String>();
                for (String longNumber : menuItemLongNumberColl) {
                    String[] numberIDs = longNumber.split("\\|");
                    String numberID = numberIDs[numberIDs.length - 1];
                    if (numberIDs.length == 1 && numberID.indexOf("%") > 0) {
                        numberID = URLDecoder.decode(numberID);
                    }
                    if (!longNumberCol.contains(numberID)) {
                        longNumberCol.add(numberID);
                        selectCondition1.append("'").append(numberID).append("', ");
                    }
                    if (numberIDs.length != 1) continue;
                    byTempType = true;
                    String tempTypeID = numberIDs[0];
                    if (tempTypeID.indexOf("%") > 0) {
                        tempTypeID = URLDecoder.decode(tempTypeID);
                    }
                    selectCondition2.append("'").append(tempTypeID).append("', ");
                }
                selectCondition1.replace(selectCondition1.length() - 2, selectCondition1.length(), "");
                selectCondition1.append(")");
                selectCondition2.replace(selectCondition2.length() - 2, selectCondition2.length(), "");
                selectCondition2.append(")");
                Context bosCtx = (Context)ctx.getMetaInfo().get("eas_context");
                IRowSet rs = DataTools.getAllTemplateType(bosCtx, " and " + selectCondition1.toString());
                list = this.buildMenuItemListFromOATemplateType(rs);
                rs = byTempType ? DataTools.getAllTemplate(bosCtx, " and (" + selectCondition1.toString() + selectCondition2.toString() + ")") : DataTools.getAllTemplate(bosCtx, " and " + selectCondition1.toString());
                List<MenuItemInfo> tmpList = this.buildMenuItemListFromOATemplate(rs);
                if (tmpList != null) {
                    list.addAll(tmpList);
                }
            } else if (NodeTypeEnum.EXTERNAL_LINK_SHR == type) {
                Context bosCtx = (Context)ctx.getMetaInfo().get("eas_context");
                String locale = bosCtx.getLocale().toString();
                JSONArray jsonArray = DataSHRTools.findSHRMenuList(bosCtx);
                list = this.buildMenuItemListFromSHR(jsonArray, null, true, locale);
            } else {
                IRowSet rs = this.getAllMenuItems(ctx, type, menuItemLongNumberColl, menuItemIdColl, isSys);
                list = this.buildMenuItemList(rs);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5916\u90e8\u83dc\u5355\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            throw new PortalBizException("\u83b7\u53d6EAS\u83dc\u5355\u5931\u8d25\uff01");
        }
        return list;
    }

    private IRowSet getAllMenuItems(PortalContext ctx, NodeTypeEnum type, String[] menuItemLongNumberColl, String[] menuItemIdColl, boolean isSys) throws BOSException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        Locale locale = context.getLocale();
        StringBuilder sql = new StringBuilder();
        this.appendSelectPart(sql, locale.toString(), isSys);
        this.appendWhereFalsePart(sql, type);
        this.appendChildrenFilterPart(sql, menuItemLongNumberColl, menuItemIdColl);
        this.appendOrderPart(sql, 1);
        return DbUtil.executeQuery((Context)context, (String)sql.toString());
    }

    private void appendWhereFalsePart(StringBuilder sql, NodeTypeEnum type) {
        sql.append(" where 1=1");
        if (NodeTypeEnum.EXTERNAL_LINK == type) {
            sql.append(" and fmenutype=5");
        } else if (NodeTypeEnum.EXTERNAL_LINK_G == type) {
            sql.append(" and (fmenutype is null or fmenutype=10)");
        }
        sql.append(" and (1=0");
    }

    private void appendChildrenFilterPart(StringBuilder sql, String[] menuItemLongNumberColl, String[] menuItemIdColl) {
        if (menuItemIdColl != null && menuItemIdColl.length > 0) {
            sql.append(" or fid in ('").append(StringUtils.arrayToString((Object[])menuItemIdColl, (String)"','")).append("')");
        }
        if (menuItemLongNumberColl != null && menuItemLongNumberColl.length > 0) {
            sql.append(" or flongnumber in ('").append(StringUtils.arrayToString((Object[])menuItemLongNumberColl, (String)"','")).append("')");
            for (String longNumber : menuItemLongNumberColl) {
                sql.append(" or flongnumber like '").append(longNumber).append("!%'");
            }
        }
        sql.append(")");
    }

    private List<MenuItemInfo> buildMenuItemListFromOATemplateType(IRowSet rs) throws SQLException {
        ArrayList<MenuItemInfo> list = new ArrayList<MenuItemInfo>();
        MenuItemInfo item = null;
        while (rs.next()) {
            item = new MenuItemInfo();
            item.setId(rs.getString("fid"));
            String name = rs.getString("fname");
            if (name == null) {
                name = "";
            }
            item.setName(name);
            item.setParentId(null);
            item.setLeaf(false);
            item.setLongNumber(URLEncoder.encode(item.getId()));
            list.add(item);
        }
        return list;
    }

    private List<MenuItemInfo> buildMenuItemListFromOATemplate(IRowSet rs) throws SQLException {
        return this.buildMenuItemListFromOATemplate(rs, null);
    }

    private List<MenuItemInfo> buildMenuItemListFromOATemplate(IRowSet rs, String longnumber) throws SQLException {
        ArrayList<MenuItemInfo> list = new ArrayList<MenuItemInfo>();
        MenuItemInfo item = null;
        while (rs.next()) {
            item = new MenuItemInfo();
            item.setId(rs.getString("fid"));
            String name = rs.getString("fname");
            if (name == null) {
                name = "";
            }
            item.setName(name);
            item.setParentId(rs.getString("FTemplateTypeID"));
            item.setUiClassName(DataTools.getTemplateUrlByFormIdAndTempId(rs.getString("fformID"), rs.getString("fid")));
            item.setLeaf(true);
            if (StringUtils.isEmpty((String)longnumber)) {
                item.setLongNumber(item.getId());
            } else {
                item.setLongNumber(longnumber + "|" + item.getId());
            }
            list.add(item);
        }
        return list;
    }

    private List<MenuItemInfo> buildMenuItemListFromSHR(JSONArray jsonArray, String longNumber, boolean isAll, String locale) throws SQLException {
        ArrayList<MenuItemInfo> list = new ArrayList<MenuItemInfo>();
        MenuItemInfo item = null;
        List list1 = JSONArray.toList((JSONArray)jsonArray, SHRMenuDTO.class);
        Iterator it = list1.iterator();
        while (it.hasNext()) {
            item = new MenuItemInfo();
            SHRMenuDTO dto = (SHRMenuDTO)it.next();
            item = new MenuItemInfo();
            if (isAll) {
                item.setId(dto.getId());
                item.setName(this.getLocaleName(dto.getDisplayName(), locale));
                item.setParentId(dto.getParentId());
                item.setUiClassName(dto.getUrl());
                item.setLongNumber(dto.getUrlPath());
                item.setLeaf(Boolean.valueOf(dto.getIsLeaf()));
                item.setLevel(dto.getLevel());
                item.setDisplayName(dto.getDisplayName());
                list.add(item);
                continue;
            }
            if (StringUtils.isEmpty((String)longNumber) && StringUtils.isEmpty((String)dto.getParentId())) {
                item.setId(dto.getId());
                item.setName(this.getLocaleName(dto.getDisplayName(), locale));
                item.setParentId(dto.getParentId());
                item.setParentId("");
                item.setUiClassName(dto.getUrl());
                item.setLongNumber(dto.getUrlPath());
                item.setLeaf(Boolean.valueOf(dto.getIsLeaf()));
                item.setLevel(dto.getLevel());
                item.setDisplayName(dto.getDisplayName());
                list.add(item);
                continue;
            }
            if (StringUtils.isEmpty((String)longNumber) || StringUtils.isEmpty((String)dto.getParentId()) || !dto.getUrlPath().startsWith(longNumber + "!")) continue;
            item.setId(dto.getId());
            item.setName(this.getLocaleName(dto.getDisplayName(), locale));
            item.setParentId(dto.getParentId());
            item.setParentId(dto.getParentId());
            item.setUiClassName(dto.getUrl());
            item.setLongNumber(dto.getUrlPath());
            item.setLeaf(Boolean.valueOf(dto.getIsLeaf()));
            item.setLevel(dto.getLevel());
            item.setDisplayName(dto.getDisplayName());
            list.add(item);
        }
        return list;
    }

    private String getLocaleName(DisplayName displayName, String locale) {
        String name = "";
        if (displayName == null) {
            return name;
        }
        if ("L1".equalsIgnoreCase(locale)) {
            name = displayName.getEn();
        } else if ("L2".equalsIgnoreCase(locale)) {
            name = displayName.getZh_CN();
        } else if ("L3".equalsIgnoreCase(locale)) {
            name = displayName.getZh_TW();
        }
        if (StringUtils.isEmpty((String)name)) {
            name = displayName.getZh_CN();
        }
        return name;
    }

    private List<MenuItemInfo> buildMenuItemList(IRowSet rs) throws SQLException {
        ArrayList<MenuItemInfo> list = new ArrayList<MenuItemInfo>();
        MenuItemInfo item = null;
        while (rs.next()) {
            item = new MenuItemInfo();
            item.setId(rs.getString("fid"));
            String name = rs.getString("fname");
            if (name == null) {
                name = "";
            }
            item.setName(name);
            item.setParentId(rs.getString("fparent"));
            item.setUiClassName(rs.getString("fuiclassname"));
            item.setLongNumber(rs.getString("flongnumber"));
            item.setLeaf(rs.getBoolean("fisleaf"));
            item.setLevel(rs.getInt("flevel"));
            item.setImagePath(rs.getString("fimagepath"));
            item.setUiClassParam(rs.getString("fuiclassparam"));
            item.setUiOprt(rs.getString("fuioprt"));
            item.setOpenMethod(rs.getString("fopenmethod"));
            list.add(item);
        }
        return list;
    }

    @Override
    public Map<String, String> getPermessionArrayExt(Context ctx, NodeTypeEnum type, boolean bl) throws PortalBizException {
        Map<Object, Object> ids;
        block19: {
            ids = null;
            try {
                if (NodeTypeEnum.EXTERNAL_LINK_OA == type) {
                    StringBuilder idBuilder = new StringBuilder();
                    IRowSet rs = null;
                    try {
                        String perId = null;
                        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                            perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
                        }
                        if ((ids = DataToolsEx.getAllNewTemp(ctx, perId)).size() > 0) {
                            rs = DataTools.getAllTemplateType(ctx, null);
                            while (rs.next()) {
                                ids.put(rs.getString("fid"), "1");
                                idBuilder.append(rs.getString("fid") + ",");
                            }
                            ids.put("idString", idBuilder.toString() + (String)ids.get("idString"));
                            break block19;
                        }
                        ids.put("idString", "");
                    }
                    catch (Exception e) {
                        logger.error("\u83b7\u53d6\u534f\u540c\u6743\u9650\u83dc\u5355\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
                        this.isOAExist = false;
                    }
                    break block19;
                }
                if (NodeTypeEnum.EXTERNAL_LINK_SHR == type) {
                    String menus;
                    if (ids == null) {
                        ids = new HashMap<String, String>();
                    }
                    if (StringUtils.isEmpty((String)(menus = DataSHRTools.findSHRPermMenuList(ctx)))) {
                        menus = "";
                    } else {
                        String[] menu;
                        for (String val : menu = menus.split(",")) {
                            ids.put(val, "1");
                        }
                    }
                    ids.put("idString", menus);
                } else {
                    String userId;
                    IObjectPK userPK;
                    boolean flag;
                    String cobId;
                    CustomCacheService cacheService = new CustomCacheService("login.all_menu");
                    cacheService.remove("allMenuRowSet");
                    IEasServiceImplFacade easServiceImplFacade = null;
                    easServiceImplFacade = EasServiceImplFacadeFactory.getRemoteInstance();
                    ids = easServiceImplFacade.getPermessionArrayExt(bl);
                    if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null && !StringUtil.isEmpty((String)(cobId = (String)ids.get("hg9BjNTjQ1eTPaicu9NuIRdCz6U=")))) {
                        ids.remove("hg9BjNTjQ1eTPaicu9NuIRdCz6U=");
                    }
                    boolean bl2 = flag = Administrator.isSuperAdmin((IObjectPK)(userPK = ctx.getCaller())) || Administrator.isCUAdmin((Context)ctx, (IObjectPK)userPK) || Administrator.isBizAdmin((Context)ctx, (IObjectPK)userPK);
                    if (!flag || "Subsystem".equalsIgnoreCase(LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getControlPolicy())) {
                        ids.remove("2FRp8wXKTEGwVTcNhYZn9RdCz6U=");
                        ids.remove("70XZjIDGQ2OLeYMgt/5lOBdCz6U=");
                        ids.remove("dLMCIBL5DfXgU0A+qMD7iBdCz6U=");
                        ids.remove("pKZ3FNCATHC8fuRItlB/5RdCz6U=");
                        ids.remove("orTblwPsS1OD7HJGvwqOFxdCz6U=");
                        ids.remove("WOOT7eDUQ9aKn2YNRjCheBdCz6U=");
                        ids.remove("uKmYq5soR1amBNeW3AG7ExdCz6U=");
                    }
                    if (!Administrator.isSuperCUAdmin((IObjectPK)userPK)) {
                        ids.remove("gTLH9RxmRpyGSRP2qqz+AxdCz6U=");
                        ids.remove("iCe7z9hRRGyRoe9VVjrJtBdCz6U=");
                        ids.remove("r7y7r6QkRiWFMHVDxFlrchdCz6U=");
                        ids.remove("ST1GNjxTQKmlub76IZ1QzBdCz6U=");
                        ids.remove("P48KfVYJTaOmVOV6G+qv9RdCz6U=");
                        ids.remove("3kf81N1FS7OLueqeuWMJzxdCz6U=");
                        ids.remove("krudynkBQxCWMnG5D7DcpBdCz6U=");
                        ids.remove("FTB968i2R86SGJWQJ5KosxdCz6U=");
                        ids.remove("g1SDcwutR+KDbuxGSAekABdCz6U=");
                        ids.remove("Cnhr9SPAT+mdA132pxHmWhdCz6U=");
                        ids.remove("F9VpTKx5S0mx7jRgil+tMhdCz6U=");
                        ids.remove("0Lc1AKmET4aEYc7+sB7pIxdCz6U=");
                        ids.remove("2vzwnj6qQ+OVDZj6VA9B2xdCz6U=");
                        ids.remove("cfUW+JCTT82Z6E6G7KgVHBdCz6U=");
                        ids.remove("1rmaR0OSSfWgYEne+oCjaxdCz6U=");
                        ids.remove("7P6NTajfT0K99EUd5FduBhdCz6U=");
                        ids.remove("8HA+hzDsSia4F/XHUha8mhdCz6U=");
                        ids.remove("1DfgElYVSGavByp6D60eGBdCz6U=");
                        ids.remove("kidEwTZ5RE+t9GaS+P42aBdCz6U=");
                        ids.remove("+QBYu254RbSbZXqGu1IlJRdCz6U=");
                        ids.remove("tv0tYkMKT6OiGXCisgU2MBdCz6U=");
                        ids.remove("q71C1Fw+QkyKa+i/pHhhpxdCz6U=");
                        ids.remove("Sg6q2rm1RYeiMOKWktuKXxdCz6U=");
                        ids.remove("RB56xVa3S2+rdoNzSC6oUBdCz6U=");
                        ids.remove("65+g3uwZSRy9TpKOfZg6TBdCz6U=");
                        ids.remove("bk4iKfg6RRKlVb8XL57AGRdCz6U=");
                        ids.remove("QYmmezXFShaDdOObgwbePRdCz6U=");
                        ids.remove("wb7vNqyvQ/2mtl7H/BgNgBdCz6U=");
                        ids.remove("EX6Rmm0QTWaqF55acdfsnBdCz6U=");
                        ids.remove("TYpvyxOfTYKhz/+b2PP+qxdCz6U=");
                        ids.remove("VGlp8Xx3QqSZQWM6Yv3XXxdCz6U=");
                        ids.remove("usZqx5gqTwS2q1IpoysR7RdCz6U=");
                        ids.remove("9wyGrD+ySsSDnzRpAfRBCxdCz6U=");
                        ids.remove("6xT1M9WESKOBJFF+CDScERdCz6U=");
                        ids.remove("g1C3HiQpTNmnXFXeAo11XxdCz6U=");
                        ids.remove("XetlUETSRUmQtehxAFxCGRdCz6U=");
                    }
                    if ("00000000-0000-0000-0000-00000000000213B7DE7F".equalsIgnoreCase(userId = userPK.toString()) || "Wp3rRSFxRCaPFjuE2apQjRO33n8=".equalsIgnoreCase(userId) || "00000000-0000-0000-0000-00000000000113B7DE7F".equalsIgnoreCase(userId) || "IpyedAEWEADgAAmlwKgTMBO33n8=".equalsIgnoreCase(userId) || "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equalsIgnoreCase(userId)) {
                        ids.remove("Pvk1O9YsSA+dnL9eUjaFMRdCz6U=");
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
                logger.error("\u83b7\u53d6web\u6743\u9650\u83dc\u5355\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
                throw new PortalBizException("300", e);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u83b7\u53d6web\u6743\u9650\u83dc\u5355\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
                throw new PortalBizException("300", e);
            }
        }
        return ids;
    }

    @Override
    public boolean removeEASSession(String id) {
        SessionManager.getInstance().removeSession(id);
        return true;
    }

    @Override
    public String writeEASlog(String logType) {
        IObjectPK logPK = null;
        try {
            ILoginAndLogout iLoginAndLogout = LoginAndLogoutFactory.getRemoteInstance();
            IAppLog iLog = AppLogFactory.getRemoteInstance();
            if ("login".equalsIgnoreCase(logType)) {
                logPK = iLog.writeLog("UserLogin()", iLoginAndLogout.getType(), null, null, "UserLoginLog");
            } else if ("logout".equalsIgnoreCase(logType)) {
                logPK = iLog.writeLog("UserLogout()", iLoginAndLogout.getType(), null, null, "UserLogoutLog");
            }
            iLog.upateLogStatus(logPK);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (logPK != null) {
            return logPK.toString();
        }
        return null;
    }

    @Override
    public Map<String, Object> getFullOrgColl(PortalContext ctx, String type, String longNumber, boolean isShowSealedUp) throws PortalBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            MetaDataPK queryPK = null;
            queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app", "NewOrgF7Query");
            if ("0".equals(type)) {
                queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app", "NewOrgF74BaseUnitQuery");
            }
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            EntityViewInfo viewInfo = this.getEntityViewExceptTreeFilter(ctx, type, longNumber, isShowSealedUp);
            exec.setObjectView(viewInfo);
            IRowSet rowSet = exec.executeQuery();
            FullOrgUnitCollection fullColl = new FullOrgUnitCollection();
            FullOrgUnitInfo fullOrgUnitInfo = null;
            if ("0".equals(type)) {
                while (rowSet.next()) {
                    fullOrgUnitInfo = new FullOrgUnitInfo();
                    fullOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                    fullOrgUnitInfo.setNumber(rowSet.getString("number"));
                    fullOrgUnitInfo.setName(rowSet.getString("name"));
                    fullOrgUnitInfo.setLongNumber(rowSet.getString("longNumber"));
                    fullOrgUnitInfo.setCode(rowSet.getString("code"));
                    fullOrgUnitInfo.setOrgTypeStr(rowSet.getString("orgTypeStr"));
                    fullColl.add(fullOrgUnitInfo);
                }
            } else {
                while (rowSet.next()) {
                    fullOrgUnitInfo = new FullOrgUnitInfo();
                    fullOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("unit.id")));
                    fullOrgUnitInfo.setNumber(rowSet.getString("unit.number"));
                    fullOrgUnitInfo.setName(rowSet.getString("unit.name"));
                    fullOrgUnitInfo.setLongNumber(rowSet.getString("longNumber"));
                    fullOrgUnitInfo.setCode(rowSet.getString("unit.code"));
                    fullOrgUnitInfo.setOrgTypeStr(rowSet.getString("unit.orgTypeStr"));
                    fullColl.add(fullOrgUnitInfo);
                }
            }
            map.put("result", fullColl);
            map.put("total", fullColl.size());
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            logger.error("\u83b7\u53d6\u5f85\u5207\u6362\u7684\u7ec4\u7ec7\u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
            throw new PortalBizException("300", e);
        }
        return map;
    }

    private EntityViewInfo getEntityViewExceptTreeFilter(PortalContext ctx, String type, String longNumber, boolean isShowSealedUp) throws BOSException {
        FilterInfo tmpOuterFilter;
        FilterInfo outerFilter;
        FilterItemInfo itemInfo;
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String userId = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
        String prefix = "0".equals(type) ? "" : "unit.";
        String treeId = "";
        if (!"0".equals(type)) {
            int orgTypeValue = Integer.parseInt(type);
            OrgViewType orgViewType = OrgViewType.getEnum((int)orgTypeValue);
            OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType);
            treeId = orgTypeInfo.getOrgTreeID();
        }
        EntityViewInfo result = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        result.setFilter(filter);
        boolean isNeedAddAssistant = true;
        boolean isNeedAddVirtual = false;
        if (isNeedAddAssistant) {
            CompanyOrgUnitInfo currentCompany = ContextUtil.getCurrentFIUnit((Context)context);
            if (currentCompany != null && currentCompany.isIsAssistantOrg()) {
                filter.getFilterItems().add(new FilterItemInfo(prefix + "isAssistantOrg", (Object)1, CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo(prefix + "isAssistantOrg", (Object)0, CompareType.EQUALS));
            }
        }
        if (isNeedAddVirtual) {
            filter.getFilterItems().add(new FilterItemInfo(prefix + "partAdmin.isVirtual", (Object)0, CompareType.EQUALS));
        }
        if (!isShowSealedUp && (itemInfo = this.getSealUpOrgFilter(context, type, prefix)) != null) {
            filter.getFilterItems().add(itemInfo);
        }
        if ((outerFilter = this.getOuterFilterInfo(userId, type)) != null) {
            filter.mergeFilter(outerFilter, "and");
        }
        if (!StringUtil.isEmpty((String)longNumber) && (tmpOuterFilter = this.buildTreeNodeFilter(longNumber, treeId)) != null) {
            filter.mergeFilter(tmpOuterFilter, "and");
        }
        SorterItemCollection coll = new SorterItemCollection();
        coll.add(new SorterItemInfo("longNumber"));
        result.setSorter(coll);
        return result;
    }

    private FilterInfo buildTreeNodeFilter(String longNumber, String treeId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        filter.setMaskString("(#0 or #1)");
        filter.mergeFilter(this.getOrgTreeFilter(treeId), "and");
        return filter;
    }

    private FilterInfo getOrgTreeFilter(String treeId) {
        if (StringUtils.isEmpty((String)treeId)) {
            return new FilterInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeId, CompareType.EQUALS));
        return filter;
    }

    private FilterInfo getOuterFilterInfo(String userPK, String type) {
        try {
            FilterInfo orgRangeFilter = null;
            String oql = this.getOrgRangeOql(userPK, type);
            if (StringUtil.isEmpty((String)oql)) {
                return null;
            }
            orgRangeFilter = new FilterInfo(this.getOrgRangeOql(userPK, type));
            return orgRangeFilter;
        }
        catch (ParserException e) {
            logger.error("getOrgRangeFilter error.", (Throwable)e);
            return null;
        }
    }

    private boolean isBasicOrgType(OrgType orgType) {
        if (orgType == null) {
            return false;
        }
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (orgTypeInfo == null) {
            return false;
        }
        return orgTypeInfo.isBasicOrgType();
    }

    private String getOrgRangeOql(String userPK, String type) {
        StringBuffer result = new StringBuffer();
        StringBuffer temp = new StringBuffer();
        temp.append("SELECT FOrgID").append(" FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(userPK).append("' AND FType = ").append(10);
        if ("0".equals(type)) {
            result.append("id in (").append(temp.toString()).append(")");
        } else {
            result.append("UNIT.id in (").append(temp.toString()).append(")");
        }
        return result.toString();
    }

    @Override
    public List<GroupDTO> getPagingSwitchOrgList(PortalContext ctx, Object coll, PagingParam param) throws PortalBizException {
        FullOrgUnitCollection fullCol = (FullOrgUnitCollection)coll;
        int size = fullCol.size();
        int start = param.getStartIndex();
        int end = start + param.getPageSize();
        String id = "";
        StringBuffer numberBuffer = null;
        StringBuffer nameBuffer = new StringBuffer();
        String code = "";
        String Longnumber = "";
        FullOrgUnitInfo info = null;
        ArrayList<GroupDTO> groupList = new ArrayList<GroupDTO>();
        GroupDTO group = null;
        for (int i = start; i < size && i < end; ++i) {
            info = fullCol.get(i);
            id = info.getId() != null ? info.getId().toString() : "";
            Longnumber = info.getLongNumber();
            int num = 0;
            while (Longnumber.indexOf("!") > 0) {
                ++num;
                Longnumber = Longnumber.substring(Longnumber.indexOf("!") + 1, Longnumber.length());
            }
            numberBuffer = new StringBuffer();
            nameBuffer = new StringBuffer();
            while (num > 0) {
                numberBuffer.append("&nbsp;&nbsp;&nbsp;");
                nameBuffer.append("&nbsp;&nbsp;&nbsp;");
                --num;
            }
            numberBuffer.append(info.getNumber());
            nameBuffer.append(StringUtils.cnulls((String)info.getName()));
            code = info.getCode();
            if (StringUtils.isEmpty((String)code)) {
                code = "&nbsp";
            }
            group = new GroupDTO();
            group.setId(id);
            group.setNumber(numberBuffer.toString());
            group.setName(nameBuffer.toString());
            group.setCode(code);
            group.setBizUnitFlag(info.getOrgTypeStr());
            groupList.add(group);
        }
        return groupList;
    }

    @Override
    public String switchOrgUnit(PortalContext ctx, String orgId) throws PortalBizException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        try {
            OrgSwitchFacadeFactory.getRemoteInstance().orgSwitch(orgId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getCurrentOUName(context);
    }

    private String getCurrentOUName(Context context) {
        return ContextUtil.getCurrentOrgUnit((Context)context).getName(context.getLocale());
    }

    @Override
    public String getOrgName(PortalContext ctx) throws PortalBizException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        return this.getCurrentOUName(context);
    }

    @Override
    public String getOrgDisplayName(PortalContext ctx) throws PortalBizException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        return ContextUtil.getCurrentOrgUnit((Context)context).getDisplayName(context.getLocale());
    }

    @Override
    public String getPersonMainPosition(PortalContext ctx) throws PortalBizException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        PersonInfo info = ContextUtil.getCurrentUserInfo((Context)context).getPerson();
        BOSUuid id = null;
        PositionInfo pinfo = null;
        if (info != null) {
            id = info.getId();
        }
        if (id != null) {
            try {
                pinfo = PersonFactory.getRemoteInstance().getPrimaryPosition(id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (pinfo != null) {
            return pinfo.getName(context.getLocale());
        }
        return "";
    }

    @Override
    public Map getPersonMetaInfo(PortalContext ctx) throws PortalBizException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        PersonInfo info = ContextUtil.getCurrentUserInfo((Context)context).getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        boolean sensitiveDef = PrivacyProtectUtil.isSensitiveDef();
        if (info != null && info.getId() != null) {
            try {
                info = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(info.getId()));
                if (sensitiveDef) {
                    map.put("isBackupCell", "true");
                    map.put("backupCell", PrivacyProtectUtil.hidePhoneInfo(info.getBackupCell()));
                    map.put("name", info.getName(context.getLocale()));
                    map.put("backupEMail", PrivacyProtectUtil.hideEmailInfo(info.getBackupEMail()));
                    map.put("cell", PrivacyProtectUtil.hidePhoneInfo(info.getNCell()));
                    map.put("globalRoaming", info.getGlobalRoaming());
                    map.put("email", PrivacyProtectUtil.hideEmailInfo(info.getEmail()));
                    map.put("officePhone", PrivacyProtectUtil.hidePhoneInfo(info.getOfficePhone()));
                    map.put("homePhone", PrivacyProtectUtil.hidePhoneInfo(info.getHomePhone()));
                } else {
                    map.put("isBackupCell", "true");
                    map.put("backupCell", info.getBackupCell());
                    map.put("name", info.getName(context.getLocale()));
                    map.put("backupEMail", info.getBackupEMail());
                    map.put("cell", info.getNCell());
                    map.put("globalRoaming", info.getGlobalRoaming());
                    map.put("email", info.getEmail());
                    map.put("officePhone", info.getOfficePhone());
                    map.put("homePhone", info.getHomePhone());
                }
                map.put("backupCellReal", info.getBackupCell());
                map.put("backupEMailReal", info.getBackupEMail());
                map.put("cellReal", info.getNCell());
                map.put("emailReal", info.getEmail());
                map.put("officePhoneReal", info.getOfficePhone());
                map.put("homePhoneReal", info.getHomePhone());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo(context.getCaller());
                if (sensitiveDef) {
                    map.put("isBackupCell", "false");
                    map.put("backupCell", "");
                    map.put("name", userInfo.getName(context.getLocale()));
                    map.put("backupEMail", PrivacyProtectUtil.hideEmailInfo(userInfo.getBackupEMail()));
                    map.put("cell", PrivacyProtectUtil.hidePhoneInfo(userInfo.getNCell()));
                    map.put("globalRoaming", userInfo.getGlobalRoaming());
                    map.put("email", PrivacyProtectUtil.hideEmailInfo(userInfo.getEmail()));
                    map.put("officePhone", PrivacyProtectUtil.hidePhoneInfo(userInfo.getOfficePhone()));
                    map.put("homePhone", PrivacyProtectUtil.hidePhoneInfo(userInfo.getHomePhone()));
                } else {
                    map.put("isBackupCell", "false");
                    map.put("backupCell", "");
                    map.put("name", userInfo.getName(context.getLocale()));
                    map.put("backupEMail", userInfo.getBackupEMail());
                    map.put("cell", userInfo.getNCell());
                    map.put("globalRoaming", userInfo.getGlobalRoaming());
                    map.put("email", userInfo.getEmail());
                    map.put("officePhone", userInfo.getOfficePhone());
                    map.put("homePhone", userInfo.getHomePhone());
                }
                map.put("backupEMailReal", userInfo.getBackupEMail());
                map.put("cellReal", userInfo.getNCell());
                map.put("emailReal", userInfo.getEmail());
                map.put("officePhoneReal", userInfo.getOfficePhone());
                map.put("homePhoneReal", userInfo.getHomePhone());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    @Override
    public void updatePersonMetaInfo(PortalContext ctx, HashMap map) throws PortalBizException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        PersonInfo info = ContextUtil.getCurrentUserInfo((Context)context).getPerson();
        try {
            if (info != null && info.getId() != null) {
                IPerson person = PersonFactory.getRemoteInstance();
                PersonInfo pInfo = person.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getId()));
                pInfo.setCell(map.get("cell").toString());
                pInfo.setBackupCell(map.get("backupCell").toString());
                pInfo.setEmail(map.get("email").toString());
                pInfo.setBackupEMail(map.get("backupEMail").toString());
                pInfo.setOfficePhone(map.get("officePhone").toString());
                pInfo.setHomePhone(map.get("homePhone").toString());
                person.update((IObjectPK)new ObjectUuidPK(pInfo.getId()), (CoreBaseInfo)pInfo);
            } else {
                IUser user = UserFactory.getRemoteInstance();
                UserInfo userinfo = user.getUserInfo(context.getCaller());
                userinfo.setCell(map.get("cell").toString());
                userinfo.setEmail(map.get("email").toString());
                userinfo.setBackupEMail(map.get("backupEMail").toString());
                userinfo.setOfficePhone(map.get("officePhone").toString());
                userinfo.setHomePhone(map.get("homePhone").toString());
                user.update((IObjectPK)new ObjectUuidPK(userinfo.getId()), (CoreBaseInfo)userinfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PortalBizException("error");
        }
    }

    @Override
    public int updatePersonMetaInfoNew(PortalContext ctx, HashMap map) throws PortalBizException {
        int flag = 0;
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        PersonInfo info = ContextUtil.getCurrentUserInfo((Context)context).getPerson();
        try {
            if (info != null && info.getId() != null) {
                IPerson person = PersonFactory.getRemoteInstance();
                PersonInfo pInfo = person.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getId()));
                pInfo.setNCell(map.get("cell").toString());
                pInfo.setCell("");
                pInfo.setBackupCell(map.get("backupCell").toString());
                pInfo.setEmail(map.get("email").toString());
                pInfo.setBackupEMail(map.get("backupEMail").toString());
                pInfo.setOfficePhone(map.get("officePhone").toString());
                pInfo.setHomePhone(map.get("homePhone").toString());
                pInfo.setGlobalRoaming(map.get("globalRoaming").toString());
                person.update((IObjectPK)new ObjectUuidPK(pInfo.getId()), (CoreBaseInfo)pInfo);
                try {
                    person.updateUserInfo(pInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    flag = 1;
                }
            } else {
                IUser user = UserFactory.getRemoteInstance();
                UserInfo userinfo = user.getUserInfo(context.getCaller());
                userinfo.setNCell(map.get("cell").toString());
                userinfo.setCell("");
                userinfo.setEmail(map.get("email").toString());
                userinfo.setBackupEMail(map.get("backupEMail").toString());
                userinfo.setOfficePhone(map.get("officePhone").toString());
                userinfo.setHomePhone(map.get("homePhone").toString());
                userinfo.setGlobalRoaming(map.get("globalRoaming").toString());
                user.update((IObjectPK)new ObjectUuidPK(userinfo.getId()), (CoreBaseInfo)userinfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PortalBizException("error");
        }
        return flag;
    }

    @Override
    public void updateLoginUserPWD(PortalContext portalContext, String oldPwd, String newPwd) throws PortalBizException {
        try {
            String userId = portalContext.getLoginUser().getId();
            if (oldPwd == null || newPwd == null) {
                throw new Exception("can not update password. old password or new password is null.");
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)userId));
            IUser user = UserFactory.getRemoteInstance();
            UserInfo userInfo = user.getUserByID((IObjectPK)pk);
            String enc_oldPwd = PermissionCommonUtil.encrypt((String)userInfo.getNumber(), (String)oldPwd);
            String enc_newPwd = PermissionCommonUtil.encrypt((String)userInfo.getNumber(), (String)newPwd);
            user.updatePass((IObjectPK)pk, enc_oldPwd, enc_newPwd);
        }
        catch (Exception ex) {
            if (ex instanceof PortalBizException) {
                throw (PortalBizException)ex;
            }
            if (ex instanceof UserException) {
                if (UserException.USER_IS_LOCKED_BY_UPDATEPW.getCode().equals(((UserException)ex).getSubCode()) || UserException.USER_IS_LOCKED.getCode().equals(((UserException)ex).getSubCode())) {
                    HashMap<String, Object> contextParams = new HashMap<String, Object>();
                    contextParams.put("errMsg", ex.getMessage());
                    contextParams.put("errDesc", ex.getMessage());
                    throw new PortalBizException("104", ex, contextParams);
                }
                HashMap<String, Object> contextParams = new HashMap<String, Object>();
                contextParams.put("errMsg", ex.getMessage());
                contextParams.put("errDesc", ex.getMessage());
                throw new PortalBizException("102", ex, contextParams);
            }
            HashMap<String, Object> contextParams = new HashMap<String, Object>();
            contextParams.put("errMsg", ex.getMessage());
            contextParams.put("errDesc", ex.getMessage());
            throw new PortalBizException("102", ex, contextParams);
        }
    }

    @Override
    public List<PortletDefinition> getPortletList(PortalContext ctx) throws PortalBizException {
        List<PortletDefinition> portletDefList = PortalServiceFacade.getPortletDefinitionServiceFacade().findPortletDefinitionList(ctx, "plt_widget", "EASPortlet", null);
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        ArrayList<PortletDefinition> list = new ArrayList<PortletDefinition>();
        try {
            IRowSet rs = this.queryPortlets(context);
            PortletDefinition define = null;
            while (rs.next()) {
                String pltId = rs.getString("id");
                if (this.isExisted4EasPortlet(pltId, portletDefList)) continue;
                define = new PortletDefinition();
                define.setDisplayName(rs.getString("portletname"));
                define.setId(pltId);
                define.setDescription(rs.getString("description"));
                define.setStatus(this.transStatus(rs.getInt("enable")));
                define.setKeywords(rs.getString("flag"));
                define.setThemeId(rs.getString("defurl"));
                define.setTmplId(rs.getString("insurl"));
                list.add(define);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return list;
    }

    private boolean isExisted4EasPortlet(String oldPltId, List<PortletDefinition> portletDefList) {
        if (portletDefList != null) {
            for (PortletDefinition portletDefinition : portletDefList) {
                String preferences = StringUtil.convNull((String)portletDefinition.getPreferences());
                if (preferences.indexOf(oldPltId) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private StatusEnum transStatus(int enable) {
        if (enable == 1) {
            return StatusEnum.ENABLE;
        }
        return StatusEnum.DISABLE;
    }

    private IRowSet queryPortlets(Context ctx) throws BOSException {
        Locale locale = ctx.getLocale();
        StringBuffer sb = new StringBuffer();
        sb.append("select p.fid id, p.fportletname_").append(locale).append(" portletname, p.fenable enable, p.fflag flag").append(", p.fdescription_").append(locale).append(" description").append(", pxt.fbizdefurl defurl, pxt.fbizinsurl insurl");
        sb.append(" from t_portal_portlet p ");
        sb.append(" left outer join t_portal_portletext pxt on p.fportletextid = pxt.fid ");
        sb.append(" where p.fenable != 3 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return rs;
    }

    @Override
    public String getOnlineServiceURL() throws PortalBizException {
        String onlineServiceUrl = KingdeeServiceUtil.getRealSitUrlFromServer();
        return onlineServiceUrl;
    }

    @Override
    public void deleteUserMonitor(PortalContext portalContext) throws PortalBizException {
        try {
            Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
            if (ctx != null) {
                String sessionId = ctx.getContextID();
                IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
                iUserMonitor.deleteSessionAndUserMonitorInfo(sessionId, null);
            } else {
                logger.error("easserviceimpl deleteUserMonitor ctx is null!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getCurrentPersonId(PortalContext ctx) {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
        if (userInfo.getPerson() != null) {
            return userInfo.getPerson().getId().toString();
        }
        return null;
    }

    @Override
    public void releaseNewContainerLicense(Context ctx, String uipk) {
        try {
            LicenseSrvAgentFactory.getRemoteInstance().releaseLicense(ctx.getContextID(), uipk);
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void releaseWebLicense(PortalContext ctx, String clientIP) {
        Context contex = (Context)ctx.getMetaInfo().get("eas_context");
        logger.debug("*********releaseWebLicense begin *********");
        logger.debug("*********contex is:" + (contex == null) + "*********");
        if (contex != null) {
            try {
                logger.debug("*********context id:" + contex.getContextID() + "*********");
                ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getRemoteInstance();
                if (iLicenseSrvAgent != null) {
                    logger.debug("**********iLicenseSrvAgent********");
                    iLicenseSrvAgent.releaseLicenseBySessionID(contex.getContextID());
                } else {
                    logger.debug("**********iLicenseSrvAgent is null ********");
                }
            }
            catch (LicenseException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deleteUserMonitorAllOtherPortalUser(PortalContext ctx, String clientIP, String sessionId) {
        Context contex = (Context)ctx.getMetaInfo().get("eas_context");
        String username = contex.getUserName();
        String dbcenter = contex.getAIS();
        try {
            List userList = UserMonitorFactory.getRemoteInstance().findUsers(dbcenter, username);
            if (userList == null || userList.isEmpty()) {
                return;
            }
            IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
            boolean needSendTickoutMessage = this.needSendTickoutMessage(contex);
            for (int i = 0; i < userList.size(); ++i) {
                String sessionID;
                UMRegistryInfo info = (UMRegistryInfo)userList.get(i);
                if (info.getId().equals(sessionId)) continue;
                if (needSendTickoutMessage) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String kickTime = sdf.format(new Date());
                    Map kickOutMap = this.getSouceInfo("kickOutMessage", clientIP, info.getClientIPAddress(), username, username, kickTime);
                    Map userNameMap = this.getSouceInfoBySet(username);
                    iUserMonitor.sendMessageToUser(info.getId(), userNameMap, kickOutMap, kickOutMap);
                }
                if ((sessionID = info.getId()) == null) {
                    sessionID = info.getGUIUserId();
                }
                try {
                    ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
                    agent.releaseLicenseBySessionID(sessionID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iUserMonitor.deleteSessionAndUserMonitorInfo(sessionID, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map getSouceInfo(String sourceName, String kickIp, String beKickIp, String kickUserName, String beKickUserName, String kickTime) {
        HashMap<Locale, String> sourceMap = new HashMap<Locale, String>();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocal = allLanguage[i].getLocale();
            String msgBody = StringUtils.cnulls((String)ResourceBase.getString((String)"com.kingdee.eas.base.usermonitor.UserMonitorCommonResource", (String)sourceName, (Locale)curLocal));
            String msg = msgBody.replaceAll("beKickUserName", beKickUserName).replaceAll("kickIp", kickIp).replaceAll("kickTime", kickTime).replaceAll("kickUserName", kickUserName);
            sourceMap.put(curLocal, msg);
        }
        return sourceMap;
    }

    private Map getSouceInfoBySet(String value) {
        HashMap<Locale, String> sourceMap = new HashMap<Locale, String>();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocal = allLanguage[i].getLocale();
            sourceMap.put(curLocal, StringUtils.cnulls((String)value));
        }
        return sourceMap;
    }

    @Override
    public List<UMRegistryInfo> findSameUsers(Context ctx) {
        List<Object> userList = new ArrayList<UMRegistryInfo>();
        try {
            logger.info("findSameUsers begin=====");
            List tempList = UserMonitorFactory.getLocalInstance((Context)ctx).findUsers(ctx.getAIS(), ctx.getUserName());
            logger.info("findSameUsers begin ===ctx.getAIS()==" + ctx.getAIS() + "==ctx.getUserName()=" + ctx.getUserName());
            if (tempList != null) {
                logger.info("findSameUsers begin tempList.size()=====" + tempList.size());
            }
            if (tempList != null && tempList.size() > 0) {
                userList = tempList;
                logger.info("findSameUsers begin userList.size()=====" + userList.size());
            }
        }
        catch (Exception e) {
            logger.error("login check error:", (Throwable)e);
        }
        return userList;
    }

    @Override
    public boolean findHaveSamePortalUser(Context ctx, String sessionId) {
        boolean haveSameUser = false;
        try {
            haveSameUser = UserMonitorFactory.getRemoteInstance().isSameNamePortalUserExists(ctx.getAIS(), ctx.getUserName(), sessionId);
        }
        catch (EASBizException e) {
            logger.error("login check error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("login check error:", (Throwable)e);
        }
        return haveSameUser;
    }

    @Override
    public boolean checkAllowUserRepeatLogin(Context ctx) {
        boolean allowRepeatLogin = true;
        try {
            UserInfo user = UserFactory.getRemoteInstance().getUserInfoByNumber(ctx.getUserName());
            if (user != null) {
                allowRepeatLogin = NotAllowRepeatLoginUserFactory.getRemoteInstance().isAllowRepeatLogin(user.getId().toString());
            }
        }
        catch (Exception e) {
            logger.error("login check error:", (Throwable)e);
        }
        return allowRepeatLogin;
    }

    @Override
    public boolean isAwokeAtUserReLogin(Context userCtx) {
        boolean flag = true;
        String paramkey = "isAwokeAtUserReLoginForPortal";
        try {
            String paravalue = ParamManager.getParamValue((Context)userCtx, null, (String)paramkey);
            flag = paravalue != null && "true".equalsIgnoreCase(paravalue);
        }
        catch (Exception e) {
            logger.error("login check error:", (Throwable)e);
        }
        return flag;
    }

    @Override
    public boolean isReachUserLimitCount(Context ctx) {
        boolean flag = true;
        try {
            flag = UserMonitorFactory.getLocalInstance((Context)ctx).isOverLicenseCount(ctx.getUserName(), ctx.getAIS(), ctx.getContextID());
        }
        catch (Exception e) {
            logger.error("isReachUserLimitCount error:", (Throwable)e);
        }
        return flag;
    }

    private boolean needSendTickoutMessage(Context ctx) {
        boolean flag = true;
        String paramkey = "needSendTickoutMessage";
        try {
            String paravalue = ParamManager.getParamValue((Context)ctx, null, (String)paramkey);
            flag = paravalue != null && "true".equalsIgnoreCase(paravalue);
        }
        catch (Exception e) {
            logger.error("needSendTickoutMessage error:", (Throwable)e);
        }
        return flag;
    }

    @Override
    public boolean passWillBeExpired(Context ctx) {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        return PermissionCommonUtil.passWillBeExpired((UserInfo)user);
    }

    @Override
    public String getExpireWarnMsg(Context ctx) {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        return PermissionCommonUtil.getExpireWarnMsg((UserInfo)user);
    }

    @Override
    public boolean isRequireChangePassword(Context ctx) {
        boolean isChgPass = false;
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String encryptPassword = (String)ctx.get((Object)"encryptPassword");
        if (encryptPassword != null) {
            UserInfo userInfoCopy = (UserInfo)user.clone();
            String plainPassword = null;
            try {
                plainPassword = CryptoTean.decrypt((String)user.getNumber(), (String)encryptPassword);
            }
            catch (CryptException e) {
                logger.error("password decrypt error:", (Throwable)e);
            }
            userInfoCopy.setPassword(plainPassword);
            isChgPass = SecurityValidator.isRequireChangePassword((UserInfo)userInfoCopy);
        }
        return isChgPass;
    }

    @Override
    public void updatePassword(Context ctx, String oldPassword, String newPassword) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getRemoteInstance();
        iUser.updatePass(ctx.getCaller(), oldPassword, newPassword);
        ctx.put((Object)"encryptPassword", (Object)newPassword);
    }

    @Override
    public String getSerialNum() {
        String serialNum = "unknow";
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            serialNum = baseInfo.getSerialNum();
        }
        catch (LicenseException e) {
            e.printStackTrace();
            logger.error("Can not get serial Num:", (Throwable)e);
        }
        return serialNum;
    }

    @Override
    public String getUserCodeByUserId(PortalContext ctx, String userId) throws BOSException {
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            StringBuilder sql = new StringBuilder();
            sql.append("select fnumber from t_pm_user where fid='" + userId + "'");
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)sql.toString());
            String userCode = "";
            if (rs != null && rs.size() > 0 && rs.next()) {
                userCode = rs.getString("fnumber");
            }
            return userCode;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5916\u90e8\u83dc\u5355\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BOSException("\u83b7\u53d6EAS\u83dc\u5355\u5931\u8d25\uff01");
        }
    }

    @Override
    public List<MenuItemInfo> getGuiListByIds(PortalContext ctx, List<String> ids, boolean isSys) throws PortalBizException {
        List<MenuItemInfo> list = null;
        try {
            IRowSet rs = this.getMenuItemByIds(ctx, ids, isSys);
            list = this.buildMenuItemList(rs);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5916\u90e8\u83dc\u5355\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            throw new PortalBizException("\u83b7\u53d6EAS\u83dc\u5355\u5931\u8d25\uff01");
        }
        return list;
    }

    private IRowSet getMenuItemByIds(PortalContext ctx, List<String> ids, boolean isSys) throws BOSException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        Locale locale = context.getLocale();
        StringBuilder sql = new StringBuilder();
        this.appendSelectPart(sql, locale.toString(), isSys);
        this.appendWhere(sql, ids);
        return DbUtil.executeQuery((Context)context, (String)sql.toString());
    }

    private void appendWhere(StringBuilder sql, List<String> ids) {
        sql.append(" where fid in(''");
        for (int i = 0; i < ids.size(); ++i) {
            sql.append(",'");
            sql.append(ids.get(i));
            sql.append("'");
        }
        sql.append(")");
    }

    @Override
    public List<GroupDTO> getAllOrgType(PortalContext ctx) {
        ArrayList<GroupDTO> orgTypeList = new ArrayList<GroupDTO>();
        Collection orgTypeInfoCol = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        Iterator it = orgTypeInfoCol.iterator();
        while (it.hasNext()) {
            GroupDTO gd = new GroupDTO();
            OrgTypeInfo orgTypeInfo = (OrgTypeInfo)it.next();
            gd.setLevel(orgTypeInfo.getOrgType().getValue());
            gd.setName(orgTypeInfo.getOrgType().toString());
            orgTypeList.add(gd);
        }
        return orgTypeList;
    }

    @Override
    public List<GroupDTO> getPagingSwitchOrgList(PortalContext ctx, Object coll, PagingParam param, String inputValue) throws PortalBizException {
        FullOrgUnitCollection fullCol = (FullOrgUnitCollection)coll;
        int size = fullCol.size();
        int start = param.getStartIndex();
        int end = start + param.getPageSize();
        if (!StringUtil.isEmpty((String)inputValue)) {
            end = size;
        }
        String id = "";
        StringBuffer numberBuffer = null;
        StringBuffer nameBuffer = new StringBuffer();
        String code = "";
        String Longnumber = "";
        String displayName = "";
        String snumber = "";
        FullOrgUnitInfo info = null;
        ArrayList<GroupDTO> groupList = new ArrayList<GroupDTO>();
        GroupDTO group = null;
        for (int i = start; i < size && i < end; ++i) {
            String lc_inputValue;
            info = fullCol.get(i);
            snumber = info.getNumber();
            displayName = StringUtils.cnulls((String)info.getName());
            String lc_snumber = snumber.toLowerCase();
            String lc_displayName = displayName.toLowerCase();
            if (!StringUtil.isEmpty((String)inputValue) && lc_snumber.indexOf(lc_inputValue = inputValue.toLowerCase()) < 0 && lc_displayName.indexOf(lc_inputValue) < 0) continue;
            id = info.getId() != null ? info.getId().toString() : "";
            Longnumber = info.getLongNumber();
            int num = 0;
            while (Longnumber.indexOf("!") > 0) {
                ++num;
                Longnumber = Longnumber.substring(Longnumber.indexOf("!") + 1, Longnumber.length());
            }
            numberBuffer = new StringBuffer();
            nameBuffer = new StringBuffer();
            while (num > 0) {
                numberBuffer.append("&nbsp;&nbsp;&nbsp;");
                nameBuffer.append("&nbsp;&nbsp;&nbsp;");
                --num;
            }
            numberBuffer.append(info.getNumber());
            nameBuffer.append(displayName);
            code = info.getCode();
            if (StringUtils.isEmpty((String)code)) {
                code = "&nbsp";
            }
            group = new GroupDTO();
            group.setId(id);
            group.setNumber(numberBuffer.toString());
            group.setName(nameBuffer.toString());
            group.setCode(code);
            groupList.add(group);
        }
        return groupList;
    }

    @Override
    public int checkPortalLicense(Context ctx) throws PortalBizException {
        int licenseFlag = 4;
        try {
            LicenseUserInfo licenseUserInfo = EASWebLicenceHelper.createLicenseUserInfo(ctx.getClientHostIP(), ctx);
            licenseFlag = LicenseSrvAgentFactory.getRemoteInstance().requestLicenseOnInvalid(licenseUserInfo, "com.kingdee.eas.portal.web.action.PortalAction");
        }
        catch (Exception e) {
            logger.error("Portal checkPortalLicense errpr===", (Throwable)e);
        }
        return licenseFlag;
    }

    @Override
    public List<String> getFullOrgIds(PortalContext ctx, String longNumber, boolean isShowSealedUp) throws PortalBizException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MetaDataPK queryPK = null;
            queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app", "NewOrgF74BaseUnitQuery");
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            EntityViewInfo viewInfo = this.getEntityViewExceptTreeFilter(ctx, "0", longNumber, isShowSealedUp);
            exec.setObjectView(viewInfo);
            IRowSet rowSet = exec.executeQuery();
            while (rowSet.next()) {
                list.add(rowSet.getString("id"));
            }
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return list;
    }

    protected FilterItemInfo getSealUpOrgFilter(Context context, String orgType, String prefix) {
        try {
            INewOrgF7Facade ifacade = NewOrgF7FacadeFactory.getLocalInstance((Context)context);
            OrgViewType orgViewType = OrgViewType.getInstance((String)"", (int)Integer.parseInt(orgType), null, null);
            if ("0".equals(orgType) || "10".equals(orgType)) {
                return new FilterItemInfo(prefix + "isOUSealUp", (Object)0, CompareType.EQUALS);
            }
            if (orgViewType != OrgViewType.UNIONDEBT) {
                String tableName = ifacade.getTableNameByOrgTypeView(orgViewType);
                if (StringUtils.isEmpty((String)tableName)) {
                    return null;
                }
                String sql = "select funitid from " + tableName + " where FIsSealUp = 0";
                return new FilterItemInfo(prefix + "id", (Object)sql, CompareType.INNER);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean isStartSHR(Context ctx) throws PortalBizException {
        String sql = "select 1 from t_org_admin where fisstartshr= 1";
        try {
            IRowSet rs = DbUtil.executeQueryNoTx((Context)ctx, (String)sql);
            if (rs.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isExpiredPassCanChg(Context ctx) {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user == null) {
            return false;
        }
        SecurityInfo security = user.getSecurity();
        if (security == null) {
            return false;
        }
        return security.isExpiredPassCanChg();
    }

    @Override
    public boolean isPassExpired(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo == null) {
            return false;
        }
        return PermissionCommonUtil.isPassExpired((UserInfo)userInfo);
    }

    @Override
    public boolean isAdminLoginByLoginNumber(Context userCtx) {
        boolean flag = false;
        String paramkey = "AdminLoginByLoginNumber";
        String paravalue = "";
        try {
            paravalue = ParamManager.getParamValue((Context)userCtx, null, (String)paramkey);
            flag = paravalue != null && "true".equalsIgnoreCase(paravalue);
        }
        catch (Exception e) {
            logger.error("login check error:", (Throwable)e);
        }
        return flag;
    }

    @Override
    public String getOrgDefault(PortalContext ctx) throws PortalBizException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        try {
            UserInfo userInfo = UserFactory.getLocalInstance((Context)context).getUserInfo(context.getCaller());
            if (userInfo.getDefOrgUnit() != null && userInfo.getDefOrgUnit().getId() != null) {
                FullOrgUnitInfo OrgDefaultName = null;
                OrgDefaultName = FullOrgUnitFactory.getLocalInstance((Context)context).getFullOrgUnitInfo("select name where id = '" + userInfo.getDefOrgUnit().getId() + "'");
                return OrgDefaultName.getName(context.getLocale());
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        return null;
    }
}

