/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.facade.eas.perm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.perm.dto.GroupDTO;
import com.kingdee.portal.biz.module.perm.service.GroupService;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EASOrgServiceImpl
implements GroupService {
    private static final Logger logger = LoggerFactory.getLogger(EASOrgServiceImpl.class);

    @Override
    public List<GroupDTO> findGroupListByParentId(PortalContext ctx, String parentId) throws PortalBizException {
        try {
            EntityViewInfo viewInfo = this.getDefaultEntityViewInfo(parentId);
            return this.innerGetOrgList(ctx, viewInfo);
        }
        catch (BOSException e) {
            logger.error("\u83b7\u53d6EAS\u7ec4\u7ec7\u6570\u636e\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            throw new PortalBizException("\u83b7\u53d6EAS\u7528\u6237\u6570\u636e\u5f02\u5e38");
        }
    }

    private EntityViewInfo getDefaultEntityViewInfo(String parentId) {
        return this.getEntityViewInfo(this.getDefaultFilter(parentId));
    }

    private FilterInfo getDefaultFilter(String parentId) {
        FilterInfo filter = new FilterInfo();
        if (StringUtil.isEmpty((String)parentId)) {
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)1, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentId, CompareType.EQUALS));
        }
        return filter;
    }

    private EntityViewInfo getEntityViewInfo(FilterInfo filter) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("displayName"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("parent.id"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        viewInfo.getSorter().add(new SorterItemInfo("name"));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private List<GroupDTO> innerGetOrgList(PortalContext ctx, EntityViewInfo viewInfo) throws BOSException {
        AdminOrgUnitCollection adminOrgColl = this.getAdminOrgColl(viewInfo);
        return this.buildAdminOrgList(ctx, adminOrgColl);
    }

    private AdminOrgUnitCollection getAdminOrgColl(EntityViewInfo viewInfo) throws BOSException {
        IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("longNumber");
        sorterItem.setSortType(SortType.ASCEND);
        sorter.add(sorterItem);
        viewInfo.setSorter(sorter);
        return adminOrgUnit.getAdminOrgUnitCollection(viewInfo);
    }

    private List<GroupDTO> buildAdminOrgList(PortalContext ctx, AdminOrgUnitCollection adminOrgColl) {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        Locale local = context.getLocale();
        ArrayList<GroupDTO> orgList = new ArrayList<GroupDTO>();
        GroupDTO org = null;
        for (AdminOrgUnitInfo adminOrgUnitInfo : adminOrgColl) {
            if (adminOrgUnitInfo == null) continue;
            org = new GroupDTO();
            org.setId(adminOrgUnitInfo.getId().toString());
            org.setName(adminOrgUnitInfo.getName(local));
            if (adminOrgUnitInfo.getParent() != null) {
                org.setParentId(adminOrgUnitInfo.getParent().getId().toString());
            }
            org.setLevel(adminOrgUnitInfo.getLevel());
            org.setLongNumber(adminOrgUnitInfo.getLongNumber());
            org.setLeaf(adminOrgUnitInfo.isIsLeaf());
            org.setDesc(adminOrgUnitInfo.getDisplayName(local));
            org.setNumber(adminOrgUnitInfo.getNumber());
            orgList.add(org);
        }
        return orgList;
    }

    @Override
    public List<GroupDTO> searchGroupListByName(PortalContext ctx, String name) throws PortalBizException {
        try {
            EntityViewInfo viewInfo = this.getSearchEntityViewInfo(name);
            return this.innerGetOrgList(ctx, viewInfo);
        }
        catch (BOSException e) {
            logger.error("\u83b7\u53d6EAS\u7ec4\u7ec7\u6570\u636e\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            throw new PortalBizException("\u83b7\u53d6EAS\u7528\u6237\u6570\u636e\u5f02\u5e38");
        }
    }

    private EntityViewInfo getSearchEntityViewInfo(String name) {
        EntityViewInfo viewInfo = this.getEntityViewInfo(this.getSearchFilter(name));
        viewInfo.setTopCount(20);
        return viewInfo;
    }

    private FilterInfo getSearchFilter(String name) {
        FilterInfo filter = new FilterInfo();
        if (!StringUtil.isEmpty((String)name)) {
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + name + "%"), CompareType.LIKE));
        }
        return filter;
    }

    @Override
    public List<GroupDTO> findGroupListByIds(PortalContext ctx, String[] groupIds) throws PortalBizException {
        try {
            return this.innerGetOrgList(ctx, this.getEntityViewInfoByIds(groupIds));
        }
        catch (BOSException e) {
            logger.error("\u83b7\u53d6EAS\u7ec4\u7ec7\u6570\u636e\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            throw new PortalBizException("\u83b7\u53d6EAS\u7528\u6237\u6570\u636e\u5f02\u5e38");
        }
    }

    private EntityViewInfo getEntityViewInfoByIds(String[] groupIds) {
        return this.getEntityViewInfo(this.getFilterByIds(groupIds));
    }

    private FilterInfo getFilterByIds(String[] groupIds) {
        String ids = StringUtils.arrayToString((Object[])groupIds, (String)",");
        FilterInfo filter = new FilterInfo();
        if (groupIds != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        }
        return filter;
    }

    @Override
    public IRowSet findOrgIdByUserId(PortalContext potalctx, String userId, String ftype) throws PortalBizException {
        Context context = (Context)potalctx.getMetaInfo().get("eas_context");
        StringBuilder permSql = new StringBuilder();
        try {
            String dbType = (String)context.get((Object)"dbType");
            if ("Oracle".equals(dbType)) {
                permSql.append("/*dialect*/ SELECT /*+ ordered use_nl(ORGLIST ORGBASE) */ DISTINCT fid ").append("FROM (SELECT /*+ ordered use_nl(RANGE ORG) index(ORG IX_ORG_BASE_FLNUM) */ ").append(" forgid, flongnumber FROM t_pm_orgrange RANGE, t_org_baseunit ORG ").append("WHERE (fuserid ='").append(userId).append("' and ftype=20 ) AND org.fid = range.forgid)  ORGLIST,t_org_baseunit ORGBASE ").append("where orgbase.flongnumber like  orglist.flongnumber || '%'");
            } else if ("MS SQL Server".equals(dbType)) {
                permSql.append("/*dialect*/ select distinct fid from t_org_baseunit as orgbase,").append("(select forgid,flongnumber from t_pm_orgrange as range ").append("join t_org_baseunit org on org.fid = range.forgid ").append("where fuserid='").append(userId).append("' and ftype=20 ) as orglist ").append("where orgbase.flongnumber like  orglist.flongnumber + '%'");
            } else {
                permSql.append("select distinct fid from t_org_baseunit as orgbase,").append("(select forgid,flongnumber from t_pm_orgrange as range ").append("join t_org_baseunit org on org.fid = range.forgid ").append("where fuserid='").append(userId).append("' and ftype=20 ) as orglist ").append("where  CHARINDEX(orglist.flongnumber,orgbase.flongnumber)=1");
            }
            logger.error("permSql.toString()==============" + permSql.toString());
            return DbUtil.executeQuery((Context)context, (String)permSql.toString());
        }
        catch (BOSException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public List<String> findOrgIdsByUserId(PortalContext ctx, String userId, String ftype) throws PortalBizException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        try {
            StringBuilder permSql = new StringBuilder();
            permSql.append("select forgid,flongnumber from t_pm_orgrange as range ").append("join t_org_baseunit org on org.fid = range.forgid ").append("where fuserid='").append(userId).append("' and ftype=20 ");
            IRowSet permRs = DbUtil.executeQuery((Context)context, (String)permSql.toString());
            String sql = "select fid,flongnumber from t_org_baseunit";
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)sql);
            ArrayList<String> orgIds = new ArrayList<String>();
            if (permRs != null && rs != null) {
                block3: while (permRs.next()) {
                    String pstr = permRs.getString("flongnumber");
                    while (rs.next()) {
                        String str = rs.getString("flongnumber");
                        if (str.length() < pstr.length() || !pstr.equals(str.substring(0, pstr.length()))) continue;
                        orgIds.add(rs.getString("fid"));
                        continue block3;
                    }
                }
            }
            return orgIds;
        }
        catch (BOSException e) {
            throw new PortalBizException("300", e);
        }
        catch (SQLException se) {
            logger.error("Get Org Error===", (Throwable)se);
            throw new PortalBizException("300", se);
        }
    }

    @Override
    public Map<String, String> matchSelectAndSaveOrg(PortalContext ctx, String selectIds, String saveIds) throws PortalBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String permIds = "";
            String delIds = "";
            logger.error("matchSelectAndSaveOrg===");
            logger.error("selectIds===" + selectIds);
            List<GroupDTO> secList = this.findGroupListByIds(ctx, selectIds.split(","));
            logger.error("secList.size()===" + secList.size());
            ArrayList<GroupDTO> addList = new ArrayList<GroupDTO>();
            String addIds = "";
            if (secList != null && secList.size() > 0) {
                for (int i = 0; i < secList.size(); ++i) {
                    GroupDTO gd = secList.get(i);
                    boolean isExit = false;
                    for (int j = 0; j < i + 1; ++j) {
                        if (gd.getLongNumber().indexOf(secList.get(j).getLongNumber() + "!") <= -1) continue;
                        isExit = true;
                        break;
                    }
                    if (isExit) continue;
                    addList.add(gd);
                    addIds = addIds + gd.getId() + ",";
                }
                if (saveIds == null) {
                    logger.error("saveIds==null===");
                    permIds = addIds;
                } else {
                    logger.error("saveIds!=null===" + saveIds);
                    List<GroupDTO> saveList = this.findGroupListByIds(ctx, saveIds.split(","));
                    if (saveList != null) {
                        logger.error("saveList.size()======" + saveList.size());
                        for (GroupDTO secOrg : addList) {
                            logger.error("secList.size()======" + addList.size());
                            boolean bl = false;
                            for (GroupDTO saveOrg : saveList) {
                                logger.error("secOrg.getLongNumber()=====" + secOrg.getLongNumber());
                                logger.error("saveOrg.getNumber()=====" + saveOrg.getNumber());
                                logger.error("saveOrg.getLongNumber()=====" + saveOrg.getLongNumber());
                                logger.error("secOrg.getLongNumber().indexOf(saveOrg.getNumber()!)=====" + secOrg.getLongNumber().indexOf(saveOrg.getNumber() + "!"));
                                if (secOrg.getId().equals(saveOrg.getId()) || secOrg.getLongNumber().indexOf(saveOrg.getNumber() + "!") > -1) {
                                    bl = true;
                                    break;
                                }
                                if (saveOrg.getLongNumber().indexOf(secOrg.getNumber() + "!") <= -1) continue;
                                delIds = delIds + saveOrg.getId() + ",";
                                if (permIds.indexOf(secOrg.getId()) < 0) {
                                    permIds = permIds + secOrg.getId() + ",";
                                }
                                bl = true;
                            }
                            if (bl) continue;
                            permIds = permIds + secOrg.getId() + ",";
                        }
                    }
                }
            }
            map.put("permIds", permIds);
            map.put("delIds", delIds);
        }
        catch (PortalBizException e) {
            throw new PortalBizException("300", e);
        }
        return map;
    }

    @Override
    public IRowSet findPermIdByUserId(PortalContext potalctx, String userId, String ftype) throws PortalBizException {
        Context context = (Context)potalctx.getMetaInfo().get("eas_context");
        StringBuilder permSql = new StringBuilder();
        try {
            String curCompanyId;
            permSql.append("select FResType,FResId,FPermType,FPermId,FPermInfo from ").append("(select PERM.*,ORG.fnumber from T_JP_PermRefRes PERM,t_org_baseunit ORG ").append("where PERM.FPermType='GROUP' and PERM.FPermId=ORG.fid) REFRES,").append("(SELECT forgid, fnumber FROM t_pm_orgrange RANGE, t_org_baseunit ORG ").append("WHERE (RANGE.fuserid ='").append(userId).append("' and RANGE.ftype=20  AND org.fid = range.forgid)) ORGLIST ").append("where  CHARINDEX(REFRES.fnumber,ORGLIST.fnumber)=1").append(" union all ").append("select FResType,FResId,FPermType,FPermId,FPermInfo from T_JP_PermRefRes ").append("where FPermId = 'da276ac7-95b4-46a6-b6dd-737a2373b7e9' or (FPermType='USER' and FPermId='").append(userId).append("') ").append(" union all ").append("select FResType,FResId,FPermType,FPermId,FPermInfo from T_JP_PermRefRes REFRES,").append("T_JP_PermRefRoleUser ROLEUSER where REFRES.FPermType='ROLE' and ").append("REFRES.FPermId=ROLEUSER.FRoleId and ROLEUSER.FUserId='").append(userId).append("' ").append(" union all ").append("select FResType,FResId,FPermType,FPermId,FPermInfo from T_JP_PermRefRes REFRES,").append("(select RGROUP.FRoleId,RGROUP.FGroupId,ORG.fnumber from T_JP_PermRefRoleGroup RGROUP,").append("t_org_baseunit ORG where RGROUP.FGroupId=ORG.fid) ORGBASE,").append("(SELECT DISTINCT forgid, fnumber FROM t_pm_orgrange RANGE,t_org_baseunit ORG").append(" WHERE (RANGE.fuserid ='").append(userId).append("' ").append("and RANGE.ftype=20  AND org.fid = range.forgid))  ORGLIST ").append("where  CHARINDEX(ORGBASE.fnumber,ORGLIST.fnumber)=1 ").append("and REFRES.FPermId=ORGBASE.FRoleId");
            if (context.get((Object)"CurCompanyId") != null && !StringUtil.isEmpty((String)(curCompanyId = context.get((Object)"CurCompanyId").toString()))) {
                permSql.append(" union all ").append("select FResType,FResId,FPermType,FPermId,FPermInfo from T_JP_PermRefRes where FPermId in (select FROLEID from t_pm_userroleorg where FUSERID = '").append(userId).append("' ").append("and FORGID = '").append(curCompanyId).append("') and FPermType = 'EAS_ROLE'");
            }
            return DbUtil.executeQuery((Context)context, (String)permSql.toString());
        }
        catch (BOSException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public IRowSet findPermIdByUserIdNoLicense(PortalContext potalctx, String userId, String ftype) throws PortalBizException {
        return null;
    }
}

