/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.facade.eas.perm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.perm.dto.UserDTO;
import com.kingdee.portal.biz.module.perm.service.UserService;
import com.kingdee.portal.common.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EASUserServiceImpl
implements UserService {
    private static final Logger logger = LoggerFactory.getLogger(EASUserServiceImpl.class);

    @Override
    public PagingResult<UserDTO> findUserList(PortalContext ctx, PagingParam pagingParam, UserDTO searchFilter) throws PortalBizException {
        try {
            return this.getPagingUserList(ctx, pagingParam, searchFilter);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6EAS\u7528\u6237\u6570\u636e\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            throw new PortalBizException("\u83b7\u53d6EAS\u7528\u6237\u6570\u636e\u5f02\u5e38");
        }
    }

    private PagingResult<UserDTO> getPagingUserList(PortalContext ctx, PagingParam pagingParam, UserDTO searchFilter) throws BOSException, SQLException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        int total = this.getUserListCount(context, searchFilter);
        List<UserDTO> users = this.getUserList(context, searchFilter, pagingParam);
        return new PagingResult<UserDTO>(pagingParam, total, users);
    }

    private int getUserListCount(Context context, UserDTO searchFilter) throws BOSException, SQLException {
        String lan = context.getLocale().toString();
        IRowSet countSet = DbUtil.executeQuery((Context)context, (String)this.buildCountUserQuerySql(lan, searchFilter, context));
        if (countSet.next()) {
            return countSet.getInt(1);
        }
        return 0;
    }

    private List<UserDTO> getUserList(Context context, UserDTO searchFilter, PagingParam pagingParam) throws SQLException, BOSException {
        String lan = context.getLocale().toString();
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)this.buildUserQuerySql(lan, searchFilter, context), (int)pagingParam.getStartIndex(), (int)pagingParam.getPageSize());
        return this.buildResultByUserRowSet(context, rowSet);
    }

    private List<UserDTO> buildResultByUserRowSet(Context context, IRowSet rowSet) throws SQLException, BOSException {
        logger.error("buildResultByUserRowSet====begin=========");
        ArrayList<UserDTO> list = new ArrayList<UserDTO>();
        StringBuilder userIdStr = new StringBuilder();
        UserDTO user = null;
        String userId = "";
        while (rowSet.next()) {
            userId = rowSet.getString(1);
            user = new UserDTO();
            user.setId(userId);
            user.setNumber(rowSet.getString(2));
            user.setName(rowSet.getString(3));
            list.add(user);
            userIdStr.append("'").append(userId).append("',");
        }
        logger.error("buildResultByUserRowSet====rowSet=========");
        String ids = "";
        int len = userIdStr.length();
        if (len > 0) {
            ids = userIdStr.substring(0, len - 1);
        }
        Map<String, String> adminOrgNameMap = this.getAdminOrgByUserIds(context, ids);
        logger.error("buildResultByUserRowSet====adminOrgNameMap=========", adminOrgNameMap);
        Map<String, String> positionNameMap = this.getPositionNameByUserIds(context, ids);
        logger.error("buildResultByUserRowSet====positionNameMap=========", positionNameMap);
        for (UserDTO dto : list) {
            dto.setOrgName(adminOrgNameMap.get(dto.getId()));
            dto.setPosition(positionNameMap.get(dto.getId()));
        }
        return list;
    }

    private Map<String, String> getAdminOrgByUserIds(Context context, String userIdStr) throws BOSException, SQLException {
        StringBuilder adminSql = new StringBuilder();
        adminSql.append("select u.fid, org.fname_").append(context.getLocale().toString()).append(" from t_pm_orgrange range").append(" join t_org_admin org on org.fid = range.forgid ").append(" join t_pm_user u on u.fid = range.fuserid ").append(" where range.ftype=20 and range.fuserid in (").append(userIdStr).append(") ");
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)adminSql.toString());
        logger.error("getAdminOrgByUserIds====positionNameMap=========" + adminSql);
        HashMap<String, String> adminOrgMap = new HashMap<String, String>();
        String userId = "";
        String adminName = "";
        while (rowSet.next()) {
            userId = rowSet.getString(1);
            adminName = (String)adminOrgMap.get(userId);
            if (adminName == null) {
                adminOrgMap.put(userId, rowSet.getString(2));
                continue;
            }
            adminName = adminName + "," + rowSet.getString(2);
            adminOrgMap.put(userId, adminName);
        }
        return adminOrgMap;
    }

    private Map<String, String> getPositionNameByUserIds(Context context, String userIdStr) throws BOSException, SQLException {
        StringBuilder positionSql = new StringBuilder();
        positionSql.append("select u.fid, po.fname_").append(context.getLocale().toString()).append(" from t_pm_user u").append(" join t_org_positionmember m on u.fpersonid=m.fpersonid ").append(" join t_org_position po on po.fid=m.fpositionid ").append(" where u.fid in (").append(userIdStr).append(") ");
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)positionSql.toString());
        HashMap<String, String> positionNameMap = new HashMap<String, String>();
        String userId = "";
        String position = "";
        while (rowSet.next()) {
            userId = rowSet.getString(1);
            position = (String)positionNameMap.get(userId);
            if (position == null) {
                positionNameMap.put(userId, rowSet.getString(2));
                continue;
            }
            position = position + "," + rowSet.getString(2);
            positionNameMap.put(userId, position);
        }
        return positionNameMap;
    }

    private String buildCountUserQuerySql(String lan, UserDTO searchFilter, Context context) {
        StringBuilder querySql = new StringBuilder();
        this.appendCountSelect(querySql);
        this.appendFrom(querySql);
        this.appendWhere(querySql, lan, searchFilter, context);
        return querySql.toString();
    }

    private void appendCountSelect(StringBuilder baseSql) {
        baseSql.append("select count(distinct u.FID) ");
    }

    private void appendFrom(StringBuilder baseSql) {
        baseSql.append(" from t_pm_user u,t_pm_orgrange r,t_org_admin a where 1=1 and u.fid = r.fuserid and a.fid = r.forgid and u.fforbidden = 0 ");
    }

    private void appendWhere(StringBuilder querySql, String lan, UserDTO searchFilter, Context context) {
        String searchWords = searchFilter.getName();
        String adminOrgId = searchFilter.getAdminOrgId();
        if (!StringUtil.isEmpty((String)searchWords)) {
            querySql.append(" and ");
            searchWords = searchWords.replace("'", "''");
            querySql.append(" (u.fnumber like '%");
            querySql.append(searchWords);
            querySql.append("%'");
            querySql.append(" or u.fname_" + lan + " like '%");
            querySql.append(searchWords);
            querySql.append("%')");
        }
        if (!StringUtil.isEmpty((String)adminOrgId) && StringUtil.isEmpty((String)searchWords)) {
            try {
                AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)context).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId));
                if (adminInfo != null) {
                    if (searchFilter.isShowSub()) {
                        querySql.append(" and (r.forgid = '" + adminOrgId + "'");
                        querySql.append(" or (a.flongnumber like '" + adminInfo.getLongNumber() + "!%'))");
                    } else {
                        querySql.append(" and r.forgid = '" + adminOrgId + "'");
                    }
                    if (!searchFilter.isShowAllOrg()) {
                        querySql.append(" and a.FControlUnitID = '" + adminInfo.getCU().getId().toString() + "'");
                    }
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private String getIncludeStr(String[] inArr) {
        String inStr = "";
        int j = inArr.length;
        for (int i = 0; i < j; ++i) {
            inStr = inStr + "'" + inArr[i] + "',";
        }
        inStr = inStr.length() > 0 ? inStr.substring(0, inStr.length() - 1) : "''";
        return inStr;
    }

    private String buildUserQuerySql(String lan, UserDTO searchFilter, Context context) {
        StringBuilder querySql = new StringBuilder();
        this.appendSelect(querySql, lan);
        this.appendFrom(querySql);
        this.appendWhere(querySql, lan, searchFilter, context);
        this.appendOrder(querySql);
        return querySql.toString();
    }

    private void appendSelect(StringBuilder baseSql, String lan) {
        baseSql.append(" select distinct u.fid, u.fnumber, u.fname_").append(lan);
    }

    private void appendUserNumberFilter(StringBuilder where, String number) {
        if (StringUtil.isEmpty((String)number)) {
            return;
        }
        where.append(" and ");
        number = number.replace("'", "''");
        where.append(" u.fnumber like '%");
        where.append(number);
        where.append("%'");
    }

    private void appendUserNameFilter(StringBuilder where, String name, String lan) {
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        where.append(" and ");
        name = name.replace("'", "''");
        where.append(" u.fname_").append(lan).append(" like '%");
        where.append(name);
        where.append("%'");
    }

    private void appendOrder(StringBuilder querySql) {
        querySql.append(" order by u.fnumber");
    }

    @Override
    public List<UserDTO> findUserListByIds(PortalContext ctx, String[] userIds) throws PortalBizException {
        try {
            logger.error("findUserListByIds====userids=========", (Object[])userIds);
            return this.innerGetUserListByIds(ctx, userIds);
        }
        catch (Exception e) {
            throw new PortalBizException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u51fa\u9519");
        }
    }

    private List<UserDTO> innerGetUserListByIds(PortalContext ctx, String[] userIds) throws BOSException, SQLException {
        logger.error("innerGetUserListByIds====begin=========");
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        logger.error("innerGetUserListByIds====context=========", (Object)context);
        String sql = this.getQuerySqlByIds(context.getLocale().toString(), userIds);
        logger.error("innerGetUserListByIds====sql=========", (Object)sql);
        if (StringUtil.isEmpty((String)sql)) {
            return new ArrayList<UserDTO>();
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)sql);
        logger.error("innerGetUserListByIds====rowSet=========", (Object)rowSet);
        return this.buildResultByUserRowSet(context, rowSet);
    }

    private String getQuerySqlByIds(String lan, String[] userIds) {
        String ids = this.getIdStr(userIds);
        if (StringUtil.isEmpty((String)ids)) {
            return null;
        }
        StringBuilder querySql = new StringBuilder();
        this.appendSelect(querySql, lan);
        this.appendFrom(querySql);
        querySql.append(" and u.fid in (").append(ids).append(")");
        querySql.append(" order by u.fname_").append(lan);
        return querySql.toString();
    }

    private String getIdStr(String[] userIds) {
        StringBuilder sql = new StringBuilder();
        for (String id : userIds) {
            if (StringUtil.isEmpty((String)id)) continue;
            sql.append(",'").append(id).append("'");
        }
        if (sql.length() > 0) {
            return sql.substring(1, sql.length());
        }
        return null;
    }
}

