/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.facade.eas.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.form.extend.flow.ITemplate;
import com.kingdee.eas.base.form.extend.flow.ITemplateType;
import com.kingdee.eas.base.form.extend.flow.TemplateCollection;
import com.kingdee.eas.base.form.extend.flow.TemplateFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.extend.flow.TemplateTypeCollection;
import com.kingdee.eas.base.form.extend.flow.TemplateTypeFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DataTools {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.portal.biz.facade.eas.util.DataTools");
    private static final String CUID = "eThjryu4wEKoEK1veu3ZzDUlqpQ=";
    public static final String WFM_MODLE_NAME = "com.kingdee.eas.cp.wfm";
    public static final String DOM_MODLE_NAME = "com.kingdee.eas.cp.odm";
    public static final String DOCRECEIVE_TEMPLATEID = "tqAoxLV0TguihBZ6eqU8bZp+rpI=";
    public static final String DOCDISPATCH_TEMPLATEID = "C/T4g3UCStmKrMRuH4ErO5p+rpI=";

    public static IRowSet getAllTemplate(Context ctx) throws BOSException {
        return DataTools.getAllTemplate(ctx, null);
    }

    public static IRowSet getAllTemplate(Context ctx, String selectCondition) throws BOSException {
        Object[] params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()};
        StringBuffer buff = new StringBuffer();
        buff.append("select fid,FName_").append(ctx.getLocale().toString());
        buff.append(" fname,fnumber,fformHeight,fformWidth,fformID,FControlUnitID,FTemplateTypeID,FUsedState ").append("\r\n");
        buff.append("from T_BAS_Template ").append("\r\n");
        buff.append("where FUsedState=2 ");
        if (selectCondition != null && selectCondition.length() > 0) {
            buff.append(selectCondition).append(" ");
        }
        buff.append(" order by fnumber asc ").append("\r\n");
        return DbUtil.executeQuery((Context)ctx, (String)buff.toString());
    }

    public static IRowSet getAllTemplate(Context ctx, String[] menuItemLongNumberColl, String[] menuItemIdColl) throws BOSException {
        Object[] params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()};
        StringBuffer buff = new StringBuffer();
        buff.append("select fid,FName_").append(ctx.getLocale().toString());
        buff.append(" fname,fnumber,fformHeight,fformWidth,fformID,FControlUnitID,FTemplateTypeID,FUsedState ").append("\r\n");
        buff.append("from T_BAS_Template ").append("\r\n");
        buff.append("'where FUsedState=2");
        if (menuItemIdColl != null && menuItemIdColl.length > 0) {
            buff.append(" and( fid in ('").append(StringUtils.arrayToString((Object[])menuItemIdColl, (String)"','")).append("')");
        }
        if (menuItemLongNumberColl != null && menuItemLongNumberColl.length > 0) {
            buff.append(" or fid in ('").append(StringUtils.arrayToString((Object[])menuItemLongNumberColl, (String)"','")).append("')");
            for (String longNumber : menuItemLongNumberColl) {
                buff.append(" or fid like '").append(longNumber).append("!%'");
            }
        }
        buff.append(") order by fnumber asc ").append("\r\n");
        return DbUtil.executeQuery((Context)ctx, (String)buff.toString());
    }

    public static String getTemplateUrlByFormIdAndTempId(String formID, String tempID) {
        return "/easweb/servlet/BillServlet?formID=" + URLEncoder.encode(formID) + "&flowTempId=" + URLEncoder.encode(tempID) + "&WFMID=KingdeeEasCpWorkFlowManagementSystemBill";
    }

    public static IRowSet getAllTemplateType(Context ctx, String selectCondition) throws BOSException {
        Object[] params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()};
        StringBuffer buff = new StringBuffer();
        buff.append("select fid,FName_").append(ctx.getLocale().toString());
        buff.append(" fname,fnumber,FControlUnitID,FUsedState ").append("\r\n");
        buff.append("from t_bas_templatetype ").append("\r\n");
        buff.append("where FUsedState=1 ");
        if (selectCondition != null && selectCondition.length() > 0) {
            buff.append(selectCondition).append(" ");
        }
        buff.append(" order by fnumber asc ").append("\r\n");
        return DbUtil.executeQuery((Context)ctx, (String)buff.toString());
    }

    public static IRowSet getHasPermissionTemplate(Context ctx, String moduleName) throws Exception {
        String perId;
        long start = System.currentTimeMillis();
        Object[] params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()};
        StringBuffer buff = new StringBuffer();
        buff.append("select fid,FName_l1,FName_l2,FName_l3,fnumber,fformHeight,fformWidth,fformID,FControlUnitID,FTemplateTypeID,FUsedState  ").append("\r\n");
        buff.append("from T_BAS_Template  ").append("\r\n");
        buff.append("where (FControlUnitID= ? or FControlUnitID='").append(CUID).append("') ").append("\r\n");
        if (null != moduleName && moduleName.equalsIgnoreCase(DOM_MODLE_NAME)) {
            List omdTemplateIss = DataTools.getAddOdmFlowTemplateList(ctx, null);
            buff.append("and fid in ").append(DataTools.getStrFromList(omdTemplateIss));
        } else if (null != moduleName && moduleName.equalsIgnoreCase(WFM_MODLE_NAME)) {
            perId = "";
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            }
            Object[] args = new Object[]{ctx, perId};
            List wfmTemplateIds = DataTools.getAllNewTemplateByPersonId(ctx, perId);
            buff.append("and fid in ").append(DataTools.getStrFromList(wfmTemplateIds));
        } else {
            perId = "";
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            }
            List wfmTemplateIds = DataTools.getAllNewTemplateByPersonId(ctx, perId);
            List omdTemplateIss = DataTools.getAddOdmFlowTemplateList(ctx, wfmTemplateIds);
            if (null != wfmTemplateIds) {
                wfmTemplateIds.addAll(omdTemplateIss);
            }
            buff.append("and fid in ").append(DataTools.getStrFromList(wfmTemplateIds));
        }
        buff.append("and FUsedState=2 order by fnumber asc ").append("\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buff.toString(), (Object[])params);
        return rs;
    }

    public static List getAllNewTemplateByPersonId(Context ctx, String personId) {
        ArrayList<String> result = new ArrayList<String>();
        TemplateInfo tempInfo = null;
        TemplateCollection temcon = DataTools.getTemplate(ctx);
        if (temcon != null && temcon.size() != 0) {
            int size = temcon.size();
            for (int i = 0; i < size; ++i) {
                tempInfo = temcon.get(i);
                String tempid = tempInfo.getId().toString();
                if (!DataTools.checkHasPermission(ctx, tempid, personId, tempInfo.getCU().getId().toString())) continue;
                result.add(tempInfo.getId().toString());
            }
        }
        return result;
    }

    public static boolean checkHasPermission(Context ctx, String temid, String perId, String tempcuid) {
        try {
            String sql1;
            String currCUid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            String sql = "select fid from T_WFM_TemplatePermission where FControlUnitID='" + currCUid + "' and FTemplateID='" + temid + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() == 0 ? tempcuid.equals(CUID) && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql1 = "select fid from T_WFM_TemplatePermission where fisAllCU=1 and FTemplateID='" + temid + "'"))).size() != 0 : DataTools.checkNewPermission(ctx, temid, perId, currCUid)) {
                return true;
            }
            if (tempcuid.equals(CUID) && DataTools.checkUserAllAdminOrgByUserID(ctx, temid, perId, currCUid)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static boolean checkUserAllAdminOrgByUserID(Context ctx, String tempid, String userId, String currcuid) throws Exception {
        Vector<String> vecOrgID = new Vector<String>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select position.* ,position.adminOrgUnit.* ");
            sb.append(" where person.id = '");
            sb.append(userId);
            sb.append("'");
            AdminOrgUnitInfo adminOrg = null;
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            PositionMemberCollection pmColl = ipm.getPositionMemberCollection(sb.toString());
            int size = pmColl.size();
            for (int i = 0; i < size; ++i) {
                String admincuid;
                if (pmColl.get(i).getPosition() == null || vecOrgID.contains(admincuid = (adminOrg = pmColl.get(i).getPosition().getAdminOrgUnit()).getCU().getId().toString())) continue;
                if (!admincuid.equals(currcuid) && DataTools.checkNewPermission(ctx, tempid, userId, admincuid)) {
                    return true;
                }
                vecOrgID.add(admincuid);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("\u4e0d\u80fd\u627e\u5230\u5f53\u524d\u7528\u6237\u6240\u5728\u7684\u90e8\u95e8!");
        }
        return false;
    }

    public static boolean checkNewPermission(Context ctx, String temid, String perId, String cuid) {
        try {
            ArrayList<AdminOrgUnitInfo> neworg = new ArrayList<AdminOrgUnitInfo>();
            StringBuffer selectSql = new StringBuffer();
            StringBuffer selectSql1 = new StringBuffer();
            AdminOrgUnitInfo info = null;
            selectSql.append("select biz.fid  from ");
            selectSql.append("T_wfm_TemplatePermission biz  \n");
            selectSql.append("left join ");
            selectSql.append("T_wfm_TemplatePermissionNewOrg admin on admin.fparentid = biz.fid \n");
            selectSql.append("where (\n");
            selectSql.append("   ('" + perId + "' in (select person.FPersonID from T_wfm_TemplatePNP person where person.fparentid = biz.fid)");
            selectSql1.append("select admin.FOrgID  from ");
            selectSql1.append("T_wfm_TemplatePermission biz  \n");
            selectSql1.append("inner join ");
            selectSql1.append("T_wfm_TemplatePermissionNewOrg admin on admin.fparentid = biz.fid \n");
            selectSql1.append("where biz.FTemplateID='" + temid + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql1.toString());
            while (rs.next()) {
                info = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(rs.getString(1)));
                neworg.add(info);
            }
            if (neworg.size() > 0) {
                selectSql.append(" or ");
                Vector<String> vecOrgID = new Vector<String>();
                StringBuffer sb = new StringBuffer();
                sb.append("select position.* ,position.adminOrgUnit.* ");
                sb.append(" where person.id = '");
                sb.append(perId);
                sb.append("'");
                AdminOrgUnitInfo adminOrg = null;
                IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
                PositionMemberCollection pmColl = ipm.getPositionMemberCollection(sb.toString());
                boolean check = false;
                int size = pmColl.size();
                for (int i = 0; i < size && !check; ++i) {
                    if (pmColl.get(i).getPosition() == null || vecOrgID.contains((adminOrg = pmColl.get(i).getPosition().getAdminOrgUnit()).getId().toString())) continue;
                    int orgsize = neworg.size();
                    for (int j = 0; j < orgsize; ++j) {
                        if (check || adminOrg.getLongNumber().indexOf(((AdminOrgUnitInfo)neworg.get(j)).getLongNumber()) < 0) continue;
                        check = true;
                        break;
                    }
                    vecOrgID.add(adminOrg.getId().toString());
                }
                if (!check) {
                    selectSql.append("1=0 ");
                } else if (check) {
                    selectSql.append("1=1 ");
                }
            }
            selectSql.append("\t) or biz.FNewPerType='1') \n");
            selectSql.append("    AND biz.FTemplateID = '");
            selectSql.append(temid);
            selectSql.append("' and biz.FControlUnitID='" + cuid + "'  \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static TemplateCollection getTemplate(Context ctx) {
        TemplateCollection tempList = null;
        try {
            ITemplate billTemplateService = TemplateFactory.getLocalInstance((Context)ctx);
            tempList = billTemplateService.getTemplateCollection("select *,templateType.* where (cu.id='" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "' or cu.id='eThjryu4wEKoEK1veu3ZzDUlqpQ=') and usedState=2 order by number asc");
            return tempList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static List getAddOdmFlowTemplateList(Context ctx, List wfmTemplateIds) {
        String perId = "";
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        TemplateTypeCollection typeList = null;
        TemplateCollection tempList = null;
        try {
            typeList = DataTools.getTemplateType(ctx);
            tempList = DataTools.getTemplateByTempModleID(ctx);
            if (wfmTemplateIds == null) {
                wfmTemplateIds = DataTools.getAllNewTemplateByPersonId(ctx, perId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("Get odm templateType or template or tempIds has error,e =" + e.getMessage()));
        }
        if (null != typeList && null != tempList && null != tempList) {
            ArrayList<String> list = new ArrayList<String>();
            for (TemplateTypeInfo typeInfo : typeList) {
                for (TemplateInfo tempInfo : tempList) {
                    if (!wfmTemplateIds.contains(tempInfo.getId().toString()) || !typeInfo.getId().equals((Object)tempInfo.getTemplateType().getId())) continue;
                    list.add(tempInfo.getId().toString());
                }
            }
            return list;
        }
        return null;
    }

    public static TemplateCollection getTemplateByTempModleID(Context ctx) {
        TemplateCollection tempList = null;
        try {
            String cuid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            ITemplate billTemplateService = TemplateFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewinfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuid, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)CUID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("usedState", (Object)new Integer(2), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("flowDirStr", (Object)"com.kingdee.eas.cp.odm%", CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)DataTools.getTemplateIdsByFormTemplateID(ctx), CompareType.INCLUDE));
            filterInfo.setMaskString("(#0 or #1) and #2 and #3 and #4 ");
            viewinfo.setFilter(filterInfo);
            tempList = billTemplateService.getTemplateCollection(viewinfo);
            return tempList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Set getTemplateIdsByFormTemplateID(Context ctx) {
        HashSet<String> set = new HashSet<String>();
        String sql = "select a.fid from t_bas_template a,t_bas_form b where  b.fid=a.FFormID and b.FTemplateID in('tqAoxLV0TguihBZ6eqU8bZp+rpI=','C/T4g3UCStmKrMRuH4ErO5p+rpI=')";
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rows != null) {
                while (rows.next()) {
                    set.add(rows.getString("fid"));
                }
            }
        }
        catch (SQLException rows) {
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static TemplateTypeCollection getTemplateType(Context ctx) {
        TemplateTypeCollection typeList = null;
        try {
            ITemplateType billTypeService = TemplateTypeFactory.getLocalInstance((Context)ctx);
            typeList = billTypeService.getTemplateTypeCollection("select id,name where usedState=1  and packageName = 'com.kingdee.eas.cp.odm'   order by number asc");
            return typeList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getStrFromList(List list) {
        assert (list != null);
        StringBuffer sb = new StringBuffer();
        if (list.size() <= 0) {
            sb.append(" ('nodata') ");
            return sb.toString();
        }
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }
}

