/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.facade.eas.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.SerialBlob;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.biz.module.page.dto.PersonPhotoDTO;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonUtil {
    private static final Logger logger = LoggerFactory.getLogger(PersonUtil.class);
    private static EASService easService = (EASService)PortalServiceLocator.getBean("easService");

    public static List<PersonPhotoDTO> generatePhotoURL(PortalContext ctx, HttpServletRequest request, String[] personIds) throws Exception {
        ArrayList<PersonPhotoDTO> resultList = new ArrayList<PersonPhotoDTO>();
        if (personIds == null || personIds.length <= 0) {
            return resultList;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select * From T_HR_PersonPhoto t    ");
        sql.append(" where  t.fpersonid  in ");
        sql.append(" (?");
        for (int i = 1; i < personIds.length; ++i) {
            sql.append(",?");
        }
        sql.append(")");
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (Object[])personIds);
            while (dataSet.next()) {
                PersonPhotoDTO se = new PersonPhotoDTO();
                se.setId(dataSet.getString("FID"));
                se.setPersonId(dataSet.getString("FPERSONID"));
                SerialBlob img = (SerialBlob)dataSet.getBlob("FIMAGEDATA");
                if (img != null && img.length() > 0L) {
                    byte[] images = img.getBytes(1L, (int)img.length());
                    String imgPath = PersonUtil.generatePhotoURL(request, images);
                    se.setImgPath(imgPath);
                } else if (easService.isStartSHR(context)) {
                    se.setImgPath("/portal/res/img/global/icons/default-shr-user-logo.png");
                } else {
                    se.setImgPath("/portal/res/img/global/icons/default-user-logo.png");
                }
                resultList.add(se);
            }
        }
        catch (Exception e) {
            logger.error("sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return resultList;
    }

    public static PersonPhotoDTO generatePhotoURL(PortalContext ctx, HttpServletRequest request, String personId) throws Exception {
        StringBuffer sql = new StringBuffer();
        PersonPhotoDTO dto = new PersonPhotoDTO();
        sql.append("   select * From T_HR_PersonPhoto t    ");
        sql.append("  where  t.fpersonid ='" + personId + "'  ");
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
            if (dataSet.next()) {
                dto.setId(dataSet.getString("FID"));
                dto.setPersonId(dataSet.getString("FPERSONID"));
                SerialBlob img = (SerialBlob)dataSet.getBlob("FIMAGEDATA");
                if (img != null && img.length() > 0L) {
                    byte[] images = img.getBytes(1L, (int)img.length());
                    String imgPath = PersonUtil.generatePhotoURL(request, images);
                    dto.setImgPath(imgPath);
                } else {
                    dto.setImgPath("/portal/res/img/global/icons/default-user-logo.png");
                }
            }
        }
        catch (Exception e) {
            logger.error("sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return dto;
    }

    public static String getInIds(String[] personIds) {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < personIds.length; ++i) {
            if (i == 0) {
                ids.append("'" + personIds[i] + "'");
                continue;
            }
            ids.append(",'" + personIds[i] + "'");
        }
        return ids.toString();
    }

    public static String generatePhotoURL(HttpServletRequest request, byte[] imageData) throws IOException, NoSuchAlgorithmException {
        if (imageData == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
        BufferedInputStream bis = new BufferedInputStream(bais);
        byte[] data = new byte[bis.available()];
        bais.read(data, 0, data.length);
        bais.close();
        String url = null;
        if (data != null) {
            url = PersonUtil.getUrl(request, data);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUrl(HttpServletRequest request, byte[] data) throws NoSuchAlgorithmException, IOException {
        String fileName = "hr/personPhoto";
        String path = request.getRealPath("/");
        File file = new File(path + fileName);
        if (!file.exists() || file.isFile()) {
            file.mkdirs();
        }
        String photoName = PersonUtil.MD5_32(new String(data));
        String url = fileName + "/" + photoName + ".gif";
        File photoFile = new File(path + url);
        if (!photoFile.exists()) {
            photoFile.createNewFile();
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(photoFile);
                outputStream.write(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
        }
        return "/portal/" + url;
    }

    private static StringBuffer getWebAppURL(HttpServletRequest request) {
        StringBuffer prefixUrl = new StringBuffer();
        prefixUrl.append(request.getScheme());
        prefixUrl.append("://");
        prefixUrl.append(request.getServerName());
        prefixUrl.append(":");
        prefixUrl.append(request.getServerPort());
        prefixUrl.append(request.getContextPath());
        prefixUrl.append("/");
        return prefixUrl;
    }

    private static String MD5_32(String var) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        StringBuffer strbuf = new StringBuffer();
        md5.update(var.getBytes(), 0, var.length());
        byte[] digest = md5.digest();
        for (int i = 0; i < digest.length; ++i) {
            strbuf.append(PersonUtil.byte2Hex(digest[i]));
        }
        return strbuf.toString();
    }

    private static String byte2Hex(byte b) {
        int value = (b & 0x7F) + (b < 0 ? 128 : 0);
        return (value < 16 ? "0" : "") + Integer.toHexString(value).toLowerCase();
    }
}

