/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.facade.eas.weibo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.weibo.IWeiboFacade;
import com.kingdee.eas.base.weibo.WeiboBillConfigInfo;
import com.kingdee.eas.base.weibo.WeiboBindPersonInfo;
import com.kingdee.eas.base.weibo.WeiboFacadeFactory;
import com.kingdee.eas.base.weibo.WeiboPrepareInfo;
import com.kingdee.eas.base.weibo.WeiboRegisterInfo;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.facade.eas.weibo.WeiboService;
import com.kingdee.portal.biz.module.weibo.BillConfigInfo;
import com.kingdee.portal.biz.module.weibo.BindPersonInfo;
import com.kingdee.portal.biz.module.weibo.PrepareInfo;
import com.kingdee.portal.biz.module.weibo.RegisterInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WeiboServiceImpl
implements WeiboService {
    @Override
    public RegisterInfo getRegisterInfo(PortalContext ctx) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            WeiboRegisterInfo info = weiboFacade.getRegisterInfo();
            return this.buildRegisterInfo(info);
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return null;
    }

    private RegisterInfo buildRegisterInfo(WeiboRegisterInfo info) {
        return new RegisterInfo(info.getPersonId(), info.getDomain(), info.getEmail());
    }

    @Override
    public boolean isWeiboEnable(PortalContext ctx) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            return weiboFacade.isWeiboEnable();
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public PrepareInfo getPrepareInfo(PortalContext ctx) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            WeiboPrepareInfo info = weiboFacade.getPrepareInfo();
            return this.buildPrepareInfo(info);
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return null;
    }

    private PrepareInfo buildPrepareInfo(WeiboPrepareInfo info) {
        return new PrepareInfo(info.getPersonId(), info.getEmail(), info.getLoginToken());
    }

    @Override
    public boolean isRegistered(PortalContext ctx, String email) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            return weiboFacade.isRegistered(email);
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean register(PortalContext ctx, String email, boolean isAdmin) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            return weiboFacade.register(email, isAdmin);
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean bind(PortalContext ctx, String email, String psw, boolean isAdmin, String weiboSystemType, String testUrl) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            return weiboFacade.bind(email, psw, isAdmin, weiboSystemType, testUrl);
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getWeiboUserId(PortalContext ctx, String personId) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            return weiboFacade.getWeiboIdbyPersonId(personId);
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getBindEmail(PortalContext ctx) throws PortalBizException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String personId = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
        if (userInfo.getPerson() != null) {
            personId = userInfo.getPerson().getId().toString();
        }
        if (StringUtils.isEmpty(personId)) {
            return null;
        }
        try {
            return WeiboBizUtil.getBindEmailByPersonId((String)personId);
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public PagingResult<BillConfigInfo> findBillConfigList(PortalContext ctx, PagingParam pagingParam) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            Map map = weiboFacade.getBillConfigListInfo(pagingParam.getStartIndex(), pagingParam.getPageSize());
            int count = (Integer)map.get("count");
            List list = (List)map.get("result");
            return new PagingResult<BillConfigInfo>(pagingParam, count, this.buildBillConfigInfo(list));
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return new PagingResult<BillConfigInfo>(pagingParam, 0, new ArrayList());
    }

    private List<BillConfigInfo> buildBillConfigInfo(List<WeiboBillConfigInfo> list) {
        ArrayList<BillConfigInfo> configList = new ArrayList<BillConfigInfo>();
        for (WeiboBillConfigInfo info : list) {
            configList.add(new BillConfigInfo(info.getId(), info.getBosType(), info.getDesc()));
        }
        return configList;
    }

    @Override
    public boolean addBillConfig(PortalContext ctx, String bosType, String desc) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            weiboFacade.addBillConfig(bosType, desc);
            return true;
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean deleteBillConfig(PortalContext ctx, String configId) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            weiboFacade.deleteBillConfig(configId);
            return true;
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public PagingResult<BindPersonInfo> findBindPersonList(PortalContext ctx, PagingParam pagingParam) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            Map map = weiboFacade.getBindPersonList(pagingParam.getStartIndex(), pagingParam.getPageSize());
            int count = (Integer)map.get("count");
            List list = (List)map.get("result");
            return new PagingResult<BindPersonInfo>(pagingParam, count, this.buildBindPersonInfo(list));
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return new PagingResult<BindPersonInfo>(pagingParam, 0, new ArrayList());
    }

    private List<BindPersonInfo> buildBindPersonInfo(List<WeiboBindPersonInfo> list) {
        ArrayList<BindPersonInfo> personList = new ArrayList<BindPersonInfo>();
        BindPersonInfo personInfo = null;
        for (WeiboBindPersonInfo info : list) {
            personInfo = new BindPersonInfo();
            personInfo.setId(info.getId());
            personInfo.setEmail(info.getEmail());
            personInfo.setName(info.getName());
            personInfo.setVerified(info.isVerified());
            personList.add(personInfo);
        }
        return personList;
    }

    @Override
    public String getAdminEmail(PortalContext ctx) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            return weiboFacade.getAdminEmail();
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean batchCreateWeiboUser(PortalContext ctx, int size) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            return weiboFacade.batchCreateWeiboUser(size);
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Map<String, Integer> getUnreadCount(PortalContext ctx) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            return weiboFacade.getUnreadCount();
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean deleteBindEmail(PortalContext ctx) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            return weiboFacade.deleteBindEamil();
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getWeiboSystemUrl(PortalContext ctx) throws PortalBizException {
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            return weiboFacade.getWeiboSystemUrl();
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return null;
    }
}

