/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.facade.portal;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvAgent;
import com.kingdee.eas.base.license.client.monitor.LicenseClientUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.portal.facade.PageRemoteServiceFacade;
import com.kingdee.portal.biz.facade.portal.facade.PortalCacheFacade;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PortalServiceRemoteFacade {
    protected static Logger logger = Logger.getLogger((String)PortalServiceRemoteFacade.class.getName());

    public static String getPageFolderByParentId(Context ctx, String parentId) {
        boolean success = false;
        LocalErr localErr = null;
        List<Page> folderList = null;
        try {
            if (StringUtil.isEmpty((String)parentId)) {
                localErr = new LocalErr();
                localErr.setDesc("parentId is null !");
            } else {
                PageRemoteServiceFacade pageRemoteService = (PageRemoteServiceFacade)PortalServiceLocator.getBean("pageRemoteServiceFacade");
                folderList = pageRemoteService.getPageFolderByParentId(ctx, parentId);
                success = true;
            }
        }
        catch (Exception e) {
            localErr = new LocalErr();
            localErr.setDesc(e.getMessage());
        }
        return PortalServiceRemoteFacade.transferToJson(success, localErr, folderList);
    }

    public static String searchPageFolder(Context ctx, String parentId, String searchKey, int level) {
        boolean success = false;
        LocalErr localErr = null;
        List<Page> folderList = null;
        try {
            PageRemoteServiceFacade pageRemoteService = (PageRemoteServiceFacade)PortalServiceLocator.getBean("pageRemoteServiceFacade");
            folderList = pageRemoteService.searchPageFolder(ctx, parentId, searchKey, level);
            success = true;
        }
        catch (Exception e) {
            localErr = new LocalErr();
            localErr.setDesc(e.getMessage());
        }
        return PortalServiceRemoteFacade.transferToJson(success, localErr, folderList);
    }

    public static boolean hasImportPage(Context ctx, String url) {
        boolean hasImport = true;
        try {
            PageRemoteServiceFacade pageRemoteService = (PageRemoteServiceFacade)PortalServiceLocator.getBean("pageRemoteServiceFacade");
            hasImport = pageRemoteService.hasImportPage(ctx, url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasImport;
    }

    public static String savePageToPortal(Context ctx, String pageJson, String parentId) {
        boolean success = false;
        LocalErr localErr = null;
        List<Page> pageList = null;
        try {
            PageRemoteServiceFacade pageRemoteService = (PageRemoteServiceFacade)PortalServiceLocator.getBean("pageRemoteServiceFacade");
            pageList = pageRemoteService.savePageToPortal(ctx, pageJson, parentId);
            if (pageList != null && pageList.size() > 0) {
                success = true;
                PortalCacheFacade.updateCacheFlag(ctx, "FClientFlag");
                CustomCacheService cacheService = new CustomCacheService("login.all_menu");
                cacheService.remove("allMenuRowSet");
            } else {
                localErr = new LocalErr();
                localErr.setDesc("Add Page Error");
            }
        }
        catch (Exception e) {
            localErr = new LocalErr();
            localErr.setDesc(e.getMessage());
        }
        return PortalServiceRemoteFacade.transferToJson(success, localErr, pageList);
    }

    public static boolean updateQingCardID(Context ctx, Map<String, String> cardIDMap) {
        try {
            PageRemoteServiceFacade pageRemoteService = (PageRemoteServiceFacade)PortalServiceLocator.getBean("pageRemoteServiceFacade");
            return pageRemoteService.updateQingCardID(ctx, cardIDMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deletePageFromPortal(Context ctx, String pageId) {
        boolean success = false;
        try {
            PageRemoteServiceFacade pageRemoteService = (PageRemoteServiceFacade)PortalServiceLocator.getBean("pageRemoteServiceFacade");
            success = pageRemoteService.deletePageFromPortal(ctx, pageId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    public static String findPortalThemeType(Context ctx) {
        String themeType = "blue";
        try {
            PageService pageService = (PageService)PortalServiceLocator.getBean("pageService");
            themeType = pageService.findPortalThemeType(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return themeType;
    }

    public static boolean isNeedCheckLicense(Context ctx, String pageId) {
        if (!FilterSpecialCharactersTool.checkParamsValid(pageId)) {
            return true;
        }
        PageRemoteServiceFacade pageRemoteService = (PageRemoteServiceFacade)PortalServiceLocator.getBean("pageRemoteServiceFacade");
        Map<String, String> licenseMap = PortalCache.getNewContainerLicense(ctx);
        return licenseMap.get(pageId = pageRemoteService.getRealPageId(ctx, pageId)) != null;
    }

    public static String checkLicenseForNewPage(Context ctx, String pageId) {
        if (!FilterSpecialCharactersTool.checkParamsValid(pageId)) {
            return "false";
        }
        PageRemoteServiceFacade pageRemoteService = (PageRemoteServiceFacade)PortalServiceLocator.getBean("pageRemoteServiceFacade");
        ILicenseSrvAgent licenseSrv = PortalServiceRemoteFacade.getLicenseSrv();
        pageId = pageRemoteService.getRealPageId(ctx, pageId);
        Map<String, String> licenseMap = PortalCache.getNewContainerLicense(ctx);
        String className = licenseMap.get(pageId);
        LicenseUserInfo user = PortalServiceRemoteFacade.getLicenseUserInfo(ctx);
        int licenselcFlag = 0;
        try {
            licenselcFlag = licenseSrv.requestLicense(user, className);
            if (licenselcFlag == 1) {
                return "true";
            }
            if (licenselcFlag == 2 || licenselcFlag == 4) {
                return PortalServiceRemoteFacade.constructLicenseMessage(className);
            }
            return PortalServiceRemoteFacade.constructLicenseMessage("com.kingdee.bos.custom.BOSCustomModuleMixUI");
        }
        catch (LicenseException e) {
            e.printStackTrace();
            return "false";
        }
    }

    public static final String constructLicenseMessage(String className) throws LicenseException {
        if (className == null) {
            return "";
        }
        ILicenseSrvAgent licenseSrv = PortalServiceRemoteFacade.getLicenseSrv();
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u7533\u8bf7license\u7684\u7c7b\u540d\u79f0\uff1a");
        buffer.append("[" + className + "]").append("<br>");
        buffer.append("\u5bf9\u5e94\u7684license\u6a21\u5757\u540d\u79f0\uff1a");
        String moduleName = licenseSrv.getModuleByPackage(className);
        if (moduleName == null || moduleName.trim().length() == 0) {
            buffer.append("");
        } else {
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)moduleName) + "[" + moduleName + "]");
        }
        buffer.append("<br>");
        buffer.append("\u5bf9\u5e94\u7684\u5b50\u7cfb\u7edf\u540d\u79f0\uff1a");
        String subSysName = LicenseClientUtil.getSubSystemNameByModularName((String)moduleName);
        if (subSysName == null || subSysName.trim().length() == 0) {
            buffer.append("");
        } else {
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)subSysName) + "[" + subSysName + "]");
        }
        buffer.append("<br>");
        return buffer.toString();
    }

    private static ILicenseSrvAgent getLicenseSrv() {
        LicenseSrvAgent licenseSrv = null;
        String url = "localhost";
        try {
            ORMServiceLocation loc = new ORMServiceLocation("license");
            if (loc == null) {
                logger.error((Object)"Invalidate config file! please make sure you have the config item about UserMonitor!");
            } else if (!loc.isLocal()) {
                url = loc.getServiceURL();
                if (url == null || url.trim().length() == 0) {
                    url = "tcp://localhost";
                }
                licenseSrv = (ILicenseSrvAgent)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.base.license.agent.LicenseSrvAgent", ILicenseSrvAgent.class);
            } else {
                licenseSrv = new LicenseSrvAgent();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Invalidate config file! please make sure you have the config item about UserMonitor! Error url is: " + url), (Throwable)e);
        }
        return licenseSrv;
    }

    private static LicenseUserInfo getLicenseUserInfo(Context ctx) {
        LicenseUserInfo info = new LicenseUserInfo();
        info.setSessionID(ctx.getContextID());
        info.setUserID(ctx.getCaller().toString());
        info.setUserIP(ctx.getClientHostIP());
        info.setUserLoginAis(ctx.getAIS());
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        if (userInfo != null) {
            info.setUserName(userInfo.getNumber());
        } else {
            info.setUserName(ctx.getUserName());
        }
        info.setUserLoginTime(new Date(System.currentTimeMillis()));
        if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            info.setUserCompany(ContextUtil.getCurrentOrgUnit((Context)ctx).getName());
        }
        return info;
    }

    private static String transferToJson(boolean success, LocalErr errinfo, Object result) {
        Object tempResult = result == null ? "" : result;
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("success", success);
        ajaxData.put("errinfo", errinfo);
        ajaxData.put("result", tempResult);
        return JSONUtil.getJson4Object(ajaxData);
    }
}

