/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.facade.portal.facade.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.CnToSpell;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.enums.ResLevelEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.core.datacenter.DSObserver;
import com.kingdee.portal.biz.facade.portal.facade.PageRemoteServiceFacade;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.json.ELinkNodeExt;
import com.kingdee.portal.biz.module.page.common.json.LinkNodeExt;
import com.kingdee.portal.biz.module.page.common.util.PageHelper;
import com.kingdee.portal.biz.module.page.dao.PageDAO;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.perm.entity.User;
import com.kingdee.portal.common.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRemoteServiceFacadeImpl
implements PageRemoteServiceFacade {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PageDAO pageDAO;

    @Override
    public List<Page> getPageFolderByParentId(Context ctx, String parentId) {
        ArrayList<Page> folderList;
        block10: {
            LocalErr localErr = null;
            folderList = null;
            try {
                if (StringUtil.isEmpty((String)parentId)) {
                    localErr = new LocalErr();
                    localErr.setDesc("parentId is null !");
                    break block10;
                }
                try {
                    IRowSet rset = DbUtil.executeQuery((Context)ctx, (String)("select FNodeLevel from T_JP_Page where fid='" + parentId + "'"));
                    Page parentPage = null;
                    if (rset != null) {
                        while (rset.next()) {
                            parentPage = new Page();
                            parentPage.setNodeLevel(rset.getInt("FNodeLevel"));
                        }
                    }
                    if (parentPage != null) {
                        StringBuilder sql = new StringBuilder();
                        sql.append("select FNodeLevel,FId,FDisplayName,FNodePath,FIcon,FParentNodeId,FNodeType,FNodeExt,FNodeOrder,FPageNumber,FPreferences,FSettingInfo,FPermViewCtrl,FPermEditCtrl").append(" from T_JP_Page where FNodePath like '%/").append(parentId).append("/%' ").append(" and FNodeLevel =").append(parentPage.getNodeLevel() + 1).append(" order by FNodeOrder asc,FCreateTime asc");
                        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                        if (rs != null) {
                            folderList = new ArrayList<Page>();
                            while (rs.next()) {
                                Page page = new Page();
                                page.setNodeLevel(rs.getInt("FNodeLevel"));
                                page.setId(rs.getString("FId"));
                                page.setDisplayName(rs.getString("FDisplayName"));
                                page.setNodePath(rs.getString("FNodePath"));
                                page.setIcon(rs.getString("FIcon"));
                                page.setParentNodeId(rs.getString("FParentNodeId"));
                                page.setNodeType(NodeTypeEnum.valueOf(rs.getString("FNodeType")));
                                page.setNodeExt(rs.getString("FNodeExt"));
                                page.setNodeOrder(rs.getInt("FNodeOrder"));
                                page.setPageNumber(rs.getString("FPageNumber"));
                                page.setPreferences(rs.getString("FPreferences"));
                                page.setSettingInfo(rs.getString("FSettingInfo"));
                                page.setPermViewCtrl(rs.getBoolean("FPermViewCtrl"));
                                page.setPermEditCtrl(rs.getBoolean("FPermEditCtrl"));
                                folderList.add(page);
                            }
                        }
                        break block10;
                    }
                    throw new PortalBizException("210");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    throw new PortalBizException("204", e);
                }
            }
            catch (PortalBizException e) {
                localErr = new LocalErr();
                localErr.setDesc(e.getMessage());
            }
        }
        return folderList;
    }

    @Override
    public List<Page> searchPageFolder(Context ctx, String parentId, String searchKey, int level) {
        Page entity = new Page();
        entity.setStatus(StatusEnum.ENABLE);
        ArrayList<Page> pageList = null;
        try {
            List<Page> allList = this.pageDAO.findList(entity, this.getNodePathFilter(parentId), new FieldFilter("nodeLevel", "<", 5), new OrderFilter("nodeLevel", OrderEnum.ASC), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
            if (allList != null && allList.size() > 0) {
                pageList = new ArrayList<Page>();
                String locale = ctx.getLocale().toString();
                for (Page cpage : allList) {
                    if (cpage.getNodeLevel() != level + 1 || cpage.getDisplayName().indexOf(searchKey) == -1) continue;
                    Page newPage = this.setPage4Perm(cpage, true, false);
                    String pathInfo = "";
                    String nodePath = cpage.getNodePath();
                    String[] paths = nodePath.split("/");
                    for (int i = 0; i < paths.length; ++i) {
                        for (Page page : allList) {
                            if (page == null || !page.getId().equals(paths[i])) continue;
                            DisplayName dn = new DisplayName(page.getDisplayName(), locale);
                            pathInfo = pathInfo + dn.getLocaleText() + " > ";
                        }
                    }
                    if (pathInfo.length() > 2) {
                        pathInfo = pathInfo.substring(0, pathInfo.length() - 3);
                    }
                    newPage.setNodePath(pathInfo);
                    pageList.add(newPage);
                }
            }
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            try {
                throw new PortalBizException("204", e);
            }
            catch (PortalBizException e1) {
                e1.printStackTrace();
            }
        }
        return pageList;
    }

    private FieldFilter getNodePathFilter(String id) {
        if (StringUtil.isEmpty((String)id)) {
            return new FieldFilter("nodePath", "like", "%/2b7f4215-aa17-4d89-952e-efc97833cee6/%");
        }
        return new FieldFilter("nodePath", "like", "%/" + id + "/%");
    }

    private Page setPage4Perm(Page page, boolean viewCtrl, boolean editCtrl) {
        LinkNodeExt ext;
        Page newPage = new Page();
        newPage.setDisplayName(page.getDisplayName());
        newPage.setIcon(page.getIcon());
        newPage.setId(page.getId());
        newPage.setNodeLevel(page.getNodeLevel());
        newPage.setNodeOrder(page.getNodeOrder());
        newPage.setNodePath(page.getNodePath());
        newPage.setNodeType(page.getNodeType());
        newPage.setPageNumber(page.getPageNumber());
        String nodeExt = page.getNodeExt();
        if (page.getNodeType().equals((Object)NodeTypeEnum.LINK) && page.getNodeExt() != null && (ext = new LinkNodeExt(nodeExt)).getSso() != null && ext.getSso().booleanValue()) {
            ext.setUrl("/portal/openSSOUrlServlet?url=" + ext.getUrl());
            nodeExt = ext.toString();
        }
        newPage.setNodeExt(nodeExt);
        return newPage;
    }

    @Override
    public boolean hasImportPage(Context ctx, String url) {
        boolean result = true;
        try {
            Page page = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select FId from T_JP_Page where FNodeExt like '%" + url + "%'"));
            if (rs != null) {
                while (rs.next()) {
                    page = new Page();
                    page.setId(rs.getString("FId"));
                }
            }
            if (page == null) {
                result = false;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            try {
                throw new PortalBizException("204", e);
            }
            catch (PortalBizException e1) {
                e1.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public List<Page> savePageToPortal(Context ctx, String pageJson, String parentId) {
        ArrayList<Page> resultList;
        block15: {
            resultList = new ArrayList<Page>();
            Page parentPage = null;
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select FNodeLevel,FId,FDisplayName,FNodePath,FNodeType,FNodeExt,FNodeOrder from T_JP_Page where fid='" + parentId + "'"));
                if (rs != null) {
                    while (rs.next()) {
                        parentPage = new Page();
                        parentPage.setNodeLevel(rs.getInt("FNodeLevel"));
                        parentPage.setId(rs.getString("FId"));
                        parentPage.setDisplayName(rs.getString("FDisplayName"));
                        parentPage.setNodePath(rs.getString("FNodePath"));
                        parentPage.setNodeType(NodeTypeEnum.valueOf(rs.getString("FNodeType")));
                        parentPage.setNodeExt(rs.getString("FNodeExt"));
                        parentPage.setNodeOrder(rs.getInt("FNodeOrder"));
                    }
                }
            }
            catch (Exception e1) {
                this.logger.error("savePageToPortal find parent error===" + e1.getMessage());
                try {
                    throw new PortalBizException("210");
                }
                catch (PortalBizException e) {
                    e.printStackTrace();
                }
            }
            if (parentPage == null) {
                this.logger.error("savePageToPortal parent is null===");
                try {
                    throw new PortalBizException("210");
                }
                catch (PortalBizException e) {
                    e.printStackTrace();
                    break block15;
                }
            }
            JSONObject obj = JSONObject.fromObject((Object)pageJson);
            String dispalyName = obj.getString("displayName");
            String url = obj.getString("url");
            String permItem = null;
            Page page = new Page();
            page.setDisplayName(dispalyName);
            page.setDescription(dispalyName);
            page.setNodeType(NodeTypeEnum.EXTERNAL_LINK);
            page.setParentNode(parentPage);
            page.setStatus(StatusEnum.ENABLE);
            page.setPageNumber(PageHelper.generatePageNumber());
            page.setPermViewCtrl(false);
            page.setPermEditCtrl(false);
            page.setCanAddFav(true);
            page.setCanSearch(true);
            page.setPreferences("2");
            String externalId = null;
            try {
                externalId = this.savePageToEAS(ctx, url, dispalyName, permItem);
            }
            catch (PortalBizException e2) {
                e2.printStackTrace();
            }
            ELinkNodeExt ext = new ELinkNodeExt();
            ext.setUrl(url);
            ext.setExternalId(externalId);
            ext.setLeaf(true);
            ext.setTarget("TAB");
            page.setNodeExt(ext.toString());
            page.setResLevel(ResLevelEnum.EXT);
            page.setNodeOrder(10000);
            page.setPortalContext(this.buildPortalContext(ctx));
            page.setUserId("portal_template_user");
            page.setAllSpell(this.getCnSpell(dispalyName, false));
            page.setFirstSpell(this.getCnSpell(dispalyName, true));
            try {
                StringBuilder saveSql = new StringBuilder();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String nowTime = df.format(new Date());
                String id = UUID.randomUUID().toString();
                saveSql.append("Insert Into T_JP_Page(FID,FCREATETIME,FCREATOR,FLASTUPDATETIME,FLASTUPDATER,FHIDDEN,FNODELEVEL,FNODEORDER,FNODEPATH,FPARENTNODEID,FPAGENUMBER,FDISPLAYNAME,FNODETYPE,FNODEEXT,FDESCRIPTION,FSETTINGINFO,FSTATUS,FICON,FPERMVIEWCTRL,FPERMEDITCTRL,FRESLEVEL,FUSERID,FPREFERENCES,FDEFAULTPAGEID,FCONTROLPARAM,FSHOWPLTBUTTON,FFIRSTSPELL,FALLSPELL,FCANSEARCH,FCANADDFAV)").append(" Values('").append(id).append("',").append("{ts'").append(nowTime).append("'}").append(",").append("'").append(ctx.getUserName()).append("',").append("{ts'").append(nowTime).append("'}").append(",").append("'").append(ctx.getUserName()).append("',").append("0,5,10000,").append("'").append(parentPage.getNodePath()).append("/").append(id).append("',").append("'").append(parentPage.getId()).append("',").append("'").append(PageHelper.generatePageNumber()).append("',").append("'").append(dispalyName).append("',").append("'EXTERNAL_LINK',").append("'").append(ext.toString()).append("',").append("'").append(dispalyName).append("',").append("null,'ENABLE',null,1,1,'EXT','portal_template_user','2',").append("null,null,null,").append("'").append(this.getCnSpell(dispalyName, true)).append("',").append("'").append(this.getCnSpell(dispalyName, false)).append("',").append("1,1)");
                DbUtil.execute((Context)ctx, (String)saveSql.toString());
                page.setId(id);
            }
            catch (Exception e) {
                this.logger.error("savePageToPortal create page error===" + e.getMessage());
                try {
                    throw new PortalBizException("202");
                }
                catch (PortalBizException e1) {
                    e1.printStackTrace();
                }
            }
            resultList.add(page);
        }
        return resultList;
    }

    @Override
    public boolean updateQingCardID(Context context, Map<String, String> cardIDMap) throws PortalBizException {
        String oldID = "";
        String newID = "";
        String oldPreferences = "";
        String newPreferences = "";
        String fid = "";
        String findSql = "select FID,FPreferences from T_JP_PortletRuntimePreferences where FPreferences like ?";
        String updSql = "update T_JP_PortletRuntimePreferences set FPreferences = ? where  FID = ?";
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement updateStmt = null;
        Statement stmt = null;
        try {
            connection = EJBFactory.getConnection((Context)context);
            updateStmt = connection.prepareStatement(updSql);
            for (Map.Entry<String, String> entry : cardIDMap.entrySet()) {
                oldID = entry.getKey();
                newID = entry.getValue();
                stmt = connection.prepareStatement(findSql);
                stmt.setString(1, "%" + oldID + "%");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    oldPreferences = rs.getString("FPreferences");
                    newPreferences = oldPreferences.replaceAll(oldID, newID);
                    fid = rs.getString("FID");
                    updateStmt.setString(1, newPreferences);
                    updateStmt.setString(2, fid);
                    updateStmt.addBatch();
                }
            }
            updateStmt.executeBatch();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new PortalBizException("300", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (updateStmt != null) {
                try {
                    updateStmt.close();
                }
                catch (Exception exception) {}
                updateStmt = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
                stmt = null;
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
                connection = null;
            }
        }
    }

    private String savePageToEAS(Context ctx, String url, String displayName, String permItem) throws PortalBizException {
        String externalId = null;
        try {
            MainMenuItemInfo parent = MainMenuItemFactory.getLocalInstance((Context)ctx).getMainMenuItemInfo((IObjectPK)new ObjectUuidPK("6u3K38SWTu6Z1Fjesbpc5f033J8="));
            if (parent == null) {
                this.logger.error("savePageToEAS eas web parent is null===");
                throw new PortalBizException("210");
            }
            MainMenuItemInfo menu = new MainMenuItemInfo();
            menu.setAvailable(true);
            BOSUuid uuId = BOSUuid.create((BOSObjectType)menu.getBOSType());
            menu.setId(uuId);
            String number = PageHelper.generatePageNumber();
            number = number.substring(2, number.length());
            menu.setNumber(number);
            menu.setLongNumber("portalAuto!" + number);
            menu.setOrder("255");
            menu.setMenutype(BizTypeEnum.webmenu);
            menu.setVisible(true);
            menu.setEnabled(true);
            DisplayName nameInfo = new DisplayName(displayName);
            menu.setName(nameInfo.getZh_CN());
            menu.setLevel(2);
            menu.setParent(parent);
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            menu.setCU(cu);
            MainMenuItemFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)menu);
            externalId = uuId.toString();
        }
        catch (Exception e) {
            this.logger.error("savePageToEAS save error ===" + e.getMessage());
            throw new PortalBizException("212");
        }
        return externalId;
    }

    private PortalContext buildPortalContext(Context ctx) {
        PortalContext portalContext = new PortalContext();
        portalContext.setIp("127.0.0.1");
        portalContext.setLocale(Locale.CHINA);
        portalContext.setLoginDate(new Date());
        User loginUser = new User();
        loginUser.setId(ctx.getCaller().toString());
        loginUser.setCode(ctx.getUserName());
        portalContext.setLoginUser(loginUser);
        portalContext.getMetaInfo().put("eas_context", ctx);
        DSObserver.putDSName(ctx.getAIS());
        return portalContext;
    }

    private String getCnSpell(String displayName, boolean onlyFirstSpell) {
        DisplayName nameInfo = new DisplayName(displayName);
        String cnName = nameInfo.getZh_CN();
        return CnToSpell.getSpell((String)cnName, (boolean)onlyFirstSpell);
    }

    @Override
    public boolean deletePageFromPortal(Context ctx, String pageId) {
        try {
            if (StringUtil.isEmpty((String)pageId)) {
                throw new PortalBizException("201");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select FId,FNodePath,FNodeType from T_JP_Page where fid='" + pageId + "'"));
            if (rs == null) {
                throw new PortalBizException("207");
            }
            Page page = null;
            while (rs.next()) {
                page = new Page();
                page.setId(rs.getString("FId"));
                page.setNodePath(rs.getString("FNodePath"));
                page.setNodeType(NodeTypeEnum.valueOf(rs.getString("FNodeType")));
            }
            if (page.getNodeType() == NodeTypeEnum.EXTERNAL_LINK || page.getNodeType() == NodeTypeEnum.EXTERNAL_LINK_G || page.getNodeType() == NodeTypeEnum.EXTERNAL_LINK_OA) {
                DbUtil.execute((Context)ctx, (String)("delete from T_JP_Page where fid='" + pageId + "'"));
                return true;
            }
            throw new Exception("nodeType \u4e3a\uff1a" + page.getNodeType().name() + "\u4e0d\u80fd\u5220\u9664\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getRealPageId(Context ctx, String pageId) {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT FNodeType,FParentNodeId FROM T_JP_PAGE where  fid = ?", (Object[])new Object[]{pageId});
            if (rs.next()) {
                String nodeType = rs.getString("FNodeType");
                if (NodeTypeEnum.PLAN.toString().equalsIgnoreCase(nodeType)) {
                    pageId = rs.getString("FParentNodeId");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageId;
    }

    public PageDAO getPageDAO() {
        return this.pageDAO;
    }

    public void setPageDAO(PageDAO pageDAO) {
        this.pageDAO = pageDAO;
    }
}

