/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.facade.portal.facade.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.facade.portal.common.context.SimplePortalContext;
import com.kingdee.portal.biz.facade.portal.common.util.SimplePortalContextUtil;
import com.kingdee.portal.biz.facade.portal.facade.PortletDefinitionServiceFacade;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.common.util.StringUtil;
import java.util.List;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PortletDefinitionServiceFacadeImpl
implements PortletDefinitionServiceFacade {
    private PortletDefinitionService portletDefinitionService;

    @Override
    public PortletDefinition createPortletDefinition(SimplePortalContext context, String appName, String portletName, PortletParam params) throws PortalBizException {
        if (StringUtil.isEmpty((String)context.getUserId()) || StringUtil.isEmpty((String)context.getDataCenter()) || StringUtil.isEmpty((String)appName) || StringUtil.isEmpty((String)portletName) || params == null) {
            throw new PortalBizException("311");
        }
        PortalContext portalContext = SimplePortalContextUtil.buildPortalContext(context);
        PortletDefinition portletDefinition = this.createPortletDefinition(portalContext, appName, portletName, params);
        return portletDefinition;
    }

    @Override
    public PortletDefinition createPortletDefinition(PortalContext context, String appName, String portletName, PortletParam params) throws PortalBizException {
        if (context == null || context.getLoginUser() == null || StringUtil.isEmpty((String)appName) || StringUtil.isEmpty((String)portletName) || params == null) {
            throw new PortalBizException("311");
        }
        PortletDefinition portletDefinition = this.portletDefinitionService.copyPortletDefinition(context, appName, portletName, params);
        return portletDefinition;
    }

    @Override
    public void updatePortletDefinition(SimplePortalContext context, String portletDefinitionId, PortletParam params) throws PortalBizException {
        if (StringUtil.isEmpty((String)context.getUserId()) || StringUtil.isEmpty((String)context.getDataCenter()) || StringUtil.isEmpty((String)portletDefinitionId)) {
            throw new PortalBizException("311");
        }
        PortalContext portalContext = SimplePortalContextUtil.buildPortalContext(context);
        this.updatePortletDefinition(portalContext, portletDefinitionId, params);
    }

    @Override
    public void updatePortletDefinition(PortalContext portalContext, String portletDefinitionId, PortletParam params) throws PortalBizException {
        if (portalContext == null || portalContext.getLoginUser() == null || StringUtil.isEmpty((String)portletDefinitionId)) {
            throw new PortalBizException("311");
        }
        PortletDefinition portletDefinition = this.portletDefinitionService.findPortletDefinitionById(portletDefinitionId);
        if (portletDefinition != null) {
            if (params.getDisplayName() != null && !StringUtil.isEmpty((String)params.getDisplayName().toString())) {
                portletDefinition.setDisplayName(params.getDisplayName().toString());
            }
            if (params.getDescription() != null && !StringUtil.isEmpty((String)params.getDescription().toString())) {
                portletDefinition.setDescription(params.getDescription().toString());
            }
            if (params.getPreferences() != null && !StringUtil.isEmpty((String)params.getPreferences().toString())) {
                portletDefinition.setPreferences(params.getPreferences().toString());
            }
            if (!StringUtil.isEmpty((String)params.getCategoryId())) {
                portletDefinition.setCategoryId(params.getCategoryId());
            }
            if (!StringUtil.isEmpty((String)params.getIcon())) {
                portletDefinition.setIcon(params.getIcon());
            }
            if (params.getStatus() != null) {
                portletDefinition.setStatus(params.getStatus());
            }
            if (params.getSupports() != null) {
                portletDefinition.setSupports(params.getSupports().toString());
            }
            if (params.getPortletName() != null) {
                portletDefinition.setPortletName(params.getPortletName().toString());
            }
            this.portletDefinitionService.updatePortlet(portalContext, portletDefinition);
        }
    }

    @Override
    public void deletePortletDefinitionById(SimplePortalContext context, String portletDefinitionId) throws PortalBizException {
        if (StringUtil.isEmpty((String)context.getUserId()) || StringUtil.isEmpty((String)context.getDataCenter()) || StringUtil.isEmpty((String)portletDefinitionId)) {
            throw new PortalBizException("311");
        }
        PortalContext portalContext = SimplePortalContextUtil.buildPortalContext(context);
        this.deletePortletDefinitionById(portalContext, portletDefinitionId);
    }

    @Override
    public void deletePortletDefinitionById(PortalContext portalContext, String portletDefinitionId) throws PortalBizException {
        if (portalContext == null || portalContext.getLoginUser() == null || StringUtil.isEmpty((String)portletDefinitionId)) {
            throw new PortalBizException("311");
        }
        this.portletDefinitionService.delPortletDefinitionById(portalContext, portletDefinitionId);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortletDefinition findPortletDefinitionById(SimplePortalContext context, String portletDefinitionId) throws PortalBizException {
        if (StringUtil.isEmpty((String)context.getUserId()) || StringUtil.isEmpty((String)context.getDataCenter()) || StringUtil.isEmpty((String)portletDefinitionId)) {
            throw new PortalBizException("311");
        }
        PortalContext portalContext = SimplePortalContextUtil.buildPortalContext(context);
        PortletDefinition portletDefinition = this.findPortletDefinitionById(portalContext, portletDefinitionId);
        return portletDefinition;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortletDefinition findPortletDefinitionById(PortalContext portalContext, String portletDefinitionId) throws PortalBizException {
        if (portalContext == null || portalContext.getLoginUser() == null || StringUtil.isEmpty((String)portletDefinitionId)) {
            throw new PortalBizException("311");
        }
        PortletDefinition portletDefinition = this.portletDefinitionService.findPortletDefinitionById(portletDefinitionId);
        return portletDefinition;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletDefinition> findPortletDefinitionList(SimplePortalContext context, String appName, String portletName, DisplayName displayName) throws PortalBizException {
        if (StringUtil.isEmpty((String)context.getUserId()) || StringUtil.isEmpty((String)context.getDataCenter()) || StringUtil.isEmpty((String)appName) || StringUtil.isEmpty((String)portletName)) {
            throw new PortalBizException("311");
        }
        PortalContext portalContext = SimplePortalContextUtil.buildPortalContext(context);
        return this.findPortletDefinitionList(portalContext, appName, portletName, displayName);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletDefinition> findPortletDefinitionList(PortalContext portalContext, String appName, String portletName, DisplayName displayName) throws PortalBizException {
        if (portalContext == null || portalContext.getLoginUser() == null || StringUtil.isEmpty((String)appName) || StringUtil.isEmpty((String)portletName)) {
            throw new PortalBizException("311");
        }
        PortletDefinition portletDefinition = new PortletDefinition();
        portletDefinition.setAppName(appName);
        portletDefinition.setPortletName(portletName);
        portletDefinition.setCopy(true);
        if (displayName != null) {
            portletDefinition.setDisplayName(displayName.toString());
        }
        return this.portletDefinitionService.findPortletDefinitionList(portalContext, portletDefinition);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<PortletDefinition> findPortletDefinitionList(PortalContext context, String appName, String portletName, String displayName, PagingParam pagingParam) throws PortalBizException {
        return this.portletDefinitionService.findCopyPortletList(context, appName, portletName, displayName, pagingParam);
    }

    public PortletDefinitionService getPortletDefinitionService() {
        return this.portletDefinitionService;
    }

    public void setPortletDefinitionService(PortletDefinitionService portletDefinitionService) {
        this.portletDefinitionService = portletDefinitionService;
    }
}

