/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.facade.portal.facade.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.SyncSettingInfo;
import com.kingdee.portal.biz.facade.portal.facade.PortletInstanceServiceFacade;
import com.kingdee.portal.biz.module.page.common.util.PageHelper;
import com.kingdee.portal.biz.module.page.dto.PageModel;
import com.kingdee.portal.biz.module.page.service.OnlineEditPageService;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.entity.PortletInstance;
import com.kingdee.portal.biz.module.portlet.entity.PortletRuntimePreferences;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.common.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PortletInstanceServiceFacadeImpl
implements PortletInstanceServiceFacade {
    private OnlineEditPageService onlineEditPageService;
    private PortletDefinitionService portletDefinitionService;

    @Override
    public void createPortletInstance4User(PortalContext context, String pageId, String userId, String appName, String portletName, PortletParam params) throws PortalBizException {
        if (StringUtil.isEmpty((String)pageId) || StringUtil.isEmpty((String)userId) || StringUtil.isEmpty((String)appName) || StringUtil.isEmpty((String)portletName) || params == null) {
            throw new PortalBizException("311");
        }
        PageModel pageModel = this.onlineEditPageService.buildPageModel(context, pageId, userId);
        int minOrderNum = this.getMinOrderNum(pageModel.getPltInsList());
        PortletDefinition portletDefinition = this.portletDefinitionService.findPortletDefinitionByName(context, appName, portletName);
        Map<String, Object> pltInsMap = this.onlineEditPageService.buildNewPortletInstanceMap(context, pageId, userId, portletDefinition, minOrderNum);
        PortletInstance portletInstance = (PortletInstance)pltInsMap.get("portletInstance");
        if (params.getDisplayName() != null) {
            portletInstance.setDisplayName(params.getDisplayName().toString());
        }
        PortletRuntimePreferences portletRuntimePreferences = (PortletRuntimePreferences)pltInsMap.get("portletRuntimePreferences");
        if (params.getPreferences() != null) {
            portletRuntimePreferences.setPreferences(params.getPreferences().toString());
        }
        pageModel.getPltInsList().add(portletInstance);
        pageModel.getPltRuntimePreferencesList().add(portletRuntimePreferences);
        SyncSettingInfo syncSettingInfo = PageHelper.getCoverSyncSettingInfo();
        this.onlineEditPageService.saveOnlineEditPage(context, pageModel, syncSettingInfo);
    }

    @Override
    public void createPortletInstance4Admin(PortalContext context, String pageId, String appName, String portletName, PortletParam params) throws PortalBizException {
        this.createPortletInstance4User(context, pageId, "portal_template_user", appName, portletName, params);
    }

    private int getMinOrderNum(List<PortletInstance> pltInsList) {
        int minOrderNum = 0;
        if (pltInsList != null) {
            for (PortletInstance pltIns : pltInsList) {
                if (!"c1".equals(pltIns.getArea()) || pltIns.getOrderNum() == null || pltIns.getOrderNum() >= minOrderNum) continue;
                minOrderNum = pltIns.getOrderNum();
            }
        }
        return minOrderNum - 1;
    }

    public OnlineEditPageService getOnlineEditPageService() {
        return this.onlineEditPageService;
    }

    public void setOnlineEditPageService(OnlineEditPageService onlineEditPageService) {
        this.onlineEditPageService = onlineEditPageService;
    }

    public PortletDefinitionService getPortletDefinitionService() {
        return this.portletDefinitionService;
    }

    public void setPortletDefinitionService(PortletDefinitionService portletDefinitionService) {
        this.portletDefinitionService = portletDefinitionService;
    }
}

