/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.facade.portal.facade.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.facade.portal.facade.PubFileServiceFacade;
import com.kingdee.portal.biz.module.pub.common.enums.FileTypeEnum;
import com.kingdee.portal.biz.module.pub.dto.CropModel;
import com.kingdee.portal.biz.module.pub.dto.FileModel;
import com.kingdee.portal.biz.module.pub.entity.PubFile;
import com.kingdee.portal.biz.module.pub.service.PubFileService;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.portal.common.util.ImageUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubFileServiceFacadeImpl
implements PubFileServiceFacade {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private PubFileService pubFileService;

    public void setPubFileService(PubFileService pubFileService) {
        this.pubFileService = pubFileService;
    }

    @Override
    public PubFile create4UploadImg(PortalContext ctx, FileModel fileModel) throws PortalBizException {
        DisplayName displayName = new DisplayName();
        displayName = new DisplayName();
        displayName.setEn(fileModel.getUploadFileName());
        displayName.setZh_CN(fileModel.getUploadFileName());
        displayName.setZh_TW(fileModel.getUploadFileName());
        CropModel cropModel = new CropModel();
        PubFile pubFile = this.pubFileService.createPubFile4Img(ctx, fileModel, cropModel, displayName, FileTypeEnum.UPLOAD_IMG);
        return pubFile;
    }

    @Override
    public void update4UploadImg(PortalContext ctx, FileModel fileModel, String pubFileId) throws PortalBizException {
        DisplayName displayName = new DisplayName();
        displayName = new DisplayName();
        displayName.setEn(fileModel.getUploadFileName());
        displayName.setZh_CN(fileModel.getUploadFileName());
        displayName.setZh_TW(fileModel.getUploadFileName());
        CropModel cropModel = new CropModel();
        PubFile pubFile = this.pubFileService.updatePubFile4Img(ctx, fileModel, cropModel, displayName, FileTypeEnum.UPLOAD_IMG, pubFileId);
    }

    @Override
    public void delete4UploadImgId(PortalContext ctx, String id) throws PortalBizException {
        if (StringUtil.isEmpty((String)id)) {
            this.logger.info("delete4UploadImgId, id is null.");
            return;
        }
        PubFile pubFile = this.pubFileService.findPubFileById(ctx, id);
        if (FileTypeEnum.UPLOAD_IMG.equals((Object)pubFile.getFileType())) {
            this.pubFileService.deletePubFileById(ctx, id);
        } else {
            this.logger.warn("delete4UploadImgId, just UPLOAD_IMG allowed, fileType=" + (Object)((Object)pubFile.getFileType()));
        }
    }

    @Override
    public FileModel findFileModelByPubFileId(PortalContext ctx, String id) throws PortalBizException {
        if (StringUtil.isEmpty((String)id)) {
            this.logger.info("getFileModelByPubFileId, id is null.");
            return null;
        }
        PubFile pubFile = this.pubFileService.findPubFileById(ctx, id);
        try {
            return this.buildFileModel4DB(pubFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public PubFile findByPubFileId(PortalContext ctx, String id) throws PortalBizException {
        if (StringUtil.isEmpty((String)id)) {
            this.logger.info("getFileModelByPubFileId, id is null.");
            return null;
        }
        PubFile pubFile = this.pubFileService.findPubFileById(ctx, id);
        return pubFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileModel buildFileModel4DB(PubFile pubFile) throws FileNotFoundException, IOException {
        String fileSuffix = StringUtil.convNull((String)pubFile.getFileSuffix());
        if (StringUtil.isEmpty((String)fileSuffix)) {
            fileSuffix = ".jpg";
        }
        String fileName = pubFile.getId() + fileSuffix;
        String imgFilePath = this.getTargetDirectory() + fileName;
        byte[] origImgContent = pubFile.getOrigImgContent();
        if (origImgContent == null) {
            origImgContent = pubFile.getContent();
        }
        ImageUtil.writeImgFile((byte[])origImgContent, (String)imgFilePath);
        FileModel fileModel = new FileModel();
        fileModel.setUploadFilePath(imgFilePath);
        fileModel.setUploadFileName(fileName);
        fileModel.setUploadContentType(pubFile.getContentType());
        fileModel.setLength(Long.valueOf(origImgContent.length));
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(new File(imgFilePath));
            BufferedImage image = ImageIO.read(fileInputStream);
            fileModel.setHeight(image.getHeight());
            fileModel.setWidth(image.getWidth());
        }
        return fileModel;
    }

    private String getTargetDirectory() {
        String targetDirectory = Constant.TEMP_UPLOAD_PATH;
        this.logger.debug("upload dir:" + targetDirectory);
        return targetDirectory;
    }
}

