/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.fme.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.module.fme.dao.DocumentIconDao;
import com.kingdee.portal.biz.module.fme.dto.DocumentIconDto;
import com.kingdee.portal.biz.module.fme.entity.DocumentIcon;
import com.kingdee.portal.biz.module.fme.service.DocumentIconService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class DocumentIconServiceImpl
implements DocumentIconService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DocumentIconDao documentIconDao;

    public DocumentIconDao getDocumentIconDao() {
        return this.documentIconDao;
    }

    public void setDocumentIconDao(DocumentIconDao documentIconDao) {
        this.documentIconDao = documentIconDao;
    }

    @Override
    public DocumentIconDto getDocumentIconById(PortalContext cxt, String id) throws Exception {
        DocumentIcon documentIcon = (DocumentIcon)this.documentIconDao.findById(id);
        DocumentIconDto documentIconDto = new DocumentIconDto();
        BeanUtils.copyProperties((Object)documentIconDto, (Object)documentIcon);
        return documentIconDto;
    }

    @Override
    public PagingResult<DocumentIconDto> findDocumentIconDtoList(PortalContext cxt, PagingParam pagingParam) throws Exception {
        DocumentIcon docIcon = new DocumentIcon();
        PagingResult<DocumentIconDto> result = new PagingResult<DocumentIconDto>();
        PagingResult<DocumentIcon> pagingResult = this.documentIconDao.findList(docIcon, pagingParam, null);
        result.setPagingParam(pagingResult.getPagingParam());
        result.setTotalCount(pagingResult.getTotalCount());
        ArrayList<DocumentIconDto> records = new ArrayList<DocumentIconDto>();
        for (DocumentIcon di : pagingResult.getRecords()) {
            DocumentIconDto did = new DocumentIconDto();
            String fileName = di.getIconPath() + di.getIconName();
            BeanUtils.copyProperties((Object)did, (Object)di);
            records.add(did);
        }
        result.setRecords(records);
        return result;
    }

    @Override
    public void saveDocumentIcon(PortalContext cxt, DocumentIconDto docIconDto) throws Exception {
        DocumentIcon sp = new DocumentIcon();
        BeanUtils.copyProperties((Object)sp, (Object)docIconDto);
        if (sp.getId() == null || sp.getId().equals("")) {
            this.documentIconDao.create(sp);
        } else {
            this.documentIconDao.update(sp);
        }
    }

    @Override
    public void deleteDocumentIcon(PortalContext cxt, String ids) throws Exception {
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; ++i) {
            this.documentIconDao.deleteById(id[i]);
        }
    }

    @Override
    public void updateDocumentIconState(PortalContext cxt, String ids, String statu) throws Exception {
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; ++i) {
            DocumentIcon sp = (DocumentIcon)this.documentIconDao.findById(id[i]);
            if (sp == null) {
                throw new Exception("can't find savePath by id=" + id);
            }
            sp.setStatus(statu);
        }
    }

    @Override
    public boolean checkSaveTypeName(PortalContext cxt, String id, String typeName) throws Exception {
        List<Object> list = new ArrayList();
        list = id == null || id.equals("") ? this.documentIconDao.findList(new FieldFilter("docTypeName", "=", typeName)) : this.documentIconDao.findList(new Filter[]{new FieldFilter("id", "<>", id), new FieldFilter("docTypeName", "=", typeName)});
        return list.size() <= 0;
    }

    @Override
    public List<String> getExtName(PortalContext cxt, String id, String docExtName) throws Exception {
        List<Object> list = new ArrayList();
        ArrayList<String> extList = new ArrayList<String>();
        if (id == null || id.equals("")) {
            id = "1";
        }
        list = this.documentIconDao.findList(new FieldFilter("id", "<>", id));
        for (DocumentIcon documentIcon : list) {
            String extNames = documentIcon.getDocExtName();
            String[] ext = extNames.split(";");
            for (int i = 0; i < ext.length; ++i) {
                extList.add(ext[i]);
            }
        }
        return extList;
    }
}

