/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.fme.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEConsoleService;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.module.fme.dao.FtpServerDao;
import com.kingdee.portal.biz.module.fme.dao.SavePathDao;
import com.kingdee.portal.biz.module.fme.dto.SavePathDto;
import com.kingdee.portal.biz.module.fme.entity.FtpServer;
import com.kingdee.portal.biz.module.fme.entity.SavePath;
import com.kingdee.portal.biz.module.fme.service.SavePathService;
import java.util.ArrayList;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class SavePathServiceImpl
implements SavePathService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SavePathDao savePathDao;
    private FtpServerDao ftpServerDao;

    @Override
    public SavePathDto getSavePathById(PortalContext cxt, String id) throws Exception {
        SavePath savePath = (SavePath)this.savePathDao.findById(id);
        SavePathDto spd = new SavePathDto();
        if (savePath != null) {
            BeanUtils.copyProperties((Object)spd, (Object)savePath);
            String serverId = savePath.getServerID();
            FtpServer fs = (FtpServer)this.ftpServerDao.findById(serverId);
            spd.setServerName(fs.getServerName());
        }
        return spd;
    }

    @Override
    public PagingResult<SavePathDto> findSavePathDtoList(PortalContext cxt, PagingParam pagingParam) throws Exception {
        SavePath savePath = new SavePath();
        PagingResult<SavePathDto> result = new PagingResult<SavePathDto>();
        PagingResult<SavePath> pagingResult = this.savePathDao.findList(savePath, pagingParam, null);
        result.setPagingParam(pagingResult.getPagingParam());
        ArrayList<SavePathDto> records = new ArrayList<SavePathDto>();
        for (SavePath sp : pagingResult.getRecords()) {
            SavePathDto spd = new SavePathDto();
            BeanUtils.copyProperties((Object)spd, (Object)sp);
            String serverId = sp.getServerID();
            FtpServer fs = (FtpServer)this.ftpServerDao.findById(serverId);
            if (fs == null) continue;
            spd.setServerName(fs.getServerName());
            records.add(spd);
        }
        result.setTotalCount(records.size());
        result.setRecords(records);
        return result;
    }

    @Override
    public String saveSavepath(Context ctx, SavePathDto savePathDto) throws Exception {
        SavePath sp = new SavePath();
        String result = "0";
        BeanUtils.copyProperties((Object)sp, (Object)savePathDto);
        if (sp.getId() == null || sp.getId().equals("")) {
            this.savePathDao.create(sp);
        } else {
            SavePath savePath = (SavePath)this.savePathDao.findById(sp.getId());
            String oldPath = savePath.getPathName();
            boolean isDocUser = false;
            if ("1".equals(savePathDto.getPathStatus()) && (isDocUser = this.savePathDao.isSavePathUser(ctx, sp.getId()))) {
                return "1";
            }
            boolean existDoc = true;
            if (!oldPath.equals(savePathDto.getPathName())) {
                IFMEConsoleService cs = FMEServiceFactory.getConsoleServiceInstance((Context)ctx);
                existDoc = cs.existDocumentInSavePath(sp.getId());
                if (!existDoc) {
                    this.savePathDao.update(sp);
                } else {
                    result = "2";
                }
            } else {
                this.savePathDao.update(sp);
            }
        }
        return result;
    }

    @Override
    public String deleteSavePath(Context ctx, String ids) throws Exception {
        String[] id = ids.split(",");
        String result = "0";
        IFMEConsoleService cs = FMEServiceFactory.getConsoleServiceInstance((Context)ctx);
        for (int i = 0; i < id.length; ++i) {
            boolean existDoc = true;
            boolean isDocUser = true;
            isDocUser = this.savePathDao.isSavePathUser(ctx, id[i]);
            if (!isDocUser) {
                existDoc = cs.existDocumentInSavePath(id[i]);
                if (!existDoc) {
                    this.savePathDao.deleteById(id[i]);
                    continue;
                }
                result = "1";
                continue;
            }
            result = "2";
        }
        return result;
    }

    @Override
    public boolean updateSavePathState(Context cxt, String ids, String state) throws Exception {
        boolean result = true;
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; ++i) {
            SavePath sp = (SavePath)this.savePathDao.findById(id[i]);
            boolean isDocUser = false;
            if ("1".equals(state) && (isDocUser = this.savePathDao.isSavePathUser(cxt, id[i]))) {
                result = false;
            }
            if (sp != null) {
                if (isDocUser) continue;
                sp.setPathStatus(state);
                continue;
            }
            throw new Exception("can't find savePath by id=" + id);
        }
        return result;
    }

    @Override
    public boolean checkSavePathName(Context cxt, String id, String savePathName) throws Exception {
        return this.savePathDao.checkSavePathName(cxt, id, savePathName);
    }

    public SavePathDao getSavePathDao() {
        return this.savePathDao;
    }

    public void setSavePathDao(SavePathDao savePathDao) {
        this.savePathDao = savePathDao;
    }

    public FtpServerDao getFtpServerDao() {
        return this.ftpServerDao;
    }

    public void setFtpServerDao(FtpServerDao ftpServerDao) {
        this.ftpServerDao = ftpServerDao;
    }
}

