/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.frame.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.module.frame.dao.CommonOrgDAO;
import com.kingdee.portal.biz.module.frame.entity.CommonOrg;
import com.kingdee.portal.biz.module.frame.service.CommonOrgService;
import com.kingdee.portal.biz.module.perm.dto.GroupDTO;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
@Service
public class CommonOrgServiceImpl
implements CommonOrgService {
    @Autowired
    private CommonOrgDAO commonOrgDAO;

    @Override
    public List<GroupDTO> findCommonOrgByUserId(Context ctx, String userId) throws DataAccessException {
        String currentId = null;
        try {
            currentId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT TOP 5 A.FOrgId AS orgId,B.FName_" + ctx.getLocale() + " AS name FROM T_JP_CommonOrg A ");
        sql.append(" LEFT JOIN T_ORG_BaseUnit B ON B.FID=A.FOrgId ");
        sql.append(" WHERE A.FUserId='" + userId + "'");
        if (!StringUtils.isEmpty((String)currentId)) {
            sql.append(" AND A.FOrgId <> '" + currentId + "'");
        }
        sql.append(" ORDER BY A.FTransferCount DESC");
        ArrayList<GroupDTO> list = new ArrayList<GroupDTO>();
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (iRowSet != null) {
                GroupDTO groupDTO = null;
                while (iRowSet.next()) {
                    groupDTO = new GroupDTO();
                    groupDTO.setId(iRowSet.getString("orgId"));
                    groupDTO.setName(iRowSet.getString("name"));
                    list.add(groupDTO);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public CommonOrg findCommonOrgByUserIdOrgId(String userId, String orgId) throws DataAccessException {
        List list = this.commonOrgDAO.findList(new Filter[]{new FieldFilter("userId", "=", userId), new FieldFilter("orgId", "=", orgId)});
        if (list != null && list.size() > 0) {
            return (CommonOrg)list.get(0);
        }
        return null;
    }

    @Override
    public void saveCommonOrg(String userId, String orgId) throws DataAccessException {
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)orgId)) {
            return;
        }
        CommonOrg info = this.findCommonOrgByUserIdOrgId(userId, orgId);
        if (info == null || info.getId() == null) {
            CommonOrg commonOrg = new CommonOrg();
            commonOrg.setTransferCount(1);
            commonOrg.setOrgId(orgId);
            commonOrg.setUserId(userId);
            this.commonOrgDAO.create(commonOrg);
        } else {
            info.setTransferCount(info.getTransferCount() + 1);
            this.commonOrgDAO.update(info);
        }
    }

    @Override
    public void deleteCommonOrg(String userId, String[] ids) throws DataAccessException {
        if (ids == null || ids.length < 1) {
            return;
        }
        this.commonOrgDAO.deleteByIds(ids);
    }

    @Override
    public HashMap<String, Object> findCommonOrgIdsByUserId(Context ctx, String userId) throws DataAccessException {
        HashMap<String, Object> hs = new HashMap<String, Object>();
        HashMap<String, String> orgId = new HashMap<String, String>();
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID,FOrgId FROM T_JP_CommonOrg ");
        sql.append(" WHERE FUserId='" + userId + "'");
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (iRowSet != null) {
                while (iRowSet.next()) {
                    list.add(iRowSet.getString("FOrgId"));
                    orgId.put(iRowSet.getString("FOrgId"), iRowSet.getString("FID"));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        hs.put("0", list);
        hs.put("1", orgId);
        return hs;
    }
}

