/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.frame.service.impl;

import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.frame.dto.PortlalBaseInfoModel;
import com.kingdee.portal.biz.module.frame.service.FrameService;
import com.kingdee.portal.biz.module.page.entity.PageLayoutTmpl;
import com.kingdee.portal.biz.module.page.service.PageIdMapCodeService;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.entity.PortletTheme;
import com.kingdee.portal.biz.module.portlet.entity.PortletTmpl;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.driver.PlutoServices;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class FrameServiceImpl
implements FrameService {
    private static final Logger logger = LoggerFactory.getLogger(FrameServiceImpl.class);
    private PortletDefinitionService portletDefinitionService;
    private PageIdMapCodeService pageIdMapCodeService;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Map<String, Map<String, List<String>>> getPortletEvents(PortalContext portalContext, String portlets) throws PortalBizException {
        if (StringUtil.isEmpty((String)portlets)) {
            throw new PortalBizException("100");
        }
        List<PortletDefinition> portletDefinitionList = this.buildPortletDefinitionList(portlets);
        HashMap<String, Map<String, List<String>>> eventMap = new HashMap<String, Map<String, List<String>>>();
        for (PortletDefinition portlet : portletDefinitionList) {
            String mapKey = portlet.getAppName() + "_" + portlet.getPortletName();
            if (eventMap.containsKey(mapKey)) continue;
            Map<String, List<String>> portletEventMap = this.getSupportedPortletEvent(portlet);
            eventMap.put(mapKey, portletEventMap);
        }
        return eventMap;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortlalBaseInfoModel findPortalBaseDataInfo(PortalContext portalContext) throws PortalBizException {
        try {
            List<PortletDefinition> permPortletDefList;
            PortlalBaseInfoModel portlalBaseInfoModel = new PortlalBaseInfoModel();
            List<PortletTmpl> portletTmplList = PortalCache.getEnabledPortletTmplList();
            portlalBaseInfoModel.setPortletTmplList(portletTmplList);
            List<PortletTheme> portletThemeList = PortalCache.getEnabledPortletThemeList();
            if (portletThemeList != null && !portletThemeList.isEmpty()) {
                ArrayList<String> themeCodeList = new ArrayList<String>(portletThemeList.size());
                for (PortletTheme portletTheme : portletThemeList) {
                    themeCodeList.add(portletTheme.getCode());
                }
                portlalBaseInfoModel.setPortletThemeCodeList(themeCodeList);
            }
            if ((permPortletDefList = this.portletDefinitionService.findEnablePltList(portalContext, portalContext.getLoginUser().getId())) != null) {
                ArrayList<String> permPortletDefIdList = new ArrayList<String>(permPortletDefList.size());
                for (PortletDefinition portletDefinition : permPortletDefList) {
                    permPortletDefIdList.add(portletDefinition.getId());
                }
                portlalBaseInfoModel.setPermPltDefIdList(permPortletDefIdList);
            }
            List<PageLayoutTmpl> pageLayoutTmplList = PortalCache.getEnabledPageLayoutTmplList();
            portlalBaseInfoModel.setPageLayoutTmplList(pageLayoutTmplList);
            String string = PortalCache.getPageIdMapCodeList();
            portlalBaseInfoModel.setPageIdMapCodeList(string);
            return portlalBaseInfoModel;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            throw new PortalBizException("103", ex);
        }
    }

    private List<PortletDefinition> buildPortletDefinitionList(String portlets) {
        String[] _portlets;
        ArrayList<PortletDefinition> portletDefinitionList = new ArrayList<PortletDefinition>();
        for (String portlet : _portlets = portlets.split("\\$")) {
            if (portlet.length() <= 0) continue;
            String[] portletInfo = portlet.split("\\|");
            String appName = portletInfo[0];
            String portletName = portletInfo[1];
            PortletDefinition portletDefinition = new PortletDefinition();
            portletDefinition.setAppName(appName);
            portletDefinition.setPortletName(portletName);
            portletDefinitionList.add(portletDefinition);
        }
        return portletDefinitionList;
    }

    private Map<String, List<String>> getSupportedPortletEvent(PortletDefinition portletDefinition) throws PortalBizException {
        if (portletDefinition == null || portletDefinition.getAppName() == null || portletDefinition.getPortletName() == null) {
            throw new PortalBizException("parameter is error.");
        }
        if (!portletDefinition.getAppName().startsWith("/")) {
            portletDefinition.setAppName("/" + portletDefinition.getAppName());
        }
        HashMap<String, List<String>> eventMap = new HashMap<String, List<String>>();
        ArrayList<String> processingEventList = new ArrayList<String>();
        ArrayList<String> publishingEventList = new ArrayList<String>();
        try {
            org.apache.pluto.container.om.portlet.PortletDefinition portlet = PlutoServices.getServices().getPortletRegistryService().getPortlet(portletDefinition.getAppName(), portletDefinition.getPortletName());
            List processingEvents = portlet.getSupportedProcessingEvents();
            for (EventDefinitionReference event : processingEvents) {
                processingEventList.add(event.getName());
            }
            List publishingEvents = portlet.getSupportedPublishingEvents();
            for (EventDefinitionReference event : publishingEvents) {
                publishingEventList.add(event.getName());
            }
        }
        catch (PortletContainerException ex) {
            throw new PortalBizException(ex.getMessage());
        }
        eventMap.put("processingEventList", processingEventList);
        eventMap.put("publishingEventList", publishingEventList);
        return eventMap;
    }

    public void setPortletDefinitionService(PortletDefinitionService portletDefinitionService) {
        this.portletDefinitionService = portletDefinitionService;
    }

    public void setPageIdMapCodeService(PageIdMapCodeService pageIdMapCodeService) {
        this.pageIdMapCodeService = pageIdMapCodeService;
    }
}

