/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.frame.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.frame.dao.PortalCacheFlagDAO;
import com.kingdee.portal.biz.module.frame.entity.PortalCacheFlag;
import com.kingdee.portal.biz.module.frame.service.PortalCacheFlagService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalCacheFlagServiceImpl
implements PortalCacheFlagService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PortalCacheFlagDAO portalCacheFlagDAO;

    @Override
    public PortalCacheFlag findPortalCacheFlagByUserId(PortalContext ctx, String userId) throws PortalBizException {
        PortalCacheFlag pcFlag = null;
        try {
            pcFlag = (PortalCacheFlag)this.portalCacheFlagDAO.findObject(new FieldFilter("userId", "=", userId));
            if (pcFlag == null) {
                pcFlag = this.createPortalCacheFlag(ctx, userId);
            }
        }
        catch (DataAccessException e) {
            this.logger.error("findPortalCacheFlagByUserId error ==", (Throwable)e);
        }
        return pcFlag;
    }

    @Override
    public PortalCacheFlag createPortalCacheFlag(PortalContext ctx, String userId) throws PortalBizException {
        PortalCacheFlag pcFlag = new PortalCacheFlag();
        try {
            pcFlag.setUserId(userId);
            pcFlag.setClientFlag(true);
            pcFlag.setOaFlag(true);
            pcFlag.setPageFlag(true);
            pcFlag.setShrFlag(true);
            pcFlag = this.portalCacheFlagDAO.create(pcFlag);
        }
        catch (DataAccessException e) {
            this.logger.error("createPortalCacheFlag error ==", (Throwable)e);
        }
        return pcFlag;
    }

    @Override
    public boolean updateClientCacheFlag(PortalContext ctx, String userId, boolean bl) throws PortalBizException {
        boolean result = false;
        try {
            PortalCacheFlag pcFlag = (PortalCacheFlag)this.portalCacheFlagDAO.findObject(new FieldFilter("userId", "=", userId));
            if (pcFlag != null) {
                pcFlag.setClientFlag(bl);
                pcFlag = this.portalCacheFlagDAO.update(pcFlag);
                result = true;
            }
        }
        catch (DataAccessException e) {
            this.logger.error("setHasRefreshClientCache error ==", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean updateOACacheFlag(PortalContext ctx, String userId, boolean bl) throws PortalBizException {
        boolean result = false;
        try {
            PortalCacheFlag pcFlag = (PortalCacheFlag)this.portalCacheFlagDAO.findObject(new FieldFilter("userId", "=", userId));
            if (pcFlag != null) {
                pcFlag.setOaFlag(bl);
                pcFlag = this.portalCacheFlagDAO.update(pcFlag);
                result = true;
            }
        }
        catch (DataAccessException e) {
            this.logger.error("setHasRefreshOACache error ==", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean updateSHRCacheFlag(PortalContext ctx, String userId, boolean bl) throws PortalBizException {
        boolean result = false;
        try {
            PortalCacheFlag pcFlag = (PortalCacheFlag)this.portalCacheFlagDAO.findObject(new FieldFilter("userId", "=", userId));
            if (pcFlag != null) {
                pcFlag.setShrFlag(bl);
                pcFlag = this.portalCacheFlagDAO.update(pcFlag);
                result = true;
            }
        }
        catch (DataAccessException e) {
            this.logger.error("setHasRefreshOACache error ==", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean updatePageCacheFlag(PortalContext ctx, String userId, boolean bl) throws PortalBizException {
        boolean result = false;
        try {
            PortalCacheFlag pcFlag = (PortalCacheFlag)this.portalCacheFlagDAO.findObject(new FieldFilter("userId", "=", userId));
            if (pcFlag != null) {
                pcFlag.setPageFlag(bl);
                pcFlag = this.portalCacheFlagDAO.update(pcFlag);
                result = true;
            }
        }
        catch (DataAccessException e) {
            this.logger.error("setHasRefreshPageCache error ==", (Throwable)e);
        }
        return result;
    }

    public void setPortalCacheFlagDAO(PortalCacheFlagDAO portalCacheFlagDAO) {
        this.portalCacheFlagDAO = portalCacheFlagDAO;
    }
}

