/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.frame.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.taskmng.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.frame.dao.QuickStartMenuDao;
import com.kingdee.portal.biz.module.frame.entity.QuickStartMenu;
import com.kingdee.portal.biz.module.frame.enums.QuickStartTypeEnum;
import com.kingdee.portal.biz.module.frame.service.QuickStartMenuService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class QuickStartMenuServiceImpl
implements QuickStartMenuService {
    private static final Logger logger = LoggerFactory.getLogger(QuickStartMenuServiceImpl.class);
    private QuickStartMenuDao quickStartMenuDAO;

    @Override
    public List<QuickStartMenu> getAllMenuByPortetInsID(String insID) throws PortalBizException {
        try {
            return this.getQuickStartMenuDAO().findList(new Filter[]{new FieldFilter("portletInstanceId", "=", insID), new OrderFilter("order", OrderEnum.ASC)});
        }
        catch (DataAccessException e) {
            throw new PortalBizException("findQuickStartMenu error", e);
        }
    }

    @Override
    public void addList(List<QuickStartMenu> list) throws PortalBizException {
        try {
            this.getQuickStartMenuDAO().create(list);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("addQuickStartMenu error", e);
        }
    }

    @Override
    public void deleteById(String id) throws PortalBizException {
        try {
            this.getQuickStartMenuDAO().deleteById(id);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("addQuickStartMenu error", e);
        }
    }

    public QuickStartMenuDao getQuickStartMenuDAO() {
        return this.quickStartMenuDAO;
    }

    public void setQuickStartMenuDAO(QuickStartMenuDao quickStartMenuDAO) {
        this.quickStartMenuDAO = quickStartMenuDAO;
    }

    @Override
    public void managerQuickStartMenu(PortalContext ctx, String insId, String[] toAdd, String[] toDel) throws PortalBizException {
        try {
            if (toDel.length > 0) {
                this.deleteByInsAndMenuIds(ctx, insId, toDel);
            }
            ArrayList<QuickStartMenu> list = new ArrayList<QuickStartMenu>();
            int order = 0;
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            String sql = "select max(forder) from T_JP_QuickStartMenu where FPortletInstanceId=?";
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)sql, (Object[])new Object[]{insId});
            order = rs.next() ? rs.getInt(1) + 1 : 0;
            for (String menuId : toAdd) {
                if (StringUtil.isEmpty((String)menuId)) continue;
                QuickStartMenu tmp = new QuickStartMenu();
                tmp.setPortletInstanceId(insId);
                tmp.setMenuID(menuId);
                tmp.setOrder(order);
                tmp.setType(QuickStartTypeEnum.MENU);
                tmp.setPortalContext(ctx);
                list.add(tmp);
                ++order;
            }
            if (list.size() > 0) {
                this.addList(list);
            }
        }
        catch (Exception e) {
            throw new PortalBizException("addQuickStartMenu error", e);
        }
    }

    @Override
    public void deleteByInsAndMenuIds(PortalContext ctx, String insId, String[] menuId) throws PortalBizException {
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            String sql = "delete from T_JP_QuickStartMenu where FPortletInstanceId=? and FMenuID=?";
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (String menu : menuId) {
                params.add(new Object[]{insId, menu});
            }
            DbUtil.executeBatch((Context)context, (String)sql, params);
        }
        catch (Exception e) {
            throw new PortalBizException("deleteQuickStartMenu error", e);
        }
    }

    @Override
    public List<QuickStartMenu> getMenuByID(String[] ids) throws PortalBizException {
        try {
            return this.getQuickStartMenuDAO().findListByIds(ids);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("addQuickStartMenu error", e);
        }
    }

    @Override
    public void deleteByInsId(PortalContext ctx, String insId) throws PortalBizException {
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            String sql = "delete from T_JP_QuickStartMenu where FPortletInstanceId=?";
            DbUtil.execute((Context)context, (String)sql, (Object[])new Object[]{insId});
        }
        catch (Exception e) {
            throw new PortalBizException("deleteQuickStartMenu error", e);
        }
    }

    @Override
    public void resetByList(PortalContext ctx, String insId, List<QuickStartMenu> list) throws PortalBizException {
        try {
            this.deleteByInsId(ctx, insId);
            this.addList(list);
        }
        catch (Exception e) {
            throw new PortalBizException("addQuickStartMenu error", e);
        }
    }
}

