/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.page.dao.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.impl.BaseDAOImpl;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.json.SyncSettingInfo;
import com.kingdee.portal.biz.module.page.common.enums.PageStatusEnum;
import com.kingdee.portal.biz.module.page.dao.PageCacheDAO;
import com.kingdee.portal.biz.module.page.entity.PageCache;
import com.kingdee.portal.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PageCacheDAOImpl
extends BaseDAOImpl<PageCache>
implements PageCacheDAO {
    private static String jpql_findPageCacheList = "select t from PageCache t where t.pageId = '{pageId}' AND t.userId IN ({userIds}) ORDER BY createTime DESC";
    private static String jpql_deletePageCacheList = "delete from PageCache where userId = '{userId}' AND pageId IN ({pageIdIds})";
    private static String jpql_disablePersonalPageCache = "UPDATE PageCache SET status = :status , syncSettingInfo = :syncSettingInfo  WHERE pageId = :pageId AND userId != :userId";
    private static String jpql_enablePersonalPageCache = "UPDATE PageCache SET status = :status WHERE pageId = :pageId AND userId = :userId ";
    private static String jpql_refreshPersonalPageBaseInfo = "UPDATE PageCache SET status = :status , syncSettingInfo = :syncSettingInfo  WHERE pageId = :pageId AND userId != :userId AND status != :status ";

    @Override
    public List<PageCache> findPageCacheList(PortalContext ctx, String pageId, String[] userIds) throws DataAccessException {
        ArrayList<PageCache> resultList = new ArrayList<PageCache>();
        StringBuffer sql = new StringBuffer(100);
        if (userIds == null || userIds.length <= 0) {
            return resultList;
        }
        sql.append(" select * From T_JP_PageCache t ");
        sql.append(" where t.FpageId = ? AND t.FuserId IN ");
        sql.append(" (?");
        for (int i = 1; i < userIds.length; ++i) {
            sql.append(",?");
        }
        sql.append(") ORDER BY FcreateTime DESC ");
        ArrayList<String> userList = new ArrayList<String>();
        Collections.addAll(userList, userIds);
        userList.add(0, pageId);
        Object[] strs = userList.toArray();
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (Object[])strs);
            if (dataSet == null) {
                return null;
            }
            while (dataSet.next()) {
                PageCache pc = new PageCache();
                pc.setPageId(dataSet.getString("FPageId"));
                pc.setUserId(dataSet.getString("FUserId"));
                pc.setPageInfo(dataSet.getString("FPageInfo"));
                pc.setPortletList(dataSet.getString("FPortletList"));
                String FStatus = dataSet.getString("FStatus");
                if (FStatus != null && "OVERDUE".equalsIgnoreCase(FStatus)) {
                    pc.setStatus(PageStatusEnum.OVERDUE);
                } else if (FStatus != null && "ENABLE".equals(FStatus)) {
                    pc.setStatus(PageStatusEnum.ENABLE);
                } else if (FStatus != null && "FIRST_LOAD".equals(FStatus)) {
                    pc.setStatus(PageStatusEnum.FIRST_LOAD);
                } else {
                    pc.setStatus(null);
                }
                pc.setSyncSettingInfo(dataSet.getString("FSyncSettingInfo"));
                resultList.add(pc);
            }
        }
        catch (Exception e) {
            this.logger.error("sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return resultList;
    }

    @Override
    public int deletePageCacheList(String[] pageIds, String userId) throws DataAccessException {
        StringBuilder builder = new StringBuilder("''");
        if (pageIds != null) {
            for (String id : pageIds) {
                if (id.equals("")) continue;
                if (id.startsWith("'")) {
                    builder.append(",").append(id).append("");
                    continue;
                }
                builder.append(",'").append(id).append("'");
            }
        }
        String jpql = StringUtil.merge((String)jpql_deletePageCacheList, (String[])new String[]{userId, builder.toString()});
        return this.executeUpdate(jpql, new Object[0]);
    }

    @Override
    public int disablePersonalPageCache(String pageId, SyncSettingInfo syncSettingInfo) throws DataAccessException {
        return this.executeUpdate(jpql_disablePersonalPageCache, new Object[]{PageStatusEnum.OVERDUE, syncSettingInfo == null ? "" : syncSettingInfo.toString(), pageId, "portal_template_user"});
    }

    @Override
    public int enablePersonalPageCache(String pageId, String userId) throws DataAccessException {
        return this.executeUpdate(jpql_enablePersonalPageCache, new Object[]{PageStatusEnum.ENABLE, pageId, userId});
    }

    @Override
    public int refreshPersonalPageBaseInfo(String pageId, SyncSettingInfo syncSettingInfo) throws DataAccessException {
        return this.executeUpdate(jpql_refreshPersonalPageBaseInfo, new Object[]{PageStatusEnum.OVERDUE, syncSettingInfo.toString(), pageId, "portal_template_user", PageStatusEnum.OVERDUE});
    }
}

