/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.page.dao.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.BaseDAOImpl;
import com.kingdee.portal.biz.common.enums.OrgFilterTypeEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.dao.PageDAO;
import com.kingdee.portal.biz.module.page.dto.SearchAllDTO;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Query;

public class PageDAOImpl
extends BaseDAOImpl<Page>
implements PageDAO {
    private static String jpql_deleteByParent = "delete from Page t where t.nodePath like :nodePath";
    private static String jpql_updateNodePath = "update Page t set t.nodePath = replace(t.nodePath, :oldValue, :newValue),t.nodeLevel=nodeLevel+(:sortLevel) where t.nodePath like :parentPath";
    private static String jpql_findByNodePath = "select t from Page t where t.nodePath like :nodePath";

    @Override
    public int deleteByNodePath(String nodePath) throws DataAccessException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("nodePath", nodePath + "%");
        return this.executeUpdate(jpql_deleteByParent, param);
    }

    @Override
    public List<Page> findSubIdsByNodePath(String nodePath) throws DataAccessException {
        String sql = "SELECT t FROM {entityClassName} t WHERE t.nodePath like '{nodePath}'";
        String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName(), nodePath + "%"});
        return this.findList(jpql, new Object[0]);
    }

    @Override
    public int updateNodePath(String parentPath, String newPath, int sortLevel) throws DataAccessException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("oldValue", parentPath);
        param.put("newValue", newPath);
        param.put("parentPath", parentPath + "%");
        param.put("sortLevel", sortLevel);
        return this.executeUpdate(jpql_updateNodePath, param);
    }

    @Override
    public List<Page> findPermPageListByPageIds(String[] pageIds) throws DataAccessException {
        try {
            String sql = "SELECT t FROM {entityClassName} t WHERE t.id IN ({ids}) order by nodeLevel,nodeOrder,createTime asc";
            StringBuilder builder = new StringBuilder(100);
            builder.append("''");
            if (pageIds != null) {
                for (String id : pageIds) {
                    if (StringUtil.isEmpty((String)id)) continue;
                    builder.append(",'").append(id).append("'");
                }
            }
            String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName(), builder.toString()});
            return this.findList(jpql, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public List<Page> findPageListByIdsAndOrder(PortalContext ctx, String[] ids, OrderEnum order) throws DataAccessException {
        try {
            String sql = "SELECT t FROM {entityClassName} t WHERE t.id IN (:id ) order by nodeOrder {order}";
            String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName(), order.name()});
            HashSet<String> idSet = new HashSet<String>();
            for (String id : ids) {
                idSet.add(id);
            }
            Object[] param = new Object[]{idSet};
            return this.findList(jpql, param);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public int findMaxNodeLevelById(String id) throws DataAccessException {
        try {
            String sql = "SELECT max(nodeOrder) FROM {entityClassName} t WHERE t.parentNodeId = :id";
            String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName(), id});
            Query query = this.em.createQuery(jpql);
            query.setFirstResult(0);
            query.setMaxResults(Integer.MAX_VALUE);
            return (Integer)query.getSingleResult();
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public List<SearchAllDTO> searchPageListByKeyNew(PortalContext ctx, String bizNodePath, String keyWord, String type) throws DataAccessException {
        keyWord = keyWord.toLowerCase();
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String sql = "";
        String dbType = (String)context.get((Object)"dbType");
        this.logger.info(" searchPageListByKey dbType===" + dbType);
        if (StringUtils.isEmpty((String)type)) {
            type = OrgFilterTypeEnum.NO_FILTER.toString();
        }
        if (OrgFilterTypeEnum.NO_FILTER.toString().equalsIgnoreCase(type)) {
            sql = this.extractedNoFilter(dbType);
        } else if (OrgFilterTypeEnum.CU.toString().equalsIgnoreCase(type)) {
            sql = this.extractedCU(context, dbType);
        } else if (OrgFilterTypeEnum.ORG_RANGE.toString().equalsIgnoreCase(type)) {
            sql = UserType.SYSTEM.equals((Object)ContextUtil.getCurrentUserInfo((Context)context).getType()) ? this.extractedCU(context, dbType) : this.extractedOrgRange(context, dbType);
        }
        ArrayList<SearchAllDTO> resultList = new ArrayList<SearchAllDTO>();
        try {
            sql = "/*dialect*/ " + sql;
            Object[] params = new String[10];
            for (int i = 0; i < 10; ++i) {
                params[i] = i == 0 ? bizNodePath : keyWord;
            }
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql, (Object[])params);
            while (dataSet.next()) {
                SearchAllDTO se = new SearchAllDTO();
                se.setId(dataSet.getString("FID"));
                se.setDisplayName(dataSet.getString("FDISPLAYNAME"));
                se.setIcon(dataSet.getString("FICON"));
                se.setType(dataSet.getString("TYPE"));
                se.setPermEditCtrl(dataSet.getString("FPERMEDITCTRL"));
                se.setPermViewCtrl(dataSet.getString("FPERMVIEWCTRL"));
                se.setNodeType(dataSet.getString("FNODETYPE"));
                se.setNodeExt(dataSet.getString("FNODEEXT"));
                se.setPreferences(dataSet.getString("FPREFERENCES"));
                se.setCanAddFav(dataSet.getString("FCANADDFAV"));
                resultList.add(se);
            }
        }
        catch (Exception e) {
            this.logger.error(" searchPageListByKey sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return resultList;
    }

    private String extractedNoFilter(String dbType) {
        String sql = "Oracle".equals(dbType) ? this.getOracleSearchSql() : ("MS SQL Server".equals(dbType) ? this.getMsSearchSql() : ("PostgreSQL".equals(dbType) || "PostgresSQL".equals(dbType) ? this.getPGSearchSql() : ("DB2 UDB".equals(dbType) ? this.getDB2SearchSql() : ("Kingbase".equals(dbType) ? this.getPGSearchSql() : ("DM".equals(dbType) ? this.getDmSearchSql() : this.getDB2SearchSql())))));
        return sql;
    }

    private String extractedCU(Context ctx, String dbType) {
        String sql = "Oracle".equals(dbType) ? this.getOracleSearchSqlByCU(ctx) : ("MS SQL Server".equals(dbType) ? this.getMsSearchSqlByCU(ctx) : ("PostgreSQL".equals(dbType) || "PostgresSQL".equals(dbType) ? this.getPGSearchSqlByCU(ctx) : ("DB2 UDB".equals(dbType) ? this.getDB2SearchSqlByCU(ctx) : ("Kingbase".equals(dbType) ? this.getPGSearchSqlByCU(ctx) : ("DM".equals(dbType) ? this.getDmSearchSqlByCU(ctx) : this.getOracleSearchSqlByCU(ctx))))));
        return sql;
    }

    private String extractedOrgRange(Context ctx, String dbType) {
        String sql = "Oracle".equals(dbType) ? this.getOracleSearchSqlByOrgRange(ctx) : ("MS SQL Server".equals(dbType) ? this.getMsSearchSqlByOrgRange(ctx) : ("PostgreSQL".equals(dbType) || "PostgresSQL".equals(dbType) ? this.getPGSearchSqlByOrgRange(ctx) : ("DB2 UDB".equals(dbType) ? this.getDB2SearchSqlByOrgRange(ctx) : ("Kingbase".equals(dbType) ? this.getPGSearchSqlByOrgRange(ctx) : ("DM".equals(dbType) ? this.getDmSearchSqlByOrgRange(ctx) : this.getOracleSearchSqlByOrgRange(ctx))))));
        return sql;
    }

    @Override
    public List<SearchAllDTO> searchPageListByKey(PortalContext ctx, String bizNodePath, String keyWord) throws DataAccessException {
        keyWord = keyWord.toLowerCase();
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String sql = "";
        String dbType = (String)context.get((Object)"dbType");
        this.logger.info(" searchPageListByKey dbType===" + dbType);
        sql = this.extractedNoFilter(dbType);
        ArrayList<SearchAllDTO> resultList = new ArrayList<SearchAllDTO>();
        try {
            sql = "/*dialect*/ " + sql;
            Object[] params = new String[10];
            for (int i = 0; i < 10; ++i) {
                params[i] = i == 0 ? bizNodePath : keyWord;
            }
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql, (Object[])params);
            while (dataSet.next()) {
                SearchAllDTO se = new SearchAllDTO();
                se.setId(dataSet.getString("FID"));
                se.setDisplayName(dataSet.getString("FDISPLAYNAME"));
                se.setIcon(dataSet.getString("FICON"));
                se.setType(dataSet.getString("TYPE"));
                se.setPermEditCtrl(dataSet.getString("FPERMEDITCTRL"));
                se.setPermViewCtrl(dataSet.getString("FPERMVIEWCTRL"));
                se.setNodeType(dataSet.getString("FNODETYPE"));
                se.setNodeExt(dataSet.getString("FNODEEXT"));
                se.setPreferences(dataSet.getString("FPREFERENCES"));
                se.setCanAddFav(dataSet.getString("FCANADDFAV"));
                resultList.add(se);
            }
        }
        catch (Exception e) {
            this.logger.error(" searchPageListByKey sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return resultList;
    }

    private String getPGSearchSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" to_char(t.FpermEditCtrl) as FPERMEDITCTRL ,to_char(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page'::character varying as type ,t.FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%\"leaf\":true%' or t.FnodeExt like '%\"leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath || '%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where  B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append("   ) as a");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0'::character varying as FpermEditCtrl,'0'::character varying as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service'::character varying as type  ,1 as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where  t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append("  order by t.FdisplayName,t.FcreateTime asc limit 5");
        sql.append(" )    as b       ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append(" select t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case  when t.FName_L3 is null then TO_CHAR('') else t.FName_L3 end || '\",\"zh_CN\":\"' || case  when t.FName_L2 is null then TO_CHAR('') else t.FName_L2 end || '\",\"en\":\"' || case  when t.FName_L1 is null then TO_CHAR('') else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  ''::character varying as fnodeExt, ''::character varying as fnodeType, ''::character varying as fpreferences, ");
        sql.append("   '0'::character varying as FpermEditCtrl,'0'::character varying as FpermViewCtrl, ");
        sql.append(" ''::character varying as FICON , 'person'::character varying  as type  ,1 as FCanAddFav ");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append("   where   (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ?||'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" order by t.FNAME_L2 asc limit 5");
        sql.append(" )  as c");
        return sql.toString();
    }

    private String getOracleSearchSqlByCU(Context ctx) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" to_char(t.FpermEditCtrl) as FPERMEDITCTRL ,to_char(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page' as type ,t.FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%\"leaf\":true%' or t.FnodeExt like '%\"leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath || '%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append("   )");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type  ,1 as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append("  and rownum<=5");
        sql.append("  order by t.FdisplayName,t.FcreateTime asc");
        sql.append(" )           ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("select distinct * from (");
        sql.append(" select t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case  when t.FName_L3 is null then TO_NCHAR('') else t.FName_L3 end || '\",\"zh_CN\":\"' || case  when t.FName_L2 is null then TO_NCHAR('') else t.FName_L2 end || '\",\"en\":\"' || case  when t.FName_L1 is null then TO_NCHAR('') else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type  ,1 as FCanAddFav ");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append(",T_ORG_PositionMember  POSITIONMEMBER, T_ORG_Position  POSITION , T_ORG_Admin  ADMINORGUNIT , T_ORG_CtrlUnit  CU2 , T_PM_OrgRange  ORGRANGE , T_PM_User  u");
        sql.append("   where 1=1 ");
        sql.append(" and  POSITIONMEMBER.FPersonID   = t.fid");
        sql.append(" and POSITIONMEMBER.FPositionID = POSITION.FID");
        sql.append(" and  POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        sql.append(" and ADMINORGUNIT.FControlUnitID = CU2.FID");
        sql.append(" and ADMINORGUNIT.FID = ORGRANGE.FOrgID");
        sql.append(" and ORGRANGE.FUserID = u.FID");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ?||'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        sql.append(" and CU2.fid = '" + orgId + "'");
        sql.append(" order by t.FNAME_L2 asc ");
        sql.append(" )  ");
        sql.append(") where rownum<=5");
        return sql.toString();
    }

    private String getDmSearchSqlByCU(Context ctx) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" to_char(t.FpermEditCtrl) as FPERMEDITCTRL ,to_char(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page' as type ,t.FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%\"leaf\":true%' or t.FnodeExt like '%\"leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath || '%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append("   )");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type  ,1 as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append("  and rownum<=5");
        sql.append("  order by t.FdisplayName,t.FcreateTime asc");
        sql.append(" )           ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("select distinct * from (");
        sql.append(" select t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case  when t.FName_L3 is null then TO_CHAR('') else t.FName_L3 end || '\",\"zh_CN\":\"' || case  when t.FName_L2 is null then TO_CHAR('') else t.FName_L2 end || '\",\"en\":\"' || case  when t.FName_L1 is null then TO_CHAR('') else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type  ,1 as FCanAddFav ");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append(",T_ORG_PositionMember  POSITIONMEMBER, T_ORG_Position  POSITION , T_ORG_Admin  ADMINORGUNIT , T_ORG_CtrlUnit  CU2 , T_PM_OrgRange  ORGRANGE , T_PM_User  u");
        sql.append("   where 1=1 ");
        sql.append(" and  POSITIONMEMBER.FPersonID   = t.fid");
        sql.append(" and POSITIONMEMBER.FPositionID = POSITION.FID");
        sql.append(" and  POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        sql.append(" and ADMINORGUNIT.FControlUnitID = CU2.FID");
        sql.append(" and ADMINORGUNIT.FID = ORGRANGE.FOrgID");
        sql.append(" and ORGRANGE.FUserID = u.FID");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ?||'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        sql.append(" and CU2.fid = '" + orgId + "'");
        sql.append(" order by t.FNAME_L2 asc ");
        sql.append(" )  ");
        sql.append(") where rownum<=5");
        return sql.toString();
    }

    private String getOracleSearchSqlByOrgRange(Context ctx) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" to_char(t.FpermEditCtrl) as FPERMEDITCTRL ,to_char(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page' as type ,t.FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%\"leaf\":true%' or t.FnodeExt like '%\"leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath || '%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append("   )");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type  ,1 as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append("  and rownum<=5");
        sql.append("  order by t.FdisplayName,t.FcreateTime asc");
        sql.append(" )           ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("select distinct * from (");
        sql.append(" select t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case  when t.FName_L3 is null then TO_NCHAR('') else t.FName_L3 end || '\",\"zh_CN\":\"' || case  when t.FName_L2 is null then TO_NCHAR('') else t.FName_L2 end || '\",\"en\":\"' || case  when t.FName_L1 is null then TO_NCHAR('') else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type  ,1 as FCanAddFav ");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append(",T_ORG_PositionMember  POSITIONMEMBER, T_ORG_Position  POSITION , T_ORG_Admin  ADMINORGUNIT , T_ORG_CtrlUnit  CU2 , T_PM_OrgRange  ORGRANGE , T_PM_User  u");
        sql.append("   where 1=1 ");
        sql.append(" and  POSITIONMEMBER.FPersonID   = t.fid");
        sql.append(" and POSITIONMEMBER.FPositionID = POSITION.FID");
        sql.append(" and  POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        sql.append(" and ADMINORGUNIT.FControlUnitID = CU2.FID");
        sql.append(" and ADMINORGUNIT.FID = ORGRANGE.FOrgID");
        sql.append(" and ORGRANGE.FUserID = u.FID");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ?||'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        sql.append(" and u.fid='" + userId + "' and ORGRANGE.ftype=20");
        sql.append(" order by t.FNAME_L2 asc ");
        sql.append(" )  ");
        sql.append(") where rownum<=5");
        return sql.toString();
    }

    private String getDmSearchSqlByOrgRange(Context ctx) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" to_char(t.FpermEditCtrl) as FPERMEDITCTRL ,to_char(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page' as type ,t.FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%\"leaf\":true%' or t.FnodeExt like '%\"leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath || '%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append("   )");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type  ,1 as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append("  and rownum<=5");
        sql.append("  order by t.FdisplayName,t.FcreateTime asc");
        sql.append(" )           ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("select distinct * from (");
        sql.append(" select t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case  when t.FName_L3 is null then TO_CHAR('') else t.FName_L3 end || '\",\"zh_CN\":\"' || case  when t.FName_L2 is null then TO_CHAR('') else t.FName_L2 end || '\",\"en\":\"' || case  when t.FName_L1 is null then TO_CHAR('') else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type  ,1 as FCanAddFav ");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append(",T_ORG_PositionMember  POSITIONMEMBER, T_ORG_Position  POSITION , T_ORG_Admin  ADMINORGUNIT , T_ORG_CtrlUnit  CU2 , T_PM_OrgRange  ORGRANGE , T_PM_User  u");
        sql.append("   where 1=1 ");
        sql.append(" and  POSITIONMEMBER.FPersonID   = t.fid");
        sql.append(" and POSITIONMEMBER.FPositionID = POSITION.FID");
        sql.append(" and  POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        sql.append(" and ADMINORGUNIT.FControlUnitID = CU2.FID");
        sql.append(" and ADMINORGUNIT.FID = ORGRANGE.FOrgID");
        sql.append(" and ORGRANGE.FUserID = u.FID");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ?||'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        sql.append(" and u.fid='" + userId + "' and ORGRANGE.ftype=20");
        sql.append(" order by t.FNAME_L2 asc ");
        sql.append(" )  ");
        sql.append(") where rownum<=5");
        return sql.toString();
    }

    private String getMsSearchSqlByCU(Context ctx) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" t.FpermEditCtrl,t.FpermViewCtrl, ");
        sql.append("  t.FICON ,'page' as type ,t.FCanAddFav  ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''+?+'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%leaf\":true%' or t.FnodeExt like '%leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath+'%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'+?+'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'+?+'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'+?+'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append(" union all   ");
        sql.append("  SELECT top 5  t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type ,'1' as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'+?+'%'");
        sql.append(" union all   ");
        sql.append(" select top 5 * from (");
        sql.append(" select distinct t.FID,");
        sql.append(" '{\"zh_TW\":\"'+case  when t.FName_L3 is null then '' else t.FName_L3 end+'\",\"zh_CN\":\"'+case  when t.FName_L2 is null then '' else t.FName_L2 end+'\",\"en\":\"'+case  when t.FName_L1 is null then '' else t.FName_L1 end+'\"}'  as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type ,'1' as FCanAddFav");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append(",T_ORG_PositionMember  POSITIONMEMBER, T_ORG_Position  POSITION , T_ORG_Admin  ADMINORGUNIT , T_ORG_CtrlUnit  CU2 , T_PM_OrgRange  ORGRANGE , T_PM_User  u");
        sql.append("   where 1=1 ");
        sql.append(" and  POSITIONMEMBER.FPersonID   = t.fid");
        sql.append(" and POSITIONMEMBER.FPositionID = POSITION.FID");
        sql.append(" and  POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        sql.append(" and ADMINORGUNIT.FControlUnitID = CU2.FID");
        sql.append(" and ADMINORGUNIT.FID = ORGRANGE.FOrgID");
        sql.append(" and ORGRANGE.FUserID = u.FID");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'+?+'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'+?+'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'+?+'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ''+?+'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ''+?+'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        sql.append(" and CU2.fid = '" + orgId + "'");
        sql.append(" ) temp");
        return sql.toString();
    }

    private String getMsSearchSqlByOrgRange(Context ctx) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" t.FpermEditCtrl,t.FpermViewCtrl, ");
        sql.append("  t.FICON ,'page' as type ,t.FCanAddFav  ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''+?+'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%leaf\":true%' or t.FnodeExt like '%leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath+'%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'+?+'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'+?+'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'+?+'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append(" union all   ");
        sql.append("  SELECT top 5  t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type ,'1' as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'+?+'%'");
        sql.append(" union all   ");
        sql.append(" select top 5 * from (");
        sql.append(" select distinct t.FID,");
        sql.append(" '{\"zh_TW\":\"'+case  when t.FName_L3 is null then '' else t.FName_L3 end+'\",\"zh_CN\":\"'+case  when t.FName_L2 is null then '' else t.FName_L2 end+'\",\"en\":\"'+case  when t.FName_L1 is null then '' else t.FName_L1 end+'\"}'  as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type ,'1' as FCanAddFav");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append(",T_ORG_PositionMember  POSITIONMEMBER, T_ORG_Position  POSITION , T_ORG_Admin  ADMINORGUNIT , T_ORG_CtrlUnit  CU2 , T_PM_OrgRange  ORGRANGE , T_PM_User  u");
        sql.append("   where 1=1 ");
        sql.append(" and  POSITIONMEMBER.FPersonID   = t.fid");
        sql.append(" and POSITIONMEMBER.FPositionID = POSITION.FID");
        sql.append(" and  POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        sql.append(" and ADMINORGUNIT.FControlUnitID = CU2.FID");
        sql.append(" and ADMINORGUNIT.FID = ORGRANGE.FOrgID");
        sql.append(" and ORGRANGE.FUserID = u.FID");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'+?+'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'+?+'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'+?+'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ''+?+'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ''+?+'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        sql.append(" and u.fid='" + userId + "' and ORGRANGE.ftype=20");
        sql.append(" ) temp");
        return sql.toString();
    }

    private String getPGSearchSqlByCU(Context ctx) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" to_char(t.FpermEditCtrl) as FPERMEDITCTRL ,to_char(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page'::character varying as type ,t.FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%\"leaf\":true%' or t.FnodeExt like '%\"leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath || '%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where  B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append("   ) as a");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0'::character varying as FpermEditCtrl,'0'::character varying as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service'::character varying as type  ,1 as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where  t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append("  order by t.FdisplayName,t.FcreateTime asc limit 5");
        sql.append(" )    as b       ");
        sql.append(" union all   ");
        sql.append(" select * from (");
        sql.append(" select distinct * from ( ");
        sql.append(" select t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case  when t.FName_L3 is null then TO_CHAR('') else t.FName_L3 end || '\",\"zh_CN\":\"' || case  when t.FName_L2 is null then TO_CHAR('') else t.FName_L2 end || '\",\"en\":\"' || case  when t.FName_L1 is null then TO_CHAR('') else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  ''::character varying as fnodeExt, ''::character varying as fnodeType, ''::character varying as fpreferences, ");
        sql.append("   '0'::character varying as FpermEditCtrl,'0'::character varying as FpermViewCtrl, ");
        sql.append(" ''::character varying as FICON , 'person'::character varying  as type  ,1 as FCanAddFav ");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append(",T_ORG_PositionMember  POSITIONMEMBER, T_ORG_Position  POSITION , T_ORG_Admin  ADMINORGUNIT , T_ORG_CtrlUnit  CU2 , T_PM_OrgRange  ORGRANGE , T_PM_User  u");
        sql.append("   where   (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ?||'%'");
        sql.append("  )  ");
        sql.append(" and  POSITIONMEMBER.FPersonID   = t.fid");
        sql.append(" and POSITIONMEMBER.FPositionID = POSITION.FID");
        sql.append(" and  POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        sql.append(" and ADMINORGUNIT.FControlUnitID = CU2.FID");
        sql.append(" and ADMINORGUNIT.FID = ORGRANGE.FOrgID");
        sql.append(" and ORGRANGE.FUserID = u.FID");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and CU2.fid = '" + orgId + "'");
        sql.append(" order by t.FNAME_L2 asc");
        sql.append(" )  as c");
        sql.append(" ) temp limit 5");
        return sql.toString();
    }

    private String getPGSearchSqlByOrgRange(Context ctx) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" to_char(t.FpermEditCtrl) as FPERMEDITCTRL ,to_char(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page'::character varying as type ,t.FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%\"leaf\":true%' or t.FnodeExt like '%\"leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath || '%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where  B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append("   ) as a");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0'::character varying as FpermEditCtrl,'0'::character varying as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service'::character varying as type  ,1 as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where  t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append("  order by t.FdisplayName,t.FcreateTime asc limit 5");
        sql.append(" )    as b       ");
        sql.append(" union all   ");
        sql.append(" select * from (");
        sql.append(" select distinct * from ( ");
        sql.append(" select t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case  when t.FName_L3 is null then TO_CHAR('') else t.FName_L3 end || '\",\"zh_CN\":\"' || case  when t.FName_L2 is null then TO_CHAR('') else t.FName_L2 end || '\",\"en\":\"' || case  when t.FName_L1 is null then TO_CHAR('') else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  ''::character varying as fnodeExt, ''::character varying as fnodeType, ''::character varying as fpreferences, ");
        sql.append("   '0'::character varying as FpermEditCtrl,'0'::character varying as FpermViewCtrl, ");
        sql.append(" ''::character varying as FICON , 'person'::character varying  as type  ,1 as FCanAddFav ");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append(",T_ORG_PositionMember  POSITIONMEMBER, T_ORG_Position  POSITION , T_ORG_Admin  ADMINORGUNIT , T_ORG_CtrlUnit  CU2 , T_PM_OrgRange  ORGRANGE , T_PM_User  u");
        sql.append("   where   (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ?||'%'");
        sql.append("  )  ");
        sql.append(" and  POSITIONMEMBER.FPersonID   = t.fid");
        sql.append(" and POSITIONMEMBER.FPositionID = POSITION.FID");
        sql.append(" and  POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        sql.append(" and ADMINORGUNIT.FControlUnitID = CU2.FID");
        sql.append(" and ADMINORGUNIT.FID = ORGRANGE.FOrgID");
        sql.append(" and ORGRANGE.FUserID = u.FID");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and u.fid='" + userId + "' and ORGRANGE.ftype=20");
        sql.append(" order by t.FNAME_L2 asc");
        sql.append(" )  as c");
        sql.append(" ) temp limit 5");
        return sql.toString();
    }

    private String getDB2SearchSqlByCU(Context ctx) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT    t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" CHAR(t.FpermEditCtrl) as FPERMEDITCTRL,CHAR(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page' as type ,CHAR(t.FCanAddFav) as FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%leaf\":true%' or t.FnodeExt like '%leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like CONCAT(B.Fnodepath,'%')  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" )  ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append(" ) ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT    t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type ,'1' as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append(" fetch first 5 rows only    )        ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append(" select distinct * from ( ");
        sql.append(" select   t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case when t.FName_L3 is null then '' else t.FName_L3 end || '\",\"zh_CN\":\"' || case when t.FName_L2 is null then '' else t.FName_L2 end || '\",\"en\":\"' || case when t.FName_L1 is null then '' else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type ,'1' as FCanAddFav");
        sql.append("  from T_BD_Person t,T_HR_BDEmployeeType et ");
        sql.append(",T_ORG_PositionMember  POSITIONMEMBER, T_ORG_Position  POSITION , T_ORG_Admin  ADMINORGUNIT , T_ORG_CtrlUnit  CU2 , T_PM_OrgRange  ORGRANGE , T_PM_User  u");
        sql.append("   where 1=1 ");
        sql.append(" and  POSITIONMEMBER.FPersonID   = t.fid");
        sql.append(" and POSITIONMEMBER.FPositionID = POSITION.FID");
        sql.append(" and  POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        sql.append(" and ADMINORGUNIT.FControlUnitID = CU2.FID");
        sql.append(" and ADMINORGUNIT.FID = ORGRANGE.FOrgID");
        sql.append(" and ORGRANGE.FUserID = u.FID");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ''||?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ''||?||'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        sql.append(" and CU2.fid = '" + orgId + "'");
        sql.append(" ) ) a");
        sql.append(" fetch first 5 rows only ");
        return sql.toString();
    }

    private String getDB2SearchSqlByOrgRange(Context ctx) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT    t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" CHAR(t.FpermEditCtrl) as FPERMEDITCTRL,CHAR(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page' as type ,CHAR(t.FCanAddFav) as FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%leaf\":true%' or t.FnodeExt like '%leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like CONCAT(B.Fnodepath,'%')  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" )  ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append(" ) ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT    t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type ,'1' as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append(" fetch first 5 rows only    )        ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append(" select distinct * from ( ");
        sql.append(" select   t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case when t.FName_L3 is null then '' else t.FName_L3 end || '\",\"zh_CN\":\"' || case when t.FName_L2 is null then '' else t.FName_L2 end || '\",\"en\":\"' || case when t.FName_L1 is null then '' else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type ,'1' as FCanAddFav");
        sql.append("  from T_BD_Person t,T_HR_BDEmployeeType et ");
        sql.append(",T_ORG_PositionMember  POSITIONMEMBER, T_ORG_Position  POSITION , T_ORG_Admin  ADMINORGUNIT , T_ORG_CtrlUnit  CU2 , T_PM_OrgRange  ORGRANGE , T_PM_User  u");
        sql.append("   where 1=1 ");
        sql.append(" and  POSITIONMEMBER.FPersonID   = t.fid");
        sql.append(" and POSITIONMEMBER.FPositionID = POSITION.FID");
        sql.append(" and  POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        sql.append(" and ADMINORGUNIT.FControlUnitID = CU2.FID");
        sql.append(" and ADMINORGUNIT.FID = ORGRANGE.FOrgID");
        sql.append(" and ORGRANGE.FUserID = u.FID");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ''||?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ''||?||'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        sql.append(" and u.fid='" + userId + "' and ORGRANGE.ftype=20");
        sql.append(" ) ) a");
        sql.append(" fetch first 5 rows only ");
        return sql.toString();
    }

    private String getOracleSearchSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" to_char(t.FpermEditCtrl) as FPERMEDITCTRL ,to_char(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page' as type ,t.FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%\"leaf\":true%' or t.FnodeExt like '%\"leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath || '%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append("   )");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type  ,1 as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append("  and rownum<=5");
        sql.append("  order by t.FdisplayName,t.FcreateTime asc");
        sql.append(" )           ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append(" select t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case  when t.FName_L3 is null then TO_NCHAR('') else t.FName_L3 end || '\",\"zh_CN\":\"' || case  when t.FName_L2 is null then TO_NCHAR('') else t.FName_L2 end || '\",\"en\":\"' || case  when t.FName_L1 is null then TO_NCHAR('') else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type  ,1 as FCanAddFav ");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append("   where 1=1 ");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ?||'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        sql.append(" and rownum<=5");
        sql.append(" order by t.FNAME_L2 asc ");
        sql.append(" )  ");
        return sql.toString();
    }

    private String getMsSearchSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("  SELECT    t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" t.FpermEditCtrl,t.FpermViewCtrl, ");
        sql.append("  t.FICON ,'page' as type ,t.FCanAddFav  ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''+?+'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%leaf\":true%' or t.FnodeExt like '%leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath+'%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'+?+'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'+?+'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'+?+'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append(" union all   ");
        sql.append("  SELECT top 5  t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type ,'1' as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'+?+'%'");
        sql.append(" union all   ");
        sql.append(" select top 5  t.FID,");
        sql.append(" '{\"zh_TW\":\"'+case  when t.FName_L3 is null then '' else t.FName_L3 end+'\",\"zh_CN\":\"'+case  when t.FName_L2 is null then '' else t.FName_L2 end+'\",\"en\":\"'+case  when t.FName_L1 is null then '' else t.FName_L1 end+'\"}'  as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type ,'1' as FCanAddFav");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append("   where 1=1 ");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'+?+'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'+?+'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'+?+'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ''+?+'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ''+?+'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        return sql.toString();
    }

    private String getDB2SearchSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT    t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" CHAR(t.FpermEditCtrl) as FPERMEDITCTRL,CHAR(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page' as type ,CHAR(t.FCanAddFav) as FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%leaf\":true%' or t.FnodeExt like '%leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like CONCAT(B.Fnodepath,'%')  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" )  ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append(" ) ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT    t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type ,'1' as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append(" fetch first 5 rows only    )        ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append(" select   t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case when t.FName_L3 is null then '' else t.FName_L3 end || '\",\"zh_CN\":\"' || case when t.FName_L2 is null then '' else t.FName_L2 end || '\",\"en\":\"' || case when t.FName_L1 is null then '' else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type ,'1' as FCanAddFav");
        sql.append("  from T_BD_Person t,T_HR_BDEmployeeType et ");
        sql.append("   where 1=1 ");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ''||?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ''||?||'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        sql.append(" fetch first 5 rows only  ");
        sql.append(" )  ");
        return sql.toString();
    }

    private String getDmSearchSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fnodeExt, t.fnodeType, t.fpreferences, ");
        sql.append(" to_char(t.FpermEditCtrl) as FPERMEDITCTRL ,to_char(t.FpermViewCtrl) as FPERMVIEWCTRL, ");
        sql.append("  t.FICON ,'page' as type ,t.FCanAddFav ");
        sql.append("  FROM T_JP_Page t ");
        sql.append("   WHERE 1=1 ");
        sql.append(" and ");
        sql.append(" ( ");
        sql.append("  (  ");
        sql.append("  t.FnodePath like ''||?||'%'  ");
        sql.append("  and ");
        sql.append("  (t.FnodeType='PAGE'or t.FnodeType='LINK' or (t.FnodeExt like '%\"leaf\":true%' or t.FnodeExt like '%\"leaf\":\"true%')) ");
        sql.append("   ) ");
        sql.append("  or ");
        sql.append(" ( ");
        sql.append(" t.fid in ( ");
        sql.append(" select A.fid from T_JP_Page A  ");
        sql.append(" left join T_JP_Page B on A.fnodepath like B.Fnodepath || '%'  ");
        sql.append(" and B.fnodetype='BIZ_PAGE' ");
        sql.append("  and B.fcansearch=1  ");
        sql.append(" and B.Fnodelevel!=0 ");
        sql.append("  and B.Fstatus='ENABLE' ");
        sql.append("  where 1=1  ");
        sql.append("   and B.Fid is not null  ");
        sql.append("  and A.Fstatus='ENABLE' ");
        sql.append("  and A.Fid!=B.Fid ");
        sql.append("  ) ");
        sql.append(" ) ");
        sql.append(" ) ");
        sql.append("  and ( Lower(t.FdisplayName) like '%'||?||'%' ");
        sql.append("  or Lower(t.FfirstSpell) like '%'||?||'%' ");
        sql.append("  or Lower(t.FallSpell) like '%'||?||'%' ) ");
        sql.append("  and t.Fstatus='ENABLE' ");
        sql.append("   )");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append("  SELECT t.FID, t.FdisplayName,");
        sql.append("  t.fopentype as fnodeExt, t.fnodeType, t.fdefparam as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append("  t.FICON ,'service' as type  ,1 as FCanAddFav ");
        sql.append("   FROM t_JP_serviceDefinition t ");
        sql.append("  where 1=1 ");
        sql.append("  and t.fstate='ENABLE' ");
        sql.append("  and Lower(t.FdisplayName) like '%'||?||'%'");
        sql.append("  and rownum<=5");
        sql.append("  order by t.FdisplayName,t.FcreateTime asc");
        sql.append(" )           ");
        sql.append(" union all   ");
        sql.append(" select * from ( ");
        sql.append(" select t.FID,");
        sql.append("  '{\"zh_TW\":\"' || case  when t.FName_L3 is null then TO_CHAR('') else t.FName_L3 end || '\",\"zh_CN\":\"' || case  when t.FName_L2 is null then TO_CHAR('') else t.FName_L2 end || '\",\"en\":\"' || case  when t.FName_L1 is null then TO_CHAR('') else t.FName_L1 end || '\"}' as FdisplayName,");
        sql.append("  '' as fnodeExt, '' as fnodeType, '' as fpreferences, ");
        sql.append("   '0' as FpermEditCtrl,'0' as FpermViewCtrl, ");
        sql.append(" '' as FICON , 'person'  as type  ,1 as FCanAddFav ");
        sql.append("  from T_BD_Person t ,T_HR_BDEmployeeType et");
        sql.append("   where 1=1 ");
        sql.append("   and  (   Lower(t.FNAME_L1) like '%'||?||'%' ");
        sql.append("   or Lower(t.FNAME_L2) like '%'||?||'%' ");
        sql.append("   or Lower( t.FNAME_L3) like '%'||?||'%'");
        sql.append("   or Lower( t.FFullNamePingYin) like ?||'%'");
        sql.append("   or Lower( t.FSimpleNamePingYin) like ?||'%'");
        sql.append("  )  ");
        sql.append(" and t.FEmployeeTypeID = et.FID and et.FinService='1'");
        sql.append(" and t.FDELETEDSTATUS !=2  ");
        sql.append(" and rownum<=5");
        sql.append(" order by t.FNAME_L2 asc ");
        sql.append(" )  ");
        return sql.toString();
    }

    @Override
    public List<Page> findAllPageListByids(Page page, String ids, boolean includeSelf) throws DataAccessException {
        try {
            String whereStr;
            String selfStr = "";
            if (!includeSelf) {
                selfStr = "/";
            }
            StringBuilder builder = new StringBuilder(100);
            if (ids != null) {
                for (String id : ids.split(",")) {
                    if (StringUtil.isEmpty((String)id)) continue;
                    builder.append("t.nodePath like '%/").append(id).append(selfStr).append("%' or ");
                }
            }
            if ((whereStr = builder.toString()).length() > 0) {
                whereStr = " where " + whereStr.substring(0, whereStr.length() - 3);
                String sql = "SELECT t FROM {entityClassName} t " + whereStr;
                String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName()});
                return this.findList(jpql, new Object[0]);
            }
            return null;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public int updateBizPageCanAddFav(PortalContext ctx, Page page) throws DataAccessException {
        String sql = "update Page t set t.canAddFav = :canAddFav where t.nodePath like :parentPath";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("canAddFav", page.getCanAddFav());
        param.put("parentPath", page.getNodePath() + "/%");
        return this.executeUpdate(sql, param);
    }

    @Override
    public List<Page> findBizList4PresetFav(PortalContext ctx) throws DataAccessException {
        try {
            String sql = "SELECT t FROM {entityClassName} t WHERE (t.canAddFav=1 and t.nodeType='BIZ_PAGE') or t.id='2b7f4215-aa17-4d89-952e-efc97833cee6' order by createTime asc";
            String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName()});
            return this.findList(jpql, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public List<Page> findAddedPageList(PortalContext ctx, String roleId) throws DataAccessException {
        try {
            String sql = "SELECT t FROM {entityClassName} t WHERE t.id IN (select favList from com.kingdee.portal.biz.module.pub.entity.PresetFav where roleId='{roleId}')";
            String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName(), roleId});
            return this.findList(jpql, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public IRowSet findPresetFavPageList(PortalContext ctx, String presetId) throws DataAccessException {
        try {
            String sql = "select a.fid ,a.displayName,b.description,a.sourceId from (select p.fid,p.fdisplayName displayName,pf.fid pid,pf.fsourceId sourceId from T_JP_PresetFavPageList pf ,T_JP_Page p where (pf.fpFId='{presetId}' and p.fid=pf.fpageId)) a,(select p.fid,p.fdisplayName description,pf.fid pid from T_JP_PresetFavPageList pf ,T_JP_Page p where (pf.fpFId='{presetId}' and p.fid=pf.fsourceId)) b  where a.pid=b.pid";
            String jpql = StringUtil.merge((String)sql, (String[])new String[]{presetId, presetId});
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            return DbUtil.executeQuery((Context)context, (String)jpql);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public IRowSet findPageListForPresetFav(PortalContext ctx, String userId, String userType) throws DataAccessException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        StringBuilder permSql = new StringBuilder();
        StringBuilder userOrgRangeSql = new StringBuilder(100);
        StringBuilder orgBaseSql = new StringBuilder(50);
        boolean isHasUserOrgRange = false;
        try {
            String userSql = "";
            userOrgRangeSql.append("SELECT DISTINCT forgid, flongnumber FROM t_pm_orgrange RANGE,t_org_admin ORG").append(" WHERE (RANGE.fuserid ='").append(userId).append("' ").append("and RANGE.ftype=20  AND org.fid = range.forgid)");
            orgBaseSql.append("select ORG.Fid,ORG.flongnumber from T_JP_PermRefRoleGroup RGROUP,").append("t_org_admin ORG where RGROUP.FGroupId=ORG.fid");
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)userOrgRangeSql.toString());
            IRowSet rs2 = DbUtil.executeQuery((Context)context, (String)orgBaseSql.toString());
            StringBuilder flongnumbers = new StringBuilder();
            if (rs != null) {
                while (rs.next()) {
                    String flongnumber = rs.getString("flongnumber");
                    if (flongnumber == null) continue;
                    flongnumbers.append(flongnumber).append(",");
                }
            }
            StringBuilder Fids = new StringBuilder();
            Fids.append("''");
            if (rs2 != null) {
                while (rs2.next()) {
                    String flongnumber = rs2.getString("flongnumber");
                    if (!flongnumbers.toString().contains(flongnumber)) continue;
                    isHasUserOrgRange = true;
                    Fids.append(",'").append(rs2.getString("Fid")).append("'");
                }
            }
            if ("".equals(userType)) {
                userSql = " and pf.FActiveType='alluser' and pfp.FIsNew=1 ";
            }
            permSql.append("select p.* from t_jp_page p,T_JP_PresetFavPageList pfp,T_JP_PresetFav pf,T_JP_PermRefRoleUser ru ").append("where pf.FRoleId=ru.FRoleId and ru.FUserId='").append(userId).append("' and pf.FId=pfp.FPFId ").append(userSql).append(" and pfp.FPageId=p.FId ");
            if (isHasUserOrgRange) {
                permSql.append(" union all ").append("select p.* from t_jp_page p,T_JP_PresetFavPageList pfp,T_JP_PresetFav pf,T_JP_PermRefRoleUser ru,T_JP_PermRefRoleGroup RGROUP ").append("where ru.FRoleId=RGROUP.FRoleId ").append("and pf.FRoleId=ru.FRoleId and ru.FUserId='").append(userId).append("' and pf.FId=pfp.FPFId ").append(userSql).append(" and pfp.FPageId=p.FId AND RGROUP.FGroupId IN (").append((CharSequence)Fids).append(")");
            }
            return DbUtil.executeQuery((Context)context, (String)permSql.toString());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Page> findAppSecondPageList(PortalContext ctx) throws DataAccessException {
        try {
            String sql = "SELECT t FROM {entityClassName} t WHERE t.nodeLevel=3 and t.nodePath like '%/2b7f4215-aa17-4d89-952e-efc97833cee6/%'";
            String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName()});
            return this.findList(jpql, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public List<Page> findFavPageList(PortalContext ctx) throws DataAccessException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        ArrayList<Page> pageList = new ArrayList<Page>();
        StringBuilder permSql = new StringBuilder();
        try {
            String userId = ctx.getLoginUser().getId();
            permSql.append("SELECT t.* FROM T_JP_Page t,T_BAS_ComFunction f ").append("where f.FUserID='").append(userId).append("' and f.FISLEAF=1 and ").append("(t.FId=f.FMenuFunctionID or ").append("  CHARINDEX(f.FMenuFunctionID,t.FNodeExt)>0 )");
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString());
            if (rs != null) {
                while (rs.next()) {
                    Page page = new Page();
                    page.setDisplayName(rs.getString("FDisplayName"));
                    page.setDescription(rs.getString("FDescription"));
                    page.setIcon(rs.getString("FIcon"));
                    page.setParentNodeId(rs.getString("FParentNodeId"));
                    page.setPermViewCtrl(rs.getBoolean("FPermViewCtrl"));
                    page.setPermEditCtrl(rs.getBoolean("FPermEditCtrl"));
                    page.setPreferences(rs.getString("FPreferences"));
                    page.setNodeType(this.getNodeTypeEnum(rs.getString("FNodeType")));
                    page.setNodeExt(rs.getString("FNodeExt"));
                    page.setPageNumber(rs.getString("FPageNumber"));
                    page.setStatus(this.getStatusEnum(rs.getString("FStatus")));
                    page.setNodePath(rs.getString("FNodePath"));
                    page.setId(rs.getString("FId"));
                    pageList.add(page);
                }
            }
            return pageList;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    private NodeTypeEnum getNodeTypeEnum(String nodeType) {
        if ("PAGE".equals(nodeType)) {
            return NodeTypeEnum.PAGE;
        }
        if ("EXTERNAL_LINK".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK;
        }
        if ("EXTERNAL_LINK_G".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK_G;
        }
        if ("EXTERNAL_LINK_OA".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK_OA;
        }
        if ("LINK".equals(nodeType)) {
            return NodeTypeEnum.LINK;
        }
        return null;
    }

    private StatusEnum getStatusEnum(String status) {
        if (status != null && "ENABLE".equals(status)) {
            return StatusEnum.ENABLE;
        }
        return StatusEnum.DISABLE;
    }

    @Override
    public List<Page> findLockPageListByPageIds(String[] pageIds) throws DataAccessException {
        ArrayList pageList = new ArrayList();
        try {
            String sql = "SELECT t FROM {entityClassName} t WHERE t.id IN ({ids}) order by nodeLevel,nodeOrder,createTime asc";
            StringBuilder builder = new StringBuilder(100);
            builder.append("''");
            if (pageIds != null) {
                for (String id : pageIds) {
                    if (StringUtil.isEmpty((String)id)) continue;
                    builder.append(",'").append(id).append("'");
                }
            }
            String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName(), builder.toString()});
            return this.findList(jpql, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }

    @Override
    public List<Page> findPageListByParentIdAndUserIds(PortalContext ctx, String parentId, String[] userIds) throws DataAccessException {
        String sql = "SELECT t FROM {entityClassName} t WHERE t.userId IN ({userIds})  and t.parentNodeId= '" + parentId + "' order by t.createTime desc";
        StringBuilder sb = new StringBuilder();
        for (String userId : userIds) {
            sb.append("'").append(userId).append("'").append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName(), sb.toString()});
        return this.findList(jpql, new Object[0]);
    }

    @Override
    public List<Page> findPageListByParentIdAndUserIdsAndStatus(PortalContext ctx, String parentId, String[] userIds, StatusEnum status) throws DataAccessException {
        String sql = "SELECT t FROM {entityClassName} t WHERE t.userId IN ({userIds})  and t.parentNodeId= '" + parentId + "' and t.status = '" + (Object)((Object)status) + "'order by t.createTime desc";
        StringBuilder sb = new StringBuilder();
        for (String userId : userIds) {
            sb.append("'").append(userId).append("'").append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName(), sb.toString()});
        return this.findList(jpql, new Object[0]);
    }
}

