/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.page.dao.impl;

import com.kingdee.portal.biz.common.dao.impl.BaseDAOImpl;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.module.page.dao.PagePersonalExtDAO;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.entity.PagePersonalExt;
import com.kingdee.portal.common.util.StringUtil;
import java.util.HashMap;
import java.util.List;

public class PagePersonalExtDAOImpl
extends BaseDAOImpl<PagePersonalExt>
implements PagePersonalExtDAO {
    private static String jpql_deleteByPageId = "delete from PagePersonalExt t where t.pageId = :pageId";
    private static String jpql_findByPageList = "select t from PagePersonalExt t where t.pageId in ({pageIds})";
    private static String jpql_deleteByPageList = "delete from PagePersonalExt t where t.pageId in ({pageIds})";
    private static String jpql_findPageExtList4User = "SELECT t FROM PagePersonalExt t WHERE t.pageId ='{pageId}' AND t.userId IN ({userIds})";

    @Override
    public int deleteByPageId(String pageId) throws DataAccessException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pageId", pageId);
        return this.executeUpdate(jpql_deleteByPageId, param);
    }

    @Override
    public List<PagePersonalExt> findByPageList(List<Page> pages) throws DataAccessException {
        String ids = this.transPageList2Str(pages);
        String jpql = StringUtil.merge((String)jpql_findByPageList, (String[])new String[]{ids});
        return this.findList(jpql, new Object[0]);
    }

    private String transPageList2Str(List<Page> pages) {
        StringBuilder str = new StringBuilder("''");
        for (Page page : pages) {
            str.append(",'").append(page.getId()).append("'");
        }
        return str.toString();
    }

    @Override
    public int deleteByPageList(List<Page> pages) throws DataAccessException {
        String ids = this.transPageList2Str(pages);
        String jpql = StringUtil.merge((String)jpql_deleteByPageList, (String[])new String[]{ids});
        return this.executeUpdate(jpql, new Object[0]);
    }

    @Override
    public List<PagePersonalExt> findPageExtList4User(String pageId, String[] userIds) throws DataAccessException {
        try {
            StringBuilder builder4UserId = new StringBuilder(100);
            builder4UserId.append("''");
            if (userIds != null) {
                for (String id : userIds) {
                    builder4UserId.append(",'").append(id).append("'");
                }
            }
            String jpql = StringUtil.merge((String)jpql_findPageExtList4User, (String[])new String[]{pageId, builder4UserId.toString()});
            return this.findList(jpql, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new DataAccessException(ex.getCause());
        }
    }
}

