/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.page.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.json.LinkNodeExt;
import com.kingdee.portal.biz.module.page.dao.AppCenterPersonalDAO;
import com.kingdee.portal.biz.module.page.entity.AppCenterPersonal;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.service.AppCenterPersonalService;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.perm.common.json.PermInfo;
import com.kingdee.portal.biz.module.perm.entity.PermRefRes;
import com.kingdee.portal.biz.module.perm.service.PermService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class AppCenterPersonalServiceImpl
implements AppCenterPersonalService {
    private AppCenterPersonalDAO appCenterPersonalDAO;
    private PermService permService;
    private PageService pageService;

    @Override
    public List<AppCenterPersonal> getAppCenterPersonalByUserID(PortalContext ctx) {
        List<AppCenterPersonal> pagesPersonal = null;
        try {
            int nodeLevel = 1;
            String userId = ctx.getLoginUser().getId();
            pagesPersonal = this.appCenterPersonalDAO.findPagesByUserIdAndLevel(userId, nodeLevel);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return pagesPersonal;
    }

    @Override
    public String[] getMenuIdsByNodeLevel(PortalContext ctx, String nodeLevel) {
        String[] menuIds = new String[]{};
        try {
            String sql = "SELECT t.FPageId FROM T_JP_AppCenterPersonal t WHERE t.FuserId=? and t.FnodeLevel=?";
            String userId = ctx.getLoginUser().getId();
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add(userId);
            paramList.add(nodeLevel);
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (Object[])paramList.toArray());
            menuIds = new String[dataSet.size()];
            int count = 0;
            while (dataSet.next()) {
                menuIds[count++] = dataSet.getString("FpageID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return menuIds;
    }

    @Override
    public boolean saveAppCenterPersonalPages(List<AppCenterPersonal> personalPages) {
        try {
            this.appCenterPersonalDAO.deleteByUserID(personalPages.get(0).getUserId());
            this.appCenterPersonalDAO.create(personalPages);
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void deleteAppcenterPersonalByUserID(PortalContext ctx) {
        String userID = ctx.getLoginUser().getId();
        this.appCenterPersonalDAO.deleteByUserID(userID);
    }

    @Override
    public List getPageByIdsAndOrder(PortalContext portalContext, String userType, OrderEnum asc) {
        String userID = "";
        String currentUserId = portalContext.getLoginUser().getId();
        userID = "personal".equals(userType) ? currentUserId : "00000000-0000-0000-0000-00000000000013B7DE7F";
        boolean isAdmin = "00000000-0000-0000-0000-00000000000013B7DE7F".equalsIgnoreCase(currentUserId);
        AppCenterPersonal entity = new AppCenterPersonal();
        entity.setUserId(userID);
        entity.setNodeLevel(1);
        ArrayList resultList = new ArrayList();
        Map<String, Integer> permMap = null;
        try {
            List<AppCenterPersonal> firstList = this.appCenterPersonalDAO.findList(entity, new Filter[0]);
            Collections.sort(firstList);
            ListIterator<AppCenterPersonal> listIterator = firstList.listIterator();
            if (!isAdmin) {
                permMap = this.getPermPageIdsByUserId(portalContext, userID);
            }
            while (listIterator.hasNext()) {
                ArrayList<Page> pageList = new ArrayList<Page>();
                AppCenterPersonal next2 = listIterator.next();
                String firstId = next2.getPageID();
                entity.setNodeLevel(2);
                entity.setParentNodeId(firstId);
                List<AppCenterPersonal> secondList = this.appCenterPersonalDAO.findList(entity, new Filter[0]);
                Collections.sort(secondList);
                ListIterator<AppCenterPersonal> listIterator2 = secondList.listIterator();
                while (listIterator2.hasNext()) {
                    AppCenterPersonal next = listIterator2.next();
                    String pageID = next.getPageID();
                    if (permMap != null && permMap.get(pageID) == null && !isAdmin) break;
                    Page page = new Page();
                    page.setId(pageID);
                    page.setNodeLevel(next.getNodeLevel());
                    page.setNodeOrder(next.getNodeOrder());
                    page.setDisplayName(next.getDisplayName());
                    page.setDescription(next.getDescription());
                    page.setAllSpell(next.getAllSpell());
                    page.setIcon(next.getIcon());
                    pageList.add(page);
                }
                if (pageList.size() <= 0) continue;
                Page page = new Page();
                page.setId(next2.getPageID());
                page.setPageNumber(next2.getPageNumber());
                page.setNodeLevel(next2.getNodeLevel());
                page.setNodeOrder(next2.getNodeOrder());
                page.setDisplayName(next2.getDisplayName());
                page.setDescription(next2.getDescription());
                page.setAllSpell(next2.getAllSpell());
                page.setIcon(next2.getIcon());
                pageList.add(0, page);
                resultList.add(pageList);
            }
            return resultList;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return resultList;
        }
    }

    @Override
    public boolean getIsPersonalAppCenter(PortalContext portalContext) {
        try {
            String sql = "SELECT 1 FROM T_JP_AppCenterPersonal t WHERE t.FuserId=?";
            String userId = portalContext.getLoginUser().getId();
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add(userId);
            Context context = (Context)portalContext.getMetaInfo().get("eas_context");
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (Object[])paramList.toArray());
            return dataSet.next();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean getIsAdminAppCenter(PortalContext portalContext) {
        try {
            String sql = "SELECT 1 FROM T_JP_AppCenterPersonal t WHERE t.FuserId=?";
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("00000000-0000-0000-0000-00000000000013B7DE7F");
            Context context = (Context)portalContext.getMetaInfo().get("eas_context");
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (Object[])paramList.toArray());
            return dataSet.next();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public Map<String, Integer> getPermPageIdsByUserId(PortalContext ctx, String userId) {
        try {
            String sql = "SELECT t.FPageId FROM T_JP_AppCenterPersonal t WHERE t.FuserId=? and t.FnodeLevel=?";
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add(userId);
            paramList.add("2");
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (Object[])paramList.toArray());
            String[] menuIds = new String[dataSet.size()];
            int count = 0;
            while (dataSet.next()) {
                menuIds[count++] = dataSet.getString("FpageID");
            }
            List<PermRefRes> permList = PortalCache.getPortalPagePerm(ctx);
            List<Page> pageList = this.pageService.findPageListByIds(ctx, menuIds);
            ArrayList<String> resultList = new ArrayList<String>();
            HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
            for (Page page : pageList) {
                boolean result = false;
                for (PermRefRes ref : permList) {
                    if (!page.getId().equals(ref.getResId()) || !page.getNodeType().toString().equals(ref.getResType().toString())) continue;
                    PermInfo pi = new PermInfo(ref.getPermInfo());
                    Page newPage = this.setPage4Perm(page, true, pi.isEdit());
                    resultList.add(newPage.getId());
                    resultMap.put(newPage.getId(), 1);
                    result = true;
                    break;
                }
                if (result || page.getPermViewCtrl().booleanValue()) continue;
                Page newPage = this.setPage4Perm(page, true, false);
                resultMap.put(newPage.getId(), 1);
            }
            return resultMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Page setPage4Perm(Page page, boolean viewCtrl, boolean editCtrl) {
        LinkNodeExt ext;
        Page newPage = new Page();
        newPage.setDescription(page.getDescription());
        newPage.setDisplayName(page.getDisplayName());
        newPage.setHidden(page.getHidden());
        newPage.setIcon(page.getIcon());
        newPage.setId(page.getId());
        newPage.setNodeLevel(page.getNodeLevel());
        newPage.setNodeOrder(page.getNodeOrder());
        newPage.setNodePath(page.getNodePath());
        newPage.setNodeType(page.getNodeType());
        newPage.setPageNumber(page.getPageNumber());
        newPage.setParentNodeId(page.getParentNodeId());
        newPage.setResLevel(page.getResLevel());
        newPage.setSettingInfo(page.getSettingInfo());
        newPage.setStatus(page.getStatus());
        newPage.setUserId(page.getUserId());
        newPage.setPermViewCtrl(viewCtrl);
        newPage.setPermEditCtrl(editCtrl);
        newPage.setPreferences(page.getPreferences());
        String nodeExt = page.getNodeExt();
        if (page.getNodeType().equals((Object)NodeTypeEnum.LINK) && page.getNodeExt() != null && (ext = new LinkNodeExt(nodeExt)).getSso() != null && ext.getSso().booleanValue()) {
            ext.setUrl("/portal/openSSOUrlServlet?url=" + ext.getUrl());
            nodeExt = ext.toString();
        }
        newPage.setPageUrl(page.getPageUrl());
        newPage.setNodeExt(nodeExt);
        return newPage;
    }

    public AppCenterPersonalDAO getAppCenterPersonalDAO() {
        return this.appCenterPersonalDAO;
    }

    public void setAppCenterPersonalDAO(AppCenterPersonalDAO appCenterPersonalDAO) {
        this.appCenterPersonalDAO = appCenterPersonalDAO;
    }

    public void setPermService(PermService permService) {
        this.permService = permService;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }
}

