/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.page.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.portal.biz.common.cache.CacheProxy;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.page.common.json.PageNodeExt;
import com.kingdee.portal.biz.module.page.dao.AppCenterDAO;
import com.kingdee.portal.biz.module.page.entity.AppCenterCache;
import com.kingdee.portal.biz.module.page.entity.AppCenterMenuJson;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.service.AppCenterService;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.perm.service.PermService;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class AppCenterServiceImpl
implements AppCenterService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private AppCenterDAO appCenterDAO;
    private PageService pageService;
    private II18nService i18nService;

    @Override
    public AppCenterCache getAppCenterDataByUserId(PortalContext ctx) throws Exception {
        String userId = ctx.getLoginUser().getId();
        AppCenterCache appCache = (AppCenterCache)this.appCenterDAO.findObject(new FieldFilter("userId", "=", userId));
        return appCache;
    }

    @Override
    public void updateAppCenterCacheByLanguage(PortalContext ctx, String language, AppCenterCache oldCache) throws Exception {
        String userId = ctx.getLoginUser().getId();
        AppCenterCache newCache = null;
        AppCenterCache appcenterCacheTemp = null;
        String pageId = "2b7f4215-aa17-4d89-952e-efc97833cee6";
        List<Page> pageList = this.pageService.findAppCenterList(ctx, pageId, null);
        appcenterCacheTemp = this.buildAppCenterCache(ctx, language, pageList);
        if (oldCache == null) {
            newCache = new AppCenterCache();
            if (language.equals("l1")) {
                newCache.setTreeContentL1(appcenterCacheTemp.getTreeContent().getBytes());
            } else if (language.equals("l3")) {
                newCache.setTreeContentL3(appcenterCacheTemp.getTreeContent().getBytes());
            } else if (language.equals("l2")) {
                newCache.setTreeContentL2(appcenterCacheTemp.getTreeContent().getBytes());
            } else {
                newCache.setTreeContentL1(appcenterCacheTemp.getTreeContent().getBytes());
                newCache.setTreeContentL2(appcenterCacheTemp.getTreeContent().getBytes());
                newCache.setTreeContentL3(appcenterCacheTemp.getTreeContent().getBytes());
            }
            newCache.setUserId(userId);
            newCache.setTwoToThreeMemuId(appcenterCacheTemp.getTwoToThreeMemuId());
            newCache.setTreeToFourMemuId(appcenterCacheTemp.getTreeToFourMemuId());
            newCache.setAppcenterTree(appcenterCacheTemp.getAppcenterTree());
            newCache = this.appCenterDAO.create(newCache);
        } else {
            if (language.equals("l1")) {
                oldCache.setTreeContentL1(appcenterCacheTemp.getTreeContent().getBytes());
            } else if (language.equals("l3")) {
                oldCache.setTreeContentL3(appcenterCacheTemp.getTreeContent().getBytes());
            } else if (language.equals("l2")) {
                oldCache.setTreeContentL2(appcenterCacheTemp.getTreeContent().getBytes());
            } else {
                oldCache.setTreeContentL1(appcenterCacheTemp.getTreeContent().getBytes());
                oldCache.setTreeContentL2(appcenterCacheTemp.getTreeContent().getBytes());
                oldCache.setTreeContentL3(appcenterCacheTemp.getTreeContent().getBytes());
            }
            oldCache.setOneToTowMemuId(appcenterCacheTemp.getOneToTowMemuId());
            oldCache.setTwoToThreeMemuId(appcenterCacheTemp.getTwoToThreeMemuId());
            oldCache.setTreeToFourMemuId(appcenterCacheTemp.getTreeToFourMemuId());
            oldCache.setAppcenterTree(appcenterCacheTemp.getAppcenterTree());
            newCache = this.appCenterDAO.update(oldCache);
        }
    }

    @Override
    public AppCenterCache getAppCenterData(PortalContext ctx) {
        AppCenterCache appCache = null;
        try {
            String userId = ctx.getLoginUser().getId();
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            String lang = context.getLocale().toString().toLowerCase();
            appCache = (AppCenterCache)this.appCenterDAO.findObject(new FieldFilter("userId", "=", userId));
            if (appCache == null) {
                PermService permService = (PermService)PortalServiceLocator.getBean("permService");
                if (CacheProxy.getCache().get("portal_license_flag") != null) {
                    boolean licenseFlag = (Boolean)CacheProxy.getCache().get("portal_license_flag");
                    permService.findPermSession(ctx, licenseFlag);
                }
                appCache = this.updateAppCenterCache(ctx, lang, null);
            } else if (this.judgeNeedRefreshAppCache(appCache, lang)) {
                appCache = this.updateAppCenterCache(ctx, lang, appCache);
            }
        }
        catch (Exception e) {
            this.logger.error("AppCenterServiceImpl = getAppCenterData = error===", (Throwable)e);
        }
        return appCache;
    }

    private AppCenterCache updateAppCenterCache(PortalContext ctx, String lang, AppCenterCache oldCache) {
        String userId = ctx.getLoginUser().getId();
        AppCenterCache newCache = null;
        AppCenterCache appcenterCacheTemp = null;
        try {
            String pageId = "2b7f4215-aa17-4d89-952e-efc97833cee6";
            List<Page> pageList = this.pageService.findAppCenterList(ctx, pageId, null);
            appcenterCacheTemp = this.buildAppCenterCache(ctx, lang, pageList);
        }
        catch (Exception e) {
            this.logger.error("updateAppCenterCache = buildTreeContent =error==", (Throwable)e);
        }
        try {
            if (oldCache == null) {
                newCache = new AppCenterCache();
                if (lang.equals("l1")) {
                    newCache.setTreeContentL1(appcenterCacheTemp.getTreeContent().getBytes());
                    newCache.setCacheL1Flag(false);
                    newCache.setCacheL2Flag(true);
                    newCache.setCacheL3Flag(true);
                } else if (lang.equals("l3")) {
                    newCache.setTreeContentL3(appcenterCacheTemp.getTreeContent().getBytes());
                    newCache.setCacheL1Flag(true);
                    newCache.setCacheL2Flag(true);
                    newCache.setCacheL3Flag(false);
                } else {
                    newCache.setTreeContentL2(appcenterCacheTemp.getTreeContent().getBytes());
                    newCache.setCacheL1Flag(true);
                    newCache.setCacheL2Flag(false);
                    newCache.setCacheL3Flag(true);
                }
                newCache.setUserId(userId);
                newCache.setOneToTowMemuId(appcenterCacheTemp.getOneToTowMemuId());
                newCache.setTwoToThreeMemuId(appcenterCacheTemp.getTwoToThreeMemuId());
                newCache.setTreeToFourMemuId(appcenterCacheTemp.getTreeToFourMemuId());
                newCache.setAppcenterTree(appcenterCacheTemp.getAppcenterTree());
                newCache = this.appCenterDAO.create(newCache);
            } else {
                if (lang.equals("l1")) {
                    oldCache.setTreeContentL1(appcenterCacheTemp.getTreeContent().getBytes());
                    oldCache.setCacheL1Flag(false);
                } else if (lang.equals("l3")) {
                    oldCache.setTreeContentL3(appcenterCacheTemp.getTreeContent().getBytes());
                    oldCache.setCacheL3Flag(false);
                } else {
                    oldCache.setTreeContentL2(appcenterCacheTemp.getTreeContent().getBytes());
                    oldCache.setCacheL2Flag(false);
                }
                oldCache.setOneToTowMemuId(appcenterCacheTemp.getOneToTowMemuId());
                oldCache.setTwoToThreeMemuId(appcenterCacheTemp.getTwoToThreeMemuId());
                oldCache.setTreeToFourMemuId(appcenterCacheTemp.getTreeToFourMemuId());
                oldCache.setAppcenterTree(appcenterCacheTemp.getAppcenterTree());
                newCache = this.appCenterDAO.update(oldCache);
            }
        }
        catch (Exception e) {
            this.logger.error("updateAppCenterCache = updateCache =error==", (Throwable)e);
        }
        return newCache;
    }

    private boolean judgeNeedRefreshAppCache(AppCenterCache appCache, String lang) {
        boolean result = true;
        try {
            result = lang.equals("l1") ? appCache.getCacheL1Flag() : (lang.equals("l3") ? appCache.getCacheL3Flag().booleanValue() : appCache.getCacheL2Flag().booleanValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private AppCenterCache buildAppCenterCache(PortalContext ctx, String lang, List<Page> pages) {
        AppCenterCache newCache = new AppCenterCache();
        List<Page> firstLevelMenu = new ArrayList<Page>();
        List<Page> secondLevelMenu = new ArrayList<Page>();
        List<Page> thirdLevelMenu = new ArrayList<Page>();
        ArrayList<Page> forthLevelMenu = new ArrayList<Page>();
        block6: for (int i = 0; i < pages.size(); ++i) {
            Page page = pages.get(i);
            switch (page.getNodeLevel()) {
                case 2: {
                    firstLevelMenu.add(page);
                    continue block6;
                }
                case 3: {
                    secondLevelMenu.add(page);
                    continue block6;
                }
                case 4: {
                    thirdLevelMenu.add(page);
                    continue block6;
                }
                case 5: {
                    forthLevelMenu.add(page);
                }
            }
        }
        thirdLevelMenu = this.markDisplayForThirdMenu(thirdLevelMenu, forthLevelMenu);
        secondLevelMenu = this.markDisplay(secondLevelMenu, thirdLevelMenu);
        firstLevelMenu = this.markDisplay(firstLevelMenu, secondLevelMenu);
        String treeContent = this.buildContentToHtml(ctx, lang, firstLevelMenu, secondLevelMenu, thirdLevelMenu, forthLevelMenu);
        newCache.setTreeContent(treeContent);
        String oneToTwoMenuIds = this.perToSubMunuId(firstLevelMenu, secondLevelMenu);
        newCache.setOneToTowMemuId(oneToTwoMenuIds.getBytes());
        String twoToThreeMenuIds = this.perToSubMunuId(secondLevelMenu, thirdLevelMenu);
        newCache.setTwoToThreeMemuId(twoToThreeMenuIds.getBytes());
        String threeToFourMenuIds = this.perToSubMunuId(thirdLevelMenu, forthLevelMenu);
        newCache.setTreeToFourMemuId(threeToFourMenuIds.getBytes());
        String appcenterTree = this.buildAppcenterTree(firstLevelMenu, secondLevelMenu);
        newCache.setAppcenterTree(appcenterTree.getBytes());
        return newCache;
    }

    private String buildAppcenterTree(List<Page> firstLevelMenu, List<Page> secondLevelMenu) {
        ArrayList<String> firstMenuList = new ArrayList<String>();
        for (Page page : firstLevelMenu) {
            String id = page.getId();
            ArrayList<Page> secondMenuList = new ArrayList<Page>();
            for (Page page2 : secondLevelMenu) {
                String parentNodeId = page2.getParentNodeId();
                if (!id.equalsIgnoreCase(parentNodeId)) continue;
                secondMenuList.add(page2);
            }
            JSONObject firstMenuObj = new JSONObject();
            firstMenuObj.put((Object)"currentMenu", (Object)page);
            firstMenuObj.put((Object)"subMenus", secondMenuList);
            String jsonStr = firstMenuObj.toString();
            firstMenuList.add(jsonStr);
        }
        String appcenterTreeJson = JSONArray.fromObject(firstMenuList).toString();
        return appcenterTreeJson;
    }

    private List<Page> markDisplay(List<Page> list, List<Page> subList) {
        ArrayList<Page> newList = new ArrayList<Page>();
        block0: for (int i = 0; i < list.size(); ++i) {
            Page page = list.get(i);
            String firstId = page.getId();
            for (int j = 0; j < subList.size(); ++j) {
                Page subPage = subList.get(j);
                String subId = subPage.getParentNodeId();
                boolean display = subPage.isDispaly();
                if (!firstId.equals(subId) || !display) continue;
                page.setDispaly(true);
                newList.add(page);
                continue block0;
            }
        }
        return newList;
    }

    private List<Page> markDisplayForThirdMenu(List<Page> list, List<Page> subList) {
        ArrayList<Page> newList = new ArrayList<Page>();
        block0: for (int i = 0; i < list.size(); ++i) {
            Page page = list.get(i);
            String firstId = page.getId();
            for (int j = 0; j < subList.size(); ++j) {
                Page subPage = subList.get(j);
                String subId = subPage.getParentNodeId();
                if (!firstId.equals(subId)) continue;
                page.setDispaly(true);
                newList.add(page);
                continue block0;
            }
        }
        return newList;
    }

    private String buildContentToHtml(PortalContext ctx, String lang, List<Page> firstLevelMenu, List<Page> secondLevelMenu, List<Page> thirdLevelMenu, List<Page> forthLevelMenu) {
        StringBuilder htmlContent = new StringBuilder();
        htmlContent.append("<div class='viewTmpl-leftNav'> <dl class='KdAccordion accordion'>");
        String leftHtml = this.buildLeftMenuToHtml(ctx, lang, firstLevelMenu, secondLevelMenu);
        if (leftHtml.length() > 0) {
            htmlContent.append(leftHtml).append("</dl></div>");
        } else {
            try {
                String nodataTip = this.i18nService.getText(ctx, "res.portal.i18n.page.viewtmpl.viewtmpl", "viewtmpl.result.nopermisson");
                htmlContent.append(nodataTip).append("</dl></div>");
            }
            catch (PortalBizException e) {
                e.printStackTrace();
            }
        }
        return htmlContent.toString();
    }

    private String buildLeftMenuToHtml(PortalContext ctx, String lang, List<Page> firstLevelMenu, List<Page> secondLevelMenu) {
        StringBuilder htmlContent = new StringBuilder();
        String pId = "2b7f4215-aa17-4d89-952e-efc97833cee6";
        for (Page flm : firstLevelMenu) {
            if (!pId.equals(flm.getParentNodeId()) || !flm.isDispaly()) continue;
            String firstId = flm.getId();
            String menuName = this.getlocaleStr(ctx, lang, flm.getDisplayName());
            String className = "6a3d1ba4-c7ca-4eef-b2d0-bb5c150d2901".equals(firstId) ? "zhanlveguanli" : ("89064a33-395d-4bed-a180-3cf3ad1a95cf".equals(firstId) ? "shangyefenxi" : ("d86a366a-04d5-4a45-a531-66bedd19eec5".equals(firstId) ? "caiwuhuiji" : ("6709d072-8251-489b-a762-1eb4ecd03b5b".equals(firstId) ? "caiwugongxiang" : ("b14574e4-3804-4f07-b6e6-d2eab0ffb464".equals(firstId) ? "guanlihuiji" : ("951bf690-c211-4a8b-98e1-839219bfca1f".equals(firstId) ? "xietongguanli" : ("ec3f8128-d4ca-465a-bddc-e1ffad35a785".equals(firstId) ? "qiyejianmo" : ("666c6822-5e05-4b58-89a3-7203c4c3346f".equals(firstId) ? "xitongpingtai" : ("c6ce6520-bc9f-4edc-b7fb-973184441da6".equals(firstId) ? "zichanguanli" : ("b924a80b-1720-49f7-8099-4dfcebb761fa".equals(firstId) ? "gongyinglianguanli" : ("375dc55f-fda5-4790-8cb7-2429e7293022".equals(firstId) ? "zijinguanli" : ("66e7efc0-8652-4302-9f29-d823b909bd15".equals(firstId) ? "tiaomaguanli" : ("8c6a1a55-d7f9-461f-9282-55cf2dcdac08".equals(firstId) ? "jichengguanli" : ("6a82811f-c78d-4eae-b655-211b80c1794e".equals(firstId) ? "shengchanzhizao" : ("6fce81d9-5ac0-4a57-97d0-dec5c1065653".equals(firstId) ? "zhiliangguanli" : ("2215f19f-b4c0-4213-8897-c58e54ff5053".equals(firstId) ? "renliziyuan" : ("b14574e4-3804-4f07-b6e6-d2eab0ffb464".equals(firstId) ? "chengbenguanli" : ("da00444a-fb15-4b56-a69c-aa78a3f3a816".equals(firstId) ? "shuiwuguanli" : ("6e92fb5e-c0d5-443b-a28c-4d1ea2e02c41".equals(firstId) ? "menu GPTzhushou" : ("84d65068-aa63-4817-9f89-6c68777bc5d6".equals(firstId) ? "menu caiwujiqiren" : ("96ba563a-4a01-4b23-8ce4-c63152fb234b".equals(firstId) ? "menu shuzikanban2" : ("944c7c9f-060d-4183-9f82-0e8d93429f61".equals(firstId) ? "menu yidongmenhu" : "zidingyicaidan")))))))))))))))))))));
            htmlContent.append("<dt id='dt_").append(firstId).append("'>").append("<i class='iconfont icon-").append(className).append("'></i>").append(menuName).append("</dt><dd><ul class='appCenter-leftTreeUL' id='icon_").append(flm.getId()).append("'>");
            for (Page slm : secondLevelMenu) {
                if (!firstId.equals(slm.getParentNodeId()) || !slm.isDispaly()) continue;
                String nodeType = slm.getNodeType().name();
                String nodeExt = slm.getNodeExt();
                String isLeaf = "";
                if (nodeExt != null && nodeExt.length() > 0) {
                    JSONObject nodeExtObj = JSONObject.fromObject((Object)nodeExt);
                    PageNodeExt PageNodeExt2 = (PageNodeExt)JSONObject.toBean((JSONObject)nodeExtObj, PageNodeExt.class);
                    isLeaf = String.valueOf(PageNodeExt2.getLeaf());
                }
                if (!(nodeType.equals("FOLDER") || nodeType.equals("EXTERNAL_LINK") && isLeaf.equals("false") || nodeType.equals("EXTERNAL_LINK_SHR") && isLeaf.equals("false")) && (!nodeType.equals("EXTERNAL_LINK_G") || !isLeaf.equals("false"))) continue;
                String displayName = this.getlocaleStr(ctx, lang, slm.getDisplayName());
                htmlContent.append("<li class='viewTmpl-link' id='a_").append(slm.getId()).append("' ");
                htmlContent.append("pageType='").append((Object)slm.getNodeType()).append("' ");
                htmlContent.append("pageId='").append(slm.getId()).append("' ");
                htmlContent.append("pId='").append(firstId).append("' ");
                htmlContent.append("permEditCtrl='").append(slm.getPermEditCtrl()).append("' ");
                if (slm.isDispaly()) {
                    htmlContent.append("style='display:block'>");
                }
                htmlContent.append("<span class='appcenterLeftTree' ").append(">");
                htmlContent.append(displayName).append("</span></li>");
            }
            htmlContent.append("</ul></dd>");
        }
        return htmlContent.toString();
    }

    private String perToSubMunuId(List<Page> perLevelMenu, List<Page> subLevelMenu) {
        ArrayList<AppCenterMenuJson> appCenterMenuList = new ArrayList<AppCenterMenuJson>();
        int len = perLevelMenu.size();
        for (int i = 0; i < len; ++i) {
            Page page = perLevelMenu.get(i);
            if (!page.isDispaly()) continue;
            String perId = perLevelMenu.get(i).getId();
            AppCenterMenuJson appCenterMenuJson = new AppCenterMenuJson();
            appCenterMenuJson.setMenuId(perId);
            ArrayList<String> subIdList = new ArrayList<String>();
            int p = subLevelMenu.size();
            for (int l = 0; l < p; ++l) {
                if (!perId.equals(subLevelMenu.get(l).getParentNodeId())) continue;
                subIdList.add(subLevelMenu.get(l).getId());
            }
            appCenterMenuJson.setSubMenuId(subIdList);
            appCenterMenuList.add(appCenterMenuJson);
        }
        return JSONArray.fromObject(appCenterMenuList).toString();
    }

    private String getlocaleStr(PortalContext ctx, String lang, String str) {
        if (str != null && str.length() > 0 && str.indexOf(":") > 0) {
            JSONObject jsonObj = JSONObject.fromObject((Object)str);
            if (ctx != null) {
                if (lang.equals("l1")) {
                    return jsonObj.getString("en");
                }
                if (lang.equals("l3")) {
                    return jsonObj.getString("zh_TW");
                }
                return jsonObj.getString("zh_CN");
            }
            this.logger.error("PortalContext is null", (Throwable)new Exception("PortalContext is null"));
            return "";
        }
        this.logger.error("localeStr is error localeStr=" + str, (Throwable)new Exception("localeStr is error localeStr"));
        return "";
    }

    public AppCenterDAO getAppCenterDAO() {
        return this.appCenterDAO;
    }

    public void setAppCenterDAO(AppCenterDAO appCenterDAO) {
        this.appCenterDAO = appCenterDAO;
    }

    public PageService getPageService() {
        return this.pageService;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    public II18nService getI18nService() {
        return this.i18nService;
    }

    public void setI18nService(II18nService i18nService) {
        this.i18nService = i18nService;
    }
}

