/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.page.service.impl;

import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.entity.CoreBaseEntity;
import com.kingdee.portal.biz.common.enums.PortletTypeEnum;
import com.kingdee.portal.biz.common.enums.ResTypeEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.common.json.SyncSettingInfo;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.util.PageHelper;
import com.kingdee.portal.biz.module.page.dao.PageDAO;
import com.kingdee.portal.biz.module.page.dao.PagePersonalExtDAO;
import com.kingdee.portal.biz.module.page.dto.PageDTO;
import com.kingdee.portal.biz.module.page.dto.PageModel;
import com.kingdee.portal.biz.module.page.dto.PermDto;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.entity.PageLayoutTmpl;
import com.kingdee.portal.biz.module.page.entity.PagePersonalExt;
import com.kingdee.portal.biz.module.page.service.OnlineEditPageService;
import com.kingdee.portal.biz.module.page.service.PageCacheService;
import com.kingdee.portal.biz.module.page.service.PageLayoutTmplService;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.perm.common.enums.PermTypeEnum;
import com.kingdee.portal.biz.module.perm.entity.PermRefRes;
import com.kingdee.portal.biz.module.perm.service.PermRefResService;
import com.kingdee.portal.biz.module.portlet.common.util.PortletHelper;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.entity.PortletInstance;
import com.kingdee.portal.biz.module.portlet.entity.PortletRuntimePreferences;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class OnlineEditPageServiceImpl
implements OnlineEditPageService {
    private PageDAO pageDAO;
    private PagePersonalExtDAO pagePersonalExtDAO;
    private PortletService portletService;
    private PageCacheService pageCacheService;
    private PageLayoutTmplService pageLayoutTmplService;
    private PageService pageService;
    private PermRefResService permRefResService;
    private II18nService i18nService;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PageModel buildPageModel(PortalContext ctx, String pageId, String userId) throws PortalBizException {
        PageModel model = new PageModel();
        try {
            PagePersonalExt pagePersonalExt;
            model.setUserId(userId);
            model.setPage(this.findPage(pageId));
            if ((NodeTypeEnum.NEW_PAGE.equals((Object)model.getPage().getNodeType()) || NodeTypeEnum.PLAN.equals((Object)model.getPage().getNodeType())) && !model.getPage().getUserId().equalsIgnoreCase(ctx.getLoginUser().getId())) {
                userId = "portal_template_user";
            }
            if ((pagePersonalExt = this.findPagePersonalExt(pageId, userId)) == null) {
                pagePersonalExt = this.buildBlankPagePersonalExt(pageId, userId);
            }
            model.setPagePersonalExt(pagePersonalExt);
            this.collectPortletInfo(ctx, model, pageId, userId);
            if ((NodeTypeEnum.NEW_PAGE.equals((Object)model.getPage().getNodeType()) || NodeTypeEnum.PLAN.equals((Object)model.getPage().getNodeType())) && (!model.getPage().getUserId().equalsIgnoreCase(ctx.getLoginUser().getId()) || "00000000-0000-0000-0000-00000000000013B7DE7F".equalsIgnoreCase(ctx.getLoginUser().getId()))) {
                PageModel copyModel = this.copyPageModel4PersonalPage(model, userId);
                copyModel.setPage(model.getPage());
                return copyModel;
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("231", e);
        }
        return model;
    }

    @Override
    public PageModel buildPageModel4RolePortal(PortalContext ctx, String pageId, String userId, String rolePortalPageId, String rolePortalUserId) throws PortalBizException {
        PageModel currentPageModel = this.buildPageModel(ctx, pageId, userId);
        PageModel rolePageModel = this.buildPageModel(ctx, rolePortalPageId, rolePortalUserId);
        PageModel newCurrentPageModel = this.copyPageModel4PersonalPage(rolePageModel, userId);
        this.correctPageModel4RolePortal(newCurrentPageModel, currentPageModel, rolePageModel);
        return newCurrentPageModel;
    }

    @Override
    public void saveOnlineEditPage(PortalContext ctx, PageModel pageModel, SyncSettingInfo syncSettingInfo) throws PortalBizException {
        if (pageModel != null) {
            try {
                this.saveData(ctx, pageModel);
                this.deleteData(ctx, pageModel);
                this.pageCacheService.buildPageCache(ctx, pageModel.getPage().getId(), pageModel.getUserId());
                if ("portal_template_user".equals(pageModel.getUserId())) {
                    this.pageCacheService.disablePersonalPageCache(ctx, pageModel.getPage().getId(), syncSettingInfo);
                }
            }
            catch (Exception e) {
                throw new PortalBizException("232", e);
            }
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public String saveOnlineEditPageAsPlan(PortalContext ctx, PageModel pageModel, SyncSettingInfo syncSettingInfo, PermDto permDto) throws PortalBizException {
        try {
            Page page = pageModel.getPage();
            if (NodeTypeEnum.PLAN.equals((Object)page.getNodeType())) {
                page.setParentNodeId(page.getParentNodeId());
            } else {
                page.setParentNodeId(page.getId());
            }
            PageDTO pageDto = new PageDTO();
            page.setId(null);
            page.setNodeType(NodeTypeEnum.PLAN);
            pageDto.setPage(page);
            page.setCreator(ctx.getLoginUser().getId());
            page.setPermViewCtrl(true);
            page.setPermEditCtrl(true);
            page.setUserId("portal_template_user");
            String nodeExt = page.getNodeExt();
            JSONObject json = null;
            json = nodeExt != null && nodeExt.length() > 0 ? JSONObject.fromObject((Object)nodeExt) : new JSONObject();
            json.put((Object)"isCanCustomer", (Object)String.valueOf(permDto.isCanCustomer()));
            page.setNodeExt(json.toString());
            page = this.pageService.createPage(ctx, pageDto);
            pageModel.setPage(page);
            pageModel.getPagePersonalExt().setPageId(page.getId());
            if (pageModel.getPltInsList() != null) {
                for (PortletInstance pltIns : pageModel.getPltInsList()) {
                    pltIns.setPageId(page.getId());
                    pltIns.setUserId("portal_template_user");
                }
            }
            this.saveData(ctx, pageModel);
            PermRefRes res = new PermRefRes();
            res.setResType(ResTypeEnum.PLAN);
            res.setSourceType(ResTypeEnum.PLAN.toString());
            res.setResId(page.getId());
            res.setPermInfo("VIEW");
            if (!StringUtils.isEmpty((String)permDto.getEasRoleIds())) {
                res.setPermType(PermTypeEnum.EAS_ROLE);
                this.getPermRefResService().batchCreatePermRefRes(ctx, res, permDto.getEasRoleIds().split(","), new String[0]);
            }
            if (!StringUtils.isEmpty((String)permDto.getUserIds())) {
                res.setPermType(PermTypeEnum.USER);
                this.getPermRefResService().batchCreatePermRefRes(ctx, res, permDto.getUserIds().split(","), new String[0]);
            }
            if (!StringUtils.isEmpty((String)permDto.getGroupIds())) {
                res.setPermType(PermTypeEnum.GROUP);
                this.getPermRefResService().batchCreatePermRefRes(ctx, res, permDto.getGroupIds().split(","), new String[0]);
            }
            if (!StringUtils.isEmpty((String)permDto.getRoleIds())) {
                res.setPermType(PermTypeEnum.ROLE);
                this.getPermRefResService().batchCreatePermRefRes(ctx, res, permDto.getRoleIds().split(","), new String[0]);
            }
            this.pageCacheService.buildPageCache(ctx, page.getId(), "portal_template_user");
            return page.getId();
        }
        catch (Exception e) {
            throw new PortalBizException("232", e);
        }
    }

    @Override
    public String saveOnlineEditPage4Customer(PortalContext ctx, PageModel pageModel, SyncSettingInfo syncSettingInfo) throws PortalBizException {
        try {
            String pageId = NodeTypeEnum.NEW_PAGE.equals((Object)pageModel.getPage().getNodeType()) ? pageModel.getPage().getId() : pageModel.getPage().getParentNodeId();
            List personalPlans = this.pageDAO.findList(new Filter[]{new FieldFilter("parentNodeId", "=", pageId), new FieldFilter("userId", "=", ctx.getLoginUser().getId())});
            for (Page page : personalPlans) {
                this.pageService.deletePageById(ctx, page.getId());
            }
            Page page = pageModel.getPage();
            if (NodeTypeEnum.PLAN.equals((Object)page.getNodeType())) {
                page.setParentNodeId(page.getParentNodeId());
            } else {
                page.setParentNodeId(page.getId());
            }
            PageDTO pageDto = new PageDTO();
            DisplayName display = new DisplayName(page.getDisplayName());
            display.setEn(ctx.getLoginUser().getName() + "'s " + display.getEn() + this.i18nService.getText(ctx, "res.portal.i18n.frame.global", "jPortal_core_engine_tool.planSwitch.CUSTOM", Locale.ENGLISH));
            display.setZh_CN(ctx.getLoginUser().getName() + display.getZh_CN() + "\u7684" + this.i18nService.getText(ctx, "res.portal.i18n.frame.global", "jPortal_core_engine_tool.planSwitch.CUSTOM", Locale.SIMPLIFIED_CHINESE));
            display.setZh_TW(ctx.getLoginUser().getName() + display.getZh_TW() + "\u7684" + this.i18nService.getText(ctx, "res.portal.i18n.frame.global", "jPortal_core_engine_tool.planSwitch.CUSTOM", Locale.TRADITIONAL_CHINESE));
            page.setId(null);
            page.setPageNumber(PageHelper.generatePageNumber());
            page.setDisplayName(display.toString());
            page.setNodeType(NodeTypeEnum.PLAN);
            page.setPermEditCtrl(false);
            page.setPermViewCtrl(false);
            pageDto.setPage(page);
            page.setCreator(ctx.getLoginUser().getId());
            page.setUserId(ctx.getLoginUser().getId());
            page = this.pageService.createPage(ctx, pageDto);
            pageModel.setPage(page);
            pageModel.getPagePersonalExt().setPageId(page.getId());
            pageModel.getPagePersonalExt().setUserId(ctx.getLoginUser().getId());
            if (pageModel.getPltInsList() != null) {
                for (PortletInstance pltIns : pageModel.getPltInsList()) {
                    pltIns.setPageId(page.getId());
                    pltIns.setUserId(ctx.getLoginUser().getId());
                }
            }
            this.saveData(ctx, pageModel);
            return page.getId();
        }
        catch (Exception e) {
            throw new PortalBizException("232", e);
        }
    }

    @Override
    public void saveOnlineEditPage4Current(PortalContext ctx, PageModel pageModel, SyncSettingInfo syncSettingInfo) throws PortalBizException {
        try {
            if (pageModel.getPltInsList() != null) {
                for (PortletInstance pltIns : pageModel.getPltInsList()) {
                    pltIns.setUserId(pageModel.getPage().getUserId());
                }
            }
            Map<String, Object> map = this.findPortletInfoMap(ctx, pageModel.getPage().getId(), pageModel.getUserId());
            List insList = (List)map.get("pltInsList");
            List prefList = (List)map.get("pltRuntimePrefList");
            ArrayList<String> insIds = new ArrayList<String>(insList.size());
            for (Object pi : insList) {
                insIds.add(((CoreBaseEntity)pi).getId());
            }
            this.deletePltIns(ctx, insIds);
            ArrayList<String> prefIds = new ArrayList<String>(insList.size());
            for (PortletRuntimePreferences pref : prefList) {
                prefIds.add(pref.getId());
            }
            this.deletePltRuntimePref(ctx, prefIds);
            PagePersonalExt pagePersonalExt = this.findPagePersonalExt(pageModel.getPage().getId(), pageModel.getUserId());
            if (pagePersonalExt != null) {
                this.pagePersonalExtDAO.deleteById(pagePersonalExt.getId());
            }
            this.saveData(ctx, pageModel);
            this.pageCacheService.buildPageCache(ctx, pageModel.getPage().getId(), pageModel.getUserId());
        }
        catch (Exception e) {
            throw new PortalBizException("232", e);
        }
    }

    @Override
    public void syncPersonalPageFormAdmin(PortalContext portalContext, String pageId, String userId) throws PortalBizException {
        try {
            if (this.isExisted4PersonalPage(portalContext, pageId, userId)) {
                SyncSettingInfo syncSettingInfo = this.pageCacheService.findSyncSettingInfo(portalContext, pageId, userId);
                this.updatePersonalPageFormAdmin(portalContext, pageId, userId, syncSettingInfo);
            } else {
                this.createPersonalPageFormAdmin(portalContext, pageId, userId);
            }
        }
        catch (Exception ex) {
            throw new PortalBizException("206", ex);
        }
    }

    @Override
    public Map<String, Object> buildNewPortletInstanceMap(PortalContext ctx, String pageId, String userId, PortletDefinition portletDefinition, int orderNum) throws PortalBizException {
        HashMap<String, Object> pltInsMap = new HashMap<String, Object>();
        PortletInstance portletInstance = this.buildPortletInstance(pageId, userId, portletDefinition, orderNum);
        PortletRuntimePreferences portletRuntimePreferences = this.buildPortletRuntimePreferences(portletInstance.getId(), portletDefinition);
        pltInsMap.put("portletInstance", portletInstance);
        pltInsMap.put("portletRuntimePreferences", portletRuntimePreferences);
        return pltInsMap;
    }

    @Override
    public void copyPage(PortalContext portalContext, String fromPageId, String formUserId, String toPageId, String toUserId) throws PortalBizException {
        try {
            PageModel formPageModel = this.buildPageModel(portalContext, fromPageId, formUserId);
            PageModel personalPageModel = this.copyPageModel4PersonalPage(formPageModel, toUserId);
            personalPageModel.getPagePersonalExt().setPageId(toPageId);
            if (personalPageModel.getPltInsList() != null) {
                for (PortletInstance pltIns : personalPageModel.getPltInsList()) {
                    pltIns.setPageId(toPageId);
                }
            }
            this.saveData(portalContext, personalPageModel);
        }
        catch (Exception ex) {
            throw new PortalBizException("209", ex);
        }
    }

    private void correctPageModel4RolePortal(PageModel newCurrentPageModel, PageModel currentPageModel, PageModel rolePageModel) {
        String pageId = currentPageModel.getPage().getId();
        newCurrentPageModel.setPage(currentPageModel.getPage());
        String layoutTmplId = rolePageModel.getPagePersonalExt().getLayoutTmplId();
        PagePersonalExt pagePersonalExt = currentPageModel.getPagePersonalExt();
        pagePersonalExt.setLayoutTmplId(layoutTmplId);
        newCurrentPageModel.setPagePersonalExt(pagePersonalExt);
        if (newCurrentPageModel.getPltInsList() != null) {
            for (PortletInstance pltIns : newCurrentPageModel.getPltInsList()) {
                pltIns.setPageId(pageId);
            }
        }
        if (currentPageModel.getPltInsList() != null) {
            for (PortletInstance portletInstance : currentPageModel.getPltInsList()) {
                newCurrentPageModel.getDelPltInsIdList().add(portletInstance.getId());
            }
        }
        if (currentPageModel.getPltRuntimePreferencesList() != null) {
            for (PortletRuntimePreferences pltPre : currentPageModel.getPltRuntimePreferencesList()) {
                newCurrentPageModel.getDelPltRuntimePreferencesIdList().add(pltPre.getId());
            }
        }
    }

    private PortletInstance buildPortletInstance(String pageId, String userId, PortletDefinition portletDefinition, int orderNum) {
        PortletInstance portletIns = new PortletInstance();
        portletIns.setId(UUID.randomUUID().toString());
        portletIns.setPageId(pageId);
        portletIns.setUserId(userId);
        portletIns.setDefinitionId(portletDefinition.getId());
        portletIns.setArea("c1");
        portletIns.setOrderNum(orderNum);
        portletIns.setInner(false);
        portletIns.setDisplayName(portletDefinition.getDisplayName());
        portletIns.setThemeId(portletDefinition.getThemeId());
        portletIns.setTmplId(portletDefinition.getTmplId());
        portletIns.setHeight("auto");
        portletIns.setPortletType(portletDefinition.getPortletType());
        return portletIns;
    }

    private PortletRuntimePreferences buildPortletRuntimePreferences(String portletInsId, PortletDefinition portletDefinition) {
        PortletRuntimePreferences portletRuntimePreferences = new PortletRuntimePreferences();
        portletRuntimePreferences.setId(UUID.randomUUID().toString());
        portletRuntimePreferences.setInsId(portletInsId);
        portletRuntimePreferences.setPreferences(portletDefinition.getPreferences());
        return portletRuntimePreferences;
    }

    private Page findPage(String pageId) throws DataAccessException {
        return (Page)this.pageDAO.findById(pageId);
    }

    private PagePersonalExt buildBlankPagePersonalExt(String pageId, String userId) {
        PagePersonalExt pagePersonalExt = new PagePersonalExt();
        pagePersonalExt.setPageId(pageId);
        pagePersonalExt.setUserId(userId);
        String layoutTmplId = PortalCache.getPortalProfileMap().get("default_page_layout");
        pagePersonalExt.setLayoutTmplId(layoutTmplId);
        return pagePersonalExt;
    }

    private PagePersonalExt findPagePersonalExt(String pageId, String userId) throws DataAccessException {
        PagePersonalExt ext = new PagePersonalExt();
        ext.setPageId(pageId);
        ext.setUserId(userId);
        return this.pagePersonalExtDAO.findObject(ext, new Filter[0]);
    }

    private void collectPortletInfo(PortalContext ctx, PageModel model, String pageId, String userId) throws PortalBizException {
        Map<String, Object> map = this.findPortletInfoMap(ctx, pageId, userId);
        List insList = (List)map.get("pltInsList");
        List prefList = (List)map.get("pltRuntimePrefList");
        model.setPltInsList(insList);
        model.setPltRuntimePreferencesList(prefList);
    }

    private Map<String, Object> findPortletInfoMap(PortalContext ctx, String pageId, String userId) throws PortalBizException {
        return this.portletService.findPortletInfoMap(ctx, pageId, userId);
    }

    private boolean isExisted4PersonalPage(PortalContext portalContext, String pageId, String userId) throws DataAccessException {
        PagePersonalExt filter = new PagePersonalExt();
        filter.setPageId(pageId);
        filter.setUserId(userId);
        PagePersonalExt pagePersonalExt = this.pagePersonalExtDAO.findObject(filter, new Filter[0]);
        return pagePersonalExt != null;
    }

    private PagePersonalExt copyPagePersonalExt(PagePersonalExt adminPagePersonalExt, String userId) {
        PagePersonalExt pagePersonalExt = new PagePersonalExt();
        pagePersonalExt.setId(UUID.randomUUID().toString());
        pagePersonalExt.setUserId(userId);
        pagePersonalExt.setPageId(adminPagePersonalExt.getPageId());
        pagePersonalExt.setLayoutTmplId(adminPagePersonalExt.getLayoutTmplId());
        return pagePersonalExt;
    }

    private PortletInstance copyPortletInstance(PortletInstance adminPltIns, String userId) {
        PortletInstance personalPltIns = new PortletInstance();
        personalPltIns.setId(UUID.randomUUID().toString());
        personalPltIns.setPageId(adminPltIns.getPageId());
        personalPltIns.setUserId(userId);
        personalPltIns.setDefinitionId(adminPltIns.getDefinitionId());
        personalPltIns.setInner(adminPltIns.getInner());
        personalPltIns.setArea(adminPltIns.getArea());
        personalPltIns.setOrderNum(adminPltIns.getOrderNum());
        personalPltIns.setRefInsId(adminPltIns.getId());
        personalPltIns.setThemeId(adminPltIns.getThemeId());
        personalPltIns.setTmplId(adminPltIns.getTmplId());
        personalPltIns.setDisplayName(adminPltIns.getDisplayName());
        personalPltIns.setHeight(adminPltIns.getHeight());
        personalPltIns.setPortletType(adminPltIns.getPortletType());
        personalPltIns.setGsPosition(adminPltIns.getGsPosition());
        return personalPltIns;
    }

    private PortletRuntimePreferences copyPortletRuntimePreferences(PortletRuntimePreferences adminPltPreferences, String pltInsId) {
        PortletRuntimePreferences pltPreferences = new PortletRuntimePreferences();
        pltPreferences.setId(UUID.randomUUID().toString());
        pltPreferences.setInsId(pltInsId);
        pltPreferences.setPreferences(adminPltPreferences.getPreferences());
        return pltPreferences;
    }

    private PageModel copyPageModel4PersonalPage(PageModel pageModel, String userId) {
        PageModel personalPageModel = new PageModel();
        personalPageModel.setUserId(userId);
        personalPageModel.setPltInsList(new ArrayList<PortletInstance>());
        personalPageModel.setPltRuntimePreferencesList(new ArrayList<PortletRuntimePreferences>());
        PagePersonalExt pagePersonalExt = this.copyPagePersonalExt(pageModel.getPagePersonalExt(), userId);
        personalPageModel.setPagePersonalExt(pagePersonalExt);
        List<PortletInstance> pltInsList = pageModel.getPltInsList();
        if (pltInsList != null) {
            ArrayList<PortletRuntimePreferences> containerPreferencesList = new ArrayList<PortletRuntimePreferences>();
            List<PortletRuntimePreferences> pltRuntimePreferencesList = pageModel.getPltRuntimePreferencesList();
            for (PortletInstance adminPltIns : pltInsList) {
                PortletInstance personalPltIns = this.copyPortletInstance(adminPltIns, userId);
                personalPageModel.getPltInsList().add(personalPltIns);
                PortletRuntimePreferences adminPltPreferences = this.getPortletRuntimePreferencesFormList(adminPltIns.getId(), pltRuntimePreferencesList);
                if (adminPltPreferences == null) continue;
                PortletRuntimePreferences personalPltPreferences = this.copyPortletRuntimePreferences(adminPltPreferences, personalPltIns.getId());
                if (personalPltIns.getPortletType().equals((Object)PortletTypeEnum.CONTAINER)) {
                    containerPreferencesList.add(personalPltPreferences);
                    continue;
                }
                personalPageModel.getPltRuntimePreferencesList().add(personalPltPreferences);
            }
            if (containerPreferencesList.size() > 0) {
                personalPageModel = this.updateContainerPreferences(containerPreferencesList, personalPageModel);
            }
        }
        return personalPageModel;
    }

    private PageModel updateContainerPreferences(List<PortletRuntimePreferences> containerList, PageModel personalPageModel) {
        for (PortletRuntimePreferences pref : containerList) {
            Preferences preferences = PortletHelper.convPreferences(pref.getPreferences());
            if (preferences != null) {
                List<Object> ctInstanceList = new ArrayList();
                for (int i = 0; i < preferences.getPreferences().size(); ++i) {
                    if (!preferences.getPreferences().get(i).getName().equals("ctInstanceList")) continue;
                    ctInstanceList = preferences.getPreferences().get(i).getValues();
                    ArrayList<String> newIdList = new ArrayList<String>();
                    for (int j = 0; j < ctInstanceList.size(); ++j) {
                        for (PortletInstance instance : personalPageModel.getPltInsList()) {
                            if (!((String)ctInstanceList.get(j)).equals(instance.getRefInsId())) continue;
                            newIdList.add(instance.getId());
                        }
                    }
                    preferences.getPreferences().get(i).setValues(newIdList);
                    pref.setPreferences(preferences.toString());
                }
                personalPageModel.getPltRuntimePreferencesList().add(pref);
                continue;
            }
            personalPageModel.getPltRuntimePreferencesList().add(pref);
        }
        return personalPageModel;
    }

    private PortletRuntimePreferences getPortletRuntimePreferencesFormList(String pltInsId, List<PortletRuntimePreferences> pltRuntimePreferencesList) {
        PortletRuntimePreferences portletRuntimePreferences = null;
        if (pltRuntimePreferencesList != null) {
            for (PortletRuntimePreferences temp : pltRuntimePreferencesList) {
                if (!temp.getInsId().equals(pltInsId)) continue;
                portletRuntimePreferences = temp;
                break;
            }
        }
        return portletRuntimePreferences;
    }

    private void createPersonalPageFormAdmin(PortalContext portalContext, String pageId, String userId) throws PortalBizException, DataAccessException {
        PageModel adminPageModel = this.buildPageModel(portalContext, pageId, "portal_template_user");
        PageModel personalPageModel = this.copyPageModel4PersonalPage(adminPageModel, userId);
        this.saveData(portalContext, personalPageModel);
    }

    private void updatePersonalPageFormAdmin(PortalContext portalContext, String pageId, String userId, SyncSettingInfo syncSettingInfo) throws PortalBizException, DataAccessException {
        PageModel adminPageModel = this.buildPageModel(portalContext, pageId, "portal_template_user");
        PageModel personalPageModel = this.buildPageModel(portalContext, pageId, userId);
        this.mergePersonalPageModel(adminPageModel, personalPageModel, syncSettingInfo);
        this.saveData(portalContext, personalPageModel);
        this.deleteData(portalContext, personalPageModel);
        this.pageCacheService.enablePersonalPageCache(portalContext, pageId, userId);
    }

    private void mergePersonalPageModel(PageModel adminPageModel, PageModel personalPageModel, SyncSettingInfo syncSettingInfo) throws DataAccessException, PortalBizException {
        if (syncSettingInfo.isDelExistedPortlet()) {
            this.syncDelExistedPortlet(adminPageModel, personalPageModel);
        }
        if (syncSettingInfo.isDynamicPortlet()) {
            this.syncDynamicPortlet(adminPageModel, personalPageModel);
        }
        if (syncSettingInfo.isDelPersonalPortlet()) {
            this.syncDelPersonalPortlet(adminPageModel, personalPageModel);
        }
        if (syncSettingInfo.isPageLayoutTmpl()) {
            this.syncPageLayoutTmpl(adminPageModel, personalPageModel);
        }
        if (syncSettingInfo.isPortletOutlook()) {
            this.syncPortletOutlook(adminPageModel, personalPageModel);
        }
        if (syncSettingInfo.isPortletPreferences()) {
            this.syncPortletPreferences(adminPageModel, personalPageModel);
        }
        if (syncSettingInfo.isPortletOrder()) {
            this.syncPortletOrder(adminPageModel, personalPageModel);
        }
    }

    private boolean isExisted4AdminPortletInPersonalPage(String adminPltId, PageModel personalPageModel) {
        PortletInstance portletInstance = this.getRefPortletInPersonalPage(adminPltId, personalPageModel);
        return portletInstance != null;
    }

    private boolean isExisted4personalPortletInAdminPage(String personalPltRefId, PageModel adminPageModel) {
        if (adminPageModel.getPltInsList() != null) {
            for (PortletInstance temp : adminPageModel.getPltInsList()) {
                if (!temp.getId().equals(personalPltRefId)) continue;
                return true;
            }
        }
        return false;
    }

    private PortletInstance getRefPortletInPersonalPage(String adminPltId, PageModel personalPageModel) {
        if (personalPageModel.getPltInsList() != null) {
            for (PortletInstance temp : personalPageModel.getPltInsList()) {
                if (!adminPltId.equals(temp.getRefInsId())) continue;
                return temp;
            }
        }
        return null;
    }

    private void syncDelExistedPortlet(PageModel adminPageModel, PageModel personalPageModel) {
        ArrayList<PortletInstance> delPltInsList = new ArrayList<PortletInstance>();
        for (PortletInstance personalPortlet : personalPageModel.getPltInsList()) {
            String pltInsId = personalPortlet.getId();
            personalPageModel.getDelPltInsIdList().add(pltInsId);
            delPltInsList.add(personalPortlet);
            PortletRuntimePreferences personalRuntimePrefer = this.getPortletRuntimePreferencesFormList(pltInsId, personalPageModel.getPltRuntimePreferencesList());
            if (personalRuntimePrefer == null) continue;
            personalPageModel.getDelPltRuntimePreferencesIdList().add(personalRuntimePrefer.getId());
            personalPageModel.getPltRuntimePreferencesList().remove(personalRuntimePrefer);
        }
        for (PortletInstance delPltIns : delPltInsList) {
            personalPageModel.getPltInsList().remove(delPltIns);
        }
    }

    private void syncDynamicPortlet(PageModel adminPageModel, PageModel personalPageModel) {
        PortletRuntimePreferences personalRuntimePrefer;
        String userId = personalPageModel.getUserId();
        if (adminPageModel.getPltInsList() != null) {
            for (PortletInstance adminPortlet : adminPageModel.getPltInsList()) {
                if (this.isExisted4AdminPortletInPersonalPage(adminPortlet.getId(), personalPageModel)) continue;
                PortletInstance personalPlt = this.copyPortletInstance(adminPortlet, userId);
                personalPageModel.getPltInsList().add(personalPlt);
                PortletRuntimePreferences adminRuntimePrefer = this.getPortletRuntimePreferencesFormList(adminPortlet.getId(), adminPageModel.getPltRuntimePreferencesList());
                if (adminRuntimePrefer == null) continue;
                personalRuntimePrefer = this.copyPortletRuntimePreferences(adminRuntimePrefer, personalPlt.getId());
                personalPageModel.getPltRuntimePreferencesList().add(personalRuntimePrefer);
            }
        }
        if (personalPageModel.getPltInsList() != null) {
            ArrayList<PortletInstance> delPltInsList = new ArrayList<PortletInstance>();
            for (PortletInstance personalPortlet : personalPageModel.getPltInsList()) {
                if (StringUtil.isEmpty((String)personalPortlet.getRefInsId()) || this.isExisted4personalPortletInAdminPage(personalPortlet.getRefInsId(), adminPageModel)) continue;
                String pltInsId = personalPortlet.getId();
                personalPageModel.getDelPltInsIdList().add(pltInsId);
                delPltInsList.add(personalPortlet);
                personalRuntimePrefer = this.getPortletRuntimePreferencesFormList(pltInsId, personalPageModel.getPltRuntimePreferencesList());
                if (personalRuntimePrefer == null) continue;
                personalPageModel.getDelPltRuntimePreferencesIdList().add(personalRuntimePrefer.getId());
                personalPageModel.getPltRuntimePreferencesList().remove(personalRuntimePrefer);
            }
            for (PortletInstance delPltIns : delPltInsList) {
                personalPageModel.getPltInsList().remove(delPltIns);
            }
        }
    }

    private void syncDelPersonalPortlet(PageModel adminPageModel, PageModel personalPageModel) {
        if (personalPageModel.getPltInsList() != null) {
            ArrayList<PortletInstance> delPltInsList = new ArrayList<PortletInstance>();
            for (PortletInstance personalPortlet : personalPageModel.getPltInsList()) {
                if (!StringUtil.isEmpty((String)personalPortlet.getRefInsId())) continue;
                String pltInsId = personalPortlet.getId();
                personalPageModel.getDelPltInsIdList().add(pltInsId);
                delPltInsList.add(personalPortlet);
                PortletRuntimePreferences personalRuntimePrefer = this.getPortletRuntimePreferencesFormList(pltInsId, personalPageModel.getPltRuntimePreferencesList());
                if (personalRuntimePrefer == null) continue;
                personalPageModel.getDelPltRuntimePreferencesIdList().add(personalRuntimePrefer.getId());
                personalPageModel.getPltRuntimePreferencesList().remove(personalRuntimePrefer);
            }
            for (PortletInstance delPltIns : delPltInsList) {
                personalPageModel.getPltInsList().remove(delPltIns);
            }
        }
    }

    private void syncPageLayoutTmpl(PageModel adminPageModel, PageModel personalPageModel) throws PortalBizException {
        String pagesonalPageLayoutTmplId;
        String adminPageLayoutTmplId = adminPageModel.getPagePersonalExt().getLayoutTmplId();
        if (adminPageLayoutTmplId.equals(pagesonalPageLayoutTmplId = personalPageModel.getPagePersonalExt().getLayoutTmplId())) {
            return;
        }
        PageLayoutTmpl adminPageLayoutTmpl = this.pageLayoutTmplService.findLayoutTmplById(null, adminPageLayoutTmplId);
        PageLayoutTmpl personalPageLayoutTmpl = this.pageLayoutTmplService.findLayoutTmplById(null, pagesonalPageLayoutTmplId);
        personalPageModel.getPagePersonalExt().setLayoutTmplId(adminPageLayoutTmplId);
        if (adminPageLayoutTmpl.getMaxWorkArea() > personalPageLayoutTmpl.getMaxWorkArea()) {
            String defaultLayoutArea = "c1";
            if (personalPageModel.getPltInsList() != null) {
                for (PortletInstance personalPortlet : personalPageModel.getPltInsList()) {
                    Integer areaName = new Integer(personalPortlet.getArea().substring(1));
                    if (areaName <= adminPageLayoutTmpl.getMaxWorkArea()) continue;
                    personalPortlet.setArea(defaultLayoutArea);
                }
            }
        }
    }

    private void syncPortletOutlook(PageModel adminPageModel, PageModel personalPageModel) {
        if (adminPageModel.getPltInsList() != null) {
            for (PortletInstance adminPortlet : adminPageModel.getPltInsList()) {
                PortletInstance refPortlet = this.getRefPortletInPersonalPage(adminPortlet.getId(), personalPageModel);
                if (refPortlet == null) continue;
                refPortlet.setThemeId(adminPortlet.getThemeId());
                refPortlet.setTmplId(adminPortlet.getTmplId());
                refPortlet.setDisplayName(adminPortlet.getDisplayName());
                refPortlet.setHeight(adminPortlet.getHeight());
            }
        }
    }

    private void syncPortletPreferences(PageModel adminPageModel, PageModel personalPageModel) {
        if (adminPageModel.getPltInsList() != null) {
            for (PortletInstance adminPortlet : adminPageModel.getPltInsList()) {
                PortletInstance refPortlet = this.getRefPortletInPersonalPage(adminPortlet.getId(), personalPageModel);
                if (refPortlet == null) continue;
                PortletRuntimePreferences adminRuntimePrefer = this.getPortletRuntimePreferencesFormList(adminPortlet.getId(), adminPageModel.getPltRuntimePreferencesList());
                PortletRuntimePreferences personalRuntimePrefer = this.getPortletRuntimePreferencesFormList(refPortlet.getId(), personalPageModel.getPltRuntimePreferencesList());
                if (personalRuntimePrefer == null) continue;
                if (PortletTypeEnum.CONTAINER.equals((Object)refPortlet.getPortletType())) {
                    personalRuntimePrefer = this.syncContainerPreferences(adminRuntimePrefer, personalRuntimePrefer, personalPageModel);
                    continue;
                }
                personalRuntimePrefer.setPreferences(adminRuntimePrefer.getPreferences());
            }
        }
    }

    private PortletRuntimePreferences syncContainerPreferences(PortletRuntimePreferences adminRuntimePrefer, PortletRuntimePreferences pref, PageModel personalPageModel) {
        List<PortletInstance> insdanceList = personalPageModel.getPltInsList();
        Preferences preferences = PortletHelper.convPreferences(adminRuntimePrefer.getPreferences());
        if (preferences != null) {
            List<Object> ctInstanceList = new ArrayList();
            for (int i = 0; i < preferences.getPreferences().size(); ++i) {
                if (!preferences.getPreferences().get(i).getName().equals("ctInstanceList")) continue;
                ctInstanceList = preferences.getPreferences().get(i).getValues();
                ArrayList<String> newIdList = new ArrayList<String>();
                for (int j = 0; j < ctInstanceList.size(); ++j) {
                    for (PortletInstance instance : insdanceList) {
                        if (!((String)ctInstanceList.get(j)).equals(instance.getRefInsId())) continue;
                        newIdList.add(instance.getId());
                    }
                }
                preferences.getPreferences().get(i).setValues(newIdList);
            }
            pref.setPreferences(preferences.toString());
        } else {
            pref.setPreferences(null);
        }
        return pref;
    }

    private void syncPortletOrder(PageModel adminPageModel, PageModel personalPageModel) {
        if (adminPageModel.getPltInsList() != null) {
            for (PortletInstance adminPortlet : adminPageModel.getPltInsList()) {
                PortletInstance refPortlet = this.getRefPortletInPersonalPage(adminPortlet.getId(), personalPageModel);
                if (refPortlet == null) continue;
                refPortlet.setOrderNum(adminPortlet.getOrderNum());
            }
        }
    }

    private void saveData(PortalContext ctx, PageModel pageModel) throws DataAccessException, PortalBizException {
        this.savePagePersonalExt(ctx, pageModel.getPagePersonalExt());
        this.savePltInsList(ctx, pageModel.getPltInsList());
        this.savePltRuntimePrefList(ctx, pageModel.getPltRuntimePreferencesList());
    }

    private void savePagePersonalExt(PortalContext ctx, PagePersonalExt ext) throws DataAccessException {
        ext.setPortalContext(ctx);
        if (StringUtil.isEmpty((String)ext.getCreator())) {
            this.pagePersonalExtDAO.create(ext);
            return;
        }
        this.pagePersonalExtDAO.update(ext);
    }

    private void savePltInsList(PortalContext ctx, List<PortletInstance> instanceList) throws PortalBizException {
        for (PortletInstance instance : instanceList) {
            instance.setPortalContext(ctx);
            if (StringUtil.isEmpty((String)instance.getCreator())) {
                this.portletService.createPortletInstance(ctx, instance);
                continue;
            }
            this.portletService.updatePortletInstance(ctx, instance);
        }
    }

    private void savePltRuntimePrefList(PortalContext ctx, List<PortletRuntimePreferences> runtimePrefList) throws PortalBizException {
        for (PortletRuntimePreferences instance : runtimePrefList) {
            instance.setPortalContext(ctx);
            if (StringUtil.isEmpty((String)instance.getCreator())) {
                this.portletService.createPortletRuntimePreferences(ctx, instance);
                continue;
            }
            this.portletService.updatePortletRuntimePreferences(ctx, instance);
        }
    }

    private void deleteData(PortalContext ctx, PageModel pageModel) throws PortalBizException {
        this.deletePltIns(ctx, pageModel.getDelPltInsIdList());
        this.deletePltRuntimePref(ctx, pageModel.getDelPltRuntimePreferencesIdList());
    }

    private void deletePltIns(PortalContext ctx, List<String> insList) throws PortalBizException {
        if (insList == null) {
            return;
        }
        String[] idArray = new String[insList.size()];
        this.portletService.deletePortletInstanceByIds(ctx, insList.toArray(idArray));
    }

    private void deletePltRuntimePref(PortalContext ctx, List<String> prefList) throws PortalBizException {
        if (prefList == null) {
            return;
        }
        String[] idArray = new String[prefList.size()];
        this.portletService.deletePortletRuntimePreferencesByIds(ctx, prefList.toArray(idArray));
    }

    public void setPageDAO(PageDAO pageDAO) {
        this.pageDAO = pageDAO;
    }

    public void setPagePersonalExtDAO(PagePersonalExtDAO pagePersonalExtDAO) {
        this.pagePersonalExtDAO = pagePersonalExtDAO;
    }

    public void setPortletService(PortletService portletService) {
        this.portletService = portletService;
    }

    public void setPageCacheService(PageCacheService pageCacheService) {
        this.pageCacheService = pageCacheService;
    }

    public void setPageLayoutTmplService(PageLayoutTmplService pageLayoutTmplService) {
        this.pageLayoutTmplService = pageLayoutTmplService;
    }

    public PageService getPageService() {
        return this.pageService;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    public PermRefResService getPermRefResService() {
        return this.permRefResService;
    }

    public void setPermRefResService(PermRefResService permRefResService) {
        this.permRefResService = permRefResService;
    }

    public II18nService getI18nService() {
        return this.i18nService;
    }

    public void setI18nService(II18nService i18nService) {
        this.i18nService = i18nService;
    }
}

