/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.page.service.impl;

import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.PortletIns;
import com.kingdee.portal.biz.common.json.SyncSettingInfo;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.enums.PageStatusEnum;
import com.kingdee.portal.biz.module.page.common.json.PageInfo;
import com.kingdee.portal.biz.module.page.common.json.PageMargin;
import com.kingdee.portal.biz.module.page.dao.PageCacheDAO;
import com.kingdee.portal.biz.module.page.dao.PagePersonalExtDAO;
import com.kingdee.portal.biz.module.page.dto.PageModel;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.entity.PageCache;
import com.kingdee.portal.biz.module.page.entity.PagePersonalExt;
import com.kingdee.portal.biz.module.page.service.OnlineEditPageService;
import com.kingdee.portal.biz.module.page.service.PageCacheService;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.portlet.entity.PortletInstance;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PageCacheServiceImpl
implements PageCacheService {
    private PageCacheDAO pageCacheDAO;
    private PagePersonalExtDAO pagePersonalExtDAO;
    private PortletService portletService;
    private PageService pageService;
    private OnlineEditPageService onlineEditPageService;

    @Override
    public void buildPageCache(PortalContext ctx, String pageId, String userId) throws PortalBizException {
        try {
            if (this.isExistedOfPageCache(pageId, userId)) {
                this.updatePageCache(ctx, pageId, userId);
            } else {
                this.createPageCache(ctx, pageId, userId);
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("221", e);
        }
    }

    @Override
    public PageCache buildTempPageCache4PageModel(PortalContext ctx, PageModel pageModel) throws PortalBizException {
        PageCache pageCache = new PageCache();
        String pageInfoJSON = this.buildPageInfoJSON(pageModel.getPage(), pageModel.getPagePersonalExt());
        String portletListJSON = this.buildPortletListJSON(ctx, pageModel.getPltInsList());
        pageCache.setPageInfo(pageInfoJSON);
        pageCache.setPortletList(portletListJSON);
        return pageCache;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public PageCache findPageCache4Show(PortalContext ctx, String pageId, String userId) throws PortalBizException {
        try {
            Page page = this.pageService.findPageById(ctx, pageId);
            if (page == null) {
                HashMap<String, Object> exceptionParam = new HashMap<String, Object>();
                exceptionParam.put("pageId", pageId);
                throw new PortalBizException("207", null, exceptionParam);
            }
            if (NodeTypeEnum.NEW_PAGE.equals((Object)page.getNodeType()) || NodeTypeEnum.PLAN.equals((Object)page.getNodeType())) {
                List pageCacheList = null;
                if (!page.getUserId().equalsIgnoreCase(ctx.getLoginUser().getId())) {
                    userId = "portal_template_user";
                }
                if ((pageCacheList = this.pageCacheDAO.findList(new Filter[]{new FieldFilter("pageId", "=", pageId), new FieldFilter("userId", "=", userId)})) == null || pageCacheList.size() == 0) {
                    this.buildPageCache(ctx, pageId, userId);
                    pageCacheList = this.pageCacheDAO.findList(new Filter[]{new FieldFilter("pageId", "=", pageId), new FieldFilter("userId", "=", userId)});
                }
                return (PageCache)pageCacheList.get(0);
            }
            if (this.pageService.isAdminPage(ctx, page)) {
                if ("portal_template_user".equals(userId)) {
                    PageCache pageCache = this.findPageCache(ctx, pageId, userId);
                    if (pageCache == null) {
                        this.buildPageCache(ctx, pageId, userId);
                        return this.findPageCache(ctx, pageId, userId);
                    }
                    return pageCache;
                }
                String[] userIds = new String[]{"portal_template_user", userId};
                List<PageCache> pageCacheList = this.pageCacheDAO.findPageCacheList(ctx, pageId, userIds);
                if (pageCacheList == null || pageCacheList.isEmpty()) {
                    this.buildPageCache(ctx, pageId, "portal_template_user");
                    pageCacheList = this.pageCacheDAO.findPageCacheList(ctx, pageId, userIds);
                }
                if (pageCacheList.size() == 1 && "portal_template_user".equals(pageCacheList.get(0).getUserId())) {
                    this.onlineEditPageService.syncPersonalPageFormAdmin(ctx, pageId, userId);
                    this.buildPageCache(ctx, pageId, userId);
                    PageCache pc = this.findPageCache(ctx, pageId, userId);
                    pc.setStatus(PageStatusEnum.OVERDUE);
                    return pc;
                }
                if (pageCacheList.size() == 1 && !"portal_template_user".equals(pageCacheList.get(0).getUserId())) {
                    return pageCacheList.get(0);
                }
                if (pageCacheList.size() > 1) {
                    for (PageCache temp : pageCacheList) {
                        if ("portal_template_user".equals(temp.getUserId())) continue;
                        return temp;
                    }
                }
                return null;
            }
            PageCache filter = new PageCache();
            filter.setPageId(pageId);
            filter.setUserId(userId);
            PageCache pageCache = this.pageCacheDAO.findObject(filter, new Filter[0]);
            if (pageCache == null) {
                return this.buildBlankPageCache(ctx, pageId, userId);
            }
            return pageCache;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("223", e);
        }
    }

    @Override
    public PageCache findPageCache(PortalContext ctx, String pageId, String userId) throws PortalBizException {
        try {
            PageCache pageCache = new PageCache();
            pageCache.setPageId(pageId);
            pageCache.setUserId(userId);
            return this.pageCacheDAO.findObject(pageCache, new Filter[0]);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("223", e);
        }
    }

    @Override
    public SyncSettingInfo findSyncSettingInfo(PortalContext portalContext, String pageId, String userId) throws PortalBizException {
        try {
            SyncSettingInfo syncSettingInfo = null;
            PageCache pageCache = this.findPageCache(portalContext, pageId, userId);
            if (pageCache == null || StringUtil.isEmpty((String)pageCache.getSyncSettingInfo())) {
                syncSettingInfo = new SyncSettingInfo();
                syncSettingInfo.setDynamicPortlet(true);
                syncSettingInfo.setDelPersonalPortlet(true);
                syncSettingInfo.setPageLayoutTmpl(true);
                syncSettingInfo.setPortletOutlook(true);
                syncSettingInfo.setPortletPreferences(true);
            } else {
                syncSettingInfo = (SyncSettingInfo)JSONUtil.getObject4Json((String)pageCache.getSyncSettingInfo(), SyncSettingInfo.class);
            }
            return syncSettingInfo;
        }
        catch (Exception e) {
            throw new PortalBizException("223", e);
        }
    }

    @Override
    public void deletePageCache(PortalContext ctx, String pageIds, String userId) throws PortalBizException {
        String[] pageIdList = pageIds.split(",");
        try {
            this.pageCacheDAO.deletePageCacheList(pageIdList, userId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("224", e);
        }
    }

    @Override
    public void disablePersonalPageCache(PortalContext ctx, String pageId, SyncSettingInfo syncSettingInfo) throws PortalBizException {
        try {
            this.pageCacheDAO.disablePersonalPageCache(pageId, syncSettingInfo);
        }
        catch (Exception e) {
            throw new PortalBizException("225", e);
        }
    }

    @Override
    public void enablePersonalPageCache(PortalContext ctx, String pageId, String userId) throws PortalBizException {
        try {
            this.pageCacheDAO.enablePersonalPageCache(pageId, userId);
        }
        catch (Exception e) {
            throw new PortalBizException("227", e);
        }
    }

    @Override
    public void refreshPageBaseInfo(PortalContext ctx, String pageId) throws PortalBizException {
        try {
            SyncSettingInfo syncSettingInfo = new SyncSettingInfo();
            this.pageCacheDAO.refreshPersonalPageBaseInfo(pageId, syncSettingInfo);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("225", e);
        }
    }

    private PageCache buildBlankPageCache(PortalContext ctx, String pageId, String userId) throws DataAccessException {
        PageCache pageCache = new PageCache();
        pageCache.setUserId(userId);
        pageCache.setPageId(pageId);
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageId(pageId);
        pageInfo.setLayoutTmplId("e47663a6-25a8-4ee0-b136-a052581ee8ca");
        pageCache.setPageInfo(pageInfo.toString());
        pageCache.setPortletList("[]");
        pageCache.setStatus(PageStatusEnum.ENABLE);
        pageCache.setPortalContext(ctx);
        this.pageCacheDAO.create(pageCache);
        return pageCache;
    }

    private boolean isExistedOfPageCache(String pageId, String userId) throws PortalBizException {
        PageCache pageCache = this.findPageCache(null, pageId, userId);
        return pageCache != null;
    }

    private void updatePageCache(PortalContext portalContext, String pageId, String userId) throws PortalBizException, DataAccessException {
        String pageInfoJSON = this.buildPageInfoJSON(portalContext, pageId, userId);
        String portletListJSON = this.buildPortletListJSON(portalContext, pageId, userId);
        PageCache pageCache = this.findPageCache(portalContext, pageId, userId);
        pageCache.setPageInfo(pageInfoJSON);
        pageCache.setPortletList(portletListJSON);
        pageCache.setStatus(PageStatusEnum.ENABLE);
        pageCache.setSyncSettingInfo(null);
        pageCache.setPortalContext(portalContext);
        this.pageCacheDAO.update(pageCache);
    }

    private void createPageCache(PortalContext portalContext, String pageId, String userId) throws DataAccessException, PortalBizException {
        PagePersonalExt pageExt = this.findPagePersonalExt4PageCache(pageId, userId);
        String pageInfoJSON = this.buildPageInfoJSON(portalContext, pageId, userId);
        String portletListJSON = this.buildPortletListJSON(portalContext, pageId, userId);
        PageCache pageCache = new PageCache(pageId, userId, pageInfoJSON, portletListJSON, PageStatusEnum.ENABLE);
        pageCache.setPortalContext(portalContext);
        this.pageCacheDAO.create(pageCache);
    }

    private PagePersonalExt findPagePersonalExt4PageCache(String pageId, String userId) throws DataAccessException {
        PagePersonalExt filter = new PagePersonalExt();
        filter.setPageId(pageId);
        filter.setUserId(userId);
        PagePersonalExt pagePersonalExt = this.pagePersonalExtDAO.findObject(filter, new Filter[0]);
        return pagePersonalExt;
    }

    private String buildPageInfoJSON(Page page, PagePersonalExt pagePersonalExt) {
        PageInfo pageInfo = new PageInfo();
        if (pagePersonalExt != null) {
            pageInfo.setLayoutTmplId(pagePersonalExt.getLayoutTmplId());
            pageInfo.setPageId(pagePersonalExt.getPageId());
        } else {
            pageInfo.setLayoutTmplId(PortalCache.getPortalProfileMap().get("default_page_layout"));
            pageInfo.setPageId(page.getId());
        }
        pageInfo.setDisplayName(page.getDisplayName());
        PageMargin pageMargin = new PageMargin();
        if (StringUtil.isEmpty((String)page.getControlParam())) {
            pageMargin.setLeft(10);
            pageMargin.setRight(10);
            pageMargin.setTop(10);
            pageMargin.setBottom(10);
        } else {
            int left = 10;
            int right = 10;
            int top = 10;
            int bottom = 10;
            Map marginMap = JSONUtil.getMap4Json((String)page.getControlParam());
            if (marginMap.get("marginLeft") != null) {
                left = Integer.parseInt(marginMap.get("marginLeft").toString());
            }
            pageMargin.setLeft(left);
            if (marginMap.get("marginRight") != null) {
                right = Integer.parseInt(marginMap.get("marginRight").toString());
            }
            pageMargin.setRight(right);
            if (marginMap.get("marginTop") != null) {
                top = Integer.parseInt(marginMap.get("marginTop").toString());
            }
            pageMargin.setTop(top);
            if (marginMap.get("marginBottom") != null) {
                bottom = Integer.parseInt(marginMap.get("marginBottom").toString());
            }
            pageMargin.setBottom(bottom);
        }
        pageInfo.setPageMargin(pageMargin);
        Boolean showPltButton = page.getShowPltButton();
        if (showPltButton != null) {
            pageInfo.setShowPltButton(showPltButton);
        } else {
            pageInfo.setShowPltButton(true);
        }
        return pageInfo.toString();
    }

    private String buildPageInfoJSON(PortalContext portalContext, String pageId, String userId) throws PortalBizException, DataAccessException {
        Page page = this.pageService.findPageById(portalContext, pageId);
        PagePersonalExt pagePersonalExt = this.findPagePersonalExt4PageCache(pageId, userId);
        return this.buildPageInfoJSON(page, pagePersonalExt);
    }

    private String buildPortletListJSON(PortalContext ctx, String pageId, String userId) throws PortalBizException {
        List<PortletIns> portletInsJSONList = this.portletService.buildPortletInsList(ctx, pageId, userId);
        return JSONUtil.getJson4List(portletInsJSONList);
    }

    private String buildPortletListJSON(PortalContext ctx, List<PortletInstance> pltInsList) throws PortalBizException {
        List<PortletIns> portletInsJSONList = this.portletService.buildPortletInsList(ctx, pltInsList);
        return JSONUtil.getJson4List(portletInsJSONList);
    }

    public void setPageCacheDAO(PageCacheDAO pageCacheDAO) {
        this.pageCacheDAO = pageCacheDAO;
    }

    public void setPagePersonalExtDAO(PagePersonalExtDAO pagePersonalExtDAO) {
        this.pagePersonalExtDAO = pagePersonalExtDAO;
    }

    public void setPortletService(PortletService portletService) {
        this.portletService = portletService;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    public void setOnlineEditPageService(OnlineEditPageService onlineEditPageService) {
        this.onlineEditPageService = onlineEditPageService;
    }
}

