/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.page.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.page.dao.PageIdMapCodeDAO;
import com.kingdee.portal.biz.module.page.entity.PageIdMapCode;
import com.kingdee.portal.biz.module.page.service.PageIdMapCodeService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PageIdMapCodeServiceImpl
implements PageIdMapCodeService {
    private PageIdMapCodeDAO pageIdMapCodeDAO;

    @Override
    public PageIdMapCode savePageIdMapCode(PortalContext ctx, PageIdMapCode ic, String saveType) throws PortalBizException {
        PageIdMapCode newIc = null;
        try {
            if (saveType.endsWith("create")) {
                newIc = this.pageIdMapCodeDAO.create(ic);
            } else {
                PageIdMapCode orIc = (PageIdMapCode)this.pageIdMapCodeDAO.findObject(new FieldFilter("pageId", "=", ic.getPageId()));
                if (orIc != null) {
                    orIc.setPageNumber(ic.getPageNumber());
                    newIc = this.pageIdMapCodeDAO.update(orIc);
                } else {
                    newIc = this.pageIdMapCodeDAO.create(ic);
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return newIc;
    }

    @Override
    public List<PageIdMapCode> findePageIdMapCodeList() throws PortalBizException {
        List icList = null;
        try {
            icList = this.pageIdMapCodeDAO.findList(new OrderFilter("createTime", OrderEnum.ASC));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return icList;
    }

    @Override
    public Map<String, String> findePageIdMapCodeMap() throws PortalBizException {
        List<PageIdMapCode> icList = this.findePageIdMapCodeList();
        HashMap<String, String> map = new HashMap<String, String>();
        if (icList != null) {
            for (PageIdMapCode ic : icList) {
                map.put(ic.getPageNumber(), ic.getId());
            }
        }
        return map;
    }

    @Override
    public void deletePageIdMapCode(PortalContext ctx, String pageIds) throws PortalBizException {
        try {
            this.pageIdMapCodeDAO.deletePageIdMapCodeByPageIds(pageIds);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw new PortalBizException("305", e);
        }
    }

    public void setPageIdMapCodeDAO(PageIdMapCodeDAO pageIdMapCodeDAO) {
        this.pageIdMapCodeDAO = pageIdMapCodeDAO;
    }
}

