/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.page.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.enums.LayoutTmplTypeEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.page.dao.PageLayoutTmplDAO;
import com.kingdee.portal.biz.module.page.entity.PageLayoutTmpl;
import com.kingdee.portal.biz.module.page.service.PageLayoutTmplService;
import com.kingdee.portal.common.util.StringUtil;
import java.util.List;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PageLayoutTmplServiceImpl
implements PageLayoutTmplService {
    private static final String DEFAULT_PAGE_LAYOUT_ID = "e47663a6-25a8-4ee0-b136-a052581ee8ca";
    private PageLayoutTmplDAO pageLayoutTmplDAO;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PageLayoutTmpl> findEnabledLayoutTmplList() throws PortalBizException {
        PageLayoutTmpl entity = new PageLayoutTmpl();
        entity.setStatus(StatusEnum.ENABLE);
        try {
            return this.pageLayoutTmplDAO.findList(entity, new OrderFilter("createTime", OrderEnum.ASC));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("211", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PageLayoutTmpl findLayoutTmplById(PortalContext ctx, String layoutId) throws PortalBizException {
        try {
            PageLayoutTmpl pageLayoutTmpl = (PageLayoutTmpl)this.pageLayoutTmplDAO.findById(layoutId);
            if (pageLayoutTmpl != null) {
                return pageLayoutTmpl;
            }
            return (PageLayoutTmpl)this.pageLayoutTmplDAO.findById(DEFAULT_PAGE_LAYOUT_ID);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("211", e);
        }
    }

    @Override
    public PageLayoutTmpl savePageLayoutTmpl(PortalContext portalContext, PageLayoutTmpl pageLayoutTmpl) throws PortalBizException {
        if (StringUtil.isEmpty((String)pageLayoutTmpl.getId())) {
            return this.createPageLayoutTmpl(portalContext, pageLayoutTmpl);
        }
        return this.updatePageLayoutTmpl(portalContext, pageLayoutTmpl);
    }

    @Override
    public void deletePageLayoutTmplById(PortalContext portalContext, String layoutId) throws PortalBizException {
        try {
            this.pageLayoutTmplDAO.deleteById(layoutId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("245");
        }
    }

    @Override
    public PagingResult<PageLayoutTmpl> findPageLayoutTmplList(PortalContext portalContext, PagingParam pagingParam) throws PortalBizException {
        PageLayoutTmpl entity = new PageLayoutTmpl();
        entity.setStatus(StatusEnum.ENABLE);
        entity.setTmplType(LayoutTmplTypeEnum.COMMON);
        try {
            return this.pageLayoutTmplDAO.findList(entity, pagingParam, new OrderFilter("createTime", OrderEnum.DESC));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("243", e);
        }
    }

    private PageLayoutTmpl createPageLayoutTmpl(PortalContext portalContext, PageLayoutTmpl pageLayoutTmpl) throws PortalBizException {
        try {
            pageLayoutTmpl.setPortalContext(portalContext);
            return this.pageLayoutTmplDAO.create(pageLayoutTmpl);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("241", e);
        }
    }

    private PageLayoutTmpl updatePageLayoutTmpl(PortalContext portalContext, PageLayoutTmpl pageLayoutTmpl) throws PortalBizException {
        try {
            PageLayoutTmpl pageLayoutTmplDB = (PageLayoutTmpl)this.pageLayoutTmplDAO.findById(pageLayoutTmpl.getId());
            if (pageLayoutTmplDB == null) {
                throw new PortalBizException("243");
            }
            pageLayoutTmplDB.setDisplayName(pageLayoutTmpl.getDisplayName());
            pageLayoutTmplDB.setContent(pageLayoutTmpl.getContent());
            pageLayoutTmplDB.setMaxWorkArea(pageLayoutTmpl.getMaxWorkArea());
            pageLayoutTmplDB.setIconName(pageLayoutTmpl.getIconName());
            pageLayoutTmplDB.setPortalContext(portalContext);
            return this.pageLayoutTmplDAO.update(pageLayoutTmplDB);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("241", e);
        }
    }

    public void setPageLayoutTmplDAO(PageLayoutTmplDAO pageLayoutTmplDAO) {
        this.pageLayoutTmplDAO = pageLayoutTmplDAO;
    }
}

