/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.page.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.CnToSpell;
import com.kingdee.eas.base.myeas.PersonalParamCollection;
import com.kingdee.eas.base.myeas.PersonalParamFactory;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.enums.LockTypeEnum;
import com.kingdee.portal.biz.common.enums.PlanTypeEnum;
import com.kingdee.portal.biz.common.enums.ResLevelEnum;
import com.kingdee.portal.biz.common.enums.ResTypeEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.json.Description;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.core.datacenter.DSObserver;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.biz.facade.portal.facade.PortalCacheFacade;
import com.kingdee.portal.biz.module.frame.entity.SpaceDefault;
import com.kingdee.portal.biz.module.frame.service.SpaceDefaultService;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.json.ELinkNodeExt;
import com.kingdee.portal.biz.module.page.common.json.GuiPreferences;
import com.kingdee.portal.biz.module.page.common.json.LinkNodeExt;
import com.kingdee.portal.biz.module.page.common.json.PageNodeExt;
import com.kingdee.portal.biz.module.page.common.json.ViewTmplPreferences;
import com.kingdee.portal.biz.module.page.common.util.PageHelper;
import com.kingdee.portal.biz.module.page.dao.AppCenterPersonalDAO;
import com.kingdee.portal.biz.module.page.dao.PageDAO;
import com.kingdee.portal.biz.module.page.dao.PageLockDAO;
import com.kingdee.portal.biz.module.page.dao.PagePersonalExtDAO;
import com.kingdee.portal.biz.module.page.dao.PageSpacePersonalExtDAO;
import com.kingdee.portal.biz.module.page.dto.CustomMenuDTO;
import com.kingdee.portal.biz.module.page.dto.ExternalLinkDTO;
import com.kingdee.portal.biz.module.page.dto.MenuItemInfo;
import com.kingdee.portal.biz.module.page.dto.NavConfigDTO;
import com.kingdee.portal.biz.module.page.dto.PageDTO;
import com.kingdee.portal.biz.module.page.dto.PageEditPermissionDto;
import com.kingdee.portal.biz.module.page.dto.PortalCenterClassDTO;
import com.kingdee.portal.biz.module.page.dto.SearchAllDTO;
import com.kingdee.portal.biz.module.page.entity.AppCenterPersonal;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.entity.PageIdMapCode;
import com.kingdee.portal.biz.module.page.entity.PageLock;
import com.kingdee.portal.biz.module.page.entity.PagePersonalExt;
import com.kingdee.portal.biz.module.page.entity.PageSpacePersonalExt;
import com.kingdee.portal.biz.module.page.service.OnlineEditPageService;
import com.kingdee.portal.biz.module.page.service.PageCacheService;
import com.kingdee.portal.biz.module.page.service.PageIdMapCodeService;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.page.service.PageSpacePersonalExtService;
import com.kingdee.portal.biz.module.perm.common.json.PermInfo;
import com.kingdee.portal.biz.module.perm.dto.PlanDto;
import com.kingdee.portal.biz.module.perm.entity.PermRefRes;
import com.kingdee.portal.biz.module.perm.entity.User;
import com.kingdee.portal.biz.module.perm.service.PermService;
import com.kingdee.portal.biz.module.personal.dto.PersonalFavoriteDTO;
import com.kingdee.portal.biz.module.personal.service.PersonalFavoriteService;
import com.kingdee.portal.biz.module.portlet.common.util.PortletHelper;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.entity.PortletCategory;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.entity.PortletInstance;
import com.kingdee.portal.biz.module.portlet.entity.PortletRuntimePreferences;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.biz.module.setting.entity.PortalProfile;
import com.kingdee.portal.biz.module.setting.service.SettingService;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.portlet.RenderRequest;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PageServiceImpl
implements PageService,
PageSpacePersonalExtService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PageDAO pageDAO;
    private PagePersonalExtDAO pagePersonalExtDAO;
    private PageSpacePersonalExtDAO pageSpacePersonalExtDAO;
    private PageLockDAO pageLockDAO;
    private SettingService settingService;
    private PageCacheService pageCacheService;
    private PortletService portletService;
    private PortletDefinitionService portletDefinitionService;
    private PortletCategoryService portletCategoryService;
    private PermService permService;
    private EASService easService;
    private II18nService i18nService;
    private OnlineEditPageService onlineEditPageService;
    private PageIdMapCodeService pageIdMapCodeService;
    private PersonalFavoriteService personalFavoriteService;
    private AppCenterPersonalDAO appCenterPersonalDAO;
    @Autowired
    private SpaceDefaultService spaceDefaultService;
    public int t = 0;

    public AppCenterPersonalDAO getAppCenterPersonalDAO() {
        return this.appCenterPersonalDAO;
    }

    public void setAppCenterPersonalDAO(AppCenterPersonalDAO appCenterPersonalDAO) {
        this.appCenterPersonalDAO = appCenterPersonalDAO;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean isAdminPage(PortalContext ctx, String pageId) throws PortalBizException {
        Page page = this.findPageById(ctx, pageId);
        return this.isAdminPage(ctx, page);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean isAdminPage(PortalContext ctx, Page page) throws PortalBizException {
        boolean result = false;
        if (page != null && "portal_template_user".equals(page.getUserId())) {
            result = true;
        }
        return result;
    }

    @Override
    public Page createPage(PortalContext ctx, PageDTO pageDto) throws PortalBizException {
        Page page = pageDto.getPage();
        try {
            page = this.innerCreatePage(ctx, page);
            if (page.getNodeType().equals((Object)NodeTypeEnum.NEW_PAGE)) {
                this.createPortletIns(ctx, page);
            }
            this.createSpaceExt(ctx, page);
            this.createPageExt(ctx, page);
            this.publishPortlet(ctx, pageDto);
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            PortalCacheFacade.updateAppCenterCacheFlag(context);
        }
        catch (Exception e) {
            throw new PortalBizException("202", e);
        }
        return page;
    }

    private void createPortletIns(PortalContext ctx, Page page) {
        String portletDefId = "15251661-4aa2-4934-8831-db593cb13be9";
        try {
            PortletDefinition portletDefinition = this.portletDefinitionService.findPortletDefinitionById(portletDefId);
            int orderNum = 1;
            Map<String, Object> pltInsMap = this.onlineEditPageService.buildNewPortletInstanceMap(ctx, page.getId(), "portal_template_user", portletDefinition, orderNum);
            PortletInstance portletInstance = (PortletInstance)pltInsMap.get("portletInstance");
            portletInstance.setPortalContext(ctx);
            this.portletService.createPortletInstance(ctx, portletInstance);
            PortletRuntimePreferences preferences = new PortletRuntimePreferences();
            preferences.setInsId(portletInstance.getId());
            this.portletService.createPortletRuntimePreferences(ctx, preferences);
        }
        catch (PortalBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String saveNewPageCenterClass(PortalContext portalContext, Page page) {
        String pageID = "";
        page.setNodeType(NodeTypeEnum.FOLDER);
        page.setPermEditCtrl(false);
        page.setPermViewCtrl(false);
        page.setStatus(StatusEnum.ENABLE);
        page.setIcon(null);
        page.setShowPltButton(true);
        page.setPreferences("4");
        page.setCanSearch(false);
        page.setCanAddFav(false);
        try {
            page = this.innerCreatePage(portalContext, page);
            this.createPageExt(portalContext, page);
            PageDTO pageDto = new PageDTO();
            pageDto.setPage(page);
            this.publishPortlet(portalContext, pageDto);
            pageID = page.getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageID;
    }

    @Override
    public String saveNewPageCenter(PortalContext portalContext, Page page) {
        String pageID = "";
        page.setNodeType(NodeTypeEnum.NEW_PAGE);
        page.setPermEditCtrl(false);
        page.setPermViewCtrl(true);
        page.setPageNumber(PageHelper.generatePageNumber());
        page.setStatus(StatusEnum.ENABLE);
        page.setIcon(page.getIcon());
        page.setShowPltButton(true);
        page.setNodeExt("{\"target\":\"TAB\"}");
        page.setControlParam("{\"useMargin\":\"true\",\"marginLeft\":\"0\",\"marginRight\":\"0\",\"marginTop\":\"10\",\"marginBottom\":\"10\"}");
        page.setPreferences("4");
        page.setCanSearch(false);
        page.setCanAddFav(false);
        try {
            page = this.innerCreatePage(portalContext, page);
            this.createPageExt(portalContext, page);
            PageDTO pageDto = new PageDTO();
            pageDto.setPage(page);
            this.publishPortlet(portalContext, pageDto);
            pageID = page.getId();
            this.createPortletIns(portalContext, page);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageID;
    }

    @Override
    public String createNewPage(PortalContext portalContext, String menuID) {
        String pageID = "";
        String displayName = "";
        String description = "";
        String parentNodeId = "";
        String isPersonalAppCenter = "personalAppCenter";
        try {
            if ("personalAppCenter".equals(isPersonalAppCenter)) {
                AppCenterPersonal entity = new AppCenterPersonal();
                entity.setPageID(menuID);
                AppCenterPersonal result = this.appCenterPersonalDAO.findObject(entity, new Filter[0]);
                displayName = result.getDisplayName();
                description = result.getDescription();
                parentNodeId = result.getParentNodeId();
            } else {
                Page result = (Page)this.pageDAO.findById(menuID);
                displayName = result.getDisplayName();
                description = result.getDescription();
                parentNodeId = result.getParentNodeId();
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        Page page = new Page();
        page.setParentNodeId(parentNodeId);
        page.setNodeType(NodeTypeEnum.NEW_PAGE);
        page.setPermEditCtrl(false);
        page.setPermViewCtrl(false);
        page.setDisplayName(displayName);
        page.setDescription(description);
        page.setPageNumber(PageHelper.generatePageNumber());
        page.setStatus(StatusEnum.ENABLE);
        page.setIcon(null);
        page.setShowPltButton(true);
        page.setNodeExt("{\"target\":\"TAB\"}");
        page.setControlParam("{\"useMargin\":\"true\",\"marginLeft\":\"0\",\"marginRight\":\"0\",\"marginTop\":\"10\",\"marginBottom\":\"10\"}");
        page.setPreferences("1");
        page.setCanSearch(false);
        page.setCanAddFav(false);
        try {
            page = this.innerCreatePage(portalContext, page);
            this.createPageExt(portalContext, page);
            pageID = page.getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageID;
    }

    @Override
    public void createNewPageAndMenuID(Context ctx, String menuId, String newPageID) {
        try {
            String id = UUID.randomUUID().toString();
            String sql = "insert into T_JP_SecondPageAndNewPage(FID,FPageID,FNewPageID) values ('" + id + "','" + menuId + "','" + newPageID + "')";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean checkDisplayName(Page page) {
        Page entity = new Page();
        entity.setNodeType(NodeTypeEnum.SPACE);
        entity.setNodeLevel(1);
        try {
            List<Page> allSpaceList = this.pageDAO.findList(entity, this.orderFilter());
            for (Page space : allSpaceList) {
                if (space.getId().equals(page.getId()) || this.innerCheckDisplayName(page.getDisplayName(), space.getDisplayName())) continue;
                return false;
            }
            return true;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean innerCheckDisplayName(String displayName1, String displayName2) {
        JSONObject fromObject;
        JSONObject map1 = fromObject = JSONObject.fromObject((Object)displayName1);
        JSONObject map2 = fromObject = JSONObject.fromObject((Object)displayName2);
        if (!((String)map1.get("en")).equals("") && ((String)map1.get("en")).equals(map2.get("en"))) {
            return false;
        }
        if (((String)map1.get("zh_CN")).equals(map2.get("zh_CN"))) {
            return false;
        }
        return !((String)map1.get("zh_TW")).equals(map2.get("zh_TW"));
    }

    private Page innerCreatePage(PortalContext ctx, Page page) throws DataAccessException {
        Page parent = (Page)this.pageDAO.findById(page.getParentNodeId());
        page.setId(null);
        page.setParentNode(parent);
        page.setResLevel(ResLevelEnum.EXT);
        page.setNodeOrder(10000);
        page.setPortalContext(ctx);
        if (!NodeTypeEnum.PLAN.equals((Object)page.getNodeType())) {
            page.setUserId("portal_template_user");
        }
        page.setAllSpell(this.getCnSpell(page.getDisplayName(), false));
        page.setFirstSpell(this.getCnSpell(page.getDisplayName(), true));
        return this.pageDAO.create(page);
    }

    private String getCnSpell(String displayName, boolean onlyFirstSpell) {
        DisplayName nameInfo = new DisplayName(displayName);
        String cnName = nameInfo.getZh_CN();
        return CnToSpell.getSpell((String)cnName, (boolean)onlyFirstSpell);
    }

    private void createSpaceExt(PortalContext ctx, Page page) throws PortalBizException, DataAccessException {
        if (page.getNodeType() == NodeTypeEnum.SPACE) {
            PageSpacePersonalExt spaceExt = new PageSpacePersonalExt();
            spaceExt.setPageId(page.getId());
            PortalProfile profile = this.settingService.findPortalProfileByConfigItem("default_page_theme");
            spaceExt.setThemeId(profile.getConfigValue());
            spaceExt.setThemeCode("Code");
            spaceExt.setUserId("portal_template_user");
            spaceExt.setPortalContext(ctx);
            this.pageSpacePersonalExtDAO.create(spaceExt);
        }
    }

    private void createPageExt(PortalContext ctx, Page page) throws PortalBizException, DataAccessException {
        if (page.getNodeType() == NodeTypeEnum.PAGE || page.getNodeType() == NodeTypeEnum.NEW_PAGE || page.getNodeType() == NodeTypeEnum.PLAN) {
            PagePersonalExt pageExt = new PagePersonalExt();
            pageExt.setPageId(page.getId());
            String key = page.getNodeType() == NodeTypeEnum.PAGE ? "default_page_layout" : "default_newpage_layout";
            PortalProfile profile = this.settingService.findPortalProfileByConfigItem(key);
            pageExt.setLayoutTmplId(profile.getConfigValue());
            pageExt.setUserId("portal_template_user");
            pageExt.setPortalContext(ctx);
            this.pagePersonalExtDAO.create(pageExt);
        }
    }

    private void publishPortlet(PortalContext ctx, PageDTO pageDto) throws PortalBizException {
        Page page = pageDto.getPage();
        if (page.getNodeType() == NodeTypeEnum.BIZ_PAGE) {
            PortletParam param = new PortletParam();
            param.setDisplayName(new DisplayName(page.getDisplayName()));
            param.setDescription(new Description(page.getDescription()));
            if (!StringUtil.isEmpty((String)page.getIcon())) {
                param.setIcon(page.getIcon());
            }
            String portletName = "IconViewPortlet";
            if (page.getPreferences() != null) {
                Boolean canAddFav = page.getCanAddFav();
                if (canAddFav == null) {
                    canAddFav = false;
                }
                ViewTmplPreferences pre = new ViewTmplPreferences(page.getPreferences());
                String[] viewTmpl = pre.getViewTmpl().split(",");
                String pageName = "";
                if (viewTmpl.length > 4) {
                    pageName = viewTmpl[4];
                }
                portletName = viewTmpl[0];
                Preferences prefs = new Preferences();
                prefs.addPreference(new Preference("pageId", page.getId()));
                prefs.addPreference(new Preference("tmplAppearance", viewTmpl[1]));
                prefs.addPreference(new Preference("mutiTab", pre.getMutiTab().toString()));
                prefs.addPreference(new Preference("showPath", pre.getShowPath().toString()));
                prefs.addPreference(new Preference("canAddFav", canAddFav.toString()));
                prefs.addPreference(new Preference("pageName", pageName));
                param.setPreferences(prefs);
            }
            this.portletDefinitionService.copyPortletDefinition(ctx, "plt_portal", portletName, param, pageDto.getCategoryId());
        }
    }

    private void emptyCheck(String pageId) throws PortalBizException {
        if (StringUtil.isEmpty((String)pageId)) {
            throw new PortalBizException("201");
        }
    }

    @Override
    public Page updatePage(PortalContext ctx, PageDTO pageDto) throws PortalBizException {
        Page page = pageDto.getPage();
        this.emptyCheck(page.getId());
        try {
            this.updatePortlet(ctx, pageDto);
            Page original = (Page)this.pageDAO.findById(page.getId());
            Page update = this.buildUpdatePage(ctx, page, original);
            Page page4DB = this.pageDAO.update(update);
            this.pageCacheService.refreshPageBaseInfo(ctx, page.getId());
            if (NodeTypeEnum.BIZ_PAGE.equals((Object)page.getNodeType())) {
                this.pageDAO.updateBizPageCanAddFav(ctx, page4DB);
            }
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            PortalCacheFacade.updateAppCenterCacheFlag(context);
            return page4DB;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PortalBizException("203", e);
        }
    }

    private void updatePortlet(PortalContext ctx, PageDTO pageDto) throws PortalBizException {
        Page page = pageDto.getPage();
        try {
            PortletDefinition plt = this.portletDefinitionService.findPltByPageId(ctx, page.getId());
            if (plt != null) {
                plt.setDisplayName(new DisplayName(page.getDisplayName()).toString());
                plt.setDescription(page.getDescription());
                plt.setCategoryId(pageDto.getCategoryId());
                if (NodeTypeEnum.BIZ_PAGE.equals((Object)page.getNodeType())) {
                    Boolean canAddFav = page.getCanAddFav();
                    if (canAddFav == null) {
                        canAddFav = false;
                    }
                    Preferences preferences = PortletHelper.convPreferences(plt.getPreferences());
                    int k = -1;
                    for (int i = 0; i < preferences.getPreferences().size(); ++i) {
                        if (!preferences.getPreferences().get(i).getName().equals("canAddFav")) continue;
                        k = i;
                    }
                    if (k != -1) {
                        ArrayList<String> addFav = new ArrayList<String>();
                        addFav.add(canAddFav.toString());
                        preferences.getPreferences().get(k).setValues(addFav);
                    } else {
                        preferences.getPreferences().add(new Preference("canAddFav", canAddFav.toString()));
                    }
                    plt.setPreferences(preferences.toString());
                }
                if (!StringUtil.isEmpty((String)page.getIcon())) {
                    plt.setIcon(page.getIcon());
                }
                this.portletDefinitionService.updatePortlet(ctx, plt);
            } else {
                ViewTmplPreferences pre = new ViewTmplPreferences();
                pre.setViewTmpl("ThreeLevelPortlet,NOCONTENT,1424b3b9-258a-4a46-9ae3-bf534c6f17d0,3");
                pre.setMutiTab(false);
                pre.setShowPath(false);
                pre.setCanAddFav(false);
                page.setPreferences(pre.toString());
                this.publishPortlet(ctx, pageDto);
            }
        }
        catch (PortalBizException e) {
            throw new PortalBizException("300", e);
        }
    }

    private Page buildUpdatePage(PortalContext ctx, Page page, Page original) throws DataAccessException {
        Page parent = (Page)this.pageDAO.findById(page.getParentNodeId());
        original.setDescription(page.getDescription());
        original.setDisplayName(page.getDisplayName());
        original.setPageNumber(page.getPageNumber());
        original.setIcon(page.getIcon());
        original.setNodeExt(page.getNodeExt());
        original.setParentNodeId(page.getParentNodeId());
        original.setParentNode(parent);
        original.setPermViewCtrl(page.getPermViewCtrl());
        if (page.getSettingInfo() != null) {
            original.setSettingInfo(page.getSettingInfo());
        }
        if (page.getStatus() != null) {
            original.setStatus(page.getStatus());
        }
        original.setPortalContext(ctx);
        if (page.getPreferences() != null) {
            original.setPreferences(page.getPreferences());
        }
        original.setShowPltButton(page.getShowPltButton());
        original.setControlParam(page.getControlParam());
        original.setAllSpell(this.getCnSpell(page.getDisplayName(), false));
        original.setFirstSpell(this.getCnSpell(page.getDisplayName(), true));
        original.setCanAddFav(page.getCanAddFav());
        original.setCanSearch(page.getCanSearch());
        return original;
    }

    @Override
    public Page renamePage(PortalContext ctx, Page page) throws PortalBizException {
        this.emptyCheck(page.getId());
        Page original = null;
        try {
            original = (Page)this.pageDAO.findById(page.getId());
            original.setDisplayName(page.getDisplayName());
            original.setAllSpell(this.getCnSpell(page.getDisplayName(), false));
            original.setFirstSpell(this.getCnSpell(page.getDisplayName(), true));
            original.setPortalContext(ctx);
            original = this.pageDAO.update(original);
            try {
                Context context = (Context)ctx.getMetaInfo().get("eas_context");
                PortalCacheFacade.updateAppCenterCacheFlag(context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("203", e);
        }
        return original;
    }

    @Override
    public void deletePageById(PortalContext ctx, String pageId) throws PortalBizException {
        this.deletePageById(ctx, pageId, null);
    }

    @Override
    public void deletePageById(PortalContext ctx, String pageId, String portletId) throws PortalBizException {
        this.emptyCheck(pageId);
        try {
            this.dispatchDelete(ctx, pageId, portletId);
        }
        catch (DataAccessException e) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("pageId", pageId);
            throw new PortalBizException("205", e, param);
        }
        this.resetDefault(pageId);
    }

    private void dispatchDelete(PortalContext ctx, String pageId, String portletId) throws DataAccessException, PortalBizException {
        Page page = (Page)this.pageDAO.findById(pageId);
        switch (page.getNodeType()) {
            case NEW_PAGE: 
            case PLAN: 
            case PAGE: {
                this.deletePageNode(ctx, page);
                break;
            }
            case SPACE: 
            case FOLDER: 
            case EXTERNAL_LINK: 
            case EXTERNAL_LINK_G: 
            case EXTERNAL_LINK_OA: {
                this.deleteWithParent(ctx, page);
                break;
            }
            case EXTERNAL_LINK_SHR: {
                this.deleteWithParent(ctx, page);
                break;
            }
            case BIZ_PAGE: {
                this.deletePublishedPortletDefinition(ctx, portletId);
                this.deleteWithParent(ctx, page);
                break;
            }
            case LINK: {
                this.innerDeletePage(page.getId());
                this.pageIdMapCodeService.deletePageIdMapCode(ctx, page.getId());
                break;
            }
        }
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            PortalCacheFacade.updateAppCenterCacheFlag(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deletePageNode(PortalContext ctx, Page page) throws DataAccessException, PortalBizException {
        this.deleteRelated(ctx, this.cast2List(page));
        this.innerDeletePage(page.getId());
    }

    private void deleteRelated(PortalContext ctx, List<Page> pages) throws PortalBizException, DataAccessException {
        String pageIds = this.buildIdStrByList(pages);
        this.deletePortletIns(ctx, pageIds);
        this.deletePageCache(ctx, pageIds);
        this.deletePageExt(pages);
        this.pageIdMapCodeService.deletePageIdMapCode(ctx, pageIds);
    }

    private List<Page> cast2List(Page page) {
        ArrayList<Page> pages = new ArrayList<Page>();
        pages.add(page);
        return pages;
    }

    private String buildIdStrByList(List<Page> pages) {
        StringBuilder ids = new StringBuilder();
        for (Page page : pages) {
            ids.append(page.getId()).append(",");
        }
        String pageIds = ids.toString();
        if (pageIds.endsWith(",")) {
            pageIds = pageIds.substring(0, pageIds.length() - 1);
        }
        return pageIds;
    }

    private void deletePortletIns(PortalContext ctx, String pageIds) throws PortalBizException {
        this.portletService.deletePltInsAllByPageIds(ctx, pageIds.split(","));
    }

    private void deletePageCache(PortalContext ctx, String pageIds) throws PortalBizException {
        this.pageCacheService.deletePageCache(ctx, pageIds, "portal_template_user");
    }

    private void deletePageExt(List<Page> pages) throws DataAccessException {
        this.pagePersonalExtDAO.deleteByPageList(pages);
    }

    private void deleteWithParent(PortalContext ctx, Page page) throws DataAccessException, PortalBizException {
        this.deleteRelated(ctx, this.findPageListDeep(page));
        this.deletePageByParent(page);
    }

    private List<Page> findPageListDeep(Page parent) throws DataAccessException {
        String path = parent.getNodePath();
        return this.pageDAO.findList(new FieldFilter("nodePath", "like", path + "%"));
    }

    private void deletePageByParent(Page parent) throws DataAccessException {
        this.pageDAO.deleteByNodePath(parent.getNodePath());
    }

    private void innerDeletePage(String pageId) throws DataAccessException {
        this.pageDAO.deleteById(pageId);
    }

    private void deletePublishedPortletDefinition(PortalContext ctx, String portletId) throws PortalBizException {
        if (!StringUtil.isEmpty((String)portletId)) {
            this.portletDefinitionService.deletePortletDefinitionByIds(ctx, new String[]{portletId});
        }
    }

    private void resetDefault(String pageId) {
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Page findPageById(PortalContext ctx, String pageId) throws PortalBizException {
        this.emptyCheck(pageId);
        try {
            return (Page)this.pageDAO.findById(pageId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    @Override
    public PagingResult<Page> findSpaceList(PortalContext ctx, PagingParam pagingParam) throws PortalBizException {
        Page entity = new Page();
        entity.setNodeType(NodeTypeEnum.SPACE);
        entity.setNodeLevel(1);
        try {
            return this.pageDAO.findList(entity, pagingParam, new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Page> findPageListByParentId(PortalContext ctx, String parentId) throws PortalBizException {
        Page entity = this.queryEntity4PageId(parentId);
        Filter[] filters = this.orderFilter();
        try {
            return this.pageDAO.findList(entity, filters);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    private Page queryEntity4PageId(String parentId) {
        Page filter = new Page();
        if (StringUtil.isEmpty((String)parentId)) {
            filter.setNodeLevel(0);
        } else {
            filter.setParentNodeId(parentId);
        }
        if ("2f9ef722-255b-4e4b-8d07-5277e353a321".equals(parentId)) {
            filter.setNodeType(NodeTypeEnum.SPACE);
        }
        return filter;
    }

    private Filter[] orderFilter() {
        Filter[] filters = new Filter[]{new OrderFilter("nodeLevel", OrderEnum.ASC), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC)};
        return filters;
    }

    @Override
    public void movePage(PortalContext ctx, String pageId, String parentId, String[] sortIds) throws PortalBizException {
        this.emptyCheck(pageId);
        this.emptyCheck(parentId);
        try {
            String pid = this.moveInto(ctx, pageId, parentId);
            if (pid != null) {
                parentId = pid;
            }
            if (sortIds != null && sortIds.length > 0) {
                this.sortPages(ctx, parentId, sortIds);
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("203", e);
        }
    }

    private String moveInto(PortalContext ctx, String pageId, String parentId) throws DataAccessException {
        Page page = (Page)this.pageDAO.findById(pageId);
        if (this.isSameParent(page, parentId)) {
            return null;
        }
        String oldPath = page.getNodePath();
        Page parent = (Page)this.pageDAO.findById(parentId);
        page = this.updatePageParent(ctx, page, parentId);
        int sortLevel = parent.getNodeLevel() + 1 - page.getNodeLevel();
        if (this.hasChildren(page)) {
            this.updateNodePath4Children(oldPath, page.getNodePath(), sortLevel);
        }
        return page.getParentNodeId();
    }

    private boolean isSameParent(Page old, String parentId) {
        return parentId.equals(old.getParentNodeId());
    }

    private Page updatePageParent(PortalContext ctx, Page page, String parentId) throws DataAccessException {
        Page parent = (Page)this.pageDAO.findById(parentId);
        page.setParentNodeId(parentId);
        page.setParentNode(parent);
        page.setNodeOrder(10000);
        page.setNodePath(parent.getNodePath() + "/" + page.getId());
        page.setPortalContext(ctx);
        return this.pageDAO.update(page);
    }

    private boolean hasChildren(Page page) {
        return page.getNodeType() == NodeTypeEnum.FOLDER;
    }

    private void updateNodePath4Children(String old, String newPath, int sortLevel) throws DataAccessException {
        this.pageDAO.updateNodePath(old, newPath, sortLevel);
    }

    private void sortPages(PortalContext ctx, String newParentId, String[] sortIds) throws DataAccessException, PortalBizException {
        ArrayList<Page> pages = new ArrayList<Page>();
        String parentId = "";
        int size = sortIds.length;
        for (int i = 0; i < size; ++i) {
            Page page = (Page)this.pageDAO.findById(sortIds[i]);
            if (i == 0) {
                parentId = page.getParentNodeId();
            }
            if (!this.isSameParent(page, parentId)) {
                throw new PortalBizException("203");
            }
            page.setNodeOrder(i + 1);
            page.setPortalContext(ctx);
            pages.add(page);
        }
        this.pageDAO.update(pages);
    }

    @Override
    public Page importExternalLink(PortalContext ctx, String source, Page page, ExternalLinkDTO elink) throws PortalBizException {
        int maxLevel = 2;
        if (!StringUtil.isEmpty((String)page.getPreferences())) {
            maxLevel = Integer.parseInt(page.getPreferences()) - 1;
        }
        Map<String, Page> pageIdMap = this.createPageMenuMap(page);
        Map<String, Integer> levelMap = this.createLevelMap(page);
        String[] menuItemLongNumberColl = null;
        String[] menuItemIdColl = null;
        String[] menuItemIdNoParentColl = null;
        if (!StringUtil.isEmpty((String)elink.getMenuItemLongNumberColl())) {
            menuItemLongNumberColl = elink.getMenuItemLongNumberColl().split(",");
        }
        if (!StringUtil.isEmpty((String)elink.getMenuItemIdColl())) {
            menuItemIdColl = elink.getMenuItemIdColl().split(",");
        }
        if (!StringUtil.isEmpty((String)elink.getMenuItemIdNoParentColl())) {
            menuItemIdNoParentColl = elink.getMenuItemIdNoParentColl().split(",");
        }
        String openType = elink.getOpenType();
        List<MenuItemInfo> items = this.easService.getExternalLinkList(ctx, page.getNodeType(), menuItemLongNumberColl, menuItemIdColl, elink.getIsSys());
        StatusEnum status = page.getStatus();
        int nodeOrder = 100;
        try {
            nodeOrder = this.pageDAO.findMaxNodeLevelById(page.getParentNodeId());
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
        int[] levelList = new int[menuItemIdColl.length];
        for (int z = 0; z < menuItemIdColl.length; ++z) {
            levelList[z] = ++nodeOrder;
        }
        int subOrder = 0;
        Page _tPage = page;
        if (NodeTypeEnum.EXTERNAL_LINK_SHR.equals((Object)page.getNodeType()) && "c41caf30-2cb6-4033-9ef0-97c79bdce021".equals(page.getParentNodeId())) {
            try {
                _tPage = (Page)this.pageDAO.findById("c41caf30-2cb6-4033-9ef0-97c79bdce021");
            }
            catch (DataAccessException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        for (MenuItemInfo info : items) {
            boolean isLeaf = info.isLeaf();
            String menuId = info.getId();
            String menuParentId = "null";
            boolean isSelect = false;
            int order = 0;
            for (int k = 0; k < menuItemIdColl.length; ++k) {
                if (!menuItemIdColl[k].equals(menuId)) continue;
                order = levelList[k];
                isSelect = true;
                break;
            }
            if (!isSelect) {
                menuParentId = info.getParentId();
                order = ++subOrder;
            }
            if (NodeTypeEnum.EXTERNAL_LINK_SHR.equals((Object)page.getNodeType())) {
                if (info.getLevel() > pageIdMap.get("null").getNodeLevel() && (StringUtil.isEmpty((String)menuParentId) || "null".equals(menuParentId))) {
                    menuParentId = info.getParentId();
                }
                if ("c41caf30-2cb6-4033-9ef0-97c79bdce021".equals(page.getParentNodeId())) {
                    if (info.getLevel() <= 2) continue;
                    Page tPage = pageIdMap.get(menuParentId);
                    if (!isSelect && (info.getLevel() != 4 || null == tPage || "c41caf30-2cb6-4033-9ef0-97c79bdce021".equals(tPage.getId()))) continue;
                    if (null == tPage) {
                        pageIdMap.put(menuParentId, _tPage);
                    }
                }
            }
            this.checkAndSetLevel(isLeaf, levelMap, menuId, menuParentId, maxLevel);
            Page pageAdd = new Page();
            pageAdd.setNodeType(page.getNodeType());
            if (info.getDisplayName() != null) {
                this.fillDisplayName(pageAdd, info.getDisplayName());
            } else {
                this.fillDisplayName(pageAdd, info.getName());
            }
            this.fillNodeExt(pageAdd, info.getUiClassName(), menuId, isLeaf, openType);
            boolean bl = this.fillParentNode(pageAdd, pageIdMap, menuParentId);
            if (!bl) continue;
            this.fillDefaultExternalLink(pageAdd, order);
            pageAdd.setStatus(status);
            pageAdd.setPortalContext(ctx);
            String icon = info.getImagePath();
            if (!StringUtil.isEmpty((String)icon)) {
                icon = "sys_" + info.getImagePath() + ".png";
            }
            pageAdd.setIcon(icon);
            pageAdd.setPreferences(this.buildGuiPre(info).toString());
            pageAdd.setAllSpell(this.getCnSpell(pageAdd.getDisplayName(), false));
            pageAdd.setFirstSpell(this.getCnSpell(pageAdd.getDisplayName(), true));
            try {
                pageAdd = this.pageDAO.create(pageAdd);
            }
            catch (DataAccessException e) {
                throw new PortalBizException("202", e);
            }
            pageIdMap.put(menuId, pageAdd);
        }
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            String flagName = "FClientFlag";
            if ("EXTERNAL_LINK_OA".equals(page.getNodeType().toString())) {
                flagName = "FOAFlag";
            } else if ("EXTERNAL_LINK_SHR".equals(page.getNodeType().toString())) {
                flagName = "FSHRFlag";
            }
            PortalCacheFacade.updateCacheFlag(context, flagName);
        }
        catch (Exception e) {
            this.logger.error("batchCreatePermRefRes updateCacheFlag error ==", (Throwable)e);
        }
        return pageIdMap.get("null");
    }

    private GuiPreferences buildGuiPre(MenuItemInfo info) {
        GuiPreferences gp = new GuiPreferences();
        gp.setOpenMethod(info.getOpenMethod());
        gp.setUiClassParam(info.getUiClassParam());
        gp.setUiOprt(info.getUiOprt());
        return gp;
    }

    private Map<String, Page> createPageMenuMap(Page page) throws PortalBizException {
        Page basePage = null;
        try {
            basePage = (Page)this.pageDAO.findById(page.getParentNodeId());
        }
        catch (DataAccessException e) {
            throw new PortalBizException("202", e);
        }
        HashMap<String, Page> pageIdMap = new HashMap<String, Page>();
        pageIdMap.put("null", basePage);
        return pageIdMap;
    }

    private Map<String, Integer> createLevelMap(Page page) {
        HashMap<String, Integer> levelMap = new HashMap<String, Integer>();
        levelMap.put("null", page.getNodeLevel());
        return levelMap;
    }

    private Set<String> createNoParentItemSet(String[] menuItemIdNoParentColl) {
        HashSet<String> noParentItemSet = new HashSet<String>();
        for (String id : menuItemIdNoParentColl) {
            noParentItemSet.add(id);
        }
        return noParentItemSet;
    }

    private void checkAndSetLevel(boolean isLeaf, Map<String, Integer> levelMap, String menuId, String menuParentId, int maxLevel) throws PortalBizException {
        int parentLevel = 0;
        if (levelMap.get(menuParentId) != null) {
            parentLevel = levelMap.get(menuParentId);
        }
        if (!isLeaf && parentLevel >= maxLevel) {
            throw new PortalBizException("208");
        }
        levelMap.put(menuId, parentLevel + 1);
    }

    private void fillDisplayName(Page page, DisplayName displayName) {
        page.setDisplayName(displayName.toString());
    }

    private void fillDisplayName(Page page, String name) {
        DisplayName nameInfo = new DisplayName();
        nameInfo.setEn(name);
        nameInfo.setZh_CN(name);
        nameInfo.setZh_TW(name);
        page.setDisplayName(nameInfo.toString());
    }

    private void fillNodeExt(Page page, String url, String externalId, boolean isLeaf, String openType) {
        ELinkNodeExt ext = new ELinkNodeExt();
        ext.setTarget(openType);
        ext.setUrl(this.transWebMenu(url));
        ext.setExternalId(externalId);
        ext.setLeaf(isLeaf);
        page.setNodeExt(ext.toString());
    }

    private boolean fillParentNode(Page page, Map<String, Page> pageIdMap, String parentId) {
        boolean bl = false;
        Page tmpParentPage = pageIdMap.get(parentId);
        if (tmpParentPage != null) {
            page.setParentNodeId(tmpParentPage.getId());
            page.setParentNode(tmpParentPage);
            bl = true;
        }
        return bl;
    }

    private void fillDefaultExternalLink(Page page, int nodeOrder) {
        page.setPageNumber(PageHelper.generatePageNumber());
        page.setNodeOrder(nodeOrder);
        page.setUserId("portal_template_user");
        page.setResLevel(ResLevelEnum.EXT);
        page.setPermViewCtrl(true);
        page.setPermEditCtrl(true);
    }

    private String transWebMenu(String link) {
        if (StringUtil.isEmpty((String)link) || "null".equals(link)) {
            return "";
        }
        if (link.endsWith(".xhtml")) {
            link = link.replace(".xhtml", ".jsf");
        }
        if (link.indexOf(".jsf") > 0 && !link.startsWith("/easweb")) {
            link = "/easweb" + link;
        }
        return link;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public Map<String, Object> findPersonalSpaceMap(PortalContext ctx, Map<String, Object> permMap) throws PortalBizException {
        Map<String, PermInfo> permResMap = this.getPermResMap(ctx, ResTypeEnum.SPACE);
        List<Page> spaceList = null;
        Page space = null;
        try {
            List<Page> allSpaceList = this.getPersonalSpaceList(permResMap);
            String userId = ctx.getLoginUser().getId();
            spaceList = this.permService.selectPermPageList(ctx, allSpaceList, permMap, userId);
            space = this.getDefaultSpace(ctx);
            boolean flag = false;
            String amdinID = "00000000-0000-0000-0000-00000000000013B7DE7F";
            if (amdinID.equals(userId)) {
                String sysDefaultSpaceID = "303e5452-1200-4ccf-9a93-f398f48f12f7";
                for (Page page : spaceList) {
                    if (!sysDefaultSpaceID.equals(page.getId())) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    Page systemDefaultSpace = (Page)this.pageDAO.findById(sysDefaultSpaceID);
                    spaceList.add(systemDefaultSpace);
                }
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
        HashMap<String, Object> spaceData = new HashMap<String, Object>();
        spaceData.put("spaceList", spaceList);
        spaceData.put("defaultSpace", space);
        return spaceData;
    }

    private Map<String, PermInfo> getPermResMap(PortalContext ctx, ResTypeEnum resType) {
        return null;
    }

    private List<Page> getPersonalSpaceList(Map<String, PermInfo> map) throws DataAccessException {
        Page entity = new Page();
        entity.setNodeType(NodeTypeEnum.SPACE);
        entity.setStatus(StatusEnum.ENABLE);
        entity.setNodeLevel(1);
        return this.pageDAO.findList(entity, this.orderFilter());
    }

    private Page getDefaultSpace(PortalContext ctx) throws DataAccessException {
        Page entity = new Page();
        String userId = ctx.getLoginUser().getId();
        SpaceDefault spaceDefault = this.spaceDefaultService.findSpaceByUserId(userId);
        if (spaceDefault != null) {
            entity.setId(spaceDefault.getSpaceId());
        } else {
            entity.setId("303e5452-1200-4ccf-9a93-f398f48f12f7");
        }
        Page defaultPage = this.pageDAO.findObject(entity, new Filter[0]);
        if (defaultPage == null) {
            entity.setId("303e5452-1200-4ccf-9a93-f398f48f12f7");
            defaultPage = this.pageDAO.findObject(entity, new Filter[0]);
        }
        return defaultPage;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public Map<String, Object> findPersonalPageMap(PortalContext ctx, String spaceId, int ilevel, Map<String, Object> permMap, int firstLevel) throws PortalBizException {
        Map<String, PermInfo> permResMap = this.getPermResMap(ctx, null);
        List<Page> pageList = null;
        try {
            pageList = this.getPersonalPageList(ctx, spaceId, permResMap, ilevel, permMap);
        }
        catch (Exception e) {
            throw new PortalBizException("204", e);
        }
        List<Page> firstLevelPages = this.getFirstLevelPages(pageList, firstLevel);
        Map<String, List<Page>> multiTreeNodes = this.getMultiTreeNodes(firstLevelPages, pageList);
        HashMap<String, Object> personalData = new HashMap<String, Object>();
        personalData.put("firstLevelPages", firstLevelPages);
        personalData.put("multiTreeNodes", multiTreeNodes);
        return personalData;
    }

    private List<Page> getPersonalPageList(PortalContext ctx, String spaceId, Map<String, PermInfo> permResMap, int ilevel, Map<String, Object> permMap) throws DataAccessException, PortalBizException {
        String userId = ctx.getLoginUser().getId();
        Page entity = new Page();
        entity.setUserId("portal_template_user");
        entity.setStatus(StatusEnum.ENABLE);
        List<Page> allPageList = this.pageDAO.findList(entity, this.getRootNodePathFilter(spaceId), new FieldFilter("nodeLevel", "<", ilevel), new OrderFilter("nodeLevel", OrderEnum.ASC), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
        List<Page> pageList = this.permService.selectPermPageList(ctx, allPageList, permMap, userId);
        return this.findPageListNoNull(pageList);
    }

    private List<Page> findPageListNoNull(List<Page> pageList) throws PortalBizException {
        ArrayList<Page> newList = new ArrayList<Page>();
        try {
            for (Page firstPage : pageList) {
                boolean bl = false;
                String nodeType = firstPage.getNodeType().toString();
                if (nodeType.equals("FOLDER") || nodeType.equals("EXTERNAL_LINK") && new ELinkNodeExt(firstPage.getNodeExt()).getLeaf() == false || nodeType.equals("EXTERNAL_LINK_G") && new ELinkNodeExt(firstPage.getNodeExt()).getLeaf() == false || nodeType.equals("EXTERNAL_LINK_OA") && new ELinkNodeExt(firstPage.getNodeExt()).getLeaf() == false || nodeType.equals("EXTERNAL_LINK_SHR") && !new ELinkNodeExt(firstPage.getNodeExt()).getLeaf().booleanValue()) {
                    for (Page page : pageList) {
                        if (page.getNodeLevel() == 2 || !firstPage.hasChildNode(page)) continue;
                        String nType = page.getNodeType().toString();
                        if (nType.equals("FOLDER") || nType.equals("EXTERNAL_LINK") && new ELinkNodeExt(page.getNodeExt()).getLeaf() == false || nType.equals("EXTERNAL_LINK_G") && new ELinkNodeExt(page.getNodeExt()).getLeaf() == false || nType.equals("EXTERNAL_LINK_OA") && new ELinkNodeExt(page.getNodeExt()).getLeaf() == false || nType.equals("EXTERNAL_LINK_SHR") && !new ELinkNodeExt(page.getNodeExt()).getLeaf().booleanValue()) {
                            for (Page pg : pageList) {
                                if (!page.hasChildNode(pg)) continue;
                                bl = true;
                                break;
                            }
                        } else {
                            bl = true;
                        }
                        if (!bl) continue;
                        break;
                    }
                    if (!bl) continue;
                    newList.add(firstPage);
                    continue;
                }
                newList.add(firstPage);
            }
            return newList;
        }
        catch (Exception e) {
            throw new PortalBizException("204", e);
        }
    }

    private List<Page> getFirstLevelPages(List<Page> allPages, int ilevel) {
        ArrayList<Page> firstLevelPages = new ArrayList<Page>();
        if (allPages != null) {
            for (Page page : allPages) {
                if (page.getNodeLevel() != ilevel) continue;
                firstLevelPages.add(page);
            }
        }
        return firstLevelPages;
    }

    private Map<String, List<Page>> getMultiTreeNodes(List<Page> firstLevelPags, List<Page> allPages) {
        HashMap<String, List<Page>> pageMap = new HashMap<String, List<Page>>();
        if (firstLevelPags != null) {
            ArrayList<Page> pageList = null;
            for (Page firstPage : firstLevelPags) {
                pageList = new ArrayList<Page>();
                for (Page page : allPages) {
                    if (!firstPage.hasChildNode(page)) continue;
                    pageList.add(page);
                }
                pageMap.put(firstPage.getId(), pageList);
            }
        }
        return pageMap;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Map<String, Object> findBizPageMapWithLevel(PortalContext ctx, String bizPageId, Map<String, Object> permMap) throws PortalBizException {
        if (StringUtil.isEmpty((String)bizPageId)) {
            bizPageId = "4c2a38f9-3b59-4bd9-92fb-22df530ffb6f";
        }
        List<Page> bizPages = null;
        List<Page> noNullList = null;
        try {
            bizPages = this.getBizPageList(ctx, bizPageId, permMap);
            noNullList = this.findPageListNoNull(bizPages);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
        return this.buildBizPageMap(noNullList);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Page> findBizPageList(PortalContext ctx, String bizPageId, Map<String, Object> permMap) throws PortalBizException {
        List<Page> bizPages;
        block8: {
            if (StringUtil.isEmpty((String)bizPageId)) {
                throw new PortalBizException("204");
            }
            bizPages = null;
            try {
                if (ctx != null) {
                    String userId = ctx.getLoginUser().getId();
                    Page entity = new Page();
                    entity.setStatus(StatusEnum.ENABLE);
                    List<Page> allList = this.pageDAO.findList(entity, this.getRootNodePathFilter(bizPageId), new OrderFilter("nodeLevel", OrderEnum.ASC), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
                    bizPages = this.permService.selectPermPageList(ctx, allList, permMap, userId);
                    String locale = ctx.getLocale().toString();
                    for (Page cpage : bizPages) {
                        String pathInfo = "";
                        String nodePath = cpage.getNodePath();
                        String[] paths = nodePath.split("/");
                        for (int i = 0; i < paths.length; ++i) {
                            for (Page page : allList) {
                                if (page == null || !page.getId().equals(paths[i])) continue;
                                DisplayName dn = new DisplayName(page.getDisplayName(), locale);
                                pathInfo = pathInfo + dn.getLocaleText() + " > ";
                            }
                        }
                        if (pathInfo.length() > 2) {
                            pathInfo = pathInfo.substring(0, pathInfo.length() - 3);
                        }
                        cpage.setNodePath(pathInfo);
                    }
                    break block8;
                }
                throw new PortalBizException("204");
            }
            catch (DataAccessException e) {
                throw new PortalBizException("204", e);
            }
        }
        return bizPages;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Page> findPageCenterList(PortalContext ctx, int nodeLevel) throws PortalBizException {
        String rootId = "793e3c69-d245-4fa1-ac95-df9bd30586e3";
        List<Page> bizPages = null;
        try {
            if (ctx == null) {
                throw new PortalBizException("204");
            }
            String userId = ctx.getLoginUser().getId();
            Page entity = new Page();
            entity.setStatus(StatusEnum.ENABLE);
            FieldFilter fieldFilter = new FieldFilter("nodePath", "like", "/" + "2f9ef722-255b-4e4b-8d07-5277e353a321" + "/%/" + rootId + "/%");
            FieldFilter fieldFilter2 = new FieldFilter("nodeLevel", "=", nodeLevel);
            List<Page> allList = this.pageDAO.findList(entity, fieldFilter, fieldFilter2, new OrderFilter("nodeLevel", OrderEnum.ASC), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
            bizPages = this.permService.selectPermPageList(ctx, allList, null, userId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
        return bizPages;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Page> findAppCenterList(PortalContext ctx, String bizPageId, Map<String, Object> permMap) throws PortalBizException {
        if (StringUtil.isEmpty((String)bizPageId)) {
            throw new PortalBizException("204");
        }
        List<Page> bizPages = null;
        try {
            if (ctx == null) {
                throw new PortalBizException("204");
            }
            String userId = ctx.getLoginUser().getId();
            Page entity = new Page();
            entity.setStatus(StatusEnum.ENABLE);
            List<Page> allList = this.pageDAO.findList(entity, this.getRootNodePathFilter(bizPageId), new OrderFilter("nodeLevel", OrderEnum.ASC), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
            bizPages = this.permService.selectPermPageList(ctx, allList, permMap, userId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
        return bizPages;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Page> findBizPageList4Icon(PortalContext ctx, String bizPageId, Map<String, Object> permMap) throws PortalBizException {
        if (StringUtil.isEmpty((String)bizPageId)) {
            throw new PortalBizException("204");
        }
        List<Page> bizPages = null;
        try {
            if (ctx == null) {
                throw new PortalBizException("204");
            }
            String userId = ctx.getLoginUser().getId();
            Page entity = new Page();
            entity.setStatus(StatusEnum.ENABLE);
            entity.setNodeLevel(2);
            List<Page> allList = this.pageDAO.findList(entity, this.getRootNodePathFilter(bizPageId), new FieldFilter("nodeType", "<>", (Object)NodeTypeEnum.FOLDER), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
            bizPages = this.permService.selectPermPageList(ctx, allList, permMap, userId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
        return bizPages;
    }

    private List<Page> getBizPageList(PortalContext ctx, String bizPageId, Map<String, Object> permMap) throws DataAccessException, PortalBizException {
        Page entity = new Page();
        entity.setStatus(StatusEnum.ENABLE);
        List<Page> allList = this.pageDAO.findList(entity, this.getRootNodePathFilter(bizPageId), new OrderFilter("nodeLevel", OrderEnum.ASC), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
        String userId = "";
        if (ctx != null) {
            userId = ctx.getLoginUser().getId();
        }
        List<Page> pageList = this.permService.selectPermPageList(ctx, allList, permMap, userId);
        return pageList;
    }

    private FieldFilter getRootNodePathFilter(String id) {
        if (StringUtil.isEmpty((String)id)) {
            return new FieldFilter("nodePath", "like", "/%");
        }
        return new FieldFilter("nodePath", "like", "/" + "2f9ef722-255b-4e4b-8d07-5277e353a321" + "/" + id + "/%");
    }

    private Map<String, Object> buildBizPageMap(List<Page> bizPages) {
        ArrayList<Page> firstLevel = new ArrayList<Page>();
        HashMap<String, List<Page>> secendLevel = new HashMap<String, List<Page>>();
        HashMap<String, List<Page>> thirdLevel = new HashMap<String, List<Page>>();
        for (Page p : bizPages) {
            switch (p.getNodeLevel()) {
                case 2: {
                    firstLevel.add(p);
                    break;
                }
                case 3: {
                    this.setLevelPageMap(secendLevel, p);
                    break;
                }
                case 4: {
                    this.setLevelPageMap(thirdLevel, p);
                }
            }
        }
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("firstLevel", firstLevel);
        maps.put("secendLevel", secendLevel);
        maps.put("thirdLevel", thirdLevel);
        return maps;
    }

    private void setLevelPageMap(Map<String, List<Page>> levelMap, Page page) {
        List<Page> pages = levelMap.get(page.getParentNodeId());
        if (pages == null) {
            pages = new ArrayList<Page>();
        }
        pages.add(page);
        levelMap.put(page.getParentNodeId(), pages);
    }

    @Override
    public void setDefault(PortalContext ctx, Page page) throws PortalBizException {
        String pageId = page.getId();
        String spaceId = page.getParentNodeId();
        this.emptyCheck(pageId);
        PageSpacePersonalExt space = new PageSpacePersonalExt();
        space.setPageId(spaceId);
        PageSpacePersonalExt ext = null;
        try {
            if (page.getNodeType().equals((Object)NodeTypeEnum.SPACE)) {
                ext = this.pageSpacePersonalExtDAO.findObject(space, new Filter[0]);
                ext.setDefaultPageId(pageId);
                ext.setPortalContext(ctx);
                this.pageSpacePersonalExtDAO.update(ext);
            }
            Page oldPage = (Page)this.pageDAO.findById(spaceId);
            oldPage.setDefaultPageId(pageId);
            this.pageDAO.update(oldPage);
            Page newPage = (Page)this.pageDAO.findById(pageId);
            newPage.setNodeOrder(-this.t);
            this.pageDAO.update(newPage);
            ++this.t;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("203", e);
        }
    }

    @Override
    public PagingResult<PageDTO> findPageDTOListByType(PortalContext ctx, NodeTypeEnum type, PagingParam pagingParam) throws PortalBizException {
        PagingResult<PageDTO> result = new PagingResult<PageDTO>();
        PagingResult<Page> pagingResult = this.findPageListByType(ctx, type, pagingParam);
        result.setPagingParam(pagingResult.getPagingParam());
        result.setTotalCount(pagingResult.getTotalCount());
        HashMap<String, String> categoryId2Name = new HashMap<String, String>();
        ArrayList<PageDTO> records = new ArrayList<PageDTO>();
        for (Page page : pagingResult.getRecords()) {
            PortletDefinition plt;
            String categoryName = (String)categoryId2Name.get(page.getIcon());
            if (categoryName == null && (plt = this.portletDefinitionService.findPltByPageId(ctx, page.getId())) != null && plt.getCategoryId() != null) {
                categoryName = this.getPortletCategoryNameById(plt.getCategoryId());
                categoryId2Name.put(page.getIcon(), categoryName);
            }
            if (categoryName == null) {
                categoryName = "";
            }
            PageDTO pageDTO = new PageDTO();
            pageDTO.setCategoryName(categoryName);
            pageDTO.setPage(page);
            records.add(pageDTO);
        }
        result.setRecords(records);
        return result;
    }

    private String getPortletCategoryNameById(String categoryId) throws PortalBizException {
        PortletCategory category = new PortletCategory();
        category.setId(categoryId);
        category = this.portletCategoryService.findCategoryById(category);
        if (category != null) {
            return category.getCategoryName();
        }
        return "";
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<Page> findPageListByType(PortalContext ctx, NodeTypeEnum type, PagingParam pagingParam) throws PortalBizException {
        Page entity = new Page();
        entity.setNodeType(type);
        entity.setStatus(StatusEnum.ENABLE);
        PagingResult<Page> result = null;
        try {
            result = this.pageDAO.findList(entity, pagingParam, new FieldFilter("nodeLevel", "!=", 0), new OrderFilter("createTime", OrderEnum.ASC));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
        return this.disposeIfBizPage(ctx, type, result);
    }

    private PagingResult<Page> disposeIfBizPage(PortalContext ctx, NodeTypeEnum type, PagingResult<Page> result) throws PortalBizException {
        if (type != NodeTypeEnum.BIZ_PAGE) {
            return result;
        }
        PagingParam pagingParam = new PagingParam(1, 10000);
        PagingResult<PortletDefinition> pagingResult = this.portletDefinitionService.findPortletList(ctx, pagingParam, "plt_portal", "%%", null);
        List<PortletDefinition> portlets = pagingResult.getRecords();
        HashMap<String, String> portletNames = new HashMap<String, String>();
        HashMap<String, String> portletIds = new HashMap<String, String>();
        String pageId = "";
        for (PortletDefinition define : portlets) {
            String prefs;
            if (!define.getCopy().booleanValue() || (prefs = define.getPreferences()) == null) continue;
            String key = "values\":[\"";
            int index = prefs.indexOf(key);
            prefs = prefs.substring(index + key.length());
            pageId = prefs = prefs.substring(0, prefs.indexOf("\""));
            portletNames.put(pageId, define.getDisplayName());
            portletIds.put(pageId, define.getId());
        }
        List<Page> pages = result.getRecords();
        for (Page page : pages) {
            page.setSettingInfo((String)portletNames.get(page.getId()));
            page.setIcon((String)portletIds.get(page.getId()));
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Page> searchPageList(PortalContext ctx, String rootId, String name, NodeTypeEnum type) throws PortalBizException {
        Page entity = new Page();
        if (type != null) {
            entity.setNodeType(type);
        }
        try {
            return this.pageDAO.findList(entity, new FieldFilter("nodeLevel", "!=", 0), this.getRootNodePathFilter(rootId), new FieldFilter("displayName", "like", this.getWildcardName(name, ctx.getLocale().toString())));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Page> searchPlanList(PortalContext ctx, String name, NodeTypeEnum type, StatusEnum status) throws PortalBizException {
        Page entity = new Page();
        if (status != null) {
            entity.setStatus(status);
        }
        try {
            return this.pageDAO.findList(entity, new FieldFilter("nodeLevel", "!=", 0), new FieldFilter("nodeType", "=", (Object)type), new FieldFilter("userId", "=", "portal_template_user"), new FieldFilter("displayName", "like", this.getWildcardName(name, ctx.getLocale().toString())), new OrderFilter("createTime", OrderEnum.DESC));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    private String getWildcardName(String name, String locale) {
        return "%\"" + locale + "\":\"%" + name + "%\"%";
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Page> findPageListByIds(PortalContext ctx, String[] pageIds) throws PortalBizException {
        try {
            return this.pageDAO.findListByIds(pageIds);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Page> getPageByIdsAndOrder(PortalContext ctx, String[] ids, OrderEnum order) throws PortalBizException {
        try {
            String userId = ctx.getLoginUser().getId();
            List<Page> pageListByIdsAndOrder = this.pageDAO.findPageListByIdsAndOrder(ctx, ids, order);
            pageListByIdsAndOrder = this.permService.selectPermPageList(ctx, pageListByIdsAndOrder, null, userId);
            return pageListByIdsAndOrder;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Page> findAllEnabledSysPageList() throws PortalBizException {
        Page entity = new Page();
        entity.setUserId("portal_template_user");
        entity.setStatus(StatusEnum.ENABLE);
        try {
            return this.pageDAO.findList(entity, new FieldFilter("nodePath", "like", "/2f9ef722-255b-4e4b-8d07-5277e353a321/%"), new OrderFilter("nodeLevel", OrderEnum.ASC), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean hasUsed4Icon(PortalContext context, String icon) throws PortalBizException {
        try {
            Page page = new Page();
            page.setIcon(icon);
            List<Page> pageList = this.pageDAO.findList(page, new Filter[0]);
            if (pageList != null && pageList.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            throw new PortalBizException("204", e);
        }
        return false;
    }

    @Override
    public List<Page> findEditPermPageList(PortalContext ctx, String spaceId, Map<String, Object> permMap) throws PortalBizException {
        try {
            List<Page> pageList = this.getPersonalPageList(ctx, spaceId, null, 100, permMap);
            ArrayList<Page> returnList = new ArrayList<Page>();
            for (Page page : pageList) {
                if (!page.getPermEditCtrl().booleanValue()) continue;
                returnList.add(page);
            }
            return returnList;
        }
        catch (Exception e) {
            throw new PortalBizException("204", e);
        }
    }

    @Override
    public Map<String, Object> findBizNavWithLevel(PortalContext ctx, String spaceId, int ilevel, Map<String, Object> permMap) throws PortalBizException {
        List<Page> pageList = null;
        try {
            pageList = this.getPersonalPageList(ctx, spaceId, null, ilevel, permMap);
        }
        catch (Exception e) {
            throw new PortalBizException("204", e);
        }
        List<Page> firstLevelPages = this.getFirstLevelPages(pageList, 2);
        Map<String, List<Page>> multiTreeNodes = this.getMultiTreeNodes(firstLevelPages, pageList);
        HashMap<String, Object> personalData = new HashMap<String, Object>();
        personalData.put("firstLevelPages", firstLevelPages);
        personalData.put("multiTreeNodes", multiTreeNodes);
        return personalData;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PageSpacePersonalExt findPageSpacePersonalExtByPageId(PortalContext ctx, String pageId) throws PortalBizException {
        PageSpacePersonalExt ext = new PageSpacePersonalExt();
        ext.setPageId(pageId);
        try {
            return this.pageSpacePersonalExtDAO.findObject(ext, new Filter[0]);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    @Override
    public List<SearchAllDTO> searchPageListByKey(PortalContext ctx, String bizPageId, String keyWord, Map<String, Object> permMap) throws PortalBizException {
        try {
            Map<String, String> portalProfileMap;
            String type;
            List<SearchAllDTO> allList;
            Page page = new Page();
            page.setStatus(StatusEnum.ENABLE);
            if (StringUtil.isEmpty((String)bizPageId)) {
                bizPageId = "/2f9ef722-255b-4e4b-8d07-5277e353a321/";
            }
            if (null == (allList = this.pageDAO.searchPageListByKeyNew(ctx, bizPageId, keyWord, type = (portalProfileMap = PortalCache.getPortalProfileMap()).get("show_organization_qua_search"))) || allList.size() == 0) {
                return allList;
            }
            String userId = "";
            if (ctx != null) {
                userId = ctx.getLoginUser().getId();
            }
            List<SearchAllDTO> resultList = this.selectPermSearchList(ctx, allList, permMap, userId);
            return resultList;
        }
        catch (Exception e) {
            throw new PortalBizException("204", e);
        }
    }

    private List<SearchAllDTO> selectPermSearchList(PortalContext ctx, List<SearchAllDTO> allList, Map<String, Object> permMap, String userId) throws PortalBizException {
        int pageCountMax = 5;
        ArrayList<SearchAllDTO> resultList = new ArrayList<SearchAllDTO>();
        int pageCount = 0;
        for (SearchAllDTO dto : allList) {
            String type = dto.getType();
            if ("page".equals(type)) {
                if (pageCount >= pageCountMax || !this.checkPagePerm(ctx, dto, permMap, userId)) continue;
                ++pageCount;
                resultList.add(dto);
                continue;
            }
            resultList.add(dto);
        }
        return resultList;
    }

    private boolean checkPagePerm(PortalContext ctx, SearchAllDTO dto, Map<String, Object> permMap, String userId) throws PortalBizException {
        if (dto.getNodeType().equals(NodeTypeEnum.FOLDER.name()) || dto.getNodeType().equals(NodeTypeEnum.EXTERNAL_LINK.name()) && new ELinkNodeExt(dto.getNodeExt()).getLeaf() == false || dto.getNodeType().equals(NodeTypeEnum.EXTERNAL_LINK_G.name()) && new ELinkNodeExt(dto.getNodeExt()).getLeaf() == false || dto.getNodeType().equals(NodeTypeEnum.EXTERNAL_LINK_OA.name()) && !new ELinkNodeExt(dto.getNodeExt()).getLeaf().booleanValue()) {
            return false;
        }
        Page newPage = new Page();
        newPage.setDisplayName(dto.getDisplayName());
        newPage.setId(dto.getId());
        newPage.setNodeExt(dto.getNodeExt());
        NodeTypeEnum myEnum = NodeTypeEnum.valueOf(dto.getNodeType());
        newPage.setNodeType(myEnum);
        newPage.setPermViewCtrl("1".equals(dto.getPermViewCtrl()));
        ArrayList<Page> newList = new ArrayList<Page>();
        newList.add(newPage);
        List<Page> pageList = null;
        try {
            pageList = this.permService.selectPermPageList(ctx, newList, permMap, userId);
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u67e5\u67d0\u4e2a\u67e5\u8be2\u7ed3\u679c\u662f\u5426\u6709\u6743\u9650\uff08type=page\u65f6\uff09\u5931\u8d25!", (Throwable)e);
        }
        boolean result = false;
        if (null != pageList && pageList.size() == 1) {
            result = true;
        }
        return result;
    }

    @Override
    public List<Page> importPage(PortalContext ctx, PageDTO pageDto, boolean copyPageContent, int maxLevel) throws PortalBizException {
        try {
            String sourceId = pageDto.getSource();
            String ids = pageDto.getElink().getMenuItemIdColl();
            this.emptyCheck(sourceId);
            this.emptyCheck(ids);
            List<Page> pageList = this.pageDAO.findAllPageListByids(new Page(), ids, true);
            if (pageList != null) {
                int copyLevel;
                Page parent = (Page)this.pageDAO.findById(sourceId);
                int nodeLevel = parent.getNodeLevel();
                if (maxLevel < nodeLevel + (copyLevel = this.getPageLevel(pageList, ids))) {
                    throw new PortalBizException("208");
                }
                pageList = this.copyAllPage(ctx, pageList, parent, ids, copyPageContent, pageDto.getPage().getStatus(), pageDto.getPage());
                try {
                    Context context = (Context)ctx.getMetaInfo().get("eas_context");
                    PortalCacheFacade.updateAppCenterCacheFlag(context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return pageList;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    private List<Page> copyAllPage(PortalContext ctx, List<Page> pageList, Page parent, String ids, boolean copyPageContent, StatusEnum status, Page bizPage) throws DataAccessException {
        for (String id : ids.split(",")) {
            for (Page page : pageList) {
                if (!page.getId().equals(id)) continue;
                Page newPage = null;
                newPage = page.getNodeType().equals((Object)NodeTypeEnum.SYS_NAV) || page.getNodeType().equals((Object)NodeTypeEnum.BIZ_PAGE) || page.getNodeType().equals((Object)NodeTypeEnum.SYS_TMPL) ? page : this.copySinglePage(ctx, page, parent, copyPageContent, status, bizPage);
                if (!this.hasFullChildren(page)) continue;
                this.copySonPage(ctx, pageList, page, newPage, copyPageContent, status, bizPage);
            }
        }
        return pageList;
    }

    private boolean hasFullChildren(Page page) {
        return page.getNodeType().equals((Object)NodeTypeEnum.FOLDER) || page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK) && new ELinkNodeExt(page.getNodeExt()).getLeaf() == false || page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK_G) && new ELinkNodeExt(page.getNodeExt()).getLeaf() == false || page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK_OA) && new ELinkNodeExt(page.getNodeExt()).getLeaf() == false;
    }

    private Page copySinglePage(PortalContext ctx, Page page, Page parent, boolean copyPageContent, StatusEnum status, Page bizPage) throws DataAccessException {
        String userId = "portal_template_user";
        Page createPage = new Page();
        createPage.setControlParam(page.getControlParam());
        createPage.setDefaultPageId(page.getDefaultPageId());
        createPage.setDescription(page.getDescription());
        createPage.setDisplayName(page.getDisplayName());
        createPage.setHidden(page.getHidden());
        createPage.setIcon(page.getIcon());
        createPage.setNodeExt(page.getNodeExt());
        createPage.setNodeType(page.getNodeType());
        createPage.setPermViewCtrl(page.getPermViewCtrl());
        createPage.setPermEditCtrl(page.getPermEditCtrl());
        createPage.setPreferences(page.getPreferences());
        createPage.setPageNumber(PageHelper.generatePageNumber());
        createPage.setSettingInfo(page.getSettingInfo());
        createPage.setShowPltButton(page.getShowPltButton());
        createPage.setStatus(status);
        createPage.setParentNode(parent);
        createPage.setResLevel(ResLevelEnum.EXT);
        createPage.setNodeOrder(10001);
        createPage.setPortalContext(ctx);
        createPage.setUserId("portal_template_user");
        createPage.setAllSpell(this.getCnSpell(page.getDisplayName(), false));
        createPage.setFirstSpell(this.getCnSpell(page.getDisplayName(), true));
        createPage.setCanAddFav(bizPage.getCanAddFav());
        Page newPage = this.pageDAO.create(createPage);
        if (page.getPageNumber() != null && page.getPageNumber().indexOf("C-") == 0) {
            PageIdMapCode ic = new PageIdMapCode();
            ic.setPageId(newPage.getId());
            ic.setPageNumber(newPage.getPageNumber());
            ic.setPortalContext(ctx);
            try {
                this.pageIdMapCodeService.savePageIdMapCode(ctx, ic, "create");
            }
            catch (PortalBizException e) {
                e.printStackTrace();
            }
        }
        if (page != null && copyPageContent) {
            try {
                this.onlineEditPageService.copyPage(ctx, page.getId(), userId, newPage.getId(), userId);
            }
            catch (PortalBizException e) {
                this.logger.error(e.getMessage());
            }
        }
        return newPage;
    }

    private List<Page> copySonPage(PortalContext ctx, List<Page> pageList, Page oldPage, Page parent, boolean copyPageContent, StatusEnum status, Page bizPage) throws DataAccessException {
        for (Page page : pageList) {
            if (page.getNodePath().indexOf(oldPage.getNodePath() + "/") <= -1) continue;
            this.copySinglePage(ctx, page, parent, copyPageContent, status, bizPage);
        }
        return pageList;
    }

    private int getPageLevel(List<Page> pageList, String ids) {
        int maxLevel = 0;
        for (String id : ids.split(",")) {
            for (Page page : pageList) {
                if (!page.getId().equals(id)) continue;
                int parentLevel = page.getNodeLevel();
                String nodePath = page.getNodePath();
                int sonLevel = 0;
                for (Page pg : pageList) {
                    if (pg.getNodePath().indexOf(nodePath + "/") <= -1 || pg.getNodeLevel() <= sonLevel) continue;
                    sonLevel = pg.getNodeLevel();
                }
                if (sonLevel - parentLevel <= maxLevel) continue;
                maxLevel = sonLevel - parentLevel;
            }
        }
        return maxLevel;
    }

    @Override
    public NavConfigDTO findViewTmplForNavConfig(PortalContext ctx, NavConfigDTO ncd, RenderRequest request) throws PortalBizException {
        NavConfigDTO returnNf = new NavConfigDTO();
        try {
            ViewTmplPreferences pre;
            String viewTmpl = "";
            String modelTitle = this.i18nService.getText(ctx, "res.portal.i18n.page.SysTmplConfigPortlet.SysTmplConfigPortlet", ncd.getModelTitle());
            String modelDesc = this.i18nService.getText(ctx, "res.portal.i18n.page.SysTmplConfigPortlet.SysTmplConfigPortlet", ncd.getModelDesc());
            Page page = this.findPageById(ctx, ncd.getParentId());
            if (page != null && page.getPreferences() != null && (viewTmpl = (pre = new ViewTmplPreferences(page.getPreferences())).getViewTmpl()) != null) {
                String[] view = viewTmpl.split(",");
                request.setAttribute("maxLevel", (Object)view[3]);
                request.setAttribute("tmplAppearance", (Object)view[1]);
            }
            request.setAttribute("pageId", (Object)ncd.getParentId());
            request.setAttribute("modelTitle", (Object)modelTitle);
            request.setAttribute("modelDesc", (Object)modelDesc);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7a7a\u95f4\u5217\u8868\u51fa\u9519", (Throwable)e);
        }
        return returnNf;
    }

    @Override
    public Page savePage(PortalContext ctx, PageDTO pageDto) throws PortalBizException {
        Page page = null;
        try {
            String codeType = "";
            Page ParamPage = pageDto.getPage();
            String pageNumber = ParamPage.getPageNumber();
            if (pageNumber != null && pageNumber.indexOf("C-") == 0) {
                codeType = StringUtil.isEmpty((String)ParamPage.getId()) ? "create" : "update";
            }
            page = StringUtil.isEmpty((String)ParamPage.getId()) ? this.createPage(ctx, pageDto) : this.updatePage(ctx, pageDto);
            if (codeType.length() > 0) {
                PageIdMapCode ic = new PageIdMapCode();
                ic.setPageId(page.getId());
                ic.setPageNumber(page.getPageNumber());
                ic.setPortalContext(ctx);
                this.pageIdMapCodeService.savePageIdMapCode(ctx, ic, codeType);
            }
        }
        catch (Exception e) {
            throw new PortalBizException("202", e);
        }
        return page;
    }

    @Override
    public Map<String, Object> findCustomMenuMap(PortalContext ctx, String rootId, Map<String, Object> permMap, String getBizType, String canAddFav) throws PortalBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List<Page> pages = this.findBizPageList(ctx, rootId, permMap);
            if (pages != null) {
                List<CustomMenuDTO> rp = this.getCustomPage(ctx, pages, permMap, getBizType, canAddFav);
                Page page = this.findPageById(ctx, rootId);
                String defaultPageId = "";
                if (page != null) {
                    defaultPageId = page.getDefaultPageId();
                }
                map.put("defaultPageId", defaultPageId);
                map.put("pages", rp);
            }
        }
        catch (Exception e) {
            throw new PortalBizException("204", e);
        }
        return map;
    }

    private List<CustomMenuDTO> getCustomPage(PortalContext ctx, List<Page> pages, Map<String, Object> permMap, String getBizType, String canAddFav) {
        ArrayList<CustomMenuDTO> rp = new ArrayList<CustomMenuDTO>();
        try {
            List<PersonalFavoriteDTO> favList = this.personalFavoriteService.findPersonalFavoriteList(ctx, permMap);
            String locale = ctx.getLocale().toString();
            for (Page page : pages) {
                ELinkNodeExt t;
                GuiPreferences gp;
                Page pg = new Page();
                CustomMenuDTO cm = new CustomMenuDTO();
                pg.setId(page.getId());
                pg.setParentNodeId(page.getParentNodeId());
                pg.setNodeType(page.getNodeType());
                pg.setNodeExt(page.getNodeExt());
                pg.setDisplayName(this.getLocaleDisplayName(locale, page.getDisplayName()));
                pg.setDescription(this.getLocaleDisplayName(locale, page.getDescription()));
                pg.setPermEditCtrl(page.getPermEditCtrl());
                pg.setNodePath(page.getNodePath());
                if (getBizType != null && getBizType.equals("tree")) {
                    pg.setIcon(this.getIconByType(page.getNodeType()));
                } else {
                    pg.setIcon(page.getIcon());
                }
                int nameLength = 0;
                if (pg.getDisplayName() != null) {
                    nameLength = pg.getDisplayName().length();
                }
                cm.setNameLength(nameLength);
                PageNodeExt pn = null;
                if (page.getNodeExt() != null) {
                    pn = new PageNodeExt(page.getNodeExt());
                    if (pn.getExternalId() != null) {
                        cm.setExternalId(pn.getExternalId());
                    }
                    if (pn.getSso() != null) {
                        cm.setSso(pn.getSso());
                    }
                    if (pn.getTarget() != null) {
                        cm.setTarget(pn.getTarget());
                    }
                    if (pn.getUrl() != null) {
                        cm.setUrl(pn.getUrl());
                    }
                }
                pg.setPreferences(page.getPreferences());
                if (NodeTypeEnum.EXTERNAL_LINK_G.equals((Object)page.getNodeType()) && !StringUtil.isEmpty((String)page.getPreferences()) && (gp = new GuiPreferences(page.getPreferences())) != null) {
                    cm.setOpenMethod(gp.getOpenMethod());
                    cm.setUiClassParam(gp.getUiClassParam());
                    cm.setUiOprt(gp.getUiOprt());
                }
                String pageId = page.getId();
                cm.setIsShow("false");
                for (Page p : pages) {
                    String parentId = p.getParentNodeId();
                    if (!pageId.equals(parentId)) continue;
                    cm.setIsShow("true");
                }
                String isLeaf = "false";
                if (NodeTypeEnum.PAGE.equals((Object)page.getNodeType()) || NodeTypeEnum.LINK.equals((Object)page.getNodeType())) {
                    isLeaf = "true";
                }
                if ((NodeTypeEnum.EXTERNAL_LINK.equals((Object)page.getNodeType()) || NodeTypeEnum.EXTERNAL_LINK_G.equals((Object)page.getNodeType()) || NodeTypeEnum.EXTERNAL_LINK_OA.equals((Object)page.getNodeType())) && (t = new ELinkNodeExt(page.getNodeExt())).getLeaf() != null) {
                    isLeaf = t.getLeaf().toString();
                }
                cm.setIsLeaf(isLeaf);
                if (!StringUtil.isEmpty((String)canAddFav) && canAddFav.equals("true") && isLeaf.equals("true")) {
                    if (favList != null) {
                        boolean isFind = false;
                        for (PersonalFavoriteDTO favDto : favList) {
                            if (NodeTypeEnum.EXTERNAL_LINK_G.equals((Object)page.getNodeType())) {
                                if (!favDto.getFavorite().getPageId().equals(pn.getExternalId())) continue;
                                isFind = true;
                                cm.setFavId(favDto.getFavorite().getId());
                                cm.setAddFav("1");
                                continue;
                            }
                            if (!favDto.getFavorite().getPageId().equals(page.getId())) continue;
                            isFind = true;
                            cm.setFavId(favDto.getFavorite().getId());
                            cm.setAddFav("1");
                        }
                        if (!isFind) {
                            cm.setAddFav("2");
                        }
                    } else {
                        cm.setAddFav("2");
                    }
                } else {
                    cm.setAddFav("0");
                }
                cm.setPage(pg);
                rp.add(cm);
            }
        }
        catch (PortalBizException e) {
            this.logger.error(e.getMessage());
        }
        return rp;
    }

    private String getLocaleDisplayName(String locale, String displayName) {
        if (displayName == null || displayName.equals("")) {
            return "";
        }
        DisplayName dn = new DisplayName(displayName, locale);
        return dn.getLocaleText();
    }

    private String getIconByType(NodeTypeEnum t) {
        String iconName = "page.gif";
        switch (t) {
            case PAGE: {
                iconName = "page.gif";
                break;
            }
            case SPACE: 
            case FOLDER: 
            case BIZ_PAGE: 
            case SYS_NAV: {
                iconName = "folder_Open.gif";
                break;
            }
            case EXTERNAL_LINK: 
            case EXTERNAL_LINK_G: 
            case EXTERNAL_LINK_OA: {
                iconName = "icon_menu.png";
                break;
            }
            case LINK: {
                iconName = "icon_link.png";
            }
        }
        return "/portal/res/img/ui/ztree/" + iconName;
    }

    @Override
    public Page findPageByPageNumber(PortalContext ctx, String pageNumber, Map<String, Object> permMap) throws PortalBizException {
        Page page = new Page();
        page.setPageNumber(pageNumber);
        try {
            String userId = ctx.getLoginUser().getId();
            Page resultPage = null;
            Page pg = this.pageDAO.findObject(page, new OrderFilter("createTime", OrderEnum.ASC));
            if (pg != null) {
                ArrayList<Page> pl = new ArrayList<Page>();
                pl.add(pg);
                List<Page> returnList = this.permService.selectPermPageList(ctx, pl, permMap, userId);
                if (returnList != null && returnList.size() > 0) {
                    resultPage = returnList.get(0);
                }
            }
            return resultPage;
        }
        catch (DataAccessException dataAccessException) {
            return null;
        }
    }

    @Override
    public List<Page> findBizList4PresetFav(PortalContext ctx) throws PortalBizException {
        try {
            return this.pageDAO.findBizList4PresetFav(ctx);
        }
        catch (DataAccessException dataAccessException) {
            return null;
        }
    }

    @Override
    public List<Page> findAddedPageList(PortalContext ctx, String roleId) throws PortalBizException {
        try {
            return this.pageDAO.findAddedPageList(ctx, roleId);
        }
        catch (DataAccessException dataAccessException) {
            return null;
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Page> findBizTreeByPId(PortalContext ctx, String pId) throws PortalBizException {
        if (StringUtil.isEmpty((String)pId)) {
            throw new PortalBizException("204");
        }
        try {
            if (ctx != null) {
                Page entity = new Page();
                entity.setStatus(StatusEnum.ENABLE);
                return this.pageDAO.findList(entity, this.getRootNodePath(pId), new OrderFilter("nodeLevel", OrderEnum.ASC), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
            }
            throw new PortalBizException("204");
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    private FieldFilter getRootNodePath(String pId) {
        if (StringUtil.isEmpty((String)pId)) {
            return new FieldFilter("nodePath", "like", "/%");
        }
        return new FieldFilter("nodePath", "like", "/" + "2f9ef722-255b-4e4b-8d07-5277e353a321" + "/" + pId + "/%");
    }

    @Override
    public List<Page> getSpaceList(PortalContext ctx, Map<String, Object> permMap) throws PortalBizException {
        Page entity = new Page();
        entity.setNodeType(NodeTypeEnum.SPACE);
        entity.setNodeLevel(1);
        try {
            List<Page> pageList = this.pageDAO.findList(entity, new Filter[0]);
            return pageList;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    @Override
    public void sortSpaceList(PortalContext ctx, String sortType, String id) throws PortalBizException {
        Page entity = new Page();
        entity.setNodeType(NodeTypeEnum.SPACE);
        entity.setNodeLevel(1);
        try {
            List<Page> pageList = this.pageDAO.findList(entity, new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
            for (int i = 0; i < pageList.size(); ++i) {
                Page page = pageList.get(i);
                Integer nodeOrder = 0;
                Timestamp createTime = null;
                if (!page.getId().equals(id)) continue;
                nodeOrder = page.getNodeOrder();
                createTime = page.getCreateTime();
                if (sortType.equals("down")) {
                    page.setNodeOrder(pageList.get(i + 1).getNodeOrder());
                    page.setCreateTime(pageList.get(i + 1).getCreateTime());
                    pageList.get(i + 1).setNodeOrder(nodeOrder);
                    pageList.get(i + 1).setCreateTime(createTime);
                    continue;
                }
                page.setNodeOrder(pageList.get(i - 1).getNodeOrder());
                page.setCreateTime(pageList.get(i - 1).getCreateTime());
                pageList.get(i - 1).setNodeOrder(nodeOrder);
                pageList.get(i - 1).setCreateTime(createTime);
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    @Override
    public IRowSet findPresetFavPageList(PortalContext ctx, String presetId) throws PortalBizException {
        try {
            return this.pageDAO.findPresetFavPageList(ctx, presetId);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("308", e);
        }
    }

    @Override
    public List<Page> findPageListForPresetFav(PortalContext ctx, String userId, String userType) throws PortalBizException {
        try {
            IRowSet rs = this.pageDAO.findPageListForPresetFav(ctx, userId, userType);
            ArrayList<Page> pageList = new ArrayList<Page>();
            if (rs != null) {
                while (rs.next()) {
                    Page page = new Page();
                    page.setNodeType(this.getNodeTypeEnum(rs.getString("FNodeType")));
                    page.setNodeExt(rs.getString("FNodeExt"));
                    page.setPageNumber(rs.getString("FPageNumber"));
                    page.setId(rs.getString("FId"));
                    pageList.add(page);
                }
            }
            return pageList;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("308", e);
        }
    }

    @Override
    public List<Page> findAppSecondPageList(PortalContext ctx) throws PortalBizException {
        try {
            return this.pageDAO.findAppSecondPageList(ctx);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("308", e);
        }
    }

    private NodeTypeEnum getNodeTypeEnum(String nodeType) {
        if ("PAGE".equals(nodeType)) {
            return NodeTypeEnum.PAGE;
        }
        if ("EXTERNAL_LINK".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK;
        }
        if ("EXTERNAL_LINK_G".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK_G;
        }
        if ("EXTERNAL_LINK_OA".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK_OA;
        }
        if ("EXTERNAL_LINK_SHR".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK_SHR;
        }
        if ("LINK".equals(nodeType)) {
            return NodeTypeEnum.LINK;
        }
        if ("NEW_PAGE".equals(nodeType)) {
            return NodeTypeEnum.NEW_PAGE;
        }
        return null;
    }

    @Override
    public List<Page> findFavPageList(PortalContext ctx) throws PortalBizException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        ArrayList<Page> pageList = new ArrayList<Page>();
        StringBuilder permSql = new StringBuilder();
        try {
            String userId = ctx.getLoginUser().getId();
            permSql.append("SELECT t.* FROM T_JP_Page t,T_BAS_ComFunction f ").append("where f.FUserID='").append(userId).append("' and f.FISLEAF=1 and ").append("(t.FId=f.FMenuFunctionID or ").append("  CHARINDEX(f.FMenuFunctionID,t.FNodeExt)>0 )");
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString());
            if (rs != null) {
                while (rs.next()) {
                    Page page = new Page();
                    page.setDisplayName(rs.getString("FDisplayName"));
                    page.setDescription(rs.getString("FDescription"));
                    page.setIcon(rs.getString("FIcon"));
                    page.setParentNodeId(rs.getString("FParentNodeId"));
                    page.setPermViewCtrl(rs.getBoolean("FPermViewCtrl"));
                    page.setPermEditCtrl(rs.getBoolean("FPermEditCtrl"));
                    page.setPreferences(rs.getString("FPreferences"));
                    page.setNodeType(this.getNodeTypeEnum(rs.getString("FNodeType")));
                    page.setNodeExt(rs.getString("FNodeExt"));
                    page.setPageNumber(rs.getString("FPageNumber"));
                    page.setStatus(this.getStatusEnum(rs.getString("FStatus")));
                    page.setNodePath(rs.getString("FNodePath"));
                    page.setId(rs.getString("FId"));
                    pageList.add(page);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return pageList;
    }

    private StatusEnum getStatusEnum(String status) {
        if (status != null && "ENABLE".equals(status)) {
            return StatusEnum.ENABLE;
        }
        return StatusEnum.DISABLE;
    }

    @Override
    public List<Page> getPageFolderByParentId(String parentId) throws PortalBizException {
        Page entity = new Page();
        entity.setStatus(StatusEnum.ENABLE);
        try {
            Page parentPage = (Page)this.pageDAO.findById(parentId);
            if (parentPage != null) {
                List<Page> allList = this.pageDAO.findList(entity, this.getDirectNodePathFilter(parentId), new FieldFilter("nodeLevel", "=", parentPage.getNodeLevel() + 1), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
                return allList;
            }
            throw new PortalBizException("210");
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("204", e);
        }
    }

    private FieldFilter getDirectNodePathFilter(String id) {
        return new FieldFilter("nodePath", "like", "%/" + id + "/%");
    }

    @Override
    public List<Page> searchPageFolder(Context ctx, String parentId, String searchKey, int level) throws PortalBizException {
        Page entity = new Page();
        entity.setStatus(StatusEnum.ENABLE);
        ArrayList<Page> pageList = null;
        try {
            List<Page> allList = this.pageDAO.findList(entity, this.getNodePathFilter(parentId), new FieldFilter("nodeLevel", "<", 5), new OrderFilter("nodeLevel", OrderEnum.ASC), new OrderFilter("nodeOrder", OrderEnum.ASC), new OrderFilter("createTime", OrderEnum.ASC));
            if (allList != null && allList.size() > 0) {
                pageList = new ArrayList<Page>();
                String locale = ctx.getLocale().toString();
                for (Page cpage : allList) {
                    if (cpage.getNodeLevel() != level + 1 || cpage.getDisplayName().indexOf(searchKey) == -1) continue;
                    Page newPage = this.setPage4Perm(cpage, true, false);
                    String pathInfo = "";
                    String nodePath = cpage.getNodePath();
                    String[] paths = nodePath.split("/");
                    for (int i = 0; i < paths.length; ++i) {
                        for (Page page : allList) {
                            if (page == null || !page.getId().equals(paths[i])) continue;
                            DisplayName dn = new DisplayName(page.getDisplayName(), locale);
                            pathInfo = pathInfo + dn.getLocaleText() + " > ";
                        }
                    }
                    if (pathInfo.length() > 2) {
                        pathInfo = pathInfo.substring(0, pathInfo.length() - 3);
                    }
                    newPage.setNodePath(pathInfo);
                    pageList.add(newPage);
                }
            }
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("204", e);
        }
        return pageList;
    }

    private FieldFilter getNodePathFilter(String id) {
        if (StringUtil.isEmpty((String)id)) {
            return new FieldFilter("nodePath", "like", "%/2b7f4215-aa17-4d89-952e-efc97833cee6/%");
        }
        return new FieldFilter("nodePath", "like", "%/" + id + "/%");
    }

    private Page setPage4Perm(Page page, boolean viewCtrl, boolean editCtrl) {
        LinkNodeExt ext;
        Page newPage = new Page();
        newPage.setDisplayName(page.getDisplayName());
        newPage.setIcon(page.getIcon());
        newPage.setId(page.getId());
        newPage.setNodeLevel(page.getNodeLevel());
        newPage.setNodeOrder(page.getNodeOrder());
        newPage.setNodePath(page.getNodePath());
        newPage.setNodeType(page.getNodeType());
        newPage.setPageNumber(page.getPageNumber());
        String nodeExt = page.getNodeExt();
        if (page.getNodeType().equals((Object)NodeTypeEnum.LINK) && page.getNodeExt() != null && (ext = new LinkNodeExt(nodeExt)).getSso() != null && ext.getSso().booleanValue()) {
            ext.setUrl("/portal/openSSOUrlServlet?url=" + ext.getUrl());
            nodeExt = ext.toString();
        }
        newPage.setNodeExt(nodeExt);
        return newPage;
    }

    @Override
    public boolean hasImportPage(Context ctx, String url) throws PortalBizException {
        boolean result = true;
        try {
            Page page = (Page)this.pageDAO.findObject(new FieldFilter("nodeExt", "like", "%" + url + "%"));
            if (page == null) {
                result = false;
            }
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("204", e);
        }
        return result;
    }

    @Override
    public List<Page> savePageToPortal(Context ctx, String pageJson, String parentId) throws PortalBizException {
        Page parent;
        ArrayList<Page> resultList = new ArrayList<Page>();
        try {
            parent = (Page)this.pageDAO.findById(parentId);
        }
        catch (DataAccessException e1) {
            this.logger.error("savePageToPortal find parent error===" + e1.getMessage());
            throw new PortalBizException("210");
        }
        if (parent == null) {
            this.logger.error("savePageToPortal parent is null===");
            throw new PortalBizException("210");
        }
        JSONObject obj = JSONObject.fromObject((Object)pageJson);
        String dispalyName = obj.getString("displayName");
        dispalyName = dispalyName.substring(1, dispalyName.length() - 1);
        String url = obj.getString("url");
        String permItem = null;
        Page page = new Page();
        page.setDisplayName(dispalyName);
        page.setDescription(dispalyName);
        page.setNodeType(NodeTypeEnum.EXTERNAL_LINK);
        page.setParentNode(parent);
        page.setStatus(StatusEnum.ENABLE);
        page.setPageNumber(PageHelper.generatePageNumber());
        page.setPermViewCtrl(false);
        page.setPermEditCtrl(false);
        page.setCanAddFav(true);
        page.setCanSearch(true);
        page.setPreferences("2");
        String externalId = this.savePageToEAS(ctx, url, dispalyName, permItem);
        ELinkNodeExt ext = new ELinkNodeExt();
        ext.setUrl(url);
        ext.setExternalId(externalId);
        ext.setLeaf(true);
        ext.setTarget("TAB");
        page.setNodeExt(ext.toString());
        page.setResLevel(ResLevelEnum.EXT);
        page.setNodeOrder(10000);
        page.setPortalContext(this.buildPortalContext(ctx));
        page.setUserId("portal_template_user");
        page.setAllSpell(this.getCnSpell(dispalyName, false));
        page.setFirstSpell(this.getCnSpell(dispalyName, true));
        try {
            StringBuilder saveSql = new StringBuilder();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String nowTime = df.format(new Date());
            String id = UUID.randomUUID().toString();
            saveSql.append("Insert Into T_JP_Page(FID,FCREATETIME,FCREATOR,FLASTUPDATETIME,FLASTUPDATER,FHIDDEN,FNODELEVEL,FNODEORDER,FNODEPATH,FPARENTNODEID,FPAGENUMBER,FDISPLAYNAME,FNODETYPE,FNODEEXT,FDESCRIPTION,FSETTINGINFO,FSTATUS,FICON,FPERMVIEWCTRL,FPERMEDITCTRL,FRESLEVEL,FUSERID,FPREFERENCES,FDEFAULTPAGEID,FCONTROLPARAM,FSHOWPLTBUTTON,FFIRSTSPELL,FALLSPELL,FCANSEARCH,FCANADDFAV)").append(" Values('").append(id).append("',").append("{ts'").append(nowTime).append("'}").append(",").append("'").append(ctx.getUserName()).append("',").append("{ts'").append(nowTime).append("'}").append(",").append("'").append(ctx.getUserName()).append("',").append("0,5,10000,").append("'").append(parent.getNodePath()).append("/").append(id).append("',").append("'").append(parent.getId()).append("',").append("'").append(PageHelper.generatePageNumber()).append("',").append("'").append(dispalyName).append("',").append("'EXTERNAL_LINK',").append("'").append(ext.toString()).append("',").append("'").append(dispalyName).append("',").append("null,'ENABLE',null,1,1,'EXT','portal_template_user','2',").append("null,null,null,").append("'").append(this.getCnSpell(dispalyName, true)).append("',").append("'").append(this.getCnSpell(dispalyName, false)).append("',").append("1,1)");
            DbUtil.execute((Context)ctx, (String)saveSql.toString());
            page.setId(id);
        }
        catch (Exception e) {
            this.logger.error("savePageToPortal create page error===" + e.getMessage());
            throw new PortalBizException("202");
        }
        resultList.add(page);
        return resultList;
    }

    private String savePageToEAS(Context ctx, String url, String displayName, String permItem) throws PortalBizException {
        String externalId = null;
        try {
            MainMenuItemInfo parent = MainMenuItemFactory.getLocalInstance((Context)ctx).getMainMenuItemInfo((IObjectPK)new ObjectUuidPK("6u3K38SWTu6Z1Fjesbpc5f033J8="));
            if (parent == null) {
                this.logger.error("savePageToEAS eas web parent is null===");
                throw new PortalBizException("210");
            }
            MainMenuItemInfo menu = new MainMenuItemInfo();
            menu.setAvailable(true);
            BOSUuid uuId = BOSUuid.create((BOSObjectType)menu.getBOSType());
            menu.setId(uuId);
            String number = PageHelper.generatePageNumber();
            number = number.substring(2, number.length());
            menu.setNumber(number);
            menu.setLongNumber("portalAuto!" + number);
            menu.setOrder("255");
            menu.setMenutype(BizTypeEnum.webmenu);
            menu.setVisible(true);
            menu.setEnabled(true);
            DisplayName nameInfo = new DisplayName(displayName);
            menu.setName(nameInfo.getZh_CN());
            menu.setLevel(2);
            menu.setParent(parent);
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            menu.setCU(cu);
            MainMenuItemFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)menu);
            externalId = uuId.toString();
        }
        catch (Exception e) {
            this.logger.error("savePageToEAS save error ===" + e.getMessage());
            throw new PortalBizException("212");
        }
        return externalId;
    }

    private PortalContext buildPortalContext(Context ctx) {
        PortalContext portalContext = new PortalContext();
        portalContext.setIp("127.0.0.1");
        portalContext.setLocale(Locale.CHINA);
        portalContext.setLoginDate(new Date());
        User loginUser = new User();
        loginUser.setId(ctx.getCaller().toString());
        loginUser.setCode(ctx.getUserName());
        portalContext.setLoginUser(loginUser);
        portalContext.getMetaInfo().put("eas_context", ctx);
        DSObserver.putDSName(ctx.getAIS());
        return portalContext;
    }

    @Override
    public boolean lockPageToTabbar(PortalContext ctx, String pageId, String pageUrl, String displayName, String spaceId, String secondPageID) throws PortalBizException {
        boolean result = false;
        String userId = ctx.getLoginUser().getId();
        this.deletePageLocks(userId, spaceId, secondPageID, null);
        try {
            if (pageId.length() > 0 && pageUrl.length() > 0) {
                ArrayList<PageLock> pageLockList = new ArrayList<PageLock>();
                String[] pageIds = pageId.split(",");
                String[] pageUrls = pageUrl.split(",");
                String[] displayNames = displayName.split(",");
                for (int i = 0; i < pageIds.length; ++i) {
                    PageLock newPageLock = new PageLock();
                    newPageLock.setPageId(pageIds[i]);
                    newPageLock.setUserId(userId);
                    newPageLock.setPageUrl(pageUrls[i]);
                    newPageLock.setOrderNum(i + 1);
                    newPageLock.setDisplayName(displayNames[i]);
                    newPageLock.setSpaceId(spaceId);
                    newPageLock.setNewSecondPageID(secondPageID);
                    newPageLock.setLockType(LockTypeEnum.TABBAR);
                    pageLockList.add(newPageLock);
                }
                this.pageLockDAO.create(pageLockList);
            }
            result = true;
        }
        catch (DataAccessException e) {
            this.logger.error("lockPageToTabbar error===", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean lockPageToHeader(PortalContext ctx, String pageId, String displayName, String spaceId) throws PortalBizException {
        boolean result = false;
        String userId = ctx.getLoginUser().getId();
        this.deletePageLocks(userId, spaceId, "", LockTypeEnum.HEADER);
        try {
            if (pageId.length() > 0) {
                ArrayList<PageLock> pageLockList = new ArrayList<PageLock>();
                String[] pageIds = pageId.split(",");
                String[] displayNames = displayName.split(",");
                for (int i = 0; i < pageIds.length; ++i) {
                    PageLock newPageLock = new PageLock();
                    newPageLock.setPageId(pageIds[i]);
                    newPageLock.setUserId(userId);
                    newPageLock.setOrderNum(i + 1);
                    newPageLock.setDisplayName(displayNames[i]);
                    newPageLock.setSpaceId(spaceId);
                    newPageLock.setLockType(LockTypeEnum.HEADER);
                    newPageLock.setPageUrl("temp");
                    pageLockList.add(newPageLock);
                }
                this.pageLockDAO.create(pageLockList);
            }
            result = true;
        }
        catch (DataAccessException e) {
            this.logger.error("lockPageToTabbar error===", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean lockPageToTabbar(PortalContext ctx, String pageId, String pageUrl, String displayName, String spaceId) throws PortalBizException {
        boolean result = false;
        String userId = ctx.getLoginUser().getId();
        this.deletePageLocks(userId, spaceId, "", LockTypeEnum.TABBAR);
        try {
            if (pageId.length() > 0 && pageUrl.length() > 0) {
                ArrayList<PageLock> pageLockList = new ArrayList<PageLock>();
                String[] pageIds = pageId.split(",");
                String[] pageUrls = pageUrl.split(",");
                String[] displayNames = displayName.split(",");
                for (int i = 0; i < pageIds.length; ++i) {
                    PageLock newPageLock = new PageLock();
                    newPageLock.setPageId(pageIds[i]);
                    newPageLock.setUserId(userId);
                    newPageLock.setPageUrl(pageUrls[i]);
                    newPageLock.setOrderNum(i + 1);
                    newPageLock.setDisplayName(displayNames[i]);
                    newPageLock.setSpaceId(spaceId);
                    newPageLock.setLockType(LockTypeEnum.TABBAR);
                    pageLockList.add(newPageLock);
                }
                this.pageLockDAO.create(pageLockList);
            }
            result = true;
        }
        catch (DataAccessException e) {
            this.logger.error("lockPageToTabbar error===", (Throwable)e);
        }
        return result;
    }

    private void deletePageLocks(String userId, String spaceId, String newSecondPageID, LockTypeEnum lockType) {
        try {
            if (StringUtils.isEmpty((String)newSecondPageID)) {
                if (lockType == null || lockType == LockTypeEnum.TABBAR) {
                    this.pageLockDAO.deletePageLocks(userId, spaceId);
                } else if (lockType == LockTypeEnum.HEADER) {
                    this.pageLockDAO.deletePageLocks(userId, spaceId, lockType);
                }
            } else {
                this.pageLockDAO.deletePageLocks(userId, spaceId, newSecondPageID);
            }
        }
        catch (DataAccessException e) {
            this.logger.error("deletePageLocks error===", (Throwable)e);
        }
    }

    @Override
    public List<Page> findLockPageList(PortalContext ctx, String spaceId, LockTypeEnum lockType) throws PortalBizException {
        ArrayList<Page> newTempList = new ArrayList<Page>();
        String userId = ctx.getLoginUser().getId();
        try {
            List lockList = this.pageLockDAO.findList(new Filter[]{new FieldFilter("userId", "=", userId), new FieldFilter("spaceId", "=", spaceId), new FieldFilter("lockType", "=", (Object)lockType), new OrderFilter("orderNum", OrderEnum.ASC)});
            if (lockList.size() < 1) {
                return newTempList;
            }
            String[] str = new String[lockList.size()];
            int i = 0;
            for (PageLock pageLock : lockList) {
                str[i] = pageLock.getPageId();
                ++i;
            }
            List<Page> tempList = this.pageDAO.findLockPageListByPageIds(str);
            List<Page> permList = this.permService.selectPermPageList(ctx, tempList, null, userId);
            for (PageLock pageLock : lockList) {
                boolean isFind = false;
                for (Page page : permList) {
                    if (!page.getId().equals(pageLock.getPageId())) continue;
                    page.setPageUrl(pageLock.getPageUrl());
                    newTempList.add(page);
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                newTempList.add(this.setPage4PageLock(pageLock));
            }
        }
        catch (DataAccessException e) {
            this.logger.error("findLockPageList error===", (Throwable)e);
        }
        return newTempList;
    }

    @Override
    public List<Page> findLockPageList(PortalContext ctx, String spaceId, String newPageID) throws PortalBizException {
        ArrayList<Page> newTempList = new ArrayList<Page>();
        String userId = ctx.getLoginUser().getId();
        try {
            List lockList = this.pageLockDAO.findList(new Filter[]{new FieldFilter("userId", "=", userId), new FieldFilter("spaceId", "=", spaceId), new FieldFilter("newSecondPageID", "=", newPageID), new OrderFilter("orderNum", OrderEnum.ASC)});
            if (lockList.size() < 1) {
                return newTempList;
            }
            String[] str = new String[lockList.size()];
            int i = 0;
            for (PageLock pageLock : lockList) {
                str[i] = pageLock.getPageId();
                ++i;
            }
            List<Page> tempList = this.pageDAO.findLockPageListByPageIds(str);
            List<Page> permList = this.permService.selectPermPageList(ctx, tempList, null, userId);
            for (PageLock pageLock : lockList) {
                boolean isFind = false;
                for (Page page : permList) {
                    if (!page.getId().equals(pageLock.getPageId())) continue;
                    page.setPageUrl(pageLock.getPageUrl());
                    newTempList.add(page);
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                newTempList.add(this.setPage4PageLock(pageLock));
            }
        }
        catch (DataAccessException e) {
            this.logger.error("findLockPageList error===", (Throwable)e);
        }
        return newTempList;
    }

    @Override
    public List<Page> findLockPageList(PortalContext ctx, String spaceId) throws PortalBizException {
        ArrayList<Page> newTempList = new ArrayList<Page>();
        String userId = ctx.getLoginUser().getId();
        try {
            List lockList = this.pageLockDAO.findList(new Filter[]{new FieldFilter("userId", "=", userId), new FieldFilter("spaceId", "=", spaceId), new OrderFilter("orderNum", OrderEnum.ASC)});
            if (lockList.size() < 1) {
                return newTempList;
            }
            String[] str = new String[lockList.size()];
            int i = 0;
            for (PageLock pageLock : lockList) {
                str[i] = pageLock.getPageId();
                ++i;
            }
            List<Page> tempList = this.pageDAO.findLockPageListByPageIds(str);
            List<Page> permList = this.permService.selectPermPageList(ctx, tempList, null, userId);
            for (PageLock pageLock : lockList) {
                boolean isFind = false;
                for (Page page : permList) {
                    if (!page.getId().equals(pageLock.getPageId())) continue;
                    page.setPageUrl(pageLock.getPageUrl());
                    newTempList.add(page);
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                newTempList.add(this.setPage4PageLock(pageLock));
            }
        }
        catch (DataAccessException e) {
            this.logger.error("findLockPageList error===", (Throwable)e);
        }
        return newTempList;
    }

    @Override
    public void updatePortalThemeType(Context ctx, String themeName) throws EASBizException, BOSException {
        PersonalParamFactory.getRemoteInstance().updatePersonalParam("PORTAL_THEME_COLOR", themeName);
        ctx.put((Object)"PORTAL_THEME_COLOR", (Object)themeName);
    }

    @Override
    public String findPortalThemeType(Context ctx) {
        String themeName = "blue";
        String layoutType = "layout_old";
        try {
            if (ctx.get((Object)"webLayoutType") != null) {
                layoutType = ctx.get((Object)"webLayoutType").toString();
                if (!"layout_new".equalsIgnoreCase(layoutType)) {
                    return themeName;
                }
            } else {
                layoutType = this.findPortalLayoutType(ctx);
                ctx.put((Object)"webLayoutType", (Object)layoutType);
            }
            if (!"layout_new".equalsIgnoreCase(layoutType)) {
                return themeName;
            }
            if (ctx.get((Object)"PORTAL_THEME_COLOR") != null && !StringUtils.isEmpty((String)(themeName = ctx.get((Object)"PORTAL_THEME_COLOR").toString()))) {
                return themeName;
            }
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            StringBuilder filter = new StringBuilder();
            filter.append("where user.id='").append(user.getId()).append("' and paramName='").append("PORTAL_THEME_COLOR").append("'");
            PersonalParamCollection coll = PersonalParamFactory.getRemoteInstance().getPersonalParamCollection(filter.toString());
            if (coll != null && coll.size() > 0 && coll.get(0) != null) {
                themeName = coll.get(0).getParamValue();
            }
            if (!"blue".equalsIgnoreCase(themeName) && !"green".equalsIgnoreCase(themeName) && !"red".equalsIgnoreCase(themeName) && !"purple".equalsIgnoreCase(themeName) && !"orange".equalsIgnoreCase(themeName) || "layout_old".equalsIgnoreCase(this.findPortalLayoutType(ctx))) {
                themeName = "blue";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ctx.put((Object)"PORTAL_THEME_COLOR", (Object)themeName);
        return themeName;
    }

    @Override
    public void updatePortalLayoutType(Context ctx, String layoutType) {
        layoutType = StringUtils.isEmpty((String)layoutType) ? "layout_old" : layoutType;
        String layoutTypeNumber = "layout_old".equals(layoutType) ? "1" : "2";
        try {
            PersonalParamFactory.getRemoteInstance().updatePersonalParam("webLayoutType", layoutTypeNumber);
            ctx.put((Object)"webLayoutType", (Object)layoutType);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String findPortalLayoutType(Context ctx) {
        String portalLayoutType = "2";
        try {
            if (ctx.get((Object)"webLayoutType") != null) {
                portalLayoutType = ctx.get((Object)"webLayoutType").toString();
                if (StringUtils.isEmpty((String)portalLayoutType)) {
                    return "layout_new";
                }
                return portalLayoutType;
            }
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            PersonalParamCollection coll = PersonalParamFactory.getRemoteInstance().getPersonalParamCollection("where user.id='" + user.getId() + "' and paramName='webLayoutType'");
            if (coll != null && coll.size() > 0 && coll.get(0) != null) {
                portalLayoutType = coll.get(0).getParamValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        portalLayoutType = "1".equals(portalLayoutType) ? "layout_old" : "layout_new";
        ctx.put((Object)"webLayoutType", (Object)portalLayoutType);
        return portalLayoutType;
    }

    @Override
    public String findNewPageIDByMenuID(Context ctx, String menuId) {
        String permSql = "select FNewPageID from T_JP_SecondPageAndNewPage where FpageId = '" + menuId + "'";
        String newPageID = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)permSql);
            if (rs != null && rs.next()) {
                newPageID = rs.getString("FNewPageID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newPageID;
    }

    @Override
    public String findMenuIDByNewPageID(Context ctx, String newPageId) {
        String permSql = "select FPageID from T_JP_SecondPageAndNewPage where FnewPageId = '" + newPageId + "'";
        String menuID = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)permSql);
            if (rs != null && rs.next()) {
                menuID = rs.getString("FPageID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return menuID;
    }

    @Override
    public List<Page> findPageListByParentIdAndUserIds(PortalContext ctx, String parentId, String[] userIds) throws PortalBizException {
        try {
            return this.pageDAO.findPageListByParentIdAndUserIds(ctx, parentId, userIds);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    @Override
    public List<Page> findPageListByParentIdAndUserIdsAndStatus(PortalContext ctx, String parentId, String[] userIds, StatusEnum status) throws PortalBizException {
        try {
            return this.pageDAO.findPageListByParentIdAndUserIdsAndStatus(ctx, parentId, userIds, status);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("204", e);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean hasPermission4Edit(PortalContext ctx, Page page) {
        boolean result = false;
        if (NodeTypeEnum.NEW_PAGE.equals((Object)page.getNodeType()) || NodeTypeEnum.PLAN.equals((Object)page.getNodeType())) {
            if (page.getUserId().equalsIgnoreCase(ctx.getLoginUser().getId())) {
                result = true;
            }
            if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(ctx.getLoginUser().getId()) && page.getUserId().equals("portal_template_user")) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public PageEditPermissionDto getNewPagePermission(PortalContext ctx, String pageId) throws PortalBizException {
        PageEditPermissionDto perm = new PageEditPermissionDto();
        Page page = this.findPageById(ctx, pageId);
        if (NodeTypeEnum.NEW_PAGE.equals((Object)page.getNodeType()) || NodeTypeEnum.PLAN.equals((Object)page.getNodeType())) {
            PermInfo pi;
            if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(ctx.getLoginUser().getId()) && page.getUserId().equals("portal_template_user")) {
                perm.setCanEdit(true);
                perm.setCanSaveAs(true);
                perm.setCanCustomer(true);
            }
            if (page.getUserId().equalsIgnoreCase(ctx.getLoginUser().getId())) {
                perm.setCanEdit(true);
                perm.setCanCustomer(false);
                if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(ctx.getLoginUser().getId())) {
                    perm.setCanSaveAs(true);
                }
            } else {
                if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(ctx.getLoginUser().getId()) || NodeTypeEnum.NEW_PAGE.equals((Object)page.getNodeType())) {
                    perm.setCanCustomer(true);
                }
                if (NodeTypeEnum.PLAN.equals((Object)page.getNodeType())) {
                    boolean isCanCustomer = new PageNodeExt(page.getNodeExt()).getIsCanCustomer();
                    perm.setCanCustomer(isCanCustomer);
                }
            }
            List<PermRefRes> permList = PortalCache.getPortalPagePerm(ctx);
            ArrayList<PermRefRes> permListNew = new ArrayList<PermRefRes>();
            for (PermRefRes permRefRes : permList) {
                if (permRefRes.getResType() != ResTypeEnum.PLAN_PERM) continue;
                permListNew.add(permRefRes);
            }
            for (PermRefRes ref : permListNew) {
                if (!"saveAs_temp".equalsIgnoreCase(ref.getResId()) || !NodeTypeEnum.PLAN.equals((Object)page.getNodeType()) && !NodeTypeEnum.NEW_PAGE.equals((Object)page.getNodeType())) continue;
                pi = new PermInfo(ref.getPermInfo());
                boolean saveAs = pi.isSaveAs();
                perm.setCanSaveAs(saveAs);
                if (!saveAs) continue;
                break;
            }
            for (PermRefRes ref : permListNew) {
                if (!"canEdit_temp".equalsIgnoreCase(ref.getResId()) || !NodeTypeEnum.PLAN.equals((Object)page.getNodeType()) && !NodeTypeEnum.NEW_PAGE.equals((Object)page.getNodeType())) continue;
                pi = new PermInfo(ref.getPermInfo());
                boolean canCustomer = pi.isCanCustomer();
                perm.setCanCustomer(canCustomer);
                if (!canCustomer) continue;
                perm.setCanEdit(true);
                break;
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return perm;
    }

    @Override
    public List<PlanDto> getPagingPlanList(PortalContext portalContext, List<Page> list, PagingParam param, String inputValue) throws PortalBizException {
        if (list == null || list.size() < 1) {
            return new ArrayList<PlanDto>();
        }
        int size = list.size();
        int start = param.getStartIndex();
        int end = start + param.getPageSize();
        if (!StringUtil.isEmpty((String)inputValue)) {
            end = size;
        }
        String id = "";
        String displayName = "";
        String snumber = "";
        Page info = null;
        ArrayList<PlanDto> groupList = new ArrayList<PlanDto>();
        PlanDto group = null;
        for (int i = start; i < size && i < end; ++i) {
            String lc_inputValue;
            info = list.get(i);
            snumber = info.getPageNumber();
            displayName = new DisplayName(info.getDisplayName(), portalContext.getLocale().toString()).getLocaleText();
            String lc_snumber = snumber.toLowerCase();
            String lc_displayName = displayName.toLowerCase();
            if (!StringUtil.isEmpty((String)inputValue) && lc_snumber.indexOf(lc_inputValue = inputValue.toLowerCase()) < 0 && lc_displayName.indexOf(lc_inputValue) < 0) continue;
            id = info.getId() != null ? info.getId().toString() : "";
            group = new PlanDto();
            group.setId(id);
            group.setNumber(snumber);
            group.setName(displayName);
            String type = null;
            if (NodeTypeEnum.NEW_PAGE.equals((Object)info.getNodeType())) {
                type = PlanTypeEnum.DEFAULT.toString();
            } else if ("portal_template_user".equals(info.getUserId())) {
                type = PlanTypeEnum.SHARE.toString();
            } else if (portalContext.getLoginUser().getId().equals(info.getUserId())) {
                type = PlanTypeEnum.CUSTOM.toString();
            }
            group.setType(this.i18nService.getText(portalContext, "res.portal.i18n.frame.global", "jPortal_core_engine_tool.planSwitch." + type));
            group.setStatu(this.i18nService.getText(portalContext, "res.portal.i18n.frame.global", "jPortal_core_engine_tool.planSwitch." + info.getStatus().toString()));
            groupList.add(group);
        }
        return groupList;
    }

    private Page setPage4PageLock(PageLock pageLock) {
        Page newPage = new Page();
        newPage.setDisplayName(this.configDisplayName(pageLock.getDisplayName()));
        newPage.setId(pageLock.getPageId());
        newPage.setNodeLevel(1);
        newPage.setNodeOrder(1000);
        newPage.setNodeType(NodeTypeEnum.LINK);
        newPage.setPageUrl(pageLock.getPageUrl());
        LinkNodeExt ext = new LinkNodeExt();
        ext.setSso(false);
        ext.setTarget("TAB");
        ext.setUrl(pageLock.getPageUrl());
        newPage.setNodeExt(ext.toString());
        return newPage;
    }

    private String configDisplayName(String cname) {
        DisplayName dm = new DisplayName();
        dm.setZh_CN(cname);
        dm.setEn(cname);
        dm.setZh_TW(cname);
        return dm.toString();
    }

    public void setI18nService(II18nService i18nService) {
        this.i18nService = i18nService;
    }

    public void setPermService(PermService permService) {
        this.permService = permService;
    }

    public void setPageDAO(PageDAO pageDAO) {
        this.pageDAO = pageDAO;
    }

    public void setPagePersonalExtDAO(PagePersonalExtDAO pagePersonalExtDAO) {
        this.pagePersonalExtDAO = pagePersonalExtDAO;
    }

    public void setSettingService(SettingService settingService) {
        this.settingService = settingService;
    }

    public void setPageSpacePersonalExtDAO(PageSpacePersonalExtDAO pageSpacePersonalExtDAO) {
        this.pageSpacePersonalExtDAO = pageSpacePersonalExtDAO;
    }

    public void setPageCacheService(PageCacheService pageCacheService) {
        this.pageCacheService = pageCacheService;
    }

    public void setPortletService(PortletService portletService) {
        this.portletService = portletService;
    }

    public void setPortletDefinitionService(PortletDefinitionService portletDefinitionService) {
        this.portletDefinitionService = portletDefinitionService;
    }

    public void setEasService(EASService easService) {
        this.easService = easService;
    }

    public void setOnlineEditPageService(OnlineEditPageService onlineEditPageService) {
        this.onlineEditPageService = onlineEditPageService;
    }

    public void setPortletCategoryService(PortletCategoryService portletCategoryService) {
        this.portletCategoryService = portletCategoryService;
    }

    public void setPageIdMapCodeService(PageIdMapCodeService pageIdMapCodeService) {
        this.pageIdMapCodeService = pageIdMapCodeService;
    }

    public void setPersonalFavoriteService(PersonalFavoriteService personalFavoriteService) {
        this.personalFavoriteService = personalFavoriteService;
    }

    public void setPageLockDAO(PageLockDAO pageLockDAO) {
        this.pageLockDAO = pageLockDAO;
    }

    @Override
    public List<PortalCenterClassDTO> findClassListByPagingParam(PortalContext portalContext, PagingParam pagingParam, List<Page> pageList, String inputValue) {
        int pageSize = pagingParam.getPageSize();
        int pageNo = pagingParam.getPageNo();
        int total = pageList.size();
        if (total > pageSize) {
            pageList = pageList.subList(pageSize * (pageNo - 1), (pageSize + 1) * (pageNo - 1));
        }
        ArrayList<PortalCenterClassDTO> returnList = new ArrayList<PortalCenterClassDTO>();
        PortalCenterClassDTO classDTO = null;
        for (Page page : pageList) {
            classDTO = new PortalCenterClassDTO();
            classDTO.setName(this.getLocaleDisplayName(portalContext.getLocale().toString(), page.getDisplayName()));
            classDTO.setNumber(page.getPageNumber());
            classDTO.setId(page.getId());
            returnList.add(classDTO);
        }
        return returnList;
    }

    @Override
    public void deleteNotSysPortalPages(PortalContext portalContext) {
        try {
            List<Page> allPortalPages = this.pageDAO.findSubIdsByNodePath("/2f9ef722-255b-4e4b-8d07-5277e353a321/2b7f4215-aa17-4d89-952e-efc97833cee6/793e3c69-d245-4fa1-ac95-df9bd30586e3/");
            List<String> systemPortalPageIds = this.getSystemPortalPageIds();
            for (Page page : allPortalPages) {
                if (systemPortalPageIds.indexOf(page.getId()) > -1) continue;
                this.pageDAO.delete(page);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private List<String> getSystemPortalPageIds() {
        String[] strArr = new String[]{"b5e727c7-7c38-4611-9206-5289a0d572ed", "6833d8a7-0215-4410-ac4d-9185cb664134"};
        return Arrays.asList(strArr);
    }
}

